/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.websocket.handler;

import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.websocket.message.MessageDispatcher;
import com.kuaike.scrm.websocket.model.WebSocketClientSession;
import com.kuaike.scrm.websocket.service.dto.WebSocketMessageDto;
import com.kuaike.scrm.websocket.session.SessionManager;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.ReferenceCountUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(WebSocketHandler.class);
    public static final String UPGRADE_HEADER_KEY = "Upgrade";

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        WebSocketClientSession session = SessionManager.getInstance().getSession(ctx.channel());
        session.setValid(false);
        SessionManager.getInstance().unRegister(ctx.channel());
        log.info("session invalid {}", (Object)session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpRequest) {
            try {
                this.handleHttpRequest(ctx, (FullHttpRequest)msg);
            }
            catch (Exception e) {
                log.error("Failed handling http request", (Throwable)e);
            }
            finally {
                ReferenceCountUtil.release((Object)msg);
            }
        } else if (msg instanceof TextWebSocketFrame) {
            try {
                TextWebSocketFrame data = (TextWebSocketFrame)msg;
                WebSocketMessageDto webSocketMessageDto = (WebSocketMessageDto)JacksonUtil.str2Obj((String)data.text(), WebSocketMessageDto.class);
                MessageDispatcher.getInstance().handleMessage(webSocketMessageDto, ctx);
            }
            catch (Exception e) {
                log.error("Failed handling text", (Throwable)e);
            }
            finally {
                ReferenceCountUtil.release((Object)msg);
            }
        } else {
            super.channelRead(ctx, msg);
        }
    }

    private void handleHttpRequest(ChannelHandlerContext ctx, FullHttpRequest fullHttpRequest) {
        if (this.validateHttpRequest(fullHttpRequest)) {
            WebSocketServerHandshakerFactory webSocketServerHandshakerFactory = new WebSocketServerHandshakerFactory("ws://localhost:8066/", null, false);
            WebSocketServerHandshaker webSocketServerHandshaker = webSocketServerHandshakerFactory.newHandshaker((HttpRequest)fullHttpRequest);
            if (webSocketServerHandshaker == null) {
                WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel());
            } else {
                webSocketServerHandshaker.handshake(ctx.channel(), fullHttpRequest);
            }
        } else {
            this.sendHttpResponse(ctx, fullHttpRequest, (FullHttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST));
        }
    }

    private boolean validateHttpRequest(FullHttpRequest fullHttpRequest) {
        HttpHeaders httpHeaders = fullHttpRequest.headers();
        return httpHeaders.get(UPGRADE_HEADER_KEY).equals("websocket");
    }

    private void sendHttpResponse(ChannelHandlerContext ctx, FullHttpRequest req, FullHttpResponse fullHttpResponse) {
        if (HttpUtil.isKeepAlive((HttpMessage)req)) {
            fullHttpResponse.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderNames.CONNECTION);
        }
        ChannelFuture future = ctx.writeAndFlush((Object)fullHttpResponse);
        if (!HttpUtil.isKeepAlive((HttpMessage)req)) {
            try {
                future.sync();
                ctx.close();
            }
            catch (InterruptedException e) {
                log.error("Interrupted!", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }
}

