/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.websocket.message;

import com.kuaike.scrm.websocket.message.handler.MessageHandler;
import com.kuaike.scrm.websocket.service.dto.WebSocketMessageDto;
import io.netty.channel.ChannelHandlerContext;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Service;

@Service
public class MessageDispatcher
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger log = LoggerFactory.getLogger(MessageDispatcher.class);
    private static MessageDispatcher messageDispatcher;
    private Map<Integer, MessageHandler> messageHandlerMap;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        ApplicationContext applicationContext = event.getApplicationContext();
        messageDispatcher = this;
        Map messageHandlers = applicationContext.getBeansOfType(MessageHandler.class);
        this.messageHandlerMap = messageHandlers.entrySet().stream().collect(Collectors.toMap(e -> ((MessageHandler)e.getValue()).getMessageType(), Map.Entry::getValue));
    }

    public static MessageDispatcher getInstance() {
        return messageDispatcher;
    }

    public void handleMessage(WebSocketMessageDto webSocketMessageDto, ChannelHandlerContext context) {
        MessageHandler messageHandler = this.messageHandlerMap.get(webSocketMessageDto.getCmd());
        if (messageHandler != null) {
            messageHandler.handleMessage(webSocketMessageDto, context);
        } else {
            log.info("invalid cmd {}", (Object)webSocketMessageDto.getCmd());
        }
    }
}

