/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.websocket.message;

import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.websocket.message.handler.MessageHandler;
import com.kuaike.scrm.websocket.service.dto.WebSocketMessageDto;
import com.kuaike.scrm.websocket.service.dto.WsRestResponse;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageHandler
implements MessageHandler {
    private static final Logger log = LoggerFactory.getLogger(AbstractMessageHandler.class);

    protected void sendSuccessResponse(ChannelHandlerContext ctx, int cmd) {
        WebSocketMessageDto message = new WebSocketMessageDto(cmd, JacksonUtil.toMap((Object)WsRestResponse.ok((Serializable)((Object)""))));
        ctx.pipeline().writeAndFlush((Object)new TextWebSocketFrame(JacksonUtil.obj2Str((Object)message)));
    }

    protected void sendErrorCodeAndClose(ChannelHandlerContext ctx, int cmd, String desc) {
        WsRestResponse wsRestResponse = new WsRestResponse();
        wsRestResponse.setCode(400L);
        wsRestResponse.setMsg(desc);
        WebSocketMessageDto message = new WebSocketMessageDto(cmd, JacksonUtil.toMap((Object)wsRestResponse));
        ctx.pipeline().writeAndFlush((Object)new TextWebSocketFrame(JacksonUtil.obj2Str((Object)message)));
        ctx.channel().close();
    }
}

