/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.service.impl;

import cn.kinyun.customer.center.service.CcCustomerNumService;
import cn.kinyun.link.common_dto.dto.BaseResponse;
import cn.kinyun.link.common_dto.dto.OpBaseResponse;
import cn.kinyun.link.common_dto.dto.ResponseCodeType;
import cn.kinyun.link.common_dto.enums.OpPlatform;
import cn.kinyun.link.service.ContactService;
import cn.kinyun.link.service.contact.request.DelContactReq;
import cn.kinyun.scrm.vip.dto.req.VipDelContactSelectParam;
import cn.kinyun.scrm.vip.dto.req.VipDelFriendAddReqDto;
import cn.kinyun.scrm.vip.dto.req.VipDelFriendCancelDto;
import cn.kinyun.scrm.vip.dto.req.VipDelFriendDetailReqDto;
import cn.kinyun.scrm.vip.dto.req.VipDelFriendListReqDto;
import cn.kinyun.scrm.vip.dto.req.VipDelFriendRetryReqDto;
import cn.kinyun.scrm.vip.dto.resp.VipDelFriendDetailRespDto;
import cn.kinyun.scrm.vip.dto.resp.VipDelFriendTaskRespDto;
import cn.kinyun.scrm.vip.dto.resp.VipDelFriendsConfigDto;
import cn.kinyun.scrm.vip.enums.DelFriendsStatus;
import cn.kinyun.scrm.vip.service.VipDelFriendService;
import cn.kinyun.scrm.vip.utils.ResponseErrUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.SettingEnum;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.common.perm.service.UserRoleCommonService;
import com.kuaike.scrm.common.service.SettingService;
import com.kuaike.scrm.common.service.dto.req.SettingReqDto;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.NamedThreadFactory;
import com.kuaike.scrm.common.utils.ThreadPoolMonitorUtils;
import com.kuaike.scrm.dal.app.entity.AppBindings;
import com.kuaike.scrm.dal.app.mapper.AppBindingsMapper;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.vip.condition.DelFriendDetailQueryCondition;
import com.kuaike.scrm.dal.vip.condition.DelFriendTaskQueryCondition;
import com.kuaike.scrm.dal.vip.dto.DelFriendStatisticCountDto;
import com.kuaike.scrm.dal.vip.entity.VipToolDelFriendDetail;
import com.kuaike.scrm.dal.vip.entity.VipToolDelFriendTask;
import com.kuaike.scrm.dal.vip.entity.VipWeworkAccount;
import com.kuaike.scrm.dal.vip.entity.VipWeworkContact;
import com.kuaike.scrm.dal.vip.mapper.VipToolDelFriendDetailMapper;
import com.kuaike.scrm.dal.vip.mapper.VipToolDelFriendTaskMapper;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkAccountMapper;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkContactDigitIdMapper;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkContactMapper;
import com.kuaike.scrm.dal.wework.dto.WeworkUserContactDto;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.wework.contact.dto.ContactRelationListParams;
import com.kuaike.scrm.wework.contact.service.ContactRelationService;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class VipDelFriendServiceImpl
implements VipDelFriendService {
    private static final Logger log = LoggerFactory.getLogger(VipDelFriendServiceImpl.class);
    private static final String MEDIUM = "delFriends:";
    private static final Integer EXPIRE_TIME = 60;
    private static final int NOT_CONTACT = 13;
    private static final int PARTITION_SIZE = 500;
    private static final SecureRandom RAND = new SecureRandom();
    @Value(value="${app.yingxiaobao.code:yingxiaobao}")
    private String yingxiaobaoCode;
    @Value(value="${spring.redis.key.prefix}")
    private String redisKeyPrefix;
    @Value(value="${scrm.vip.delFriend.minInterval:60}")
    private Integer minDelFriendsInterval;
    @Value(value="${scrm.vip.delFriend.maxInterval:90}")
    private Integer maxDelFriendsInterval;
    @Value(value="${scrm.vip.delFriend.upperLimit:15}")
    private Integer everyDayDelFriendsUpperLimit;
    @Value(value="${scrm.vip.delFriend.minLimitCount:10}")
    private Integer minDelFriendsLimitCount;
    @Autowired
    private IdGen idGen;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private AppBindingsMapper appBindingsMapper;
    @Autowired
    private VipToolDelFriendTaskMapper vipToolDelFriendTaskMapper;
    @Autowired
    private VipToolDelFriendDetailMapper vipToolDelFriendDetailMapper;
    @Autowired
    private VipWeworkContactMapper vipWeworkContactMapper;
    @Autowired
    private VipWeworkAccountMapper vipWeworkAccountMapper;
    @Autowired
    private VipWeworkContactDigitIdMapper vipWeworkContactDigitIdMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private SettingService settingService;
    @Autowired
    private UserRoleCommonService userRoleCommonService;
    @Autowired
    private CcCustomerNumService ccCustomerNumService;
    @Autowired
    private ContactRelationService contactRelationService;
    @Autowired
    private ContactService contactService;
    private final ExecutorService executorService = new ThreadPoolExecutor(1, 100, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1024), (ThreadFactory)new NamedThreadFactory("tool-del-friend"), new ThreadPoolExecutor.CallerRunsPolicy());

    @PostConstruct
    public void init() {
        ThreadPoolMonitorUtils.addToMonitor((ExecutorService)this.executorService);
    }

    @Override
    public boolean isGoingDelFriends(String weworkId) {
        log.info("isGoingDelFriends, weworkId:{}", (Object)weworkId);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)weworkId), (Object)"\u673a\u5668\u4eba\u5fae\u4fe1id\u4e0d\u80fd\u4e3a\u7a7a");
        int count = this.vipToolDelFriendDetailMapper.getNotStartAndOngoingRecordsByWeworkId(weworkId);
        log.info("weworkId:{}, \u8fd8\u6709:{}\u4e2a\u597d\u53cb\u9700\u8981\u5220\u9664", (Object)weworkId, (Object)count);
        return count != NumberUtils.INTEGER_ZERO;
    }

    @Override
    public String create(VipDelContactSelectParam params) {
        List selectContacts;
        log.info("add del contact select params:{}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"params \u4e3a\u7a7a");
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        AppBindings appBindings = this.appBindingsMapper.selectByBizIdAndAppCode(bizId, this.yingxiaobaoCode);
        if (Objects.isNull(appBindings) || YnEnum.NO.getValue().equals(appBindings.getIsOpen())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5f53\u524d\u5546\u5bb6\u672a\u5f00\u901a\u8425\u9500\u5b9d");
        }
        if (params.getIsSelectAll().booleanValue()) {
            Object selectParams = params.getSelectParams();
            if (selectParams == null) {
                selectParams = new ContactRelationListParams();
            }
            selectContacts = this.contactRelationService.queryWeworkContactRelationList((ContactRelationListParams)selectParams);
            Set weworkUserIds = selectContacts.stream().map(WeworkUserContactDto::getWeworkUserId).collect(Collectors.toSet());
            Map weworkUserIdNumMap = this.weworkUserMapper.queryUserNumIdMap(corpId, weworkUserIds);
            for (WeworkUserContactDto item : selectContacts) {
                item.setWeworkUserNum(weworkUserIdNumMap.getOrDefault(item.getWeworkUserId(), ""));
            }
        } else {
            selectContacts = params.getSelectContacts();
            for (WeworkUserContactDto item : selectContacts) {
                item.setWeworkUserNum(item.getWeworkUserId());
            }
        }
        if (CollectionUtils.isEmpty((Collection)selectContacts)) {
            log.info("selectContacts is empty");
            return null;
        }
        log.info("isSelectAll:{}, contactDtoList:{}", (Object)params.getIsSelectAll(), (Object)selectContacts);
        Set weworkUserNums = selectContacts.stream().map(WeworkUserContactDto::getWeworkUserNum).collect(Collectors.toSet());
        Set allContactIds = selectContacts.stream().map(WeworkUserContactDto::getContactId).collect(Collectors.toSet());
        Map weworkDigitIdMap = this.weworkUserMapper.queryDigitIdMapByNum(weworkUserNums);
        Map contactDigitIdMap = this.vipWeworkContactDigitIdMapper.queryDigitIdMapByContactId(corpId, allContactIds);
        Map relationMap = selectContacts.stream().collect(Collectors.groupingBy(WeworkUserContactDto::getWeworkUserNum, Collectors.mapping(WeworkUserContactDto::getContactId, Collectors.toList())));
        ArrayList list = Lists.newArrayList();
        for (Map.Entry entry : relationMap.entrySet()) {
            String weworkUserNum = entry.getKey();
            String robotWeworkId = (String)weworkDigitIdMap.get(weworkUserNum);
            if (StringUtils.isBlank((CharSequence)robotWeworkId)) {
                log.warn("\u5f53\u524d\u6210\u5458\u672a\u5f00\u901a\u8425\u9500\u5b9d, weworkUserNum:{}", (Object)weworkUserNum);
                continue;
            }
            VipDelFriendAddReqDto reqDto = new VipDelFriendAddReqDto();
            reqDto.setRobotWeworkId(robotWeworkId);
            HashSet contactWeworkIds = Sets.newHashSet();
            for (String contactId : entry.getValue()) {
                String contactDigitId = (String)contactDigitIdMap.get(contactId);
                if (StringUtils.isNotBlank((CharSequence)contactDigitId)) {
                    contactWeworkIds.add(contactDigitId);
                    continue;
                }
                log.warn("\u5f53\u524d\u8054\u7cfb\u4eba\u672a\u5f00\u901a\u8425\u9500\u5b9d, contactId:{}", (Object)contactId);
            }
            if (contactWeworkIds.isEmpty()) {
                log.warn("\u5f53\u524d\u6210\u5458\u6ca1\u6709\u5bf9\u5e94\u7684\u8054\u7cfb\u4eba, weworkUserNum:{}", (Object)weworkUserNum);
                continue;
            }
            reqDto.setContactIds(contactWeworkIds);
            list.add(reqDto);
        }
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return this.addTask(list);
        }
        log.info("\u6ca1\u6709\u6ee1\u8db3\u6761\u4ef6\u7684\u5220\u9664\u597d\u53cb\u4efb\u52a1");
        return null;
    }

    @Override
    @Transactional
    public String addTask(List<VipDelFriendAddReqDto> params) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((currentUserInfo != null ? 1 : 0) != 0, (Object)"\u64cd\u4f5c\u7528\u6237\u4e3a\u7a7a");
        Long userId = currentUserInfo.getId();
        Long bizId = currentUserInfo.getBizId();
        log.info("add del friend task, bizId:{}, operatorId:{}, params:{}", new Object[]{bizId, userId, params});
        AppBindings appBindings = this.appBindingsMapper.selectByBizIdAndAppCode(bizId, this.yingxiaobaoCode);
        if (Objects.isNull(appBindings) || YnEnum.NO.getValue().equals(appBindings.getIsOpen())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5f53\u524d\u5546\u5bb6\u672a\u5f00\u901a\u8425\u9500\u5b9d");
        }
        for (VipDelFriendAddReqDto vipDelFriendAddReqDto : params) {
            vipDelFriendAddReqDto.validateParams();
        }
        List<String> robotWeworkIds = params.stream().map(VipDelFriendAddReqDto::getRobotWeworkId).collect(Collectors.toList());
        List vipWeworkAccounts = this.vipWeworkAccountMapper.queryByWeworkIdsAndBizId(robotWeworkIds, bizId);
        Map vipWeworkAccountMap = vipWeworkAccounts.stream().collect(Collectors.toMap(VipWeworkAccount::getWeworkId, Function.identity()));
        Map externalContactCountMap = this.vipWeworkContactMapper.queryExternalCountListByWeworkIds(bizId, robotWeworkIds);
        VipToolDelFriendTask task = this.buildVipToolDelFriendTask(bizId, userId, robotWeworkIds);
        this.vipToolDelFriendTaskMapper.insert((Object)task);
        Long taskId = task.getId();
        Date startDate = new Date();
        VipDelFriendsConfigDto configDto = this.getDelFriendsConfig(bizId);
        log.info("delFriendsConfig: {}", (Object)configDto);
        Map alreadyDelCountMap = this.vipToolDelFriendDetailMapper.getWeworkIdAndAlreadyDelCount(robotWeworkIds, bizId, DateUtil.getTodayStartTime(), DateUtil.getTodayEndTime());
        StringBuilder tipMsg = new StringBuilder(64);
        ArrayList vipToolDelFriendDetails = Lists.newArrayList();
        for (VipDelFriendAddReqDto taskReqDto : params) {
            String robotWeworkId = taskReqDto.getRobotWeworkId();
            HashSet<String> contactWeworkIds = new HashSet<String>(taskReqDto.getContactIds());
            VipWeworkAccount vipWeworkAccount = (VipWeworkAccount)vipWeworkAccountMap.get(robotWeworkId);
            if (this.isNotValidate(tipMsg, robotWeworkId, vipWeworkAccount, contactWeworkIds, externalContactCountMap)) continue;
            Integer contactCount = (Integer)externalContactCountMap.get(robotWeworkId);
            int canDelTotalCount = this.getCanDelTotalCount(contactCount, configDto);
            log.info("canDelTotalCount:{}, contactWeworkIdCount:{}", (Object)canDelTotalCount, (Object)contactWeworkIds.size());
            int alreadyDelCount = alreadyDelCountMap.getOrDefault(robotWeworkId, 0);
            Date subTaskStartDate = startDate;
            for (String contactWeworkId : contactWeworkIds) {
                int delFriendsIntervalSeconds = this.getDelFriendsIntervalSeconds(configDto.getMinDelFriendsInterval(), configDto.getMaxDelFriendsInterval());
                subTaskStartDate = DateUtils.addSeconds((Date)subTaskStartDate, (int)delFriendsIntervalSeconds);
                VipToolDelFriendDetail detail = new VipToolDelFriendDetail();
                detail.setNum(this.idGen.getNum());
                detail.setBizId(bizId);
                detail.setTaskId(taskId);
                detail.setRobotWeworkId(robotWeworkId);
                detail.setContactWeworkId(contactWeworkId);
                detail.setRequestId("");
                detail.setExpectDelTime(subTaskStartDate);
                if (alreadyDelCount < canDelTotalCount) {
                    detail.setStatus(Integer.valueOf(DelFriendsStatus.NOT_START.getValue()));
                    detail.setFailReason("");
                } else {
                    detail.setStatus(Integer.valueOf(DelFriendsStatus.FAIL.getValue()));
                    detail.setFailReason("\u5df2\u8d85\u8fc7" + configDto.getEveryDayDelFriendsUpperLimit() + "%\u7684\u9650\u5236");
                }
                detail.setCreateBy(userId);
                detail.setCreateTime(new Date());
                detail.setUpdateBy(userId);
                detail.setUpdateTime(new Date());
                vipToolDelFriendDetails.add(detail);
                ++alreadyDelCount;
            }
        }
        if (CollectionUtils.isEmpty((Collection)vipToolDelFriendDetails)) {
            log.info("vipToolDelFriendDetails \u96c6\u5408\u4e3a\u7a7a");
            this.vipToolDelFriendTaskMapper.deleteByPrimaryKey((Object)taskId);
        } else {
            Lists.partition((List)vipToolDelFriendDetails, (int)500).forEach(list -> this.vipToolDelFriendDetailMapper.batchInsertDetail((Collection)list));
        }
        log.info("add del friend task success, taskId:{}, tipMsg:{}", (Object)taskId, (Object)tipMsg);
        return tipMsg.toString();
    }

    private boolean isNotValidate(StringBuilder tipMsg, String robotWeworkId, VipWeworkAccount vipWeworkAccount, Set<String> contactWeworkIds, Map<String, Integer> externalContactCountMap) {
        if (vipWeworkAccount == null) {
            log.warn("\u673a\u5668\u4eba:{},\u6ca1\u6709\u5bf9\u5e94\u7684\u5fae\u4fe1\u53f7", (Object)robotWeworkId);
            if (tipMsg.length() > 0) {
                tipMsg.append(',');
            }
            tipMsg.append(robotWeworkId).append("\u6ca1\u6709\u5bf9\u5e94\u7684\u5fae\u4fe1\u53f7");
            return true;
        }
        String nickname = vipWeworkAccount.getNickname();
        if (CollectionUtils.isEmpty(contactWeworkIds) || MapUtils.isEmpty(externalContactCountMap) || externalContactCountMap.get(robotWeworkId) <= 0) {
            log.warn("\u673a\u5668\u4eba:{},\u6ca1\u6709\u5bf9\u5e94\u7684\u597d\u53cb", (Object)robotWeworkId);
            if (tipMsg.length() > 0) {
                tipMsg.append(',');
            }
            tipMsg.append(nickname).append("\u6ca1\u6709\u5bf9\u5e94\u7684\u597d\u53cb");
            return true;
        }
        if (this.isGoingDelFriends(robotWeworkId)) {
            log.warn("\u673a\u5668\u4eba:{}, \u5df2\u7ecf\u5904\u4e8e\u5220\u9664\u597d\u53cb\u7684\u4efb\u52a1\u4e2d\uff0c\u6682\u65f6\u4e0d\u80fd\u65b0\u5efa\u5220\u9664\u4efb\u52a1", (Object)robotWeworkId);
            if (tipMsg.length() > 0) {
                tipMsg.append(',');
            }
            tipMsg.append(nickname).append("\u5df2\u7ecf\u5904\u4e8e\u5220\u9664\u597d\u53cb\u7684\u4efb\u52a1\u4e2d\uff0c\u6682\u65f6\u4e0d\u80fd\u65b0\u5efa\u5220\u9664\u4efb\u52a1");
            return true;
        }
        return false;
    }

    @Override
    public List<VipDelFriendTaskRespDto> taskList(VipDelFriendListReqDto params) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo), (Object)"\u5f53\u524d\u64cd\u4f5c\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        Long bizId = currentUserInfo.getBizId();
        log.info("\u5f53\u524d\u64cd\u4f5c\u4ebaid:{}, \u5f53\u524d\u5546\u6237id:{}", (Object)currentUserInfo.getId(), (Object)bizId);
        Set manageUserIds = this.userRoleCommonService.getManageUserIds();
        if (StringUtils.isNotBlank((CharSequence)params.getCreateBy())) {
            Long userId = this.userMapper.getIdByNum(params.getCreateBy());
            manageUserIds.retainAll(Lists.newArrayList((Object[])new Long[]{userId}));
        }
        if (CollectionUtils.isEmpty((Collection)manageUserIds)) {
            log.info("\u5f53\u524d\u64cd\u4f5c\u4eba\u6ca1\u6709\u6570\u636e\u6743\u9650");
            return Collections.emptyList();
        }
        PageDto pageDto = params.getPageDto();
        if (Objects.isNull(pageDto)) {
            pageDto = new PageDto();
            params.setPageDto(pageDto);
        }
        Set taskIds = Sets.newHashSet();
        if (StringUtils.isNotBlank((CharSequence)params.getWeworkUserNum())) {
            String weworkDigitId = this.weworkUserMapper.queryWeworkDigitIdByNum(params.getWeworkUserNum());
            if (StringUtils.isBlank((CharSequence)weworkDigitId)) {
                log.info("\u6839\u636e\u5546\u6237id:{}, \u6210\u5458num:{} \u672a\u67e5\u8be2\u5230\u4efb\u52a1ID", (Object)bizId, (Object)params.getWeworkUserNum());
                return Collections.emptyList();
            }
            taskIds = this.vipToolDelFriendDetailMapper.getByBizIdAndWeworkQuery(bizId, weworkDigitId);
            if (CollectionUtils.isEmpty((Collection)taskIds)) {
                log.info("\u6839\u636e\u5546\u6237id:{},\u673a\u5668\u4eba\u5fae\u4fe1id:{}\u672a\u67e5\u8be2\u5230\u4efb\u52a1id", (Object)bizId, (Object)weworkDigitId);
                return Collections.emptyList();
            }
        }
        DelFriendTaskQueryCondition delFriendTaskQueryCondition = new DelFriendTaskQueryCondition();
        delFriendTaskQueryCondition.setBizId(bizId);
        delFriendTaskQueryCondition.setTaskIds(taskIds);
        delFriendTaskQueryCondition.setUserIds(manageUserIds);
        delFriendTaskQueryCondition.setBeginCreateTime(params.getBeginCreateTime());
        delFriendTaskQueryCondition.setEndCreateTime(params.getEndCreateTime());
        delFriendTaskQueryCondition.setPageSize(pageDto.getPageSize().intValue());
        delFriendTaskQueryCondition.setOffset(pageDto.getOffset());
        List vipToolDelFriendTasks = this.vipToolDelFriendTaskMapper.queryListByCondition(delFriendTaskQueryCondition);
        if (CollectionUtils.isEmpty((Collection)vipToolDelFriendTasks)) {
            log.info("\u672a\u67e5\u8be2\u5230\u4efb\u52a1\u6570\u636e\uff0ccondition:{}", (Object)delFriendTaskQueryCondition);
            return Collections.emptyList();
        }
        int count = this.vipToolDelFriendTaskMapper.queryCountByCondition(delFriendTaskQueryCondition);
        pageDto.setCount(Integer.valueOf(count));
        pageDto.setCurPageCount(Integer.valueOf(vipToolDelFriendTasks.size()));
        Set pageTaskIds = vipToolDelFriendTasks.stream().map(VipToolDelFriendTask::getId).collect(Collectors.toSet());
        List pageVipToolDelFriendTasks = this.vipToolDelFriendDetailMapper.getStatisticCountByTaskIds(pageTaskIds);
        Map<Object, Object> taskId2StatisticCountMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)pageVipToolDelFriendTasks)) {
            taskId2StatisticCountMap = pageVipToolDelFriendTasks.stream().collect(Collectors.toMap(DelFriendStatisticCountDto::getTaskId, Function.identity()));
        }
        Map taskId2ExpectDelTime = this.vipToolDelFriendDetailMapper.getTaskMaxExpectDelTime(pageTaskIds);
        Set userIds = vipToolDelFriendTasks.stream().map(VipToolDelFriendTask::getCreateBy).collect(Collectors.toSet());
        List users = this.userMapper.getUserInfoByIds(userIds);
        Map<Object, Object> userMap = CollectionUtils.isNotEmpty((Collection)users) ? users.stream().collect(Collectors.toMap(User::getId, Function.identity())) : Collections.emptyMap();
        HashSet weworkIds = Sets.newHashSet();
        vipToolDelFriendTasks.forEach(task -> {
            String robotWeworkIds = task.getRobotWeworkIds();
            weworkIds.addAll(Sets.newHashSet((Object[])robotWeworkIds.split(",")));
        });
        List vipWeworkAccounts = this.vipWeworkAccountMapper.queryByWeworkIdsAndBizId((Collection)weworkIds, bizId);
        Map<String, Object> vipWeworkAccountMap = CollectionUtils.isNotEmpty((Collection)vipWeworkAccounts) ? vipWeworkAccounts.stream().collect(Collectors.toMap(VipWeworkAccount::getWeworkId, Function.identity())) : Collections.emptyMap();
        return this.buildResult(vipToolDelFriendTasks, vipWeworkAccountMap, userMap, taskId2StatisticCountMap, taskId2ExpectDelTime);
    }

    @Override
    public void cancel(VipDelFriendCancelDto params) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Preconditions.checkNotNull((Object)currentUserInfo, (Object)"\u5f53\u524d\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        Preconditions.checkNotNull((Object)params, (Object)"\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
        Preconditions.checkNotNull((Object)params.getTaskId(), (Object)"\u4efb\u52a1id\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("cancelDel, taskId:{}, operatorId:{}", (Object)params.getTaskId(), (Object)currentUserInfo.getId());
        VipToolDelFriendTask task = this.vipToolDelFriendTaskMapper.getByNum(params.getTaskId());
        Preconditions.checkNotNull((Object)task, (Object)"\u4efb\u52a1id\u4e0d\u5408\u6cd5");
        this.vipToolDelFriendTaskMapper.updateIsCanceledById(NumberUtils.INTEGER_ONE, task.getId(), currentUserInfo.getId());
        this.vipToolDelFriendDetailMapper.changeNotStartToFailByTaskId(task.getId(), "\u53d6\u6d88\u5220\u9664", currentUserInfo.getId());
    }

    @Override
    public void retry(VipDelFriendRetryReqDto params) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo), (Object)"\u5f53\u524d\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(params.getTaskId()), (Object)"\u4efb\u52a1id\u4e3a\u7a7a");
        Long bizId = currentUserInfo.getBizId();
        Long operatorId = currentUserInfo.getId();
        log.info("retryDel, operatorId:{}, taskId:{}, detailId:{}", new Object[]{operatorId, params.getTaskId(), params.getDetailId()});
        VipToolDelFriendTask task = this.vipToolDelFriendTaskMapper.getByNum(params.getTaskId());
        Preconditions.checkArgument((boolean)Objects.nonNull(task), (Object)"\u6839\u636e\u4efb\u52a1id\u672a\u83b7\u53d6\u5230\u8bb0\u5f55");
        if (Objects.nonNull(params.getDetailId())) {
            this.retryDelSingleRecord(bizId, operatorId, task.getId(), params.getDetailId());
        } else {
            this.retryDelTaskAllFailedRecord(bizId, operatorId, task.getId());
        }
        this.vipToolDelFriendTaskMapper.updateUpdaterIdAndUpdateTimeById(currentUserInfo.getId(), task.getId());
        log.info("retryDel,\u66f4\u65b0\u4efb\u52a1id:{}\u66f4\u65b0\u4eba\u548c\u66f4\u65b0\u65f6\u95f4\u6210\u529f", (Object)params.getTaskId());
    }

    @Override
    public List<VipDelFriendDetailRespDto> detailList(VipDelFriendDetailReqDto params) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo), (Object)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(params.getTaskId()), (Object)"\u4efb\u52a1id\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("get delFriend task detail, operatorId:{}, params:{}", (Object)currentUserInfo.getId(), (Object)params);
        params.validateParams();
        Long bizId = currentUserInfo.getBizId();
        VipToolDelFriendTask task = this.vipToolDelFriendTaskMapper.getByNum(params.getTaskId());
        Preconditions.checkArgument((boolean)Objects.nonNull(task), (Object)"\u6839\u636e\u4efb\u52a1id\u672a\u83b7\u53d6\u5230\u8bb0\u5f55");
        DelFriendDetailQueryCondition delFriendDetailQueryCondition = new DelFriendDetailQueryCondition();
        delFriendDetailQueryCondition.setTaskId(task.getId());
        delFriendDetailQueryCondition.setStatus(params.getStatus());
        if (StringUtils.isNotBlank((CharSequence)params.getWeworkUserNum())) {
            String weworkDigitId = this.weworkUserMapper.queryWeworkDigitIdByNum(params.getWeworkUserNum());
            if (StringUtils.isBlank((CharSequence)weworkDigitId)) {
                log.info("\u6839\u636e\u6761\u4ef6\u672a\u67e5\u8be2\u5230\u8bb0\u5f55");
                return Collections.emptyList();
            }
            delFriendDetailQueryCondition.setRobotWeworkId(weworkDigitId);
        }
        delFriendDetailQueryCondition.setOffset(Integer.valueOf(params.getPageDto().getOffset()));
        delFriendDetailQueryCondition.setPageSize(params.getPageDto().getPageSize());
        List vipToolDelFriendDetails = this.vipToolDelFriendDetailMapper.getListByProcessCondition(delFriendDetailQueryCondition);
        if (CollectionUtils.isEmpty((Collection)vipToolDelFriendDetails)) {
            log.info("\u6839\u636e\u6761\u4ef6\u672a\u67e5\u8be2\u5230\u8bb0\u5f55");
            return Collections.emptyList();
        }
        int count = this.vipToolDelFriendDetailMapper.getCountByProcessCondition(delFriendDetailQueryCondition);
        params.getPageDto().setCurPageCount(Integer.valueOf(vipToolDelFriendDetails.size()));
        params.getPageDto().setCount(Integer.valueOf(count));
        Set robotWeworkIds = vipToolDelFriendDetails.stream().map(VipToolDelFriendDetail::getRobotWeworkId).collect(Collectors.toSet());
        Set contactWeworkIds = vipToolDelFriendDetails.stream().map(VipToolDelFriendDetail::getContactWeworkId).collect(Collectors.toSet());
        Map contactIdMap = this.vipWeworkContactDigitIdMapper.queryContactIdMapByDigitId(bizId, contactWeworkIds);
        Map customerNumMap = this.ccCustomerNumService.butchGetCustomerNumByContactId(bizId, contactIdMap.values());
        List vipWeworkAccounts = this.vipWeworkAccountMapper.queryByWeworkIdsAndBizId(robotWeworkIds, bizId);
        Map<Object, Object> vipWeworkAccountMap = CollectionUtils.isNotEmpty((Collection)vipWeworkAccounts) ? vipWeworkAccounts.stream().collect(Collectors.toMap(VipWeworkAccount::getWeworkId, Function.identity())) : Collections.emptyMap();
        List vipWeworkContacts = this.vipWeworkContactMapper.queryByWeworkIdsAndContactIds(bizId, robotWeworkIds, contactWeworkIds);
        Map<Object, Object> vipWeworkContactMap = CollectionUtils.isNotEmpty((Collection)vipWeworkAccounts) ? vipWeworkContacts.stream().collect(Collectors.toMap(it -> it.getWeworkId() + "_" + it.getContactId(), Function.identity())) : Collections.emptyMap();
        ArrayList detailList = Lists.newArrayList();
        for (VipToolDelFriendDetail detail : vipToolDelFriendDetails) {
            String weworkIdAndContactId = detail.getRobotWeworkId() + "_" + detail.getContactWeworkId();
            VipWeworkAccount vipWeworkAccount = (VipWeworkAccount)vipWeworkAccountMap.get(detail.getRobotWeworkId());
            VipWeworkContact vipWeworkContact = (VipWeworkContact)vipWeworkContactMap.get(weworkIdAndContactId);
            String contactId = (String)contactIdMap.get(detail.getContactWeworkId());
            String customerNum = null;
            if (StringUtils.isNotBlank((CharSequence)contactId)) {
                customerNum = (String)customerNumMap.get(contactId);
            }
            VipDelFriendDetailRespDto detailRespDto = this.buildDetailRespDto(detail, customerNum, vipWeworkContact, vipWeworkAccount);
            detailList.add(detailRespDto);
        }
        return detailList;
    }

    private VipDelFriendDetailRespDto buildDetailRespDto(VipToolDelFriendDetail detail, String customerNum, VipWeworkContact vipWeworkContact, VipWeworkAccount vipWeworkAccount) {
        VipDelFriendDetailRespDto detailRespDto = new VipDelFriendDetailRespDto();
        detailRespDto.setDetailId(detail.getNum());
        detailRespDto.setCustomerNum(customerNum);
        if (Objects.nonNull(vipWeworkContact)) {
            detailRespDto.setContactAvatar(vipWeworkContact.getAvatar());
            if (StringUtils.isNotBlank((CharSequence)vipWeworkContact.getRealName())) {
                detailRespDto.setContactName(vipWeworkContact.getRealName());
            } else {
                detailRespDto.setContactName(vipWeworkContact.getNickname());
            }
            if (!"\u5fae\u4fe1".equals(vipWeworkContact.getCorpName())) {
                detailRespDto.setContactCorpName(vipWeworkContact.getCorpName());
            }
            if (StringUtils.isBlank((CharSequence)vipWeworkContact.getRemark())) {
                detailRespDto.setContactRemark(detailRespDto.getContactName());
            } else {
                detailRespDto.setContactRemark(vipWeworkContact.getRemark());
            }
        }
        if (Objects.nonNull(vipWeworkAccount)) {
            detailRespDto.setWeworkUserAvatar(vipWeworkAccount.getAvatar());
            detailRespDto.setWeworkUserName(vipWeworkAccount.getNickname());
        }
        detailRespDto.setRealDelTime(detail.getRealDelTime());
        detailRespDto.setStatus(detail.getStatus());
        DelFriendsStatus status = DelFriendsStatus.getType(detail.getStatus());
        if (Objects.nonNull((Object)status)) {
            detailRespDto.setStatusStr(status.getDesc());
        }
        detailRespDto.setFailReason(detail.getFailReason());
        detailRespDto.setExpectDelTime(detail.getExpectDelTime());
        return detailRespDto;
    }

    @Override
    public void delFriends() {
        Date date = new Date();
        log.info("delFriends,date:{}", (Object)date);
        List vipToolDelFriendDetails = this.vipToolDelFriendDetailMapper.selectByStatusAndExpectDelTime(Integer.valueOf(DelFriendsStatus.NOT_START.getValue()), date);
        if (CollectionUtils.isEmpty((Collection)vipToolDelFriendDetails)) {
            log.info("\u6839\u636estatus:{},date:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)DelFriendsStatus.NOT_START.getValue(), (Object)date);
            return;
        }
        Map<Long, List<VipToolDelFriendDetail>> bizDetailMap = vipToolDelFriendDetails.stream().collect(Collectors.groupingBy(VipToolDelFriendDetail::getBizId));
        bizDetailMap.forEach(this::delFriend);
    }

    private void delFriend(Long bizId, List<VipToolDelFriendDetail> vipToolDelFriendDetails) {
        Map<String, List<VipToolDelFriendDetail>> detailMap = vipToolDelFriendDetails.stream().collect(Collectors.groupingBy(VipToolDelFriendDetail::getRobotWeworkId));
        Set<String> robotWeworkIds = detailMap.keySet();
        HashSet contactWeworkIds = Sets.newHashSet();
        ArrayList details = Lists.newArrayList();
        for (Map.Entry<String, List<VipToolDelFriendDetail>> entry : detailMap.entrySet()) {
            List sortedDetails = entry.getValue().stream().sorted(Comparator.comparing(VipToolDelFriendDetail::getExpectDelTime)).collect(Collectors.toList());
            contactWeworkIds.add(((VipToolDelFriendDetail)sortedDetails.get(0)).getContactWeworkId());
            details.add(sortedDetails.get(0));
        }
        if (CollectionUtils.isEmpty((Collection)details)) {
            log.info("\u5f53\u524d\u65f6\u95f4\u70b9:{}\u5185\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u8bb0\u5f55", (Object)new Date());
            return;
        }
        List detailIds = details.stream().map(VipToolDelFriendDetail::getId).sorted().collect(Collectors.toList());
        this.vipToolDelFriendDetailMapper.updateStatusByIds(Integer.valueOf(DelFriendsStatus.ONGOING.getValue()), detailIds);
        log.info("\u66f4\u65b0detail\u8868\u8bb0\u5f55\u4e3a\u8fdb\u884c\u4e2d,detailIds:{}", detailIds);
        List vipWeworkContacts = this.vipWeworkContactMapper.queryByWeworkIdsAndContactIds(bizId, robotWeworkIds, (Collection)contactWeworkIds);
        Map vipWeworkContactMap = vipWeworkContacts.stream().collect(Collectors.toMap(it -> it.getWeworkId() + "_" + it.getContactId(), Function.identity()));
        for (VipToolDelFriendDetail detail : details) {
            this.executorService.execute(() -> {
                String robotWeworkId = detail.getRobotWeworkId();
                String contactWeworkId = detail.getContactWeworkId();
                String redisKey = this.redisKeyPrefix + MEDIUM + robotWeworkId;
                try {
                    Object redisValue = this.redisTemplate.opsForValue().get((Object)redisKey);
                    log.info("delFriends, robotWeworkId:{}, contactWeworkId:{}, redisKey:{}, redisValue:{}", new Object[]{robotWeworkId, contactWeworkId, redisKey, redisValue});
                    if (Objects.nonNull(redisValue)) {
                        detail.setStatus(Integer.valueOf(DelFriendsStatus.NOT_START.getValue()));
                    } else {
                        VipWeworkContact vipWeworkContact;
                        this.redisTemplate.opsForValue().set((Object)redisKey, (Object)EXPIRE_TIME, (long)EXPIRE_TIME.intValue(), TimeUnit.SECONDS);
                        detail.setStatus(Integer.valueOf(DelFriendsStatus.SUCCESS.getValue()));
                        if (MapUtils.isNotEmpty((Map)vipWeworkContactMap) && Objects.nonNull(vipWeworkContact = (VipWeworkContact)vipWeworkContactMap.get(robotWeworkId + "_" + contactWeworkId))) {
                            if (NumberUtils.INTEGER_ONE.equals(vipWeworkContact.getIsDeleted())) {
                                detail.setStatus(Integer.valueOf(DelFriendsStatus.SUCCESS.getValue()));
                                detail.setRealDelTime(detail.getExpectDelTime());
                            } else {
                                this.deleteContact(vipWeworkContact, detail);
                            }
                        }
                    }
                    this.vipToolDelFriendDetailMapper.updateDetailInfo(detail);
                    log.info("\u66f4\u65b0detailId:{}\u7684\u72b6\u6001\u4e3a:{}", (Object)detail.getId(), (Object)detail.getStatus());
                }
                catch (Exception ex) {
                    log.error("\u66f4\u65b0\u8be6\u60c5\u8bb0\u5f55{}\u53d1\u751f\u5f02\u5e38", (Object)detail.getId(), (Object)ex);
                }
            });
        }
    }

    @Override
    public void handleDelFriends(OpBaseResponse opBaseResponse) {
        log.info("handleDelFriends,opBaseResponse:{}", (Object)opBaseResponse);
        String requestId = opBaseResponse.getRequestId();
        VipToolDelFriendDetail vipToolDelFriendDetail = this.vipToolDelFriendDetailMapper.queryByRequestId(requestId);
        if (Objects.isNull(vipToolDelFriendDetail)) {
            log.info("\u6839\u636erequestId:{}\u672a\u67e5\u627e\u5230\u8bb0\u5f55", (Object)requestId);
            return;
        }
        if (opBaseResponse.getCode() == ResponseCodeType.SUCCESS.getCode() || opBaseResponse.getCode() == 13) {
            vipToolDelFriendDetail.setStatus(Integer.valueOf(DelFriendsStatus.SUCCESS.getValue()));
            vipToolDelFriendDetail.setFailReason("");
            vipToolDelFriendDetail.setRealDelTime(new Date());
        } else {
            vipToolDelFriendDetail.setStatus(Integer.valueOf(DelFriendsStatus.FAIL.getValue()));
            vipToolDelFriendDetail.setFailReason(ResponseErrUtil.getRemark((OpBaseResponse)opBaseResponse));
        }
        this.vipToolDelFriendDetailMapper.updateDetailInfo(vipToolDelFriendDetail);
    }

    @Override
    public void compensateDelFriendStatus() {
        List allOngoingDetails = this.vipToolDelFriendDetailMapper.getByStatus(Integer.valueOf(DelFriendsStatus.ONGOING.getValue()));
        if (CollectionUtils.isEmpty((Collection)allOngoingDetails)) {
            return;
        }
        List details = allOngoingDetails.stream().filter(detail -> detail.getExpectDelTime().before(DateUtils.addHours((Date)new Date(), (int)-1))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(details)) {
            log.info("\u671f\u671b\u5220\u9664\u65f6\u95f4\u6ca1\u6709\u5728\u5f53\u524d\u65f6\u95f41\u5c0f\u65f6\u4e4b\u524d\u7684\u8bb0\u5f55");
            return;
        }
        Map<Long, List<VipToolDelFriendDetail>> bizDetailMap = details.stream().collect(Collectors.groupingBy(VipToolDelFriendDetail::getBizId));
        bizDetailMap.forEach(this::compensateDelFriendStatus);
    }

    private void compensateDelFriendStatus(Long bizId, List<VipToolDelFriendDetail> details) {
        Set contactWeworkIds;
        Set robotWeworkIds = details.stream().map(VipToolDelFriendDetail::getRobotWeworkId).collect(Collectors.toSet());
        List vipWeworkContacts = this.vipWeworkContactMapper.queryByWeworkIdsAndContactIds(bizId, robotWeworkIds, contactWeworkIds = details.stream().map(VipToolDelFriendDetail::getContactWeworkId).collect(Collectors.toSet()));
        Map<Object, Object> contactDeletedMap = CollectionUtils.isNotEmpty((Collection)vipWeworkContacts) ? vipWeworkContacts.stream().collect(Collectors.toMap(it -> it.getWeworkId() + "_" + it.getContactId(), VipWeworkContact::getIsDeleted)) : Collections.emptyMap();
        HashSet successDetailIds = Sets.newHashSet();
        HashSet failDetailIds = Sets.newHashSet();
        for (VipToolDelFriendDetail detail : details) {
            String key = detail.getRobotWeworkId() + "_" + detail.getContactWeworkId();
            if (MapUtils.isNotEmpty(contactDeletedMap) && contactDeletedMap.containsKey(key)) {
                if (NumberUtils.INTEGER_ONE.equals(contactDeletedMap.get(key))) {
                    successDetailIds.add(detail.getId());
                    continue;
                }
                failDetailIds.add(detail.getId());
                continue;
            }
            failDetailIds.add(detail.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)successDetailIds)) {
            this.vipToolDelFriendDetailMapper.updateStatusByIds(Integer.valueOf(DelFriendsStatus.SUCCESS.getValue()), (Collection)successDetailIds);
            log.info("\u66f4\u65b0\u5b50\u4efb\u52a1:{}\u72b6\u6001\u4e3a\u6210\u529f", (Object)successDetailIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)failDetailIds)) {
            this.vipToolDelFriendDetailMapper.updateStatusByIds(Integer.valueOf(DelFriendsStatus.FAIL.getValue()), (Collection)failDetailIds);
            log.info("\u66f4\u65b0\u5b50\u4efb\u52a1:{}\u72b6\u6001\u4e3a\u5931\u8d25", (Object)failDetailIds);
        }
    }

    private VipToolDelFriendTask buildVipToolDelFriendTask(Long bizId, Long userId, List<String> robotWeworkIds) {
        VipToolDelFriendTask task = new VipToolDelFriendTask();
        task.setNum(this.idGen.getNum());
        task.setBizId(bizId);
        task.setIsCanceled(NumberUtils.INTEGER_ZERO);
        task.setRobotWeworkIds(String.join((CharSequence)",", robotWeworkIds));
        task.setCreateBy(userId);
        task.setCreateTime(new Date());
        task.setUpdateBy(userId);
        task.setUpdateTime(new Date());
        return task;
    }

    private int getDelFriendsIntervalSeconds(int min, int max) {
        return min + RAND.nextInt(max - min) + 1;
    }

    private int getCanDelTotalCount(Integer contactCount, VipDelFriendsConfigDto configDto) {
        if (Objects.isNull(contactCount) || Objects.isNull(configDto.getEveryDayDelFriendsUpperLimit())) {
            return 0;
        }
        if (contactCount <= configDto.getMinDelFriendsLimitCount()) {
            return contactCount;
        }
        return contactCount * configDto.getEveryDayDelFriendsUpperLimit() / 100;
    }

    @Override
    public VipDelFriendsConfigDto getDelFriendsConfig() {
        Long bizId = LoginUtils.getCurrentUserBizId();
        log.info("getDelFriendsConfig, bizId:{}", (Object)bizId);
        return this.getDelFriendsConfig(bizId);
    }

    public VipDelFriendsConfigDto getDelFriendsConfig(Long bizId) {
        log.info("getDelFriendsConfig, bizId:{}", (Object)bizId);
        VipDelFriendsConfigDto configDto = new VipDelFriendsConfigDto();
        configDto.setMinDelFriendsInterval(this.settingService.getIntegerOrDefault(bizId, SettingEnum.MIN_DEL_FRIENDS_INTERVAL.getName(), this.minDelFriendsInterval));
        configDto.setMaxDelFriendsInterval(this.settingService.getIntegerOrDefault(bizId, SettingEnum.MAX_DEL_FRIENDS_INTERVAL.getName(), this.maxDelFriendsInterval));
        configDto.setEveryDayDelFriendsUpperLimit(this.settingService.getIntegerOrDefault(bizId, SettingEnum.EVERY_DAY_DEL_FRIENDS_UPPER_LIMIT.getName(), this.everyDayDelFriendsUpperLimit));
        configDto.setMinDelFriendsLimitCount(this.settingService.getIntegerOrDefault(bizId, SettingEnum.MIN_DEL_FRIENDS_LIMIT_COUNT.getName(), this.minDelFriendsLimitCount));
        return configDto;
    }

    @Override
    public void setDelFriendsConfig(VipDelFriendsConfigDto params) {
        Long bizId = LoginUtils.getCurrentUserBizId();
        log.info("setDelFriendsConfig, bizId:{}, params:{}", (Object)bizId, (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e3a\u7a7a");
        if (params.getMinDelFriendsInterval() != null) {
            Preconditions.checkArgument((params.getMinDelFriendsInterval() >= 0 ? 1 : 0) != 0, (Object)"\u6700\u5c0f\u5220\u9664\u95f4\u9694\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0");
        }
        if (params.getMaxDelFriendsInterval() != null) {
            Preconditions.checkArgument((params.getMaxDelFriendsInterval() > 0 ? 1 : 0) != 0, (Object)"\u6700\u5927\u5220\u9664\u95f4\u9694\u5fc5\u987b\u5927\u4e8e0");
        }
        if (params.getMinDelFriendsLimitCount() != null) {
            Preconditions.checkArgument((params.getMinDelFriendsLimitCount() > 0 ? 1 : 0) != 0, (Object)"\u6700\u5c0f\u5220\u9664\u597d\u53cb\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
        }
        if (params.getEveryDayDelFriendsUpperLimit() != null) {
            Preconditions.checkArgument((params.getEveryDayDelFriendsUpperLimit() >= 0 ? 1 : 0) != 0, (Object)"\u6bcf\u65e5\u5220\u9664\u4e0a\u9650\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0");
            Preconditions.checkArgument((params.getEveryDayDelFriendsUpperLimit() <= 100 ? 1 : 0) != 0, (Object)"\u6bcf\u65e5\u5220\u9664\u4e0a\u9650\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e100");
        }
        if (params.getMaxDelFriendsInterval() != null && params.getMinDelFriendsInterval() != null) {
            Preconditions.checkArgument((params.getMinDelFriendsInterval() <= params.getMaxDelFriendsInterval() ? 1 : 0) != 0, (Object)"\u6700\u5c0f\u5220\u9664\u95f4\u9694\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u6700\u5927\u5220\u9664\u95f4\u9694");
        } else if (params.getMaxDelFriendsInterval() != null) {
            Integer min = this.settingService.getIntegerOrDefault(bizId, SettingEnum.MIN_DEL_FRIENDS_INTERVAL.getName(), this.minDelFriendsInterval);
            Preconditions.checkArgument((params.getMaxDelFriendsInterval() >= min ? 1 : 0) != 0, (Object)"\u6700\u5927\u5220\u9664\u95f4\u9694\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5f53\u524d\u6700\u5c0f\u5220\u9664\u95f4\u9694");
        } else if (params.getMinDelFriendsInterval() != null) {
            Integer max = this.settingService.getIntegerOrDefault(bizId, SettingEnum.MAX_DEL_FRIENDS_INTERVAL.getName(), this.maxDelFriendsInterval);
            Preconditions.checkArgument((params.getMinDelFriendsInterval() <= max ? 1 : 0) != 0, (Object)"\u6700\u5c0f\u5220\u9664\u95f4\u9694\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u5f53\u524d\u6700\u5927\u5220\u9664\u95f4\u9694");
        }
        SettingReqDto settingReqDto = new SettingReqDto();
        settingReqDto.setStatus(Integer.valueOf(0));
        if (params.getMinDelFriendsLimitCount() != null) {
            settingReqDto.setParamName(SettingEnum.MIN_DEL_FRIENDS_INTERVAL.getName());
            settingReqDto.setParamValue(params.getMinDelFriendsInterval().toString());
            this.settingService.modSetting(settingReqDto);
        }
        if (params.getMaxDelFriendsInterval() != null) {
            settingReqDto.setParamName(SettingEnum.MAX_DEL_FRIENDS_INTERVAL.getName());
            settingReqDto.setParamValue(params.getMaxDelFriendsInterval().toString());
            this.settingService.modSetting(settingReqDto);
        }
        if (params.getMinDelFriendsLimitCount() != null) {
            settingReqDto.setParamName(SettingEnum.MIN_DEL_FRIENDS_LIMIT_COUNT.getName());
            settingReqDto.setParamValue(params.getMinDelFriendsLimitCount().toString());
            this.settingService.modSetting(settingReqDto);
        }
        if (params.getEveryDayDelFriendsUpperLimit() != null) {
            settingReqDto.setParamName(SettingEnum.EVERY_DAY_DEL_FRIENDS_UPPER_LIMIT.getName());
            settingReqDto.setParamValue(params.getEveryDayDelFriendsUpperLimit().toString());
            this.settingService.modSetting(settingReqDto);
        }
    }

    private List<VipDelFriendTaskRespDto> buildResult(List<VipToolDelFriendTask> vipToolDelFriendTasks, Map<String, VipWeworkAccount> vipWeworkAccountMap, Map<Long, User> userMap, Map<Long, DelFriendStatisticCountDto> statisticCountDtoMap, Map<Long, Date> taskId2ExpectDelTime) {
        ArrayList list = Lists.newArrayList();
        for (VipToolDelFriendTask task : vipToolDelFriendTasks) {
            DelFriendStatisticCountDto statistic;
            VipDelFriendTaskRespDto respDto = new VipDelFriendTaskRespDto();
            respDto.setId(task.getNum());
            respDto.setIsCanceled(task.getIsCanceled());
            respDto.setIsCanceledStr(NumberUtils.INTEGER_ZERO.equals(task.getIsCanceled()) ? "\u672a\u53d6\u6d88" : "\u5df2\u53d6\u6d88");
            String[] taskWeworkIds = task.getRobotWeworkIds().split(",");
            ArrayList weworkUserNameList = Lists.newArrayList();
            for (String weworkId : taskWeworkIds) {
                if (!vipWeworkAccountMap.containsKey(weworkId)) continue;
                VipWeworkAccount vipWeworkAccount = vipWeworkAccountMap.get(weworkId);
                weworkUserNameList.add(vipWeworkAccount.getNickname());
            }
            if (!weworkUserNameList.isEmpty()) {
                respDto.setWeworkUserNameList(weworkUserNameList);
            }
            respDto.setCreateTime(task.getCreateTime());
            User user = userMap.get(task.getCreateBy());
            if (user != null) {
                respDto.setCreateName(user.getName());
            }
            if ((statistic = statisticCountDtoMap.get(task.getId())) != null) {
                respDto.setFailCount(statistic.getFailCount());
                respDto.setOngoingCount(statistic.getOngoingCount());
                respDto.setSuccessCount(statistic.getSuccessCount());
                respDto.setNotStartCount(statistic.getNotStartCount());
            }
            if (MapUtils.isNotEmpty(taskId2ExpectDelTime) && taskId2ExpectDelTime.containsKey(task.getId())) {
                respDto.setExpectDelTime(taskId2ExpectDelTime.get(task.getId()));
            }
            list.add(respDto);
        }
        return list;
    }

    private void retryDelSingleRecord(Long bizId, Long operatorId, Long taskId, String detailId) {
        log.info("retryDelSingleRecord, operatorId:{}, taskId:{}, detailId:{}", new Object[]{operatorId, taskId, detailId});
        VipToolDelFriendDetail detail = this.vipToolDelFriendDetailMapper.getByNum(detailId);
        Preconditions.checkArgument((boolean)Objects.nonNull(detail), (Object)"\u6839\u636e\u5b50\u4efb\u52a1id\u672a\u67e5\u8be2\u5230\u5b50\u4efb\u52a1");
        Preconditions.checkArgument((DelFriendsStatus.FAIL.getValue() == detail.getStatus().intValue() ? 1 : 0) != 0, (Object)"\u5b50\u4efb\u52a1\u4e0d\u4e3a\u5df2\u5931\u8d25\uff0c\u4e0d\u80fd\u91cd\u590d\u5220\u9664");
        VipWeworkContact weworkContact = this.vipWeworkContactMapper.queryByWeworkIdAndContactId(detail.getRobotWeworkId(), detail.getContactWeworkId(), bizId);
        if (weworkContact == null) {
            log.error("\u6839\u636eweworkId:{}, contactId:{} \u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)detail.getRobotWeworkId(), (Object)detail.getContactWeworkId());
            return;
        }
        VipWeworkAccount weworkAccount = this.vipWeworkAccountMapper.getWeworkAccount(bizId, weworkContact.getWeworkId());
        Map ongoingCountExceptTaskId = this.vipToolDelFriendDetailMapper.getNotStartAndOngoingCountExceptTaskId(taskId, (Collection)Lists.newArrayList((Object[])new String[]{detail.getRobotWeworkId()}));
        int count = 0;
        if (MapUtils.isNotEmpty((Map)ongoingCountExceptTaskId) && ongoingCountExceptTaskId.containsKey(detail.getRobotWeworkId())) {
            count = (Integer)ongoingCountExceptTaskId.get(detail.getRobotWeworkId());
        }
        if (count > NumberUtils.INTEGER_ZERO) {
            detail.setFailReason(weworkAccount.getNickname() + "\u6b63\u5728\u5220\u9664\u597d\u53cb");
        } else if (NumberUtils.INTEGER_ONE.equals(weworkContact.getIsDeleted())) {
            detail.setStatus(Integer.valueOf(DelFriendsStatus.SUCCESS.getValue()));
            detail.setFailReason("");
        } else {
            VipDelFriendsConfigDto configDto = this.getDelFriendsConfig(bizId);
            Map contactCountMap = this.vipWeworkContactMapper.queryExternalCountListByWeworkIds(bizId, (Collection)Lists.newArrayList((Object[])new String[]{detail.getRobotWeworkId()}));
            Integer contactCount = contactCountMap.getOrDefault(detail.getRobotWeworkId(), 0);
            int canDelTotalCount = this.getCanDelTotalCount(contactCount, configDto);
            log.info("everyDayDelFriendsUpperLimit:{}, canDelTotalCount:{}", (Object)configDto.getEveryDayDelFriendsUpperLimit(), (Object)canDelTotalCount);
            Map todayAlreadyDelCountMap = this.vipToolDelFriendDetailMapper.getWeworkIdAndAlreadyDelCount((Collection)Lists.newArrayList((Object[])new String[]{detail.getRobotWeworkId()}), bizId, DateUtil.getTodayStartTime(), DateUtil.getTodayEndTime());
            int alreadyDelCount = 0;
            if (MapUtils.isNotEmpty((Map)todayAlreadyDelCountMap) && todayAlreadyDelCountMap.containsKey(detail.getRobotWeworkId())) {
                alreadyDelCount = (Integer)todayAlreadyDelCountMap.get(detail.getRobotWeworkId());
            }
            if (canDelTotalCount < alreadyDelCount + 1) {
                detail.setStatus(Integer.valueOf(DelFriendsStatus.FAIL.getValue()));
                detail.setFailReason("\u5df2\u8d85\u8fc7" + configDto.getEveryDayDelFriendsUpperLimit() + "%\u7684\u9650\u5236");
            } else {
                detail.setStatus(Integer.valueOf(DelFriendsStatus.NOT_START.getValue()));
                detail.setFailReason("");
                Map maxExpectDelTimeMap = this.vipToolDelFriendDetailMapper.getMaxExpctDelTimeByTaskIdAndRobotWeworkId(taskId, (Collection)Lists.newArrayList((Object[])new String[]{detail.getRobotWeworkId()}));
                Date maxExpectDelTime = null;
                if (MapUtils.isNotEmpty((Map)maxExpectDelTimeMap) && maxExpectDelTimeMap.containsKey(detail.getRobotWeworkId())) {
                    maxExpectDelTime = (Date)maxExpectDelTimeMap.get(detail.getRobotWeworkId());
                }
                if (Objects.isNull(maxExpectDelTime) || new Date().after(maxExpectDelTime)) {
                    maxExpectDelTime = new Date();
                }
                int randomSeconds = this.getDelFriendsIntervalSeconds(configDto.getMinDelFriendsInterval(), configDto.getMaxDelFriendsInterval());
                log.info("retryDelSingleRecord, delFriendsConfig:{}, randomSeconds:{}", (Object)configDto, (Object)randomSeconds);
                detail.setExpectDelTime(DateUtils.addSeconds((Date)maxExpectDelTime, (int)randomSeconds));
            }
        }
        detail.setUpdateBy(operatorId);
        detail.setUpdateTime(new Date());
        this.vipToolDelFriendDetailMapper.updateByPrimaryKey((Object)detail);
    }

    private void retryDelTaskAllFailedRecord(Long bizId, Long operatorId, Long taskId) {
        List detailList = this.vipToolDelFriendDetailMapper.selectByTaskIdAndStatus(taskId, Integer.valueOf(DelFriendsStatus.FAIL.getValue()));
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)detailList), (Object)"\u6839\u636e\u4efb\u52a1id\u672a\u67e5\u8be2\u5230\u5931\u8d25\u8bb0\u5f55");
        Map<String, List<VipToolDelFriendDetail>> detailsMap = detailList.stream().collect(Collectors.groupingBy(VipToolDelFriendDetail::getRobotWeworkId));
        log.info("retryDelTaskAllFailedRecord, detailList.size:{}, detailsMap.size:{}", (Object)detailList.size(), (Object)detailsMap.size());
        Set<String> robotWeworkIds = detailsMap.keySet();
        Map notCompletedCountMap = this.vipToolDelFriendDetailMapper.getNotStartAndOngoingCountExceptTaskId(taskId, robotWeworkIds);
        Map maxExpectDelTimeMap = this.vipToolDelFriendDetailMapper.getMaxExpctDelTimeByTaskIdAndRobotWeworkId(taskId, robotWeworkIds);
        List vipWeworkAccounts = this.vipWeworkAccountMapper.queryListByWeworkIds(robotWeworkIds);
        Map<Object, Object> vipWeworkAccountMap = CollectionUtils.isNotEmpty((Collection)vipWeworkAccounts) ? vipWeworkAccounts.stream().collect(Collectors.toMap(VipWeworkAccount::getWeworkId, Function.identity())) : Collections.emptyMap();
        VipDelFriendsConfigDto configDto = this.getDelFriendsConfig(bizId);
        Map contactCountMap = this.vipWeworkContactMapper.queryExternalCountListByWeworkIds(bizId, robotWeworkIds);
        Map alreadyDelCountMap = this.vipToolDelFriendDetailMapper.getWeworkIdAndAlreadyDelCount(robotWeworkIds, bizId, DateUtil.getTodayStartTime(), DateUtil.getTodayEndTime());
        for (Map.Entry<String, List<VipToolDelFriendDetail>> entry : detailsMap.entrySet()) {
            String robotWeworkId = entry.getKey();
            List<VipToolDelFriendDetail> details = entry.getValue();
            List contactWeworkIds = details.stream().map(VipToolDelFriendDetail::getContactWeworkId).collect(Collectors.toList());
            List vipWeworkContacts = this.vipWeworkContactMapper.queryContactCorpInfo(bizId, robotWeworkId, contactWeworkIds);
            Map uniqKey2ObjectMap = vipWeworkContacts.stream().collect(Collectors.toMap(it -> it.getWeworkId() + "_" + it.getContactId(), Function.identity()));
            VipWeworkAccount vipWeworkAccount = (VipWeworkAccount)vipWeworkAccountMap.get(robotWeworkId);
            Date maxExpectDelTime = null;
            if (MapUtils.isNotEmpty((Map)maxExpectDelTimeMap) && maxExpectDelTimeMap.containsKey(robotWeworkId)) {
                maxExpectDelTime = (Date)maxExpectDelTimeMap.get(robotWeworkId);
            }
            if (Objects.isNull(maxExpectDelTime) || new Date().after(maxExpectDelTime)) {
                maxExpectDelTime = new Date();
            }
            int i = 0;
            int todayAlreadyDelAmount = 0;
            if (MapUtils.isNotEmpty((Map)alreadyDelCountMap) && alreadyDelCountMap.containsKey(robotWeworkId)) {
                todayAlreadyDelAmount = (Integer)alreadyDelCountMap.get(robotWeworkId);
            }
            for (VipToolDelFriendDetail detail : details) {
                VipWeworkContact vipWeworkContact = (VipWeworkContact)uniqKey2ObjectMap.get(detail.getRobotWeworkId() + "_" + detail.getContactWeworkId());
                int count = 0;
                if (MapUtils.isNotEmpty((Map)notCompletedCountMap) && notCompletedCountMap.containsKey(robotWeworkId)) {
                    count = (Integer)notCompletedCountMap.get(robotWeworkId);
                }
                if (count > NumberUtils.INTEGER_ZERO) {
                    detail.setFailReason(vipWeworkAccount.getNickname() + "\u6b63\u5728\u5220\u9664\u597d\u53cb");
                } else {
                    ++i;
                    if (NumberUtils.INTEGER_ONE.equals(vipWeworkContact.getIsDeleted())) {
                        detail.setStatus(Integer.valueOf(DelFriendsStatus.SUCCESS.getValue()));
                        detail.setFailReason("");
                    } else {
                        Integer contactCount = (Integer)contactCountMap.get(detail.getRobotWeworkId());
                        int canDelTotalCount = this.getCanDelTotalCount(contactCount, configDto);
                        log.info("everyDayDelFriendsUpperLimit:{}, canDelTotalCount:{}", (Object)configDto.getEveryDayDelFriendsUpperLimit(), (Object)canDelTotalCount);
                        if (canDelTotalCount < todayAlreadyDelAmount + i) {
                            detail.setStatus(Integer.valueOf(DelFriendsStatus.FAIL.getValue()));
                            detail.setFailReason("\u5df2\u8d85\u8fc7" + configDto.getEveryDayDelFriendsUpperLimit() + "%\u7684\u9650\u5236");
                        } else {
                            detail.setStatus(Integer.valueOf(DelFriendsStatus.NOT_START.getValue()));
                            detail.setFailReason("");
                            int delFriendsIntervalSeconds = this.getDelFriendsIntervalSeconds(configDto.getMinDelFriendsInterval(), configDto.getMaxDelFriendsInterval());
                            detail.setExpectDelTime(DateUtils.addSeconds((Date)maxExpectDelTime, (int)delFriendsIntervalSeconds));
                            maxExpectDelTime = DateUtils.addSeconds((Date)maxExpectDelTime, (int)delFriendsIntervalSeconds);
                        }
                    }
                }
                detail.setUpdateBy(operatorId);
                detail.setUpdateTime(new Date());
            }
        }
        Lists.partition((List)detailList, (int)500).forEach(list -> this.vipToolDelFriendDetailMapper.batchUpdateDetail(list));
    }

    private void deleteContact(VipWeworkContact vipWeworkContact, VipToolDelFriendDetail vipToolDelFriendDetail) {
        log.info("deleteContact, robotWeworkId:{}, contactWeworkId:{}", (Object)vipToolDelFriendDetail.getRobotWeworkId(), (Object)vipToolDelFriendDetail.getContactWeworkId());
        DelContactReq delContactReq = new DelContactReq();
        delContactReq.setOpPlatform(Integer.valueOf(OpPlatform.MANAGER.getType()));
        delContactReq.setBizId(vipWeworkContact.getBizId());
        delContactReq.setCorpId(vipWeworkContact.getCorpId());
        delContactReq.setWeworkId(vipWeworkContact.getWeworkId());
        delContactReq.setTargetId(vipWeworkContact.getContactId());
        delContactReq.setControl(false);
        try {
            BaseResponse baseResponse = this.contactService.deleteExternalContact(delContactReq);
            log.info("deleteContact baseResponse:{}", (Object)baseResponse);
            vipToolDelFriendDetail.setRequestId(baseResponse.getRequestId());
            long code = baseResponse.getCode();
            if ((long)ResponseCodeType.SUCCESS.getCode() == code) {
                vipToolDelFriendDetail.setStatus(Integer.valueOf(DelFriendsStatus.ONGOING.getValue()));
            } else if ((long)ResponseCodeType.WEWORK_OFFLINE.getCode() == code) {
                vipToolDelFriendDetail.setStatus(Integer.valueOf(DelFriendsStatus.FAIL.getValue()));
                vipToolDelFriendDetail.setFailReason(ResponseCodeType.WEWORK_OFFLINE.getDesc());
            } else {
                vipToolDelFriendDetail.setStatus(Integer.valueOf(DelFriendsStatus.FAIL.getValue()));
                vipToolDelFriendDetail.setFailReason(baseResponse.getMsg());
            }
        }
        catch (Exception ex) {
            log.error("\u8c03\u7528\u5220\u9664\u8054\u7cfb\u4eba\u63a5\u53e3\u5f02\u5e38:", (Throwable)ex);
            vipToolDelFriendDetail.setStatus(Integer.valueOf(DelFriendsStatus.FAIL.getValue()));
            vipToolDelFriendDetail.setFailReason("\u8c03\u7528\u5220\u9664\u8054\u7cfb\u4eba\u63a5\u53e3\u5931\u8d25");
        }
    }
}

