/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.reply.service.impl;

import cn.kinyun.scrm.vip.cache.service.FriendKeywordCacheService;
import cn.kinyun.scrm.vip.reply.dto.AutoReplyMessageDto;
import cn.kinyun.scrm.vip.reply.dto.AutoReplyWordDto;
import cn.kinyun.scrm.vip.reply.dto.req.FriendKeywordReplyCheckReq;
import cn.kinyun.scrm.vip.reply.dto.req.FriendKeywordReplyIdReqDto;
import cn.kinyun.scrm.vip.reply.dto.req.FriendKeywordReplyListReq;
import cn.kinyun.scrm.vip.reply.dto.req.FriendKeywordReplyReq;
import cn.kinyun.scrm.vip.reply.dto.resp.FriendKeywordReplyDetailResp;
import cn.kinyun.scrm.vip.reply.dto.resp.FriendKeywordReplyListResp;
import cn.kinyun.scrm.vip.reply.enums.AutoReplyRelationType;
import cn.kinyun.scrm.vip.reply.enums.AutoReplyType;
import cn.kinyun.scrm.vip.reply.enums.FriendMsgReplyType;
import cn.kinyun.scrm.vip.reply.enums.KeywordMatchType;
import cn.kinyun.scrm.vip.reply.service.FriendDefaultReplyService;
import cn.kinyun.scrm.vip.reply.service.FriendKeywordReplyService;
import cn.kinyun.scrm.vip.reply.utils.KeywordUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.dto.StrIdAndNameDto;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.SHA1Utils;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.vip.dto.VipUserDto;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkAuthorizeAccountMapper;
import com.kuaike.scrm.dal.vip.reply.dto.ExistFriendKeywordDto;
import com.kuaike.scrm.dal.vip.reply.dto.FriendKeywordListParams;
import com.kuaike.scrm.dal.vip.reply.dto.VipAutoReplyWeworkNickNameDto;
import com.kuaike.scrm.dal.vip.reply.entity.VipAutoReply;
import com.kuaike.scrm.dal.vip.reply.entity.VipAutoReplyWework;
import com.kuaike.scrm.dal.vip.reply.entity.VipAutoReplyWord;
import com.kuaike.scrm.dal.vip.reply.enums.VipWeworkConfigType;
import com.kuaike.scrm.dal.vip.reply.mapper.VipAutoReplyMapper;
import com.kuaike.scrm.dal.vip.reply.mapper.VipAutoReplyWeworkMapper;
import com.kuaike.scrm.dal.vip.reply.mapper.VipAutoReplyWordMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FriendKeywordReplyServiceImpl
implements FriendKeywordReplyService {
    private static final Logger log = LoggerFactory.getLogger(FriendKeywordReplyServiceImpl.class);
    @Autowired
    private IdGen idGen;
    @Autowired
    private FriendKeywordCacheService friendKeywordCacheService;
    @Autowired
    private VipAutoReplyMapper vipAutoReplyMapper;
    @Autowired
    private VipAutoReplyWordMapper vipAutoReplyWordMapper;
    @Autowired
    private VipAutoReplyWeworkMapper vipAutoReplyWeworkMapper;
    @Autowired
    private VipWeworkAuthorizeAccountMapper vipWeworkAuthorizeAccountMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private FriendDefaultReplyService friendDefaultReplyService;

    private List<String> toWeworkDigitIds(Long bizId, String corpId, List<String> weworkUserNums) {
        List weworkUsers = this.weworkUserMapper.queryWeworkUsersByDigitId(corpId, weworkUserNums);
        if (CollectionUtils.isEmpty((Collection)weworkUsers)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u672a\u9009\u62e9\u5f00\u901a\u4f01\u5fae\u5b9d\u7684\u7528\u6237");
        }
        if (CollectionUtils.isEmpty(weworkUsers = weworkUsers.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getWeworkDigitId())).collect(Collectors.toList()))) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u672a\u9009\u62e9\u5f00\u901a\u4f01\u5fae\u5b9d\u7684\u5408\u6cd5\u7528\u6237");
        }
        List list = this.vipWeworkAuthorizeAccountMapper.batchQueryByWeworkNums(bizId, weworkUserNums);
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6240\u9009\u7528\u6237\u672a\u5f00\u901a\u4f01\u5fae\u5b9d");
        }
        Map<String, VipUserDto> mapToWeworkUserNum = list.stream().filter(it -> StringUtils.isNotBlank((CharSequence)it.getWeworkDigitId())).collect(Collectors.toMap(VipUserDto::getWeworkUserNum, vipUserDto -> vipUserDto, (v1, v2) -> v2));
        for (WeworkUser item2 : weworkUsers) {
            VipUserDto vipUserDto2 = mapToWeworkUserNum.get(item2.getNum());
            String userName = item2.getName();
            if (!Objects.isNull(vipUserDto2)) continue;
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "[" + userName + "]\u672a\u5f00\u901a\u4f01\u5fae\u5b9d");
        }
        return weworkUsers.stream().map(WeworkUser::getWeworkDigitId).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long add(FriendKeywordReplyReq params) {
        List<ExistFriendKeywordDto> existKeywords;
        log.info("add friend keyword reply with params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0);
        Preconditions.checkArgument((params.getRtype() != null ? 1 : 0) != 0, (Object)"\u6d88\u606f\u7c7b\u578b\u4e3a\u7a7a");
        if (params.getRtype().intValue() != FriendMsgReplyType.KEYWORD.getValue()) {
            return this.friendDefaultReplyService.add(params);
        }
        this.validate(params);
        List<String> weworkDigitIds = this.toWeworkDigitIds(params.getBizId(), params.getCorpId(), params.getWeworkIds());
        params.setRelationType(AutoReplyRelationType.WEWORK.getValue());
        params.setReplyType(AutoReplyType.KEYWORD_REPLY.getValue());
        VipAutoReply reply = this.newVipAutoReply(params);
        reply.setCreateBy(params.getOperatorId());
        reply.setUpdateBy(params.getOperatorId());
        reply.setNodeId(params.getNodeId());
        reply.setBizId(params.getBizId());
        reply.setNum(this.idGen.getNum());
        reply.setCreateTime(new Date());
        reply.setUpdateTime(new Date());
        this.vipAutoReplyMapper.insertSelective((Object)reply);
        params.setId(reply.getId());
        List<VipAutoReplyWework> weworkList = this.newVipReplyWeworkList(params.getBizId(), reply.getId(), weworkDigitIds, params.getOperatorId());
        this.vipAutoReplyWeworkMapper.batchInsert(weworkList);
        VipAutoReplyWord word = this.newVipAutoReplyWord(params);
        word.setCreateBy(params.getOperatorId());
        word.setBizId(params.getBizId());
        word.setNodeId(params.getNodeId());
        word.setNum(this.idGen.getNum());
        word.setCreateTime(new Date());
        word.setUpdateTime(new Date());
        this.vipAutoReplyWordMapper.insertSelective((Object)word);
        if (word.getType().intValue() == KeywordMatchType.ACCURATE.getValue() && CollectionUtils.isNotEmpty(existKeywords = this.queryExistKeywords(word.getKeyword(), weworkDigitIds, reply.getId(), reply.getBizId()))) {
            this.clear(existKeywords, params.getOperatorId());
        }
        this.friendKeywordCacheService.newVersion();
        return params.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addAll(List<FriendKeywordReplyReq> list) {
        log.info("add all friend keyword reply with list={}", list);
        if (CollectionUtils.isEmpty(list)) {
            log.warn("friend keyword reply list is empty.");
            return;
        }
        for (FriendKeywordReplyReq params : list) {
            this.add(params);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modify(FriendKeywordReplyReq params) {
        List<ExistFriendKeywordDto> existKeywords;
        log.info("modify friend keyword reply with params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0);
        Preconditions.checkArgument((params.getRtype() != null ? 1 : 0) != 0, (Object)"\u6d88\u606f\u7c7b\u578b\u4e3a\u7a7a");
        if (params.getRtype().intValue() != FriendMsgReplyType.KEYWORD.getValue()) {
            this.friendDefaultReplyService.modify(params);
            return;
        }
        this.validate(params);
        Preconditions.checkArgument((params.getId() != null ? 1 : 0) != 0, (Object)"id\u4e0d\u53ef\u4e3a\u7a7a");
        List<String> weworkDigitIds = this.toWeworkDigitIds(params.getBizId(), params.getCorpId(), params.getWeworkIds());
        params.setRelationType(AutoReplyRelationType.WEWORK.getValue());
        params.setReplyType(AutoReplyType.KEYWORD_REPLY.getValue());
        List<Long> ids = Collections.singletonList(params.getId());
        Long updateBy = params.getOperatorId();
        Date updateTime = new Date();
        VipAutoReply reply = this.newVipAutoReply(params);
        reply.setId(params.getId());
        reply.setUpdateBy(updateBy);
        reply.setUpdateTime(updateTime);
        reply.setCreateBy(null);
        reply.setNodeId(null);
        reply.setBizId(null);
        this.vipAutoReplyMapper.updateByPrimaryKeySelective((Object)reply);
        List<VipAutoReplyWework> weworkList = this.newVipReplyWeworkList(params.getBizId(), reply.getId(), weworkDigitIds, params.getOperatorId());
        this.vipAutoReplyWeworkMapper.logicDeleteByAutoReplyIds(ids, updateBy, updateTime);
        this.vipAutoReplyWeworkMapper.batchInsert(weworkList);
        VipAutoReplyWord word = this.vipAutoReplyWordMapper.selectByAutoReplyId(params.getId());
        AutoReplyWordDto keyword = params.getKeyword();
        word.setKeyword(keyword.getWord());
        word.setType(keyword.getType());
        word.setUpdateBy(updateBy);
        word.setUpdateTime(updateTime);
        this.vipAutoReplyWordMapper.updateByPrimaryKeySelective((Object)word);
        if (word.getType().intValue() == KeywordMatchType.ACCURATE.getValue() && CollectionUtils.isNotEmpty(existKeywords = this.queryExistKeywords(word.getKeyword(), weworkDigitIds, params.getId(), params.getBizId()))) {
            this.clear(existKeywords, params.getOperatorId());
        }
        this.friendKeywordCacheService.newVersion();
    }

    @Override
    public Boolean check(FriendKeywordReplyCheckReq params) {
        log.info("check friend keyword reply with params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"params is null");
        Preconditions.checkArgument((params.getRtype() != null ? 1 : 0) != 0, (Object)"rtype is null");
        if (params.getRtype().intValue() != FriendMsgReplyType.KEYWORD.getValue()) {
            return this.friendDefaultReplyService.check(params);
        }
        Preconditions.checkArgument((params.getBizId() != null ? 1 : 0) != 0, (Object)"\u5546\u6237ID\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getType() != null ? 1 : 0) != 0, (Object)"\u5173\u952e\u8bcd\u7c7b\u578b\u4e3a\u7a7a");
        if (StringUtils.isBlank((CharSequence)params.getKeyword())) {
            log.info("\u5173\u952e\u8bcd\u4e3a\u7a7a\uff0c\u4e0d\u9700\u8981\u68c0\u6d4b");
            return false;
        }
        if (params.getType().intValue() == KeywordMatchType.FUZZY.getValue()) {
            KeywordUtil.validateFuzzyKeyword(params.getKeyword());
            return false;
        }
        if (CollectionUtils.isEmpty(params.getWeworkIds())) {
            log.info("\u5fae\u4fe1\u53f7\u4e3a\u7a7a\uff0c\u4e0d\u9700\u8981\u68c0\u6d4b");
            return false;
        }
        List<String> weworkDigitIds = this.toWeworkDigitIds(params.getBizId(), params.getCorpId(), params.getWeworkIds());
        Long replyId = params.getId();
        List existKeywords = this.vipAutoReplyWeworkMapper.queryExistFriendKeywords(params.getKeyword(), weworkDigitIds, replyId, Integer.valueOf(AutoReplyType.KEYWORD_REPLY.getValue()), Integer.valueOf(AutoReplyRelationType.WEWORK.getValue()), params.getBizId());
        return CollectionUtils.isNotEmpty((Collection)existKeywords);
    }

    @Override
    public FriendKeywordReplyListResp list(FriendKeywordReplyListReq params) {
        log.info("query friend keyword reply list with params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u67e5\u8be2\u53c2\u6570\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getOperatorId() != null ? 1 : 0) != 0, (Object)"operatorId\u4e0d\u53ef\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getBizId() != null ? 1 : 0) != 0, (Object)"bizId\u4e0d\u53ef\u4e3a\u7a7a");
        Sets.SetView keywordFiltedIds = null;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getKeywordQuery()})) {
            List autoReplyIds = this.vipAutoReplyWordMapper.fuzzyQueryAutoReplyIds(params.getKeywordQuery());
            if (CollectionUtils.isNotEmpty((Collection)autoReplyIds)) {
                keywordFiltedIds = new HashSet(autoReplyIds);
                log.info("Filted by keyword={}, autoReplyIds={}", (Object)params.getKeywordQuery(), keywordFiltedIds);
            } else {
                log.info("\u627e\u4e0d\u5230\u5339\u914d\u7684\u5173\u952e\u8bcd\uff0c\u7b5b\u9009\u7ed3\u679c\u4e3a\u7a7a. keywordQuery={}", (Object)params.getKeywordQuery());
                return this.emptyFriendKeywordReplyListResp();
            }
        }
        Set weworkFiltedIds = null;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getWeworkId()})) {
            String weworkDigitId = this.weworkUserMapper.queryWeworkDigitIdByNum(params.getWeworkId());
            if (StringUtils.isBlank((CharSequence)weworkDigitId)) {
                log.info("\u627e\u4e0d\u5230\u5339\u914d\u7684weworkDigitId\uff0c\u7b5b\u9009\u7ed3\u679c\u4e3a\u7a7a. weworkId={}", (Object)params.getWeworkId());
                return this.emptyFriendKeywordReplyListResp();
            }
            List list = this.vipAutoReplyWeworkMapper.queryByWeworkId(weworkDigitId);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                weworkFiltedIds = list.stream().map(VipAutoReplyWework::getAutoReplyId).collect(Collectors.toSet());
                log.info("Filted by weworkId={}, autoReplyIds={}", (Object)params.getWeworkId(), weworkFiltedIds);
            } else {
                log.info("\u627e\u4e0d\u5230\u5339\u914d\u7684\u5fae\u4fe1\u53f7\uff0c\u7b5b\u9009\u7ed3\u679c\u4e3a\u7a7a. weworkId={}", (Object)params.getWeworkId());
                return this.emptyFriendKeywordReplyListResp();
            }
        }
        Sets.SetView ids = null;
        if (keywordFiltedIds != null && weworkFiltedIds != null) {
            ids = Sets.intersection(keywordFiltedIds, weworkFiltedIds);
            log.info("Use keyword and weworkId filter, ids={}", (Object)ids);
            if (CollectionUtils.isEmpty((Collection)ids)) {
                log.info("Ids is empty.");
                return this.emptyFriendKeywordReplyListResp();
            }
        } else if (keywordFiltedIds != null) {
            ids = keywordFiltedIds;
            log.info("Use keyword filter, ids={}", (Object)ids);
        } else if (weworkFiltedIds != null) {
            ids = weworkFiltedIds;
            log.info("Use weworkId filter, ids={}", (Object)ids);
        }
        List<Long> userIds = null;
        if (params.getUserId() != null) {
            userIds = Collections.singletonList(params.getUserId());
        }
        FriendKeywordListParams queryParam = new FriendKeywordListParams();
        queryParam.setBizId(params.getBizId());
        queryParam.setOperatorId(params.getOperatorId());
        queryParam.setNodeIds(params.getNodeIds());
        queryParam.setRelationType(Integer.valueOf(AutoReplyRelationType.WEWORK.getValue()));
        if (params.getRtype() == null) {
            queryParam.setReplyTypes((Collection)Lists.newArrayList((Object[])new Integer[]{AutoReplyType.KEYWORD_REPLY.getValue(), AutoReplyType.DEFAULT_REPLY.getValue()}));
        } else {
            FriendMsgReplyType rType = FriendMsgReplyType.getType(params.getRtype());
            Preconditions.checkArgument((rType != null ? 1 : 0) != 0, (Object)"\u4e0d\u652f\u6301\u7684\u6d88\u606f\u7c7b\u578b");
            switch (rType) {
                case KEYWORD: {
                    queryParam.setReplyType(Integer.valueOf(AutoReplyType.KEYWORD_REPLY.getValue()));
                    break;
                }
                case DEFAULT: 
                case IMAGE: 
                case VIDEO: 
                case VOICE: 
                case FILE: {
                    queryParam.setReplyType(Integer.valueOf(AutoReplyType.DEFAULT_REPLY.getValue()));
                    queryParam.setDefaultMsgType(rType.getDesc());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u56de\u590d\u7c7b\u578b:" + (Object)((Object)rType));
                }
            }
        }
        queryParam.setIds((Collection)ids);
        queryParam.setUserIds(userIds);
        queryParam.setUpdateStartTime(params.getUpdateStartTime());
        queryParam.setUpdateEndTime(params.getUpdateEndTime());
        queryParam.setPageDto(params.getPageDto());
        queryParam.setTimeSort(params.getTimeSort());
        int count = this.vipAutoReplyMapper.countFriendKeywordReply(queryParam);
        if (count <= 0) {
            log.info("\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u8bb0\u5f55");
            return this.emptyFriendKeywordReplyListResp();
        }
        List list = this.vipAutoReplyMapper.queryFriendKeywordReply(queryParam);
        if (params.getPageDto() != null) {
            params.getPageDto().setCount(Integer.valueOf(count));
        }
        FriendKeywordReplyListResp resp = new FriendKeywordReplyListResp();
        resp.setList(this.toRespList(list));
        resp.setPageDto(params.getPageDto());
        return resp;
    }

    @Override
    public FriendKeywordReplyDetailResp detail(FriendKeywordReplyIdReqDto params) {
        List<AutoReplyMessageDto> replyMessage;
        log.info("query friend keyword reply detail with params={}", (Object)params);
        Preconditions.checkArgument((params.getId() != null ? 1 : 0) != 0, (Object)"id\u4e0d\u53ef\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getOperatorId() != null ? 1 : 0) != 0, (Object)"operatorId\u4e0d\u53ef\u4e3a\u7a7a");
        Long id = params.getId();
        VipAutoReply reply = (VipAutoReply)this.vipAutoReplyMapper.selectByPrimaryKey((Object)id);
        if (reply == null) {
            log.warn("\u8be5\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664, id={}", (Object)id);
            return null;
        }
        VipAutoReplyWord word = this.vipAutoReplyWordMapper.selectByAutoReplyId(id);
        List weworks = this.vipAutoReplyWeworkMapper.queryByReplyIds(Collections.singletonList(id));
        User user = (User)this.userMapper.selectByPrimaryKey((Object)reply.getUpdateBy());
        try {
            replyMessage = JacksonUtil.str2List((String)reply.getMessage(), AutoReplyMessageDto.class);
        }
        catch (IOException e) {
            log.error("Failed parsing replyMessage, id={}", (Object)reply.getId(), (Object)e);
            replyMessage = Collections.emptyList();
        }
        FriendKeywordReplyDetailResp result = this.toDetailResp(reply, word, weworks, user);
        result.setReplyMessage(replyMessage);
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(FriendKeywordReplyIdReqDto params) {
        log.info("delete friend keyword reply with params={}", (Object)params);
        Preconditions.checkArgument((params.getId() != null ? 1 : 0) != 0, (Object)"id\u4e0d\u53ef\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getOperatorId() != null ? 1 : 0) != 0, (Object)"operatorId\u4e0d\u53ef\u4e3a\u7a7a");
        List<Long> ids = Collections.singletonList(params.getId());
        Long updateBy = params.getOperatorId();
        Date updateTime = new Date();
        try {
            this.vipAutoReplyMapper.logicDeleteByPrimaryKeys(ids, updateBy, updateTime);
            this.vipAutoReplyWordMapper.logicDeleteByAutoReplyIds(ids, updateBy, updateTime);
            this.vipAutoReplyWeworkMapper.logicDeleteByAutoReplyIds(ids, updateBy, updateTime);
        }
        catch (Exception e) {
            log.error("Failed deleting friend keyword reply with params={}", (Object)params, (Object)e);
            throw e;
        }
        this.friendKeywordCacheService.newVersion();
    }

    private void validate(FriendKeywordReplyReq params) {
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getOperatorId() != null ? 1 : 0) != 0, (Object)"operatorId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getBizId() != null ? 1 : 0) != 0, (Object)"bizId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getNodeId() != null ? 1 : 0) != 0, (Object)"nodeId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(params.getWeworkIds()), (Object)"weworkIds\u4e0d\u80fd\u4e3a\u7a7a");
        for (String weworkId : params.getWeworkIds()) {
            Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{weworkId}), (Object)"weworkId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AutoReplyWordDto wordDto = params.getKeyword();
        Preconditions.checkArgument((wordDto != null ? 1 : 0) != 0, (Object)"\u5173\u952e\u8bcd\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((wordDto.getType() != null ? 1 : 0) != 0, (Object)"\u5173\u952e\u8bcd\u5339\u914d\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{wordDto.getWord()}), (Object)"\u5173\u952e\u8bcd\u4e0d\u80fd\u4e3a\u7a7a");
        if (params.getKeyword().getType().intValue() == KeywordMatchType.FUZZY.getValue()) {
            KeywordUtil.validateFuzzyKeyword(wordDto.getWord());
        }
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getRequest()), (Object)"\u95ee\u9898\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(params.getReplyMessage()), (Object)"\u56de\u590d\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private VipAutoReply newVipAutoReply(FriendKeywordReplyReq params) {
        VipAutoReply logicAutoReply = new VipAutoReply();
        logicAutoReply.setReplyType(params.getReplyType());
        logicAutoReply.setRelationType(params.getRelationType());
        logicAutoReply.setRequest(params.getRequest());
        String message = JacksonUtil.obj2Str(params.getReplyMessage());
        logicAutoReply.setMessage(message);
        String digest = SHA1Utils.digest((String)message);
        logicAutoReply.setDigest(digest);
        return logicAutoReply;
    }

    private List<VipAutoReplyWework> newVipReplyWeworkList(Long bizId, Long autoReplyId, List<String> weworkDigitIds, Long operatorId) {
        ArrayList<VipAutoReplyWework> list = new ArrayList<VipAutoReplyWework>(weworkDigitIds.size());
        for (String weworkId : weworkDigitIds) {
            VipAutoReplyWework replyWework = new VipAutoReplyWework();
            replyWework.setAutoReplyId(autoReplyId);
            replyWework.setWeworkId(weworkId);
            replyWework.setCreateBy(operatorId);
            replyWework.setUpdateBy(operatorId);
            replyWework.setNum(this.idGen.getNum());
            replyWework.setBizId(bizId);
            replyWework.setCreateTime(new Date());
            replyWework.setUpdateTime(new Date());
            replyWework.setType(Integer.valueOf(VipWeworkConfigType.KEYWORD_REPLY.getValue()));
            list.add(replyWework);
        }
        return list;
    }

    private VipAutoReplyWord newVipAutoReplyWord(FriendKeywordReplyReq params) {
        AutoReplyWordDto word = params.getKeyword();
        VipAutoReplyWord vipAutoReplyWord = new VipAutoReplyWord();
        vipAutoReplyWord.setKeyword(word.getWord());
        vipAutoReplyWord.setType(word.getType());
        vipAutoReplyWord.setAutoReplyId(params.getId());
        vipAutoReplyWord.setUpdateBy(params.getOperatorId());
        return vipAutoReplyWord;
    }

    private List<ExistFriendKeywordDto> queryExistKeywords(String keyword, List<String> weworkIds, Long replyId, Long bizId) {
        List existKeywords = this.vipAutoReplyWeworkMapper.queryExistFriendKeywords(keyword, weworkIds, replyId, Integer.valueOf(AutoReplyType.KEYWORD_REPLY.getValue()), Integer.valueOf(AutoReplyRelationType.WEWORK.getValue()), bizId);
        if (CollectionUtils.isEmpty((Collection)existKeywords)) {
            log.info("\u6ca1\u6709\u91cd\u590d\u7684\u5173\u952e\u8bcd\uff0c\u65e0\u9700\u53bb\u91cd\u3002");
            return Collections.emptyList();
        }
        return existKeywords;
    }

    private void clear(List<ExistFriendKeywordDto> existKeywords, Long updateBy) {
        Date updateTime = new Date();
        Set existWeworkIds = existKeywords.stream().map(ExistFriendKeywordDto::getAutoReplyWeworkId).collect(Collectors.toSet());
        this.vipAutoReplyWeworkMapper.logicDeleteByPrimaryKeys(existWeworkIds, updateBy, updateTime);
        Set existReplyIds = existKeywords.stream().map(ExistFriendKeywordDto::getAutoReplyId).collect(Collectors.toSet());
        Map existWeworkCountMap = this.vipAutoReplyWeworkMapper.queryExistCount(existReplyIds);
        HashSet toDel = Sets.newHashSet();
        for (Long replyId : existReplyIds) {
            Integer count = existWeworkCountMap.getOrDefault(replyId, 0);
            if (count != 0) continue;
            toDel.add(replyId);
        }
        if (CollectionUtils.isNotEmpty((Collection)toDel)) {
            this.vipAutoReplyMapper.logicDeleteByPrimaryKeys((Collection)toDel, updateBy, updateTime);
            this.vipAutoReplyWordMapper.logicDeleteByAutoReplyIds((Collection)toDel, updateBy, updateTime);
        }
    }

    private FriendKeywordReplyListResp emptyFriendKeywordReplyListResp() {
        FriendKeywordReplyListResp resp = new FriendKeywordReplyListResp();
        resp.setList(Collections.emptyList());
        resp.setPageDto(new PageDto());
        return resp;
    }

    private FriendKeywordReplyDetailResp toDetailResp(VipAutoReply reply, VipAutoReplyWord word, List<VipAutoReplyWeworkNickNameDto> weworks, User user) {
        String request = reply.getRequest();
        AutoReplyWordDto keyword = null;
        if (word != null) {
            keyword = new AutoReplyWordDto();
            keyword.setWord(word.getKeyword());
            keyword.setType(word.getType());
        }
        ArrayList weworkList = null;
        if (CollectionUtils.isNotEmpty(weworks)) {
            weworkList = Lists.newArrayList();
            for (VipAutoReplyWeworkNickNameDto replyWework : weworks) {
                StrIdAndNameDto w = new StrIdAndNameDto();
                w.setId(replyWework.getWeworkUserNum());
                w.setName(replyWework.getName());
                weworkList.add(w);
            }
        }
        FriendKeywordReplyDetailResp resp = new FriendKeywordReplyDetailResp();
        resp.setId(reply.getId());
        resp.setKeyword(keyword);
        resp.setRequest(request);
        resp.setApplyScopeList(weworkList);
        resp.setUpdateTime(reply.getUpdateTime());
        if (user != null) {
            resp.setUpdateName(user.getName());
        }
        if (reply.getReplyType().intValue() == AutoReplyType.KEYWORD_REPLY.getValue()) {
            resp.setRtype(FriendMsgReplyType.KEYWORD.getValue());
        } else if (reply.getReplyType().intValue() == AutoReplyType.DEFAULT_REPLY.getValue()) {
            FriendMsgReplyType rType = FriendMsgReplyType.getType(reply.getRequest());
            if (rType != null) {
                resp.setRtype(rType.getValue());
                resp.setRequest("");
            } else {
                log.warn("Unknown wework default reply type, id={}, request={}", (Object)reply.getId(), (Object)reply.getRequest());
            }
        }
        return resp;
    }

    private List<FriendKeywordReplyDetailResp> toRespList(List<VipAutoReply> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        List ids = list.stream().map(VipAutoReply::getId).collect(Collectors.toList());
        List replyWordList = this.vipAutoReplyWordMapper.selectByAutoReplyIds(ids);
        Map<Long, List<VipAutoReplyWord>> replyWordMap = replyWordList.stream().collect(Collectors.groupingBy(VipAutoReplyWord::getAutoReplyId));
        List replyWeworkList = this.vipAutoReplyWeworkMapper.queryByReplyIds(ids);
        Map<Long, List<VipAutoReplyWeworkNickNameDto>> replyWeworkMap = replyWeworkList.stream().collect(Collectors.groupingBy(VipAutoReplyWework::getAutoReplyId));
        List userIds = list.stream().map(VipAutoReply::getUpdateBy).collect(Collectors.toList());
        List userList = this.userMapper.getUserInfoByIds(userIds);
        Map<Long, User> userMap = userList.stream().collect(Collectors.toMap(User::getId, it -> it));
        ArrayList result = Lists.newArrayListWithCapacity((int)list.size());
        for (VipAutoReply reply : list) {
            List<AutoReplyMessageDto> replyMessage;
            VipAutoReplyWord word = null;
            List<VipAutoReplyWord> wordList = replyWordMap.get(reply.getId());
            if (wordList != null && wordList.size() > 0) {
                word = wordList.get(0);
            }
            List<VipAutoReplyWeworkNickNameDto> weworks = replyWeworkMap.get(reply.getId());
            User user = userMap.get(reply.getUpdateBy());
            try {
                replyMessage = JacksonUtil.str2List((String)reply.getMessage(), AutoReplyMessageDto.class);
            }
            catch (IOException e) {
                log.error("Failed parsing replyMessage, id={}", (Object)reply.getId(), (Object)e);
                replyMessage = Collections.emptyList();
            }
            FriendKeywordReplyDetailResp resp = this.toDetailResp(reply, word, weworks, user);
            resp.setReplyMessage(replyMessage);
            result.add(resp);
        }
        return result;
    }
}

