/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.reply.enums;

import com.google.common.collect.ImmutableMap;
import com.kuaike.common.enums.EnumService;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum AutoReplyRelationType implements EnumService
{
    CHAT_ROOM(1, "\u5fae\u4fe1\u7fa4"),
    OFFICIAL_ACCOUNT(2, "\u516c\u4f17\u53f7"),
    DRAINAGE_PLAN(3, "\u7fa4\u5f15\u6d41"),
    FISSION_PLAN(4, "\u7fa4\u88c2\u53d8"),
    WEWORK(5, "\u5fae\u4fe1\u53f7"),
    CHAT_ROOM_GROUP(6, "\u5fae\u4fe1\u7fa4\u7ec4");

    private static final Map<Integer, AutoReplyRelationType> MAP;
    private final int value;
    private final String desc;

    private AutoReplyRelationType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static AutoReplyRelationType getType(int value) {
        return MAP.get(value);
    }

    public int getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    public static Integer getValueByDesc(String desc) {
        for (AutoReplyRelationType type : MAP.values()) {
            if (!type.getDesc().equals(desc)) continue;
            return type.getValue();
        }
        return null;
    }

    public static String getDescByValue(Integer value) {
        AutoReplyRelationType type = AutoReplyRelationType.getType(value);
        if (type != null) {
            return type.getDesc();
        }
        return null;
    }

    static {
        MAP = ImmutableMap.copyOf(Arrays.stream(AutoReplyRelationType.values()).collect(Collectors.toMap(AutoReplyRelationType::getValue, Function.identity())));
    }
}

