/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.cache.service.impl;

import cn.kinyun.scrm.vip.cache.service.VersionedCache;
import cn.kinyun.scrm.vip.cache.service.WeworkAccountCacheService;
import com.kuaike.scrm.dal.vip.dto.CachedWeworkAccount;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkAccountMapper;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class WeworkAccountCacheServiceImpl
extends VersionedCache
implements WeworkAccountCacheService {
    private static final Logger log = LoggerFactory.getLogger(WeworkAccountCacheServiceImpl.class);
    private Map<String, CachedWeworkAccount> cache = Collections.emptyMap();
    @Autowired
    private VipWeworkAccountMapper vipWeworkAccountMapper;
    @Value(value="${spring.redis.key.prefix}${spring.redis.key.weworkAccountVersion:wework_account_version}")
    private String versionRedisKey;

    @Override
    protected String getVersionRedisKey() {
        return this.versionRedisKey;
    }

    @Override
    protected Long getExpiredInSecond() {
        return 300L;
    }

    @Override
    protected void initialize() {
        List list = this.vipWeworkAccountMapper.queryAllForCache();
        this.cache = CollectionUtils.isEmpty((Collection)list) ? Collections.emptyMap() : list.stream().collect(Collectors.toMap(CachedWeworkAccount::getWeworkDigitId, Function.identity()));
    }

    @Override
    public void newVersion() {
        super.reset();
    }

    @Override
    @Scheduled(fixedRate=5000L)
    public void refresh() {
        super.refresh();
    }

    @Override
    public Long getBizId(String weworkDigitId) {
        CachedWeworkAccount dto = this.cache.get(weworkDigitId);
        if (dto == null) {
            return null;
        }
        return dto.getBizId();
    }

    @Override
    public CachedWeworkAccount get(String weworkDigitId) {
        return this.cache.get(weworkDigitId);
    }

    @Override
    public boolean isRobot(String weworkDigitId) {
        return this.cache.containsKey(weworkDigitId);
    }

    @Override
    public boolean isRobot(Long bizId, String weworkDigitId) {
        if (bizId == null) {
            log.warn("bizId is null");
            return false;
        }
        CachedWeworkAccount dto = this.cache.get(weworkDigitId);
        if (dto == null) {
            return false;
        }
        return bizId.equals(dto.getBizId());
    }
}

