/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.cache.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;

public class WordTree
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int MIN_MATCH_TYPE = 1;
    public static final int MAX_MATCH_TYPE = 2;
    private boolean isEnd;
    private HashMap<Character, WordTree> next = new HashMap();

    public WordTree() {
    }

    public WordTree(Collection<String> words) {
        for (String word : words) {
            this.addWord(word);
        }
    }

    public void addWords(Collection<String> words) {
        for (String word : words) {
            this.addWord(word);
        }
    }

    public void addWord(String word) {
        if (word == null || word.isEmpty()) {
            return;
        }
        WordTree cur = this;
        int len = word.length();
        for (int i = 0; i < len; ++i) {
            char keyChar = word.charAt(i);
            WordTree tree = cur.next.get(Character.valueOf(keyChar));
            if (tree == null) {
                tree = new WordTree();
                cur.next.put(Character.valueOf(keyChar), tree);
            }
            cur = tree;
            if (i != len - 1) continue;
            cur.isEnd = true;
        }
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.next.isEmpty();
    }

    public int checkWord(String txt, int beginIndex, int matchType) {
        char word;
        boolean flag = false;
        WordTree cur = this;
        int length = txt.length();
        int curLength = 0;
        for (int i = beginIndex; i < length && (cur = cur.next.get(Character.valueOf(word = txt.charAt(i)))) != null; ++i) {
            ++curLength;
            if (!cur.isEnd) continue;
            flag = true;
            if (1 == matchType) break;
        }
        if (!flag) {
            curLength = 0;
        }
        return curLength;
    }

    public boolean isContainsWord(String txt) {
        if (txt == null || txt.isEmpty()) {
            return false;
        }
        if (this.next.isEmpty()) {
            return false;
        }
        boolean flag = false;
        for (int i = 0; i < txt.length(); ++i) {
            int matchFlag = this.checkWord(txt, i, 1);
            if (matchFlag <= 0) continue;
            flag = true;
        }
        return flag;
    }

    public List<String> getMatchedWords(String txt) {
        LinkedHashSet<String> matched = new LinkedHashSet<String>();
        if (txt == null || txt.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.next.isEmpty()) {
            return Collections.emptyList();
        }
        int length = txt.length();
        for (int i = 0; i < length; ++i) {
            char word;
            WordTree cur = this;
            int curLength = 0;
            for (int k = i; k < length && (cur = cur.next.get(Character.valueOf(word = txt.charAt(k)))) != null; ++k) {
                ++curLength;
                if (!cur.isEnd) continue;
                String curWord = txt.substring(i, i + curLength);
                matched.add(curWord);
            }
        }
        return Lists.newArrayList(matched);
    }

    public boolean isEnd() {
        return this.isEnd;
    }

    public HashMap<Character, WordTree> getNext() {
        return this.next;
    }

    public void setEnd(boolean isEnd) {
        this.isEnd = isEnd;
    }

    public void setNext(HashMap<Character, WordTree> next) {
        this.next = next;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WordTree)) {
            return false;
        }
        WordTree other = (WordTree)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnd() != other.isEnd()) {
            return false;
        }
        HashMap<Character, WordTree> this$next = this.getNext();
        HashMap<Character, WordTree> other$next = other.getNext();
        return !(this$next == null ? other$next != null : !((Object)this$next).equals(other$next));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WordTree;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnd() ? 79 : 97);
        HashMap<Character, WordTree> $next = this.getNext();
        result = result * 59 + ($next == null ? 43 : ((Object)$next).hashCode());
        return result;
    }

    public String toString() {
        return "WordTree(isEnd=" + this.isEnd() + ", next=" + this.getNext() + ")";
    }
}

