/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.handler.utils;

import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class VipMsgLock {
    private static final Logger log = LoggerFactory.getLogger(VipMsgLock.class);
    @Value(value="${spring.redis.key.prefix}")
    private String redisKeyPrefix;
    @Value(value="${spring.redis.key.msgSyncLock.format:msg_sync_lock:%d:%s}")
    private String msgSyncLock;
    @Value(value="${spring.redis.key.msgSyncLock.expire:600}")
    private Long msgSyncLockExpireTime;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    public boolean locked(Long bizId, String appInfo) {
        String content = String.format(this.msgSyncLock, bizId, appInfo);
        String lockKey = this.redisKeyPrefix + content;
        try {
            Boolean locked = this.redisTemplate.opsForValue().setIfAbsent((Object)lockKey, (Object)"", this.msgSyncLockExpireTime.longValue(), TimeUnit.SECONDS);
            log.debug("locked={}, key={}", (Object)locked, (Object)lockKey);
            if (locked == null) {
                return false;
            }
            return locked;
        }
        catch (Exception e) {
            log.error("Failed lock msg appInfo={}", (Object)appInfo, (Object)e);
            return false;
        }
    }

    public void unlock(Long bizId, String appInfo) {
        String content = String.format(this.msgSyncLock, bizId, appInfo);
        String lockKey = this.redisKeyPrefix + content;
        try {
            this.redisTemplate.delete((Object)lockKey);
            log.debug("unlock key={}", (Object)lockKey);
        }
        catch (Exception e) {
            log.error("Failed unlock msg appInfo={}", (Object)appInfo, (Object)e);
        }
    }
}

