/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.handler.common;

import cn.kinyun.scrm.vip.context.ReplyContext;
import cn.kinyun.scrm.vip.context.ReplyContextUtil;
import cn.kinyun.scrm.vip.reply.service.ReplySettingService;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class MsgDigestHelper {
    private static final Logger log = LoggerFactory.getLogger(MsgDigestHelper.class);
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Value(value="${spring.redis.key.prefix}")
    private String redisKeyPrefix;
    @Autowired
    private ReplySettingService settingService;

    private String friendKey(Long bizId, String weworkId, String senderId) {
        return this.redisKeyPrefix + String.format("mdc:f:%d:%s:%s", bizId, weworkId, senderId);
    }

    private String groupKey(Long businessCustomerId, String chatroomId) {
        return this.redisKeyPrefix + String.format("mdc:g:%d:%s", businessCustomerId, chatroomId);
    }

    public String redisKey() {
        ReplyContext ctx = ReplyContextUtil.get();
        if (ctx.getConType() == 0) {
            return this.friendKey(ctx.getBizId(), ctx.getWeworkId(), ctx.getSenderId());
        }
        return this.groupKey(ctx.getBizId(), ctx.getChatRoomId());
    }

    private Integer friendExpired(Long bizId) {
        boolean deduplicateEnabled = this.settingService.getFriendReplyDeduplicateEnabled(bizId);
        Integer deduplicateTime = this.settingService.getFriendReplyDeduplicateTime(bizId);
        if (deduplicateEnabled && deduplicateTime > 0) {
            return deduplicateTime;
        }
        return -1;
    }

    private Integer groupExpired(Long bizId) {
        boolean deduplicateEnabled = this.settingService.getGroupReplyDeduplicateEnabled(bizId);
        Integer deduplicateTime = this.settingService.getGroupReplyDeduplicateTime(bizId);
        if (deduplicateEnabled && deduplicateTime > 0) {
            return deduplicateTime;
        }
        return -1;
    }

    public Integer expire() {
        ReplyContext ctx = ReplyContextUtil.get();
        if (ctx.getConType() == 0) {
            return this.friendExpired(ctx.getBizId());
        }
        return this.groupExpired(ctx.getBizId());
    }

    public Set<String> isCached(List<String> digests) {
        log.info("Query cached digests={}", digests);
        long seconds = this.expire().intValue();
        if (seconds <= 0L) {
            log.info("message deduplicate is disabled, expire={}", (Object)seconds);
            return Collections.emptySet();
        }
        String key = this.redisKey();
        Map map = null;
        try {
            HashOperations hash = this.redisTemplate.opsForHash();
            map = hash.entries((Object)key);
        }
        catch (Exception e) {
            log.error("Failed get redis, key={}", (Object)key, (Object)e);
        }
        if (map == null || map.isEmpty()) {
            log.info("No cached digests found, key={}", (Object)key);
            return Collections.emptySet();
        }
        long now = System.currentTimeMillis() / 1000L;
        HashSet result = Sets.newHashSet();
        for (String digest : digests) {
            if (!map.containsKey(digest)) continue;
            String value = (String)map.get(digest);
            try {
                long timestamp = Long.parseLong(value);
                if (now > timestamp + seconds) continue;
                result.add(digest);
            }
            catch (Exception e) {
                log.error("Failed parsing digest timestamp={}", (Object)value, (Object)e);
            }
        }
        if (!result.isEmpty()) {
            log.info("These digests is cached, key={}, result={}", (Object)key, (Object)result);
        }
        return result;
    }

    public boolean isCached(String digest) {
        long timestamp;
        long seconds = this.expire().intValue();
        if (seconds <= 0L) {
            log.info("message deduplicate is disabled, expire={}", (Object)seconds);
            return false;
        }
        String key = this.redisKey();
        String value = null;
        try {
            HashOperations hash = this.redisTemplate.opsForHash();
            value = (String)hash.get((Object)key, (Object)digest);
        }
        catch (Exception e) {
            log.error("Failed get redis, key={}, digest={}", new Object[]{key, digest, e});
        }
        if (value == null) {
            log.info("No cached digest found, key={}, digest={}", (Object)key, (Object)digest);
            return false;
        }
        try {
            timestamp = Long.parseLong(value);
        }
        catch (Exception e) {
            log.error("Failed parsing digest timestamp={}", (Object)value, (Object)e);
            return false;
        }
        long now = System.currentTimeMillis() / 1000L;
        if (now > timestamp + seconds) {
            return false;
        }
        log.info("This message is cached, key={}, digest={}, createTime={}", new Object[]{key, digest, timestamp});
        return true;
    }

    public void cache(String digest) {
        long seconds = this.expire().intValue();
        if (seconds <= 0L) {
            return;
        }
        String key = this.redisKey();
        log.info("cache message digest, key={}, digest={}, seconds={}", new Object[]{key, digest, seconds});
        long timestamp = System.currentTimeMillis() / 1000L;
        String value = Long.toString(timestamp);
        try {
            HashOperations hash = this.redisTemplate.opsForHash();
            hash.put((Object)key, (Object)digest, (Object)value);
            this.redisTemplate.expire((Object)key, seconds, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            log.error("Failed cache message key={}, digest={}", new Object[]{key, digest, e});
        }
    }
}

