/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.handler.biz;

import cn.kinyun.scrm.vip.cache.dto.CachedOption;
import cn.kinyun.scrm.vip.cache.dto.CachedReplyMsg;
import cn.kinyun.scrm.vip.cache.service.ReplyOptionCacheService;
import cn.kinyun.scrm.vip.context.ReplyContext;
import cn.kinyun.scrm.vip.context.ReplyContextUtil;
import cn.kinyun.scrm.vip.handler.common.ReplyMsgSendHelper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReplyOptionHandler {
    private static final Logger log = LoggerFactory.getLogger(ReplyOptionHandler.class);
    @Autowired
    private ReplyMsgSendHelper replyMsgSendHelper;
    @Autowired
    private ReplyOptionCacheService replyOptionCacheService;

    public boolean recvFriendText() {
        ReplyContext ctx = ReplyContextUtil.get();
        String text = ctx.getPureMsg();
        String weworkId = ctx.getWeworkId();
        String senderId = ctx.getSenderId();
        Long bizId = ctx.getBizId();
        if (!StringUtils.isNumeric((CharSequence)text)) {
            return false;
        }
        log.info("reply option with num={}", (Object)text);
        String redisKey = this.replyOptionCacheService.getReplyOptionKey(bizId, weworkId, senderId);
        CachedOption cache = this.replyOptionCacheService.getCachedOption(redisKey);
        CachedReplyMsg result = this.replyOptionCacheService.getValidOption(cache, text);
        if (result == null) {
            log.info("No valid option found with cache={}, num={}", (Object)cache, (Object)text);
            return false;
        }
        return this.replyMsgSendHelper.sendFriendMsg(cache.getText(), null, result);
    }
}

