/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.handler.biz;

import cn.kinyun.scrm.vip.cache.dto.CachedReplyMsg;
import cn.kinyun.scrm.vip.context.ReplyContext;
import cn.kinyun.scrm.vip.context.ReplyContextUtil;
import cn.kinyun.scrm.vip.handler.common.ReplyMsgSendHelper;
import cn.kinyun.scrm.vip.reply.enums.FriendMsgReplyType;
import com.kuaike.scrm.common.utils.SHA1Utils;
import com.kuaike.scrm.dal.vip.reply.entity.VipAutoReply;
import com.kuaike.scrm.dal.vip.reply.mapper.VipAutoReplyMapper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FriendDefaultReplyHandler {
    private static final Logger log = LoggerFactory.getLogger(FriendDefaultReplyHandler.class);
    @Autowired
    private VipAutoReplyMapper vipAutoReplyMapper;
    @Autowired
    private ReplyMsgSendHelper replyMsgSendHelper;

    public boolean defaultReply() {
        return this.reply(FriendMsgReplyType.DEFAULT);
    }

    public boolean recvImage() {
        return this.reply(FriendMsgReplyType.IMAGE);
    }

    public boolean recvVideo() {
        return this.reply(FriendMsgReplyType.VIDEO);
    }

    public boolean recvVoice() {
        return this.reply(FriendMsgReplyType.VOICE);
    }

    public boolean recvFile() {
        return this.reply(FriendMsgReplyType.FILE);
    }

    private boolean reply(FriendMsgReplyType msgType) {
        ReplyContext ctx = ReplyContextUtil.get();
        log.info("default reply on msgType={}, requestId={}", (Object)msgType, (Object)ctx.getRequestId());
        String weworkId = ctx.getWeworkId();
        String text = ctx.getPureMsg();
        Long bizId = ctx.getBizId();
        VipAutoReply reply = this.vipAutoReplyMapper.selectFriendDefaultReply(weworkId, bizId, msgType.getDesc());
        if (reply == null) {
            return false;
        }
        if (reply.getEnabled() == null || reply.getEnabled() == 0) {
            log.info("Auto reply is disabled for businessCustomerId={}, wechatId={}", (Object)bizId, (Object)weworkId);
            return false;
        }
        String message = reply.getMessage();
        if (StringUtils.isBlank((CharSequence)message)) {
            log.warn("Auto reply message is blank, replyId={}", (Object)reply.getId());
            return false;
        }
        CachedReplyMsg dto = new CachedReplyMsg();
        dto.setReplyId(reply.getId());
        dto.setMsg(reply.getMessage());
        if (StringUtils.isNotBlank((CharSequence)reply.getMessage())) {
            dto.setDigest(reply.getDigest());
        } else {
            dto.setDigest(SHA1Utils.digest((String)reply.getMessage()));
        }
        return this.replyMsgSendHelper.sendFriendMsg(text, null, dto);
    }
}

