/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.handler;

import cn.kinyun.scrm.vip.cache.service.BlacklistCacheService;
import cn.kinyun.scrm.vip.cache.service.WeworkAccountCacheService;
import cn.kinyun.scrm.vip.context.ReplyContext;
import cn.kinyun.scrm.vip.context.ReplyContextUtil;
import cn.kinyun.scrm.vip.handler.AbstractDispatcher;
import cn.kinyun.scrm.vip.handler.biz.FriendDefaultReplyHandler;
import cn.kinyun.scrm.vip.handler.biz.FriendKeywordReplyHandler;
import cn.kinyun.scrm.vip.handler.biz.ReplyOptionHandler;
import cn.kinyun.scrm.vip.handler.utils.VipMsgLock;
import cn.kinyun.scrm.vip.reply.service.ReplySettingService;
import cn.kinyun.scrm.vip.reply.utils.MsgUtils;
import com.kuaike.scrm.vip.dto.model.WeworkMessage;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FriendMsgRecvHandler
extends AbstractDispatcher {
    private static final Logger log = LoggerFactory.getLogger(FriendMsgRecvHandler.class);
    @Autowired
    private VipMsgLock lock;
    @Autowired
    private ReplySettingService settingService;
    @Autowired
    private WeworkAccountCacheService wechatAccountCacheService;
    @Autowired
    private BlacklistCacheService blacklistCacheService;
    @Autowired
    private FriendKeywordReplyHandler friendKeywordReplyHandler;
    @Autowired
    private ReplyOptionHandler replyOptionHandler;
    @Autowired
    private FriendDefaultReplyHandler friendDefaultReplyHandler;

    @Override
    public void dispatch(WeworkMessage weworkMessage) {
        ReplyContext ctx = ReplyContextUtil.get();
        if (this.blacklistCacheService.inBlacklist(ctx.getBizId(), ctx.getConId())) {
            log.info("Ignore sender in black list, bizId={}, senderId={}", (Object)ctx.getBizId(), (Object)ctx.getConId());
            return;
        }
        if (this.wechatAccountCacheService.isRobot(ctx.getConId())) {
            log.info("Ignore msg from robot, senderId={}", (Object)ctx.getConId());
            return;
        }
        if (this.settingService.isRestTime(ctx.getBizId())) {
            return;
        }
        if (!this.lock.locked(ctx.getBizId(), ctx.getAppInfo())) {
            log.info("Not locked, requestId={}", (Object)ctx.getRequestId());
            ctx.setLocked(false);
            return;
        }
        ctx.setLocked(true);
        super.dispatch(weworkMessage);
    }

    @Override
    public boolean text(WeworkMessage weworkMessage) {
        log.info("receive text message, content={}", (Object)weworkMessage.getContent());
        String content = weworkMessage.getContent();
        if ("\u6211\u901a\u8fc7\u4e86\u4f60\u7684\u8054\u7cfb\u4eba\u9a8c\u8bc1\u8bf7\u6c42\uff0c\u73b0\u5728\u6211\u4eec\u53ef\u4ee5\u5f00\u59cb\u804a\u5929\u4e86".equals(content)) {
            log.info("addFriendByMobile received requestId:{}", (Object)weworkMessage.getRequestId());
            return false;
        }
        if ("\u6211\u5df2\u7ecf\u6dfb\u52a0\u4e86\u4f60\uff0c\u73b0\u5728\u6211\u4eec\u53ef\u4ee5\u5f00\u59cb\u804a\u5929\u4e86\u3002".equals(content)) {
            log.info("addFriend received requestId:{}", (Object)weworkMessage.getRequestId());
            return false;
        }
        return this.onText(weworkMessage);
    }

    @Override
    public boolean textControl(WeworkMessage weworkMessage) {
        log.info("receive text control message, content={}", (Object)weworkMessage.getContent());
        String content = weworkMessage.getContent();
        if (MsgUtils.match((String)content, (Pattern)MsgUtils.FRIEND_IS_JOINED_PATTERN)) {
            return false;
        }
        if (MsgUtils.match((String)content, (Pattern)MsgUtils.JOINED_BY_FRIEND_PATTERN)) {
            return false;
        }
        if (MsgUtils.match((String)content, (Pattern)MsgUtils.NOT_FRIEND_PATTERN)) {
            return false;
        }
        if (MsgUtils.match((String)content, (Pattern)MsgUtils.NOT_FRIEND_PATTERN_MSG)) {
            return false;
        }
        return this.onText(weworkMessage);
    }

    private boolean onText(WeworkMessage weworkMessage) {
        String content = weworkMessage.getContent();
        ReplyContextUtil.get().setMsg(content);
        content = MsgUtils.removeReferredText((String)content);
        ReplyContextUtil.get().setPureMsg(content);
        if (this.replyOptionHandler.recvFriendText()) {
            return true;
        }
        if (this.friendKeywordReplyHandler.recvText()) {
            return true;
        }
        if (this.friendDefaultReplyHandler.defaultReply()) {
            return true;
        }
        log.info("\u672a\u547d\u4e2d\u4efb\u4f55\u56de\u590d, uniqueId={}", (Object)weworkMessage.getUniqueId());
        return false;
    }

    @Override
    public boolean image(WeworkMessage weworkMessage) {
        if (this.friendDefaultReplyHandler.recvImage()) {
            return true;
        }
        if (this.friendDefaultReplyHandler.defaultReply()) {
            return true;
        }
        log.info("\u672a\u547d\u4e2d\u4efb\u4f55\u56de\u590d, uniqueId={}", (Object)weworkMessage.getUniqueId());
        return false;
    }

    @Override
    public boolean emotion(WeworkMessage weworkMessage) {
        if (this.friendDefaultReplyHandler.recvImage()) {
            return true;
        }
        if (this.friendDefaultReplyHandler.defaultReply()) {
            return true;
        }
        log.info("\u672a\u547d\u4e2d\u4efb\u4f55\u56de\u590d, uniqueId={}", (Object)weworkMessage.getUniqueId());
        return false;
    }

    @Override
    public boolean voice(WeworkMessage weworkMessage) {
        if (this.friendDefaultReplyHandler.recvVoice()) {
            return true;
        }
        if (this.friendDefaultReplyHandler.defaultReply()) {
            return true;
        }
        log.info("\u672a\u547d\u4e2d\u4efb\u4f55\u56de\u590d, uniqueId={}", (Object)weworkMessage.getUniqueId());
        return false;
    }

    @Override
    public boolean video(WeworkMessage weworkMessage) {
        if (this.friendDefaultReplyHandler.recvVideo()) {
            return true;
        }
        if (this.friendDefaultReplyHandler.defaultReply()) {
            return true;
        }
        log.info("\u672a\u547d\u4e2d\u4efb\u4f55\u56de\u590d, uniqueId={}", (Object)weworkMessage.getUniqueId());
        return false;
    }

    @Override
    public boolean file(WeworkMessage weworkMessage) {
        if (this.friendDefaultReplyHandler.recvFile()) {
            return true;
        }
        if (this.friendDefaultReplyHandler.defaultReply()) {
            return true;
        }
        log.info("\u672a\u547d\u4e2d\u4efb\u4f55\u56de\u590d, uniqueId={}", (Object)weworkMessage.getUniqueId());
        return false;
    }

    @Override
    public boolean link(WeworkMessage weworkMessage) {
        if (this.friendDefaultReplyHandler.defaultReply()) {
            return true;
        }
        log.info("\u672a\u547d\u4e2d\u4efb\u4f55\u56de\u590d, uniqueId={}", (Object)weworkMessage.getUniqueId());
        return false;
    }
}

