/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.handler;

import com.kuaike.scrm.vip.dto.model.WeworkMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractDispatcher {
    private static final Logger log = LoggerFactory.getLogger(AbstractDispatcher.class);

    public void dispatch(WeworkMessage weworkMessage) {
        Integer contentType = weworkMessage.getContentType();
        if (contentType == null) {
            log.warn("contentType is null, requestId={}", (Object)weworkMessage.getRequestId());
            return;
        }
        switch (contentType) {
            case 0: 
            case 2: {
                this.text(weworkMessage);
                break;
            }
            case 5: 
            case 17: 
            case 23: 
            case 103: {
                this.video(weworkMessage);
                break;
            }
            case 7: 
            case 14: 
            case 101: {
                this.image(weworkMessage);
                break;
            }
            case 9: 
            case 16: {
                this.voice(weworkMessage);
                break;
            }
            case 13: {
                this.link(weworkMessage);
                break;
            }
            case 41: {
                this.personalCard(weworkMessage);
                break;
            }
            case 8: 
            case 15: 
            case 102: {
                this.file(weworkMessage);
                break;
            }
            case 29: 
            case 104: {
                this.emotion(weworkMessage);
                break;
            }
            case 1001: {
                this.changeRoomName(weworkMessage);
                break;
            }
            case 1002: {
                this.addRoomMember(weworkMessage);
                break;
            }
            case 1003: {
                this.deleteRoomMember(weworkMessage);
                break;
            }
            case 1006: {
                this.createRoom(weworkMessage);
                break;
            }
            case 1023: {
                this.dismissRoom(weworkMessage);
                break;
            }
            case 1011: {
                this.textControl(weworkMessage);
                break;
            }
            default: {
                this.unknown(weworkMessage);
            }
        }
    }

    public void unknown(WeworkMessage weworkMessage) {
        log.info("Unknown contentType:{}, requestId:{}", (Object)weworkMessage.getContentType(), (Object)weworkMessage.getRequestId());
    }

    public boolean text(WeworkMessage weworkMessage) {
        log.info("text:{}", (Object)weworkMessage.getAppInfo());
        return false;
    }

    public boolean image(WeworkMessage weworkMessage) {
        log.info("image:{}", (Object)weworkMessage.getAppInfo());
        return false;
    }

    public boolean emotion(WeworkMessage weworkMessage) {
        log.info("emotion:{}", (Object)weworkMessage.getAppInfo());
        return false;
    }

    public boolean voice(WeworkMessage weworkMessage) {
        log.info("voice:{}", (Object)weworkMessage.getAppInfo());
        return false;
    }

    public boolean video(WeworkMessage weworkMessage) {
        log.info("video:{}", (Object)weworkMessage.getAppInfo());
        return false;
    }

    public boolean file(WeworkMessage weworkMessage) {
        log.info("file:{}", (Object)weworkMessage.getAppInfo());
        return false;
    }

    public boolean link(WeworkMessage weworkMessage) {
        log.info("link:{}", (Object)weworkMessage.getAppInfo());
        return false;
    }

    public boolean personalCard(WeworkMessage weworkMessage) {
        log.info("personalCard:{}", (Object)weworkMessage.getAppInfo());
        return false;
    }

    public boolean changeRoomName(WeworkMessage weworkMessage) {
        log.info("changeRoomName:{}", (Object)weworkMessage.getAppInfo());
        return false;
    }

    public boolean addRoomMember(WeworkMessage weworkMessage) {
        log.info("addRoomMember:{}", (Object)weworkMessage.getAppInfo());
        return false;
    }

    public boolean deleteRoomMember(WeworkMessage weworkMessage) {
        log.info("deleteRoomMember:{}", (Object)weworkMessage.getAppInfo());
        return false;
    }

    public boolean createRoom(WeworkMessage weworkMessage) {
        log.info("createRoom:{}", (Object)weworkMessage.getAppInfo());
        return false;
    }

    public boolean dismissRoom(WeworkMessage weworkMessage) {
        log.info("dismissRoom:{}", (Object)weworkMessage.getAppInfo());
        return false;
    }

    public boolean textControl(WeworkMessage weworkMessage) {
        log.info("textControl:{}", (Object)weworkMessage.getAppInfo());
        return false;
    }
}

