/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.tranfer.service.impl;

import cn.kinyun.wework.sdk.api.external.TransferClient;
import cn.kinyun.wework.sdk.entity.external.transfer.TransferResult;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.FollowRecordType;
import com.kuaike.scrm.common.enums.TakeoverStatus;
import com.kuaike.scrm.dal.transfer.entity.DimissionWeworkUserCustomer;
import com.kuaike.scrm.dal.transfer.entity.InJobAllocateRecord;
import com.kuaike.scrm.dal.transfer.mapper.DimissionAllocateRecordMapper;
import com.kuaike.scrm.dal.transfer.mapper.DimissionWeworkUserCustomerMapper;
import com.kuaike.scrm.dal.transfer.mapper.DimissionWeworkUserMapper;
import com.kuaike.scrm.dal.transfer.mapper.InJobAllocateRecordMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.follow.dto.AllocateInfo;
import com.kuaike.scrm.follow.dto.FollowReqDto;
import com.kuaike.scrm.follow.service.FollowService;
import com.kuaike.scrm.tranfer.service.TransferService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TransferServiceImpl
implements TransferService {
    private static final Logger log = LoggerFactory.getLogger(TransferServiceImpl.class);
    @Autowired
    private TransferClient transferClient;
    @Autowired
    private FollowService followService;
    @Autowired
    private InJobAllocateRecordMapper inJobAllocateRecordMapper;
    @Autowired
    private DimissionWeworkUserMapper dimissionWeworkUserMapper;
    @Autowired
    private DimissionWeworkUserCustomerMapper dimissionWeworkUserCustomerMapper;
    @Autowired
    private DimissionAllocateRecordMapper dimissionAllocateRecordMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;

    @Override
    public void queryInJobTransferStatus() {
        List allocateRecords = this.inJobAllocateRecordMapper.selectWaitAllocateRecords();
        if (CollectionUtils.isEmpty((Collection)allocateRecords)) {
            log.info("\u6ca1\u6709\u5904\u4e8e\u5206\u914d\u4e2d\u7684\u8bb0\u5f55");
            return;
        }
        Map<String, List<InJobAllocateRecord>> corpId2RecordsMap = allocateRecords.stream().collect(Collectors.groupingBy(InJobAllocateRecord::getCorpId));
        CountDownLatch countDownLatch = new CountDownLatch(corpId2RecordsMap.size());
        log.info("countDownLatch:{}", (Object)countDownLatch);
        for (Map.Entry<String, List<InJobAllocateRecord>> entry : corpId2RecordsMap.entrySet()) {
            String corpId = entry.getKey();
            List<InJobAllocateRecord> inJobAllocateRecords = entry.getValue();
            new Thread(() -> {
                for (InJobAllocateRecord inJobAllocateRecord : inJobAllocateRecords) {
                    String weworkUserNum = inJobAllocateRecord.getWeworkUserNum();
                    String weworkUserId = this.weworkUserMapper.queryWeworkUserIdByNum(weworkUserNum);
                    String takeoverUserNum = inJobAllocateRecord.getTakeoverUserNum();
                    String takeoverUserId = this.weworkUserMapper.queryWeworkUserIdByNum(takeoverUserNum);
                    String cursor = null;
                    boolean flag = true;
                    try {
                        log.info("corpId:{}, weworkUserId:{}, takeoverUserId:{}, cursor:{}", new Object[]{corpId, weworkUserId, takeoverUserId, cursor});
                        while (flag) {
                            TransferResult transferResult = this.transferClient.getTransferResult(corpId, weworkUserId, takeoverUserId, cursor);
                            log.info("transferResult:{}", (Object)transferResult);
                            cursor = transferResult.getNextCursor();
                            if (StringUtils.isBlank((CharSequence)transferResult.getNextCursor())) {
                                flag = false;
                            }
                            List customers = transferResult.getCustomerList();
                            for (TransferResult.Customer customer : customers) {
                                InJobAllocateRecord jobAllocateRecord = this.inJobAllocateRecordMapper.selectByParams(corpId, weworkUserNum, takeoverUserNum, customer.getExternalUserId());
                                if (Objects.isNull(jobAllocateRecord)) {
                                    log.info("\u6839\u636ecorpId:{}, weworkUserId:{}, takeoverUserId:{}, contactId:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", new Object[]{corpId, weworkUserId, takeoverUserId, customer.getExternalUserId()});
                                    continue;
                                }
                                if (TakeoverStatus.FINISH.getValue() == customer.getStatus().intValue() && jobAllocateRecord.getStatus().intValue() != TakeoverStatus.FINISH.getValue()) {
                                    this.addSaveFollowRecord(1, weworkUserNum, customer.getExternalUserId(), takeoverUserNum, corpId, jobAllocateRecord.getBizId(), jobAllocateRecord.getCreateBy());
                                }
                                if (jobAllocateRecord.getStatus().equals(customer.getStatus())) continue;
                                this.inJobAllocateRecordMapper.updateStatus(corpId, weworkUserNum, takeoverUserNum, customer.getStatus(), customer.getExternalUserId());
                            }
                        }
                    }
                    catch (Exception ex) {
                        WeworkException weworkException;
                        int errorCode;
                        log.error("\u67e5\u8be2\u5728\u804c\u7ee7\u627f\u72b6\u6001\u65f6\u53d1\u751f\u5f02\u5e38:", (Throwable)ex);
                        if (!(ex instanceof WeworkException) || (errorCode = (weworkException = (WeworkException)ex).getErrorCode().intValue()) != 40003) continue;
                        this.inJobAllocateRecordMapper.batchUpdateStatus(corpId, weworkUserNum, takeoverUserNum, Integer.valueOf(TakeoverStatus.FAIL.getValue()), Integer.valueOf(errorCode), weworkException.getErrorMsg());
                    }
                }
                countDownLatch.countDown();
            }).start();
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            log.error("countDownLatch await \u53d1\u751f\u5f02\u5e38");
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void queryDimissionTransferStatus() {
        List userCustomers = this.dimissionWeworkUserCustomerMapper.selectWaitAllocateRecords();
        if (CollectionUtils.isEmpty((Collection)userCustomers)) {
            log.info("\u6ca1\u6709\u5904\u4e8e\u5206\u914d\u4e2d\u7684\u8bb0\u5f55");
            return;
        }
        Map<String, List<DimissionWeworkUserCustomer>> corpId2RecordsMap = userCustomers.stream().collect(Collectors.groupingBy(DimissionWeworkUserCustomer::getCorpId));
        CountDownLatch countDownLatch = new CountDownLatch(corpId2RecordsMap.size());
        for (Map.Entry<String, List<DimissionWeworkUserCustomer>> entry : corpId2RecordsMap.entrySet()) {
            String corpId = entry.getKey();
            List<DimissionWeworkUserCustomer> corpUserCustomers = entry.getValue();
            new Thread(() -> {
                for (DimissionWeworkUserCustomer inJobAllocateRecord : corpUserCustomers) {
                    String weworkUserNum = inJobAllocateRecord.getWeworkUserNum();
                    String weworkUserId = this.weworkUserMapper.queryWeworkUserIdByNum(weworkUserNum);
                    String takeoverUserNum = inJobAllocateRecord.getTakeoverUserNum();
                    String takeoverUserId = this.weworkUserMapper.queryWeworkUserIdByNum(takeoverUserNum);
                    String cursor = null;
                    boolean flag = true;
                    int successCount = 0;
                    try {
                        log.info("corpId:{}, weworkUserId:{}, takeoverUserId:{}, cursor:{}", new Object[]{corpId, weworkUserNum, takeoverUserNum, cursor});
                        while (flag) {
                            TransferResult transferResult = this.transferClient.getTransferResultOfDimission(corpId, weworkUserId, takeoverUserId, cursor);
                            log.info("queryDimissionTransferStatus,transferResult:{}", (Object)transferResult);
                            cursor = transferResult.getNextCursor();
                            if (StringUtils.isBlank((CharSequence)cursor)) {
                                flag = false;
                            }
                            List customers = transferResult.getCustomerList();
                            for (TransferResult.Customer customer : customers) {
                                DimissionWeworkUserCustomer weworkUserCustomer = this.dimissionWeworkUserCustomerMapper.selectByParams(corpId, weworkUserNum, takeoverUserNum, customer.getExternalUserId());
                                if (Objects.isNull(weworkUserCustomer)) {
                                    log.info("\u6839\u636ecorpId:{},weworkUserNum:{},takeoverUserNum:{},contactId:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", new Object[]{corpId, weworkUserNum, takeoverUserNum, customer.getExternalUserId()});
                                    continue;
                                }
                                if (TakeoverStatus.FINISH.getValue() == customer.getStatus().intValue() && TakeoverStatus.FINISH.getValue() != weworkUserCustomer.getStatus().intValue()) {
                                    this.addSaveFollowRecord(2, weworkUserNum, customer.getExternalUserId(), takeoverUserNum, corpId, weworkUserCustomer.getBizId(), weworkUserCustomer.getUpdateBy());
                                }
                                if (!weworkUserCustomer.getStatus().equals(customer.getStatus())) {
                                    this.dimissionAllocateRecordMapper.updateStatus(corpId, weworkUserNum, takeoverUserNum, customer.getExternalUserId(), customer.getStatus());
                                    this.dimissionWeworkUserCustomerMapper.updateStatus(corpId, weworkUserNum, takeoverUserNum, customer.getExternalUserId(), customer.getStatus());
                                }
                                if (TakeoverStatus.FINISH.getValue() != customer.getStatus().intValue() || weworkUserCustomer.getStatus().intValue() == TakeoverStatus.FINISH.getValue()) continue;
                                ++successCount;
                            }
                        }
                    }
                    catch (Exception ex) {
                        log.error("\u67e5\u8be2\u79bb\u804c\u7ee7\u627f\u72b6\u6001\u65f6\u53d1\u751f\u5f02\u5e38:", (Throwable)ex);
                    }
                    if (successCount <= 0) continue;
                    this.dimissionWeworkUserMapper.updateCustomerCount(corpId, weworkUserNum, Integer.valueOf(successCount));
                }
                countDownLatch.countDown();
            }).start();
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            log.error("countDownLatch await \u53d1\u751f\u5f02\u5e38");
            Thread.currentThread().interrupt();
        }
    }

    private void addSaveFollowRecord(int allocateType, String handoverUserNum, String contactId, String takeoverUserNum, String corpId, Long bizId, Long operatorId) {
        FollowReqDto followReqDto = new FollowReqDto();
        followReqDto.setType(Integer.valueOf(FollowRecordType.TRANSFER_CONTACT.getValue()));
        followReqDto.setWeworkUserNum(takeoverUserNum);
        followReqDto.setContactId(contactId);
        AllocateInfo allocateInfo = new AllocateInfo();
        followReqDto.setAllocateInfo(allocateInfo);
        allocateInfo.setAllocateType(Integer.valueOf(allocateType));
        allocateInfo.setHandoverUserId(handoverUserNum);
        allocateInfo.setTakeoverUserId(takeoverUserNum);
        CurrentUserInfo currentUserInfo = new CurrentUserInfo();
        currentUserInfo.setCorpId(corpId);
        currentUserInfo.setBizId(bizId);
        currentUserInfo.setId(operatorId);
        try {
            this.followService.saveFollowRecord(followReqDto, currentUserInfo);
        }
        catch (Exception ex) {
            log.error("allocateType:{}, handoverUserNum:{}, contactId:{}, takeoverUserNum:{}", new Object[]{allocateType, handoverUserNum, contactId, takeoverUserNum});
            log.error("\u8f6c\u4ea4\u6210\u529f\u540e\u6dfb\u52a0\u8ddf\u8fdb\u8bb0\u5f55\u53d1\u751f\u5f02\u5e38:", (Throwable)ex);
        }
    }
}

