/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.tranfer.dto.request;

import com.google.common.base.Preconditions;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.dal.transfer.dto.ContactQueryParams;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class CustomerReqDto {
    private String weworkUserId;
    private String weworkUserName;
    private String query;
    private Set<String> tagIds;
    private PageDto pageDto;
    private String channelId;
    private String takeoverUserId;
    private Date startTime;
    private Date endTime;
    private Integer status;

    public void baseValidate() {
        Preconditions.checkArgument((boolean)Objects.nonNull(this.pageDto), (Object)"\u5206\u9875\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.pageDto.getPageNum()), (Object)"\u5206\u9875\u9875\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.pageDto.getPageSize()), (Object)"\u5206\u9875\u5927\u5c0f\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public void validateParams() {
        this.baseValidate();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.weworkUserId), (Object)"\u6210\u5458\u552f\u4e00\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public ContactQueryParams convert2QueryParams(Set<String> contactIds) {
        ContactQueryParams queryParams = new ContactQueryParams();
        queryParams.setContactIds(contactIds);
        queryParams.setWeworkUserNum(this.weworkUserId);
        queryParams.setTakeoverUserNum(this.takeoverUserId);
        queryParams.setStatus(this.status);
        queryParams.setStartTime(this.startTime);
        queryParams.setEndTime(this.endTime);
        queryParams.setOffset(Integer.valueOf((this.pageDto.getPageNum() - 1) * this.pageDto.getPageSize()));
        queryParams.setPageSize(this.pageDto.getPageSize());
        return queryParams;
    }

    public String getWeworkUserId() {
        return this.weworkUserId;
    }

    public String getWeworkUserName() {
        return this.weworkUserName;
    }

    public String getQuery() {
        return this.query;
    }

    public Set<String> getTagIds() {
        return this.tagIds;
    }

    public PageDto getPageDto() {
        return this.pageDto;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public String getTakeoverUserId() {
        return this.takeoverUserId;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setWeworkUserId(String weworkUserId) {
        this.weworkUserId = weworkUserId;
    }

    public void setWeworkUserName(String weworkUserName) {
        this.weworkUserName = weworkUserName;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setTagIds(Set<String> tagIds) {
        this.tagIds = tagIds;
    }

    public void setPageDto(PageDto pageDto) {
        this.pageDto = pageDto;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public void setTakeoverUserId(String takeoverUserId) {
        this.takeoverUserId = takeoverUserId;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomerReqDto)) {
            return false;
        }
        CustomerReqDto other = (CustomerReqDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        String this$weworkUserId = this.getWeworkUserId();
        String other$weworkUserId = other.getWeworkUserId();
        if (this$weworkUserId == null ? other$weworkUserId != null : !this$weworkUserId.equals(other$weworkUserId)) {
            return false;
        }
        String this$weworkUserName = this.getWeworkUserName();
        String other$weworkUserName = other.getWeworkUserName();
        if (this$weworkUserName == null ? other$weworkUserName != null : !this$weworkUserName.equals(other$weworkUserName)) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        Set<String> this$tagIds = this.getTagIds();
        Set<String> other$tagIds = other.getTagIds();
        if (this$tagIds == null ? other$tagIds != null : !((Object)this$tagIds).equals(other$tagIds)) {
            return false;
        }
        PageDto this$pageDto = this.getPageDto();
        PageDto other$pageDto = other.getPageDto();
        if (this$pageDto == null ? other$pageDto != null : !this$pageDto.equals(other$pageDto)) {
            return false;
        }
        String this$channelId = this.getChannelId();
        String other$channelId = other.getChannelId();
        if (this$channelId == null ? other$channelId != null : !this$channelId.equals(other$channelId)) {
            return false;
        }
        String this$takeoverUserId = this.getTakeoverUserId();
        String other$takeoverUserId = other.getTakeoverUserId();
        if (this$takeoverUserId == null ? other$takeoverUserId != null : !this$takeoverUserId.equals(other$takeoverUserId)) {
            return false;
        }
        Date this$startTime = this.getStartTime();
        Date other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Date this$endTime = this.getEndTime();
        Date other$endTime = other.getEndTime();
        return !(this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CustomerReqDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        String $weworkUserId = this.getWeworkUserId();
        result = result * 59 + ($weworkUserId == null ? 43 : $weworkUserId.hashCode());
        String $weworkUserName = this.getWeworkUserName();
        result = result * 59 + ($weworkUserName == null ? 43 : $weworkUserName.hashCode());
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        Set<String> $tagIds = this.getTagIds();
        result = result * 59 + ($tagIds == null ? 43 : ((Object)$tagIds).hashCode());
        PageDto $pageDto = this.getPageDto();
        result = result * 59 + ($pageDto == null ? 43 : $pageDto.hashCode());
        String $channelId = this.getChannelId();
        result = result * 59 + ($channelId == null ? 43 : $channelId.hashCode());
        String $takeoverUserId = this.getTakeoverUserId();
        result = result * 59 + ($takeoverUserId == null ? 43 : $takeoverUserId.hashCode());
        Date $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Date $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        return result;
    }

    public String toString() {
        return "CustomerReqDto(weworkUserId=" + this.getWeworkUserId() + ", weworkUserName=" + this.getWeworkUserName() + ", query=" + this.getQuery() + ", tagIds=" + this.getTagIds() + ", pageDto=" + this.getPageDto() + ", channelId=" + this.getChannelId() + ", takeoverUserId=" + this.getTakeoverUserId() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", status=" + this.getStatus() + ")";
    }
}

