/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.tranfer.dto.request;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.dal.transfer.dto.RoomQueryParams;
import com.kuaike.scrm.tranfer.dto.request.SelectParams;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class AllocateRoomReqDto {
    private boolean isSelectAll;
    private String weworkUserId;
    private String takeoverUserId;
    private Set<String> roomIds;
    private SelectParams selectParams;

    public void validateParams() {
        Preconditions.checkArgument((boolean)Objects.nonNull(this.isSelectAll), (Object)"\u662f\u5426\u5168\u9009\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.weworkUserId), (Object)"\u79bb\u804c\u6210\u5458\u552f\u4e00\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.takeoverUserId), (Object)"\u63a5\u66ff\u6210\u5458\u552f\u4e00\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        if (!this.isSelectAll) {
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.roomIds), (Object)"\u7fa4id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((this.roomIds.size() <= 300 ? 1 : 0) != 0, (Object)"\u9009\u62e9\u7684\u7fa4\u6570\u91cf\u8d85\u8fc7300");
        }
    }

    public RoomQueryParams convert2RoomQueryParams(String corpId) {
        RoomQueryParams roomQueryParams = new RoomQueryParams();
        roomQueryParams.setCorpId(corpId);
        roomQueryParams.setWeworkUserNum(this.weworkUserId);
        if (Objects.nonNull(this.selectParams)) {
            roomQueryParams.setName(this.selectParams.getName());
            roomQueryParams.setBuildRoomStartTime(this.selectParams.getStartTime());
            roomQueryParams.setBuildRoomEndTime(this.selectParams.getEndTime());
        }
        return roomQueryParams;
    }

    public boolean isSelectAll() {
        return this.isSelectAll;
    }

    public String getWeworkUserId() {
        return this.weworkUserId;
    }

    public String getTakeoverUserId() {
        return this.takeoverUserId;
    }

    public Set<String> getRoomIds() {
        return this.roomIds;
    }

    public SelectParams getSelectParams() {
        return this.selectParams;
    }

    public void setSelectAll(boolean isSelectAll) {
        this.isSelectAll = isSelectAll;
    }

    public void setWeworkUserId(String weworkUserId) {
        this.weworkUserId = weworkUserId;
    }

    public void setTakeoverUserId(String takeoverUserId) {
        this.takeoverUserId = takeoverUserId;
    }

    public void setRoomIds(Set<String> roomIds) {
        this.roomIds = roomIds;
    }

    public void setSelectParams(SelectParams selectParams) {
        this.selectParams = selectParams;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AllocateRoomReqDto)) {
            return false;
        }
        AllocateRoomReqDto other = (AllocateRoomReqDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSelectAll() != other.isSelectAll()) {
            return false;
        }
        String this$weworkUserId = this.getWeworkUserId();
        String other$weworkUserId = other.getWeworkUserId();
        if (this$weworkUserId == null ? other$weworkUserId != null : !this$weworkUserId.equals(other$weworkUserId)) {
            return false;
        }
        String this$takeoverUserId = this.getTakeoverUserId();
        String other$takeoverUserId = other.getTakeoverUserId();
        if (this$takeoverUserId == null ? other$takeoverUserId != null : !this$takeoverUserId.equals(other$takeoverUserId)) {
            return false;
        }
        Set<String> this$roomIds = this.getRoomIds();
        Set<String> other$roomIds = other.getRoomIds();
        if (this$roomIds == null ? other$roomIds != null : !((Object)this$roomIds).equals(other$roomIds)) {
            return false;
        }
        SelectParams this$selectParams = this.getSelectParams();
        SelectParams other$selectParams = other.getSelectParams();
        return !(this$selectParams == null ? other$selectParams != null : !((Object)this$selectParams).equals(other$selectParams));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AllocateRoomReqDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSelectAll() ? 79 : 97);
        String $weworkUserId = this.getWeworkUserId();
        result = result * 59 + ($weworkUserId == null ? 43 : $weworkUserId.hashCode());
        String $takeoverUserId = this.getTakeoverUserId();
        result = result * 59 + ($takeoverUserId == null ? 43 : $takeoverUserId.hashCode());
        Set<String> $roomIds = this.getRoomIds();
        result = result * 59 + ($roomIds == null ? 43 : ((Object)$roomIds).hashCode());
        SelectParams $selectParams = this.getSelectParams();
        result = result * 59 + ($selectParams == null ? 43 : ((Object)$selectParams).hashCode());
        return result;
    }

    public String toString() {
        return "AllocateRoomReqDto(isSelectAll=" + this.isSelectAll() + ", weworkUserId=" + this.getWeworkUserId() + ", takeoverUserId=" + this.getTakeoverUserId() + ", roomIds=" + this.getRoomIds() + ", selectParams=" + this.getSelectParams() + ")";
    }
}

