/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.tranfer.service.impl;

import cn.kinyun.wework.sdk.api.external.TransferClient;
import cn.kinyun.wework.sdk.entity.external.transfer.TransferCustomerParams;
import cn.kinyun.wework.sdk.entity.external.transfer.TransferCustomerResp;
import cn.kinyun.wework.sdk.entity.external.transfer.TransferGroupChatFailMsg;
import cn.kinyun.wework.sdk.entity.external.transfer.TransferGroupChatResp;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.dto.resp.IdAndNameDto;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.RoomStatus;
import com.kuaike.scrm.common.enums.TakeoverStatus;
import com.kuaike.scrm.common.service.NodeService;
import com.kuaike.scrm.common.service.OrgService;
import com.kuaike.scrm.common.service.SettingService;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.MobileUtils;
import com.kuaike.scrm.dal.channel.entity.Channel;
import com.kuaike.scrm.dal.channel.mapper.ChannelMapper;
import com.kuaike.scrm.dal.contactanalyse.entity.WeworkContactLog;
import com.kuaike.scrm.dal.contactanalyse.mapper.WeworkContactLogMapper;
import com.kuaike.scrm.dal.contactanalyse.mapper.WeworkRoomJoinQuitLogMapper;
import com.kuaike.scrm.dal.transfer.dto.ContactQueryParams;
import com.kuaike.scrm.dal.transfer.dto.DimissionWeworkUserQueryParams;
import com.kuaike.scrm.dal.transfer.dto.RoomQueryParams;
import com.kuaike.scrm.dal.transfer.entity.DimissionAllocateRecord;
import com.kuaike.scrm.dal.transfer.entity.DimissionWeworkUser;
import com.kuaike.scrm.dal.transfer.entity.DimissionWeworkUserCustomer;
import com.kuaike.scrm.dal.transfer.entity.DimissionWeworkUserRoom;
import com.kuaike.scrm.dal.transfer.mapper.DimissionAllocateRecordMapper;
import com.kuaike.scrm.dal.transfer.mapper.DimissionWeworkUserCustomerMapper;
import com.kuaike.scrm.dal.transfer.mapper.DimissionWeworkUserMapper;
import com.kuaike.scrm.dal.transfer.mapper.DimissionWeworkUserRoomMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.entity.WeworkContactMobile;
import com.kuaike.scrm.dal.wework.entity.WeworkContactRelation;
import com.kuaike.scrm.dal.wework.entity.WeworkDepartment;
import com.kuaike.scrm.dal.wework.entity.WeworkDepartmentUser;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkChatRoomRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMobileMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkDepartmentMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkDepartmentUserMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.dal.weworktag.entity.WeworkContactTag;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkContactTagMapper;
import com.kuaike.scrm.tranfer.dto.request.AllocateContactReqDto;
import com.kuaike.scrm.tranfer.dto.request.AllocateCountReqDto;
import com.kuaike.scrm.tranfer.dto.request.AllocateReqDto;
import com.kuaike.scrm.tranfer.dto.request.AllocateRoomReqDto;
import com.kuaike.scrm.tranfer.dto.request.CustomerReqDto;
import com.kuaike.scrm.tranfer.dto.request.DimissionWeworkUserListReqDto;
import com.kuaike.scrm.tranfer.dto.request.RoomReqDto;
import com.kuaike.scrm.tranfer.dto.request.SelectParams;
import com.kuaike.scrm.tranfer.dto.response.AllocateCountRespDto;
import com.kuaike.scrm.tranfer.dto.response.AllocateResultRespDto;
import com.kuaike.scrm.tranfer.dto.response.CustomerRespDto;
import com.kuaike.scrm.tranfer.dto.response.DimissionWeworkUserRespDto;
import com.kuaike.scrm.tranfer.dto.response.RoomRespDto;
import com.kuaike.scrm.tranfer.service.DimissionService;
import com.kuaike.scrm.wework.department.service.DepartmentService;
import com.kuaike.scrm.wework.weworkuser.service.WeworkUserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DimissionServiceImpl
implements DimissionService {
    private static final Logger log = LoggerFactory.getLogger(DimissionServiceImpl.class);
    private static final Pattern NUM_PATTERN = Pattern.compile("[0-9]*");
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private WeworkDepartmentMapper weworkDepartmentMapper;
    @Autowired
    private WeworkDepartmentUserMapper weworkDepartmentUserMapper;
    @Autowired
    private DimissionWeworkUserMapper dimissionWeworkUserMapper;
    @Autowired
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Autowired
    private WeworkContactTagMapper weworkContactTagMapper;
    @Autowired
    private WeworkContactLogMapper weworkContactLogMapper;
    @Autowired
    private WeworkContactMobileMapper weworkContactMobileMapper;
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private DimissionWeworkUserCustomerMapper customerMapper;
    @Autowired
    private ChannelMapper channelMapper;
    @Autowired
    private DimissionAllocateRecordMapper dimissionAllocateRecordMapper;
    @Autowired
    private DimissionWeworkUserRoomMapper dimissionWeworkUserRoomMapper;
    @Autowired
    private WeworkChatRoomRelationMapper weworkChatRoomRelationMapper;
    @Autowired
    private DimissionWeworkUserCustomerMapper dimissionWeworkUserCustomerMapper;
    @Autowired
    private WeworkRoomJoinQuitLogMapper weworkRoomJoinQuitLogMapper;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private TransferClient transferClient;
    @Autowired
    private SettingService settingService;
    @Autowired
    private WeworkUserService weworkUserService;
    @Resource
    private NodeService nodeService;
    @Resource
    private OrgService orgService;

    @Override
    public List<DimissionWeworkUserRespDto> weworkUserList(DimissionWeworkUserListReqDto reqDto) {
        DimissionWeworkUserQueryParams queryParams;
        List dimissionWeworkUsers;
        CurrentUserInfo currentUserInfo = this.validateCurrentOperateUser();
        String corpId = currentUserInfo.getCorpId();
        Long bizId = currentUserInfo.getBizId();
        log.info("weworkUserList,params:{}, operatorId:{},bizId:{},corpId:{}", new Object[]{reqDto, currentUserInfo.getId(), bizId, corpId});
        reqDto.validateParams();
        Set managedWeworkUserIds = this.weworkUserService.queryCurManagerWeworkUserContainDel();
        if (CollectionUtils.isEmpty((Collection)managedWeworkUserIds)) {
            log.info("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u7ba1\u8f96\u7684\u4f01\u5fae\u6210\u5458");
            return Collections.emptyList();
        }
        HashSet weworkUserIdsByParams = new HashSet();
        if (CollectionUtils.isNotEmpty(reqDto.getWeworkUserIds())) {
            Map weworkUserNumAndWeworkUserIdMap = this.weworkUserService.getWeworkUserIdMapByNums(reqDto.getWeworkUserIds());
            Collection weworkUserIdByParams = weworkUserNumAndWeworkUserIdMap.values();
            weworkUserIdsByParams.addAll(weworkUserIdByParams);
        }
        if (CollectionUtils.isNotEmpty(reqDto.getDeptIds())) {
            Set subOrgIds = this.nodeService.getPosterityIds(reqDto.getDeptIds(), currentUserInfo.getBizId());
            Set deptIds = this.orgService.getDepartmentIds(subOrgIds);
            Set weworkUserIdByDeptParams = this.weworkDepartmentUserMapper.selectByCorpIdAndDepartmentIds(currentUserInfo.getCorpId(), (Collection)deptIds, Boolean.valueOf(false));
            weworkUserIdsByParams.addAll(weworkUserIdByDeptParams);
        }
        if (CollectionUtils.isNotEmpty(reqDto.getWeworkUserIds()) || CollectionUtils.isNotEmpty(reqDto.getDeptIds())) {
            managedWeworkUserIds.retainAll(weworkUserIdsByParams);
            if (CollectionUtils.isEmpty((Collection)managedWeworkUserIds)) {
                log.info("\u7ba1\u8f96\u7684\u548c\u524d\u7aef\u4f20\u5165\u7684\u4f01\u5fae\u6210\u5458\u6ca1\u6709\u4ea4\u96c6");
                return Collections.emptyList();
            }
        }
        if (CollectionUtils.isEmpty((Collection)(dimissionWeworkUsers = this.dimissionWeworkUserMapper.selectByQueryParams(queryParams = this.buildQueryParamsObj(managedWeworkUserIds, reqDto, corpId))))) {
            log.info("\u6839\u636equeryParams:{}\u672a\u83b7\u53d6\u5230\u8bb0\u5f55", (Object)queryParams);
            return Collections.emptyList();
        }
        int count = this.dimissionWeworkUserMapper.getCountByQueryParams(queryParams);
        reqDto.getPageDto().setCount(Integer.valueOf(count));
        Set pagedWeworkUserNums = dimissionWeworkUsers.stream().map(DimissionWeworkUser::getWeworkUserNum).collect(Collectors.toSet());
        Collection<String> pagedWeworkUserIds = this.weworkUserMapper.selectWeworkUserNumAndIdByNums(pagedWeworkUserNums).values();
        List weworkUsers = this.weworkUserMapper.selectByWeworkUserIdsAndCorpId(pagedWeworkUserIds, corpId);
        Map<String, WeworkUser> weworkUserNum2WeworkUserMap = null;
        if (CollectionUtils.isNotEmpty((Collection)weworkUsers)) {
            weworkUserNum2WeworkUserMap = weworkUsers.stream().collect(Collectors.toMap(WeworkUser::getNum, Functions.identity()));
        }
        Map<String, List<Integer>> weworkUserId2DepartmentIdsMap = this.getWeworkUserId2DepartmentIdsMap(corpId, pagedWeworkUserIds);
        Map<Integer, WeworkDepartment> weworkDepartmentId2ObjMap = this.getWeworkDepartmentMap(corpId);
        return this.buildWeworkUserList(dimissionWeworkUsers, weworkUserNum2WeworkUserMap, weworkUserId2DepartmentIdsMap, weworkDepartmentId2ObjMap);
    }

    @Override
    public List<CustomerRespDto> waitAllocateCustomerList(CustomerReqDto reqDto) {
        CurrentUserInfo currentUserInfo = this.validateCurrentOperateUser();
        String corpId = currentUserInfo.getCorpId();
        Long bizId = currentUserInfo.getBizId();
        log.info("waitAllocateCustomerList,params:{}, operatorId:{},bizId:{},corpId:{}", new Object[]{reqDto, currentUserInfo.getId(), bizId, corpId});
        reqDto.validateParams();
        String weworkUserNum = reqDto.getWeworkUserId();
        String weworkUserId = this.weworkUserMapper.queryWeworkUserIdByNum(weworkUserNum);
        if (StringUtils.isBlank((CharSequence)weworkUserId)) {
            log.error("\u6839\u636eweworkUserNum:{}\u672a\u83b7\u53d6\u5230\u8bb0\u5f55", (Object)weworkUserNum);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "weworkUserId\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        ContactQueryParams contactQueryParams = new ContactQueryParams();
        contactQueryParams.setCorpId(corpId);
        contactQueryParams.setWeworkUserId(weworkUserId);
        contactQueryParams.setWeworkUserNum(weworkUserNum);
        HashSet contactIds = Sets.newHashSet();
        boolean isNeedReturn = this.getWeworkContactIds(contactQueryParams, reqDto.getStartTime(), reqDto.getEndTime(), reqDto.getTagIds(), reqDto.getChannelId(), reqDto.getQuery(), contactIds);
        if (isNeedReturn) {
            log.info("\u6839\u636e\u6761\u4ef6\u672a\u83b7\u53d6\u5230contactIds");
            return Collections.emptyList();
        }
        if (CollectionUtils.isNotEmpty((Collection)contactIds)) {
            contactQueryParams.setContactIds((Set)contactIds);
        }
        PageDto pageDto = reqDto.getPageDto();
        contactQueryParams.setOffset(Integer.valueOf((pageDto.getPageNum() - 1) * pageDto.getPageSize()));
        contactQueryParams.setPageSize(pageDto.getPageSize());
        contactQueryParams.setStatus(NumberUtils.INTEGER_MINUS_ONE);
        Set pagedContactIds = this.customerMapper.selectByQueryParams(contactQueryParams);
        if (CollectionUtils.isEmpty((Collection)pagedContactIds)) {
            log.info("\u6839\u636e\u67e5\u8be2\u6761\u4ef6\u672a\u83b7\u53d6\u5230\u6ee1\u8db3\u6761\u4ef6\u7684\u8bb0\u5f55");
            return Collections.emptyList();
        }
        contactQueryParams.setStartTime(null);
        contactQueryParams.setEndTime(null);
        int count = this.customerMapper.getCountByQueryParams(contactQueryParams);
        reqDto.getPageDto().setCount(Integer.valueOf(count));
        List contacts = this.weworkContactMapper.selectByCorpIdAndContactIds(corpId, (Collection)pagedContactIds);
        Map<String, WeworkContact> contactId2ObjMap = contacts.stream().collect(Collectors.toMap(WeworkContact::getContactId, Function.identity()));
        Set weworkContactIds = contacts.stream().map(WeworkContact::getContactId).collect(Collectors.toSet());
        Map contactCustomerMap = null;
        if (CollectionUtils.isNotEmpty(weworkContactIds)) {
            contactCustomerMap = this.weworkContactMapper.queryContactCustomerNum(corpId, weworkContactIds);
        }
        List contactRelations = this.weworkContactRelationMapper.selectByCorpIdAndContactIds(corpId, (Collection)pagedContactIds, weworkUserId);
        Map<String, WeworkContactRelation> contactId2RelationMap = contactRelations.stream().collect(Collectors.toMap(WeworkContactRelation::getContactId, Functions.identity()));
        List contactMobiles = this.weworkContactMobileMapper.selectByCorpIdContactIds(corpId, (Collection)pagedContactIds, weworkUserId);
        Map<String, List<String>> contactId2MobilesMap = null;
        if (CollectionUtils.isNotEmpty((Collection)contactMobiles)) {
            contactId2MobilesMap = contactMobiles.stream().collect(Collectors.groupingBy(WeworkContactMobile::getContactId, Collectors.mapping(WeworkContactMobile::getRemarkMobile, Collectors.toList())));
        }
        List contactTags = this.weworkContactTagMapper.selectByCorpIdContactIds(corpId, (Collection)pagedContactIds, weworkUserId);
        Map<String, List<String>> contactId2TagNamesMap = null;
        if (CollectionUtils.isNotEmpty((Collection)contactTags)) {
            contactId2TagNamesMap = contactTags.stream().collect(Collectors.groupingBy(WeworkContactTag::getContactId, Collectors.mapping(WeworkContactTag::getTagName, Collectors.toList())));
        }
        Map<String, Long> contactId2ChannelIdMap = null;
        Map channelId2NameMap = null;
        Set<Object> channelIds = Sets.newHashSet();
        if (Objects.isNull(reqDto.getChannelId())) {
            List weworkContactLogs = this.weworkContactLogMapper.selectByCorpIdContactIds(corpId, (Collection)pagedContactIds, weworkUserNum);
            if (CollectionUtils.isNotEmpty((Collection)weworkContactLogs)) {
                contactId2ChannelIdMap = weworkContactLogs.stream().collect(Collectors.toMap(WeworkContactLog::getContactId, WeworkContactLog::getChannelId));
                channelIds = weworkContactLogs.stream().map(WeworkContactLog::getChannelId).collect(Collectors.toSet());
            }
        } else {
            channelIds.add(contactQueryParams.getChannelId());
        }
        if (CollectionUtils.isNotEmpty((Collection)channelIds)) {
            channelId2NameMap = this.channelMapper.selectIdAndNameByIds(bizId, (Collection)channelIds);
        }
        return this.buildWaitAllocateCustomerList(pagedContactIds, contactId2ObjMap, contactId2RelationMap, contactId2MobilesMap, contactId2TagNamesMap, contactId2ChannelIdMap, channelId2NameMap, reqDto, contactCustomerMap);
    }

    @Override
    public List<CustomerRespDto> allocatedCustomerList(CustomerReqDto reqDto) {
        CurrentUserInfo currentUserInfo = this.validateCurrentOperateUser();
        String corpId = currentUserInfo.getCorpId();
        Long bizId = currentUserInfo.getBizId();
        String weworkUserNum = reqDto.getWeworkUserId();
        log.info("allocatedCustomerList,params:{}, operatorId:{},bizId:{},corpId:{}", new Object[]{reqDto, currentUserInfo.getId(), bizId, corpId});
        reqDto.validateParams();
        String weworkUserId = this.weworkUserMapper.queryWeworkUserIdByNum(weworkUserNum);
        if (StringUtils.isBlank((CharSequence)weworkUserId)) {
            log.error("\u6839\u636eweworkUserNum:{}\u672a\u83b7\u53d6\u5230\u8bb0\u5f55", (Object)weworkUserNum);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        ContactQueryParams contactQueryParams = new ContactQueryParams();
        contactQueryParams.setCorpId(corpId);
        contactQueryParams.setWeworkUserId(weworkUserId);
        contactQueryParams.setWeworkUserNum(weworkUserNum);
        Set finishTakeoverUserNums = this.dimissionWeworkUserCustomerMapper.getTakeoverUserNumsByCorpIdAndStatus(corpId, Integer.valueOf(TakeoverStatus.FINISH.getValue()));
        if (CollectionUtils.isEmpty((Collection)finishTakeoverUserNums)) {
            return Collections.emptyList();
        }
        Set finishTakeoverUserIds = this.weworkUserMapper.getWeworkUserIdsByNums((Collection)finishTakeoverUserNums);
        contactQueryParams.setTakeoverUserIds((Collection)finishTakeoverUserIds);
        HashSet contactIds = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(reqDto.getTagIds())) {
            contactQueryParams.setTagIds(reqDto.getTagIds());
            Set tagContactIds = this.weworkContactTagMapper.selectTakeoverContactIdsByQueryParams(contactQueryParams);
            if (CollectionUtils.isEmpty((Collection)tagContactIds)) {
                log.info("\u6839\u636e\u67e5\u8be2\u6761\u4ef6:{}\u67e5\u8be2weworkContactTag\u8868\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)contactQueryParams);
                return Collections.emptyList();
            }
            if (CollectionUtils.isNotEmpty((Collection)contactIds)) {
                contactIds.retainAll(tagContactIds);
            } else {
                contactIds.addAll(tagContactIds);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getQuery())) {
            contactQueryParams.setQuery(reqDto.getQuery());
            HashSet queryContactIds = Sets.newHashSet();
            if (this.isMobile(reqDto.getQuery())) {
                Set mobileContactIds = this.weworkContactMobileMapper.selectTakeoverContactIdsByQueryParams(contactQueryParams);
                if (CollectionUtils.isEmpty((Collection)mobileContactIds)) {
                    log.info("\u6839\u636e\u67e5\u8be2\u6761\u4ef6:{}\u67e5\u8be2weworkContactMobile\u8868\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)contactQueryParams);
                    return Collections.emptyList();
                }
                queryContactIds.addAll(mobileContactIds);
            } else {
                Set nicknameContactIds = this.weworkContactMapper.selectTakeoverContactIdsByQueryParams(contactQueryParams);
                if (CollectionUtils.isEmpty((Collection)nicknameContactIds)) {
                    log.info("\u6839\u636e\u67e5\u8be2\u6761\u4ef6:{}\u67e5\u8be2weworkContact\u3001weworkContactRelation\u8868\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)contactQueryParams);
                    return Collections.emptyList();
                }
                queryContactIds.addAll(nicknameContactIds);
            }
            if (CollectionUtils.isNotEmpty((Collection)contactIds)) {
                contactIds.retainAll(queryContactIds);
                if (CollectionUtils.isEmpty((Collection)contactIds)) {
                    log.info("\u6ca1\u6709\u4ea4\u96c6");
                    return Collections.emptyList();
                }
            } else {
                contactIds.addAll(queryContactIds);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)contactIds)) {
            contactQueryParams.setContactIds((Set)contactIds);
        }
        PageDto pageDto = reqDto.getPageDto();
        contactQueryParams.setOffset(Integer.valueOf((pageDto.getPageNum() - 1) * pageDto.getPageSize()));
        contactQueryParams.setPageSize(pageDto.getPageSize());
        contactQueryParams.setStatus(Integer.valueOf(TakeoverStatus.FINISH.getValue()));
        if (StringUtils.isNotBlank((CharSequence)reqDto.getTakeoverUserId())) {
            contactQueryParams.setTakeoverUserNum(reqDto.getTakeoverUserId());
            contactQueryParams.setTakeoverUserId(this.weworkUserMapper.queryWeworkUserIdByNum(reqDto.getTakeoverUserId()));
        }
        contactQueryParams.setStartTime(reqDto.getStartTime());
        contactQueryParams.setEndTime(reqDto.getEndTime());
        List dimissionWeworkUserCustomers = this.customerMapper.selectCustomerByQueryParams(contactQueryParams);
        if (CollectionUtils.isEmpty((Collection)dimissionWeworkUserCustomers)) {
            log.info("\u6839\u636e\u67e5\u8be2\u6761\u4ef6\u672a\u83b7\u53d6\u5230\u6ee1\u8db3\u6761\u4ef6\u7684\u8bb0\u5f55");
            return Collections.emptyList();
        }
        int count = this.customerMapper.getCountByQueryParams(contactQueryParams);
        reqDto.getPageDto().setCount(Integer.valueOf(count));
        Set pagedContactIds = dimissionWeworkUserCustomers.stream().map(DimissionWeworkUserCustomer::getWeworkContactId).collect(Collectors.toSet());
        List contacts = this.weworkContactMapper.selectByCorpIdAndContactIds(corpId, pagedContactIds);
        Map<String, WeworkContact> contactId2ObjMap = contacts.stream().collect(Collectors.toMap(WeworkContact::getContactId, Function.identity()));
        Set weworkContactIds = contacts.stream().map(WeworkContact::getContactId).collect(Collectors.toSet());
        Map contactCustomerMap = null;
        if (CollectionUtils.isNotEmpty(weworkContactIds)) {
            contactCustomerMap = this.weworkContactMapper.queryContactCustomerNum(corpId, weworkContactIds);
        }
        Set takeoverUserNums = dimissionWeworkUserCustomers.stream().map(DimissionWeworkUserCustomer::getTakeoverUserNum).collect(Collectors.toSet());
        takeoverUserNums.add(weworkUserNum);
        Map weworkUserNum2IdMap = this.weworkUserMapper.selectWeworkUserNumAndIdByNums(takeoverUserNums);
        Collection<String> takeoverUserIds = weworkUserNum2IdMap.values();
        List weworkUsers = this.weworkUserMapper.selectByWeworkUserIdsAndCorpId(takeoverUserIds, corpId);
        Map<String, String> weworkUserNum2NameMap = weworkUsers.stream().collect(Collectors.toMap(WeworkUser::getNum, WeworkUser::getName));
        List contactRelations = this.weworkContactRelationMapper.selectByCorpIdAndContactIdsAndWeworkUserIds(corpId, pagedContactIds, takeoverUserIds);
        Map<String, WeworkContactRelation> contactId2RelationMap = null;
        if (CollectionUtils.isNotEmpty((Collection)contactRelations)) {
            contactId2RelationMap = contactRelations.stream().collect(Collectors.toMap(it -> it.getWeworkUserId() + ":" + it.getContactId(), Functions.identity()));
        }
        List contactMobiles = this.weworkContactMobileMapper.selectByCorpIdAndContactIdsAndWeworkUserIds(corpId, pagedContactIds, takeoverUserIds);
        Map<String, List<String>> contactId2MobilesMap = null;
        if (CollectionUtils.isNotEmpty((Collection)contactMobiles)) {
            contactMobiles.forEach(contactMobile -> contactMobile.setWeworkUserAndContactId(contactMobile.getWeworkUserId() + ":" + contactMobile.getContactId()));
            contactId2MobilesMap = contactMobiles.stream().collect(Collectors.groupingBy(WeworkContactMobile::getWeworkUserAndContactId, Collectors.mapping(WeworkContactMobile::getRemarkMobile, Collectors.toList())));
        }
        List contactTags = this.weworkContactTagMapper.selectByCorpIdAndContactIdsAndWeworkUserIds(corpId, pagedContactIds, takeoverUserIds);
        Map<String, List<String>> contactId2TagNamesMap = null;
        if (CollectionUtils.isNotEmpty((Collection)contactTags)) {
            contactTags.forEach(contactTag -> contactTag.setWeworkUserAndContactId(contactTag.getWeworkUserId() + ":" + contactTag.getContactId()));
            contactId2TagNamesMap = contactTags.stream().collect(Collectors.groupingBy(WeworkContactTag::getWeworkUserAndContactId, Collectors.mapping(WeworkContactTag::getTagName, Collectors.toList())));
        }
        Map<String, List<Integer>> weworkUserId2DepartmentIdsMap = this.getWeworkUserId2DepartmentIdsMap(corpId, takeoverUserIds);
        Map<Integer, WeworkDepartment> weworkDepartmentId2ObjMap = this.getWeworkDepartmentMap(corpId);
        return this.buildAllocatedCustomerList(dimissionWeworkUserCustomers, contactId2ObjMap, contactId2RelationMap, weworkUserNum2NameMap, contactId2MobilesMap, contactId2TagNamesMap, weworkUserId2DepartmentIdsMap, weworkDepartmentId2ObjMap, weworkUserNum2IdMap, contactCustomerMap);
    }

    @Override
    public List<CustomerRespDto> allocateCustomerRecords(CustomerReqDto reqDto) {
        CurrentUserInfo currentUserInfo = this.validateCurrentOperateUser();
        String corpId = currentUserInfo.getCorpId();
        Long bizId = currentUserInfo.getBizId();
        log.info("allocateCustomerRecords,params:{}, operatorId:{},bizId:{},corpId:{}", new Object[]{reqDto, currentUserInfo.getId(), bizId, corpId});
        reqDto.baseValidate();
        Set managedWeworkUserIds = this.weworkUserService.queryCurManagerWeworkUserContainDel();
        if (CollectionUtils.isEmpty((Collection)managedWeworkUserIds)) {
            log.info("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u7ba1\u8f96\u7684\u4f01\u5fae\u6210\u5458");
            return Collections.emptyList();
        }
        Collection managedWeworkUserNums = this.weworkUserMapper.selectWeworkUserIdAndNumByWeworkUserIds(corpId, (Collection)managedWeworkUserIds).values();
        if (CollectionUtils.isEmpty(managedWeworkUserNums)) {
            log.info("\u6839\u636ecorpId\u548c\u6210\u5458userIds\u672a\u83b7\u53d6\u5230\u6210\u5458\u8bb0\u5f55\u552f\u4e00\u6807\u8bc6");
            return Collections.emptyList();
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getWeworkUserId())) {
            managedWeworkUserNums.retainAll(Sets.newHashSet((Object[])new String[]{reqDto.getWeworkUserId()}));
            if (CollectionUtils.isEmpty(managedWeworkUserNums)) {
                log.info("\u7ba1\u8f96\u7684\u6210\u5458\u548c\u524d\u7aef\u4f20\u5165\u7684\u6ca1\u6709\u4ea4\u96c6");
                return Collections.emptyList();
            }
        }
        HashSet contactIds = Sets.newHashSet();
        if (StringUtils.isNotBlank((CharSequence)reqDto.getQuery())) {
            Set weworkUserNums = this.dimissionWeworkUserMapper.selectDimissionWorkUserNumsByCorpId(corpId);
            if (CollectionUtils.isEmpty((Collection)weworkUserNums)) {
                log.info("\u5546\u6237\u8fd8\u6ca1\u6709\u79bb\u804c\u6210\u5458");
                return Collections.emptyList();
            }
            Set weworkUserIds = this.weworkUserMapper.getWeworkUserIdsByNums((Collection)weworkUserNums);
            Set nicknameContactIds = this.weworkContactMapper.selectByCorpIdAndQuery(corpId, reqDto.getQuery(), (Collection)weworkUserIds);
            if (CollectionUtils.isEmpty((Collection)nicknameContactIds)) {
                log.info("\u6839\u636e\u53c2\u6570corpId:{}, query:{}\u67e5\u8be2weworkContact\u3001weworkContactRelation\u8868\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)corpId, (Object)reqDto.getQuery());
                return Collections.emptyList();
            }
            contactIds.addAll(nicknameContactIds);
        }
        ContactQueryParams queryParams = reqDto.convert2QueryParams(contactIds);
        queryParams.setTargetType(NumberUtils.INTEGER_ONE);
        queryParams.setCorpId(corpId);
        queryParams.setWeworkUserNums(managedWeworkUserNums);
        List allocateRecords = this.dimissionAllocateRecordMapper.selectByQueryParams(queryParams);
        if (CollectionUtils.isEmpty((Collection)allocateRecords)) {
            log.info("\u6839\u636e\u6761\u4ef6params:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)queryParams);
            return Collections.emptyList();
        }
        int count = this.dimissionAllocateRecordMapper.getCountByParams(queryParams);
        reqDto.getPageDto().setCount(Integer.valueOf(count));
        Set pagedContactIds = allocateRecords.stream().map(DimissionAllocateRecord::getTargetId).collect(Collectors.toSet());
        Set weworkUserNums = allocateRecords.stream().map(DimissionAllocateRecord::getWeworkUserNum).collect(Collectors.toSet());
        Set weworkUserIds = this.weworkUserMapper.getWeworkUserIdsByNums(weworkUserNums);
        Set takeoverUserNums = allocateRecords.stream().map(DimissionAllocateRecord::getTakeoverUserNum).collect(Collectors.toSet());
        Set takeoverUserIds = this.weworkUserMapper.getWeworkUserIdsByNums(takeoverUserNums);
        List contacts = this.weworkContactMapper.selectByCorpIdAndContactIds(corpId, pagedContactIds);
        Map<String, WeworkContact> contactId2ObjMap = contacts.stream().collect(Collectors.toMap(WeworkContact::getContactId, Function.identity()));
        Set weworkContactIds = contacts.stream().map(WeworkContact::getContactId).collect(Collectors.toSet());
        Map contactCustomerMap = null;
        if (CollectionUtils.isNotEmpty(weworkContactIds)) {
            contactCustomerMap = this.weworkContactMapper.queryContactCustomerNum(corpId, weworkContactIds);
        }
        List contactRelations = this.weworkContactRelationMapper.selectByCorpIdAndContactIdsAndWeworkUserIds(corpId, pagedContactIds, (Collection)weworkUserIds);
        Map<String, WeworkContactRelation> contactId2RelationMap = null;
        if (CollectionUtils.isNotEmpty((Collection)contactRelations)) {
            contactId2RelationMap = contactRelations.stream().collect(Collectors.toMap(it -> it.getWeworkUserId() + ":" + it.getContactId(), Functions.identity()));
        }
        List contactMobiles = this.weworkContactMobileMapper.selectByCorpIdAndContactIdsAndWeworkUserIds(corpId, pagedContactIds, (Collection)weworkUserIds);
        Map<String, List<String>> contactId2MobilesMap = null;
        if (CollectionUtils.isNotEmpty((Collection)contactMobiles)) {
            contactMobiles.forEach(contactMobile -> contactMobile.setWeworkUserAndContactId(contactMobile.getWeworkUserId() + ":" + contactMobile.getContactId()));
            contactId2MobilesMap = contactMobiles.stream().collect(Collectors.groupingBy(WeworkContactMobile::getContactId, Collectors.mapping(WeworkContactMobile::getRemarkMobile, Collectors.toList())));
        }
        List contactTags = this.weworkContactTagMapper.selectByCorpIdAndContactIdsAndWeworkUserIds(corpId, pagedContactIds, (Collection)weworkUserIds);
        Map<String, List<String>> contactId2TagNamesMap = null;
        if (CollectionUtils.isNotEmpty((Collection)contactTags)) {
            contactTags.forEach(contactTag -> contactTag.setWeworkUserAndContactId(contactTag.getWeworkUserId() + ":" + contactTag.getContactId()));
            contactId2TagNamesMap = contactTags.stream().collect(Collectors.groupingBy(WeworkContactTag::getContactId, Collectors.mapping(WeworkContactTag::getTagName, Collectors.toList())));
        }
        Map<String, List<Integer>> takeoverUserId2DepartmentIdsMap = this.getWeworkUserId2DepartmentIdsMap(corpId, takeoverUserIds);
        Map<Integer, WeworkDepartment> weworkDepartmentId2ObjMap = this.getWeworkDepartmentMap(corpId);
        weworkUserIds.addAll(takeoverUserIds);
        List weworkUsers = this.weworkUserMapper.selectByWeworkUserIdsAndCorpId((Collection)weworkUserIds, corpId);
        Map<String, WeworkUser> weworkUserNum2WeworkUserMap = weworkUsers.stream().collect(Collectors.toMap(WeworkUser::getNum, Function.identity()));
        return this.buildAllocateCustomerRecordList(allocateRecords, contactId2ObjMap, contactId2RelationMap, contactId2MobilesMap, contactId2TagNamesMap, takeoverUserId2DepartmentIdsMap, weworkDepartmentId2ObjMap, weworkUserNum2WeworkUserMap, contactCustomerMap);
    }

    @Override
    public List<RoomRespDto> waitAllocateRoomList(RoomReqDto reqDto) {
        CurrentUserInfo currentUserInfo = this.validateCurrentOperateUser();
        String corpId = currentUserInfo.getCorpId();
        Long bizId = currentUserInfo.getBizId();
        log.info("waitAllocateRoomList,params:{}, operatorId:{},bizId:{},corpId:{}", new Object[]{reqDto, currentUserInfo.getId(), bizId, corpId});
        reqDto.allocateParams();
        String weworkUserId = this.weworkUserMapper.queryWeworkUserIdByNum(reqDto.getWeworkUserId());
        if (StringUtils.isBlank((CharSequence)weworkUserId)) {
            log.error("\u6839\u636eweworkUserNum:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)reqDto.getWeworkUserId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        RoomQueryParams roomQueryParams = reqDto.convert2QueryParams(corpId);
        roomQueryParams.setStatus(NumberUtils.INTEGER_ZERO);
        roomQueryParams.setBuildRoomStartTime(reqDto.getStartTime());
        roomQueryParams.setBuildRoomEndTime(reqDto.getEndTime());
        roomQueryParams.setOrderByFiled("build_room_time");
        List chatRooms = this.dimissionWeworkUserRoomMapper.selectByRoomQueryParams(roomQueryParams);
        if (CollectionUtils.isEmpty((Collection)chatRooms)) {
            log.info("\u6839\u636e\u6761\u4ef6:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)roomQueryParams);
            return Collections.emptyList();
        }
        int count = this.dimissionWeworkUserRoomMapper.getCountByQueryParams(roomQueryParams);
        reqDto.getPageDto().setCount(Integer.valueOf(count));
        Set roomIds = chatRooms.stream().map(DimissionWeworkUserRoom::getWeworkRoomId).collect(Collectors.toSet());
        Date beginOfToday = new Date(DateUtil.getTheDateBegin((Date)new Date()));
        Map roomId2MemberCountMap = this.weworkChatRoomRelationMapper.getRoomIdAndMemberCountByCorpIdAndRoomIds(corpId, roomIds);
        Map roomId2JoinCountMap = this.weworkRoomJoinQuitLogMapper.getRoomIdAndTodayJoinCountByCorpIdAndRoomIds(corpId, roomIds, beginOfToday);
        Map roomId2QuitCountMap = this.weworkRoomJoinQuitLogMapper.getRoomIdAndTodayQuitCountByCorpIdAndRoomIds(corpId, roomIds, beginOfToday);
        List weworkUsers = this.weworkUserMapper.selectByWeworkUserIdsAndCorpId((Collection)Lists.newArrayList((Object[])new String[]{weworkUserId}), corpId);
        Map<String, String> weworkUserNum2NameMap = weworkUsers.stream().collect(Collectors.toMap(WeworkUser::getNum, WeworkUser::getName));
        return this.buildWaitAllocateRoomList(chatRooms, roomId2MemberCountMap, roomId2JoinCountMap, roomId2QuitCountMap, weworkUserNum2NameMap);
    }

    @Override
    public List<RoomRespDto> allocatedRoomList(RoomReqDto reqDto) {
        CurrentUserInfo currentUserInfo = this.validateCurrentOperateUser();
        String corpId = currentUserInfo.getCorpId();
        Long bizId = currentUserInfo.getBizId();
        log.info("allocatedRoomList,params:{}, operatorId:{},bizId:{},corpId:{}", new Object[]{reqDto, currentUserInfo.getId(), bizId, corpId});
        reqDto.allocateParams();
        RoomQueryParams roomQueryParams = reqDto.convert2QueryParams(corpId);
        roomQueryParams.setStatus(NumberUtils.INTEGER_ONE);
        roomQueryParams.setAllocateStartTime(reqDto.getStartTime());
        roomQueryParams.setAllocateEndTime(reqDto.getEndTime());
        roomQueryParams.setOrderByFiled("allocate_time");
        List chatRooms = this.dimissionWeworkUserRoomMapper.selectByRoomQueryParams(roomQueryParams);
        if (CollectionUtils.isEmpty((Collection)chatRooms)) {
            log.info("\u6839\u636e\u6761\u4ef6:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)roomQueryParams);
            return Collections.emptyList();
        }
        int count = this.dimissionWeworkUserRoomMapper.getCountByQueryParams(roomQueryParams);
        reqDto.getPageDto().setCount(Integer.valueOf(count));
        Set roomIds = chatRooms.stream().map(DimissionWeworkUserRoom::getWeworkRoomId).collect(Collectors.toSet());
        Set takeoverUserNums = chatRooms.stream().map(DimissionWeworkUserRoom::getTakeoverUserNum).collect(Collectors.toSet());
        Map takeoverUserNum2IdMap = this.weworkUserMapper.selectWeworkUserNumAndIdByNums(takeoverUserNums);
        Collection<String> takeoverUserIds = takeoverUserNum2IdMap.values();
        Map roomId2MemberCountMap = this.weworkChatRoomRelationMapper.getRoomIdAndMemberCountByCorpIdAndRoomIds(corpId, roomIds);
        List weworkUsers = this.weworkUserMapper.selectByWeworkUserIdsAndCorpId(takeoverUserIds, corpId);
        Map<String, String> takeoverUserNum2NameMap = weworkUsers.stream().collect(Collectors.toMap(WeworkUser::getNum, WeworkUser::getName));
        Map<String, List<Integer>> weworkUserId2DepartmentIdsMap = this.getWeworkUserId2DepartmentIdsMap(corpId, takeoverUserIds);
        Map<Integer, WeworkDepartment> departmentId2ObjMap = this.getWeworkDepartmentMap(corpId);
        return this.buildAllocatedRoomList(chatRooms, roomId2MemberCountMap, takeoverUserNum2NameMap, weworkUserId2DepartmentIdsMap, departmentId2ObjMap, takeoverUserNum2IdMap);
    }

    @Override
    public List<RoomRespDto> allocatedRoomRecords(RoomReqDto reqDto) {
        CurrentUserInfo currentUserInfo = this.validateCurrentOperateUser();
        String corpId = currentUserInfo.getCorpId();
        Long bizId = currentUserInfo.getBizId();
        log.info("allocatedRoomList,params:{}, operatorId:{},bizId:{},corpId:{}", new Object[]{reqDto, currentUserInfo.getId(), bizId, corpId});
        reqDto.baseValidate();
        Set managedWeworkUserIds = this.weworkUserService.queryCurManagerWeworkUserContainDel();
        if (CollectionUtils.isEmpty((Collection)managedWeworkUserIds)) {
            log.info("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u7ba1\u8f96\u7684\u4f01\u5fae\u6210\u5458");
            return Collections.emptyList();
        }
        Collection managedWeworkUserNums = this.weworkUserMapper.selectWeworkUserIdAndNumByWeworkUserIds(corpId, (Collection)managedWeworkUserIds).values();
        if (CollectionUtils.isEmpty(managedWeworkUserNums)) {
            log.info("\u6839\u636ecorpId\u548c\u6210\u5458userIds\u672a\u83b7\u53d6\u5230\u6210\u5458\u8bb0\u5f55\u552f\u4e00\u6807\u8bc6");
            return Collections.emptyList();
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getWeworkUserId())) {
            managedWeworkUserNums.retainAll(Sets.newHashSet((Object[])new String[]{reqDto.getWeworkUserId()}));
            if (CollectionUtils.isEmpty(managedWeworkUserNums)) {
                log.info("\u7ba1\u8f96\u7684\u6210\u5458\u548c\u524d\u7aef\u4f20\u5165\u7684\u6ca1\u6709\u4ea4\u96c6");
                return Collections.emptyList();
            }
        }
        RoomQueryParams roomQueryParams = reqDto.convert2QueryParams(corpId);
        roomQueryParams.setWeworkUserNums(managedWeworkUserNums);
        List allocatedRoomRecords = this.dimissionAllocateRecordMapper.selectAllocatedRoomRecords(roomQueryParams);
        if (CollectionUtils.isEmpty((Collection)allocatedRoomRecords)) {
            log.info("\u6839\u636e\u6761\u4ef6:{}\u672a\u67e5\u8be2\u5230\u5df2\u5206\u914d\u5ba2\u6237\u7fa4\u8bb0\u5f55", (Object)roomQueryParams);
            return Collections.emptyList();
        }
        int count = this.dimissionAllocateRecordMapper.getAllocatedRoomCount(roomQueryParams);
        reqDto.getPageDto().setCount(Integer.valueOf(count));
        Set roomIds = allocatedRoomRecords.stream().map(DimissionAllocateRecord::getTargetId).collect(Collectors.toSet());
        Set takeoverUserNums = allocatedRoomRecords.stream().map(DimissionAllocateRecord::getTakeoverUserNum).collect(Collectors.toSet());
        Map takeoverUserNum2IdMap = this.weworkUserMapper.selectWeworkUserNumAndIdByNums(takeoverUserNums);
        Set weworkUserNums = allocatedRoomRecords.stream().map(DimissionAllocateRecord::getWeworkUserNum).collect(Collectors.toSet());
        Map weworkUserNum2IdMap = this.weworkUserMapper.selectWeworkUserNumAndIdByNums(weworkUserNums);
        Map roomId2MemberCountMap = this.weworkChatRoomRelationMapper.getRoomIdAndMemberCountByCorpIdAndRoomIds(corpId, roomIds);
        Map<String, List<Integer>> takeoverUserId2DepartmentIdsMap = this.getWeworkUserId2DepartmentIdsMap(corpId, takeoverUserNum2IdMap.values());
        Map<Integer, WeworkDepartment> departmentId2ObjMap = this.getWeworkDepartmentMap(corpId);
        HashSet weworkUserIds = Sets.newHashSet();
        weworkUserIds.addAll(takeoverUserNum2IdMap.values());
        weworkUserIds.addAll(weworkUserNum2IdMap.values());
        List weworkUsers = this.weworkUserMapper.selectByWeworkUserIdsAndCorpId((Collection)weworkUserIds, corpId);
        Map<String, String> weworkUserNum2NameMap = weworkUsers.stream().collect(Collectors.toMap(WeworkUser::getNum, WeworkUser::getName));
        return this.buildAllocatedRoomRecords(allocatedRoomRecords, roomId2MemberCountMap, takeoverUserId2DepartmentIdsMap, departmentId2ObjMap, weworkUserNum2NameMap, takeoverUserNum2IdMap);
    }

    @Override
    public AllocateCountRespDto getWaitAllocateCount(AllocateCountReqDto reqDto) {
        CurrentUserInfo currentUserInfo = this.validateCurrentOperateUser();
        String corpId = currentUserInfo.getCorpId();
        Long bizId = currentUserInfo.getBizId();
        log.info("getWaitAllocateCount,params:{}, operatorId:{},bizId:{},corpId:{}", new Object[]{reqDto, currentUserInfo.getId(), bizId, corpId});
        reqDto.validateParams();
        AllocateCountRespDto allocateCountRespDto = new AllocateCountRespDto();
        int customerCount = 0;
        int roomCount = 0;
        if (reqDto.getIsSelectAll().booleanValue()) {
            if (Objects.isNull(reqDto.getSelectParams())) {
                customerCount = this.dimissionWeworkUserMapper.getCustomerCountByCorpId(corpId);
                roomCount = this.dimissionWeworkUserMapper.getRoomCountByCorpId(corpId);
            } else {
                SelectParams selectParams = reqDto.getSelectParams();
                Collection<Object> weworkUserNums = Sets.newHashSet();
                HashSet weworkUserIds = Sets.newHashSet();
                if (StringUtils.isNotBlank((CharSequence)selectParams.getWeworkUserId())) {
                    weworkUserNums.add(selectParams.getWeworkUserId());
                    weworkUserIds.addAll(this.weworkUserMapper.selectWeworkUserNumAndIdByNums((Collection)weworkUserNums).values());
                }
                if (Objects.nonNull(selectParams.getWeworkDepartmentId())) {
                    Set departmentIds = this.departmentService.getChildDepartment(corpId, selectParams.getWeworkDepartmentId(), true);
                    Set departmentUserIds = this.weworkDepartmentUserMapper.selectByCorpIdAndDepartmentIds(corpId, (Collection)departmentIds, Boolean.valueOf(false));
                    if (CollectionUtils.isEmpty((Collection)departmentUserIds)) {
                        log.info("\u6839\u636ecorpId:{},departmentIds:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)corpId, (Object)departmentIds);
                        allocateCountRespDto.setCustomerCount(customerCount);
                        allocateCountRespDto.setRoomCount(roomCount);
                        return allocateCountRespDto;
                    }
                    if (CollectionUtils.isEmpty((Collection)weworkUserIds)) {
                        weworkUserIds.addAll(departmentUserIds);
                    } else {
                        weworkUserIds.retainAll(departmentUserIds);
                        if (CollectionUtils.isEmpty((Collection)weworkUserIds)) {
                            log.info("weworkUserIds\u548cdepartmentUserIds\u6ca1\u6709\u4ea4\u96c6");
                            allocateCountRespDto.setCustomerCount(customerCount);
                            allocateCountRespDto.setRoomCount(roomCount);
                            return allocateCountRespDto;
                        }
                    }
                }
                if (CollectionUtils.isNotEmpty((Collection)weworkUserIds)) {
                    weworkUserNums = this.weworkUserMapper.selectWeworkUserIdAndNumByWeworkUserIds(corpId, (Collection)weworkUserIds).values();
                }
                DimissionWeworkUserQueryParams queryParams = new DimissionWeworkUserQueryParams();
                queryParams.setCorpId(corpId);
                queryParams.setWeworkUserNums((Collection)weworkUserNums);
                queryParams.setStartTime(selectParams.getStartTime());
                queryParams.setEndTime(selectParams.getEndTime());
                customerCount = this.dimissionWeworkUserMapper.getCustomerCountByQueryParams(queryParams);
                roomCount = this.dimissionWeworkUserMapper.getRoomCountByQueryParams(queryParams);
            }
        } else {
            customerCount = this.dimissionWeworkUserMapper.getCustomerCountByCorpIdAndWeworkUserIds(corpId, reqDto.getWeworkUserIds());
            roomCount = this.dimissionWeworkUserMapper.getRoomCountByCorpIdAndWeworkUserIds(corpId, reqDto.getWeworkUserIds());
        }
        allocateCountRespDto.setCustomerCount(customerCount);
        allocateCountRespDto.setRoomCount(roomCount);
        return allocateCountRespDto;
    }

    @Override
    public AllocateResultRespDto allocateContact(AllocateContactReqDto reqDto) {
        CurrentUserInfo currentUserInfo = this.validateCurrentOperateUser();
        String corpId = currentUserInfo.getCorpId();
        Long bizId = currentUserInfo.getBizId();
        log.info("allocateContact,params:{}, operatorId:{},bizId:{},corpId:{}", new Object[]{reqDto, currentUserInfo.getId(), bizId, corpId});
        reqDto.validateParams();
        DimissionWeworkUser dimissionWeworkUser = this.dimissionWeworkUserMapper.selectByCorpIdAndWeworkUserNum(corpId, reqDto.getWeworkUserId());
        if (Objects.isNull(dimissionWeworkUser)) {
            log.error("\u6839\u636ecorpId:{},weworkUserId:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)corpId, (Object)reqDto.getWeworkUserId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u79bb\u804c\u6210\u5458\u552f\u4e00\u6807\u8bc6\u4e0d\u5408\u6cd5");
        }
        this.validateAllocateParams(reqDto.getTakeoverUserId(), corpId);
        AllocateResultRespDto allocateResultRespDto = new AllocateResultRespDto();
        Set<Object> contactIds = Sets.newHashSet();
        AtomicInteger contactSuccessCount = new AtomicInteger(0);
        AtomicInteger contactFailCount = new AtomicInteger(0);
        if (!reqDto.getIsSelectAll().booleanValue()) {
            Set weworkContactIds;
            contactIds = reqDto.getContactIds();
            if (!contactIds.equals(weworkContactIds = this.dimissionWeworkUserCustomerMapper.selectContactIdsByCorpIdWeworkUserIdAndContactIds(corpId, reqDto.getWeworkUserId(), reqDto.getContactIds()))) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.SIGN_INVALIDATE, "\u4f20\u5165\u7684\u5ba2\u6237\u5fc5\u987b\u662f\u79bb\u804c\u6210\u5458\u7684\u5ba2\u6237");
            }
        } else {
            ContactQueryParams contactQueryParams = new ContactQueryParams();
            contactQueryParams.setCorpId(corpId);
            contactQueryParams.setWeworkUserNum(reqDto.getWeworkUserId());
            contactQueryParams.setWeworkUserId(this.weworkUserMapper.queryWeworkUserIdByNum(reqDto.getWeworkUserId()));
            if (Objects.nonNull(reqDto.getSelectParams())) {
                SelectParams selectParams = reqDto.getSelectParams();
                boolean isNeedReturn = this.getWeworkContactIds(contactQueryParams, selectParams.getStartTime(), selectParams.getEndTime(), selectParams.getTagIds(), selectParams.getChannelId(), selectParams.getQuery(), contactIds);
                if (isNeedReturn) {
                    log.warn("\u6839\u636eweworkUserId:{}, selectParams:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)reqDto.getWeworkUserId(), (Object)selectParams);
                    allocateResultRespDto.setContactSuccessCount(contactSuccessCount.get());
                    allocateResultRespDto.setContactFailCount(contactFailCount.get());
                    return allocateResultRespDto;
                }
                if (CollectionUtils.isNotEmpty(contactIds)) {
                    contactQueryParams.setContactIds(contactIds);
                }
            }
            contactQueryParams.setStatus(NumberUtils.INTEGER_MINUS_ONE);
            contactIds = this.dimissionWeworkUserCustomerMapper.selectByQueryParams(contactQueryParams);
            if (CollectionUtils.isEmpty(contactIds)) {
                log.warn("\u6839\u636eweworkUserId:{}, contactQueryParams:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)reqDto.getWeworkUserId(), (Object)contactQueryParams);
                allocateResultRespDto.setContactSuccessCount(contactSuccessCount.get());
                allocateResultRespDto.setContactFailCount(contactFailCount.get());
                return allocateResultRespDto;
            }
        }
        TransferCustomerParams transferCustomerParams = new TransferCustomerParams();
        transferCustomerParams.setHandoverUserId(this.weworkUserMapper.queryWeworkUserIdByNum(reqDto.getWeworkUserId()));
        transferCustomerParams.setTakeoverUserId(this.weworkUserMapper.queryWeworkUserIdByNum(reqDto.getTakeoverUserId()));
        ArrayList dimissionAllocateRecords = Lists.newArrayList();
        AtomicInteger allocatedSuccessNum = new AtomicInteger(NumberUtils.INTEGER_ZERO);
        ArrayList ongoingTakeoverContactIds = Lists.newArrayList();
        Lists.partition((List)Lists.newArrayList(contactIds), (int)50).forEach(partitionContactIds -> {
            transferCustomerParams.setExternalUserIdList(partitionContactIds);
            try {
                TransferCustomerResp transferCustomerResp = this.transferClient.dimissionTransferCustomer(corpId, transferCustomerParams);
                log.info("dimissionTransferCustomer,transferCustomerResp:{}", (Object)transferCustomerResp);
                if (Objects.isNull(transferCustomerResp) || !NumberUtils.INTEGER_ZERO.equals(transferCustomerResp.getErrCode())) {
                    contactFailCount.addAndGet(partitionContactIds.size());
                } else {
                    List customers = transferCustomerResp.getCustomer();
                    for (TransferCustomerResp.Customer customer : customers) {
                        DimissionAllocateRecord dimissionAllocateRecord = this.buildAllocateRecord(bizId, corpId, reqDto.getWeworkUserId(), NumberUtils.INTEGER_ONE, customer.getExternalUserId(), reqDto.getTakeoverUserId(), customer.getErrCode(), currentUserInfo.getId());
                        dimissionAllocateRecords.add(dimissionAllocateRecord);
                        if (String.valueOf(NumberUtils.INTEGER_ZERO).equals(customer.getErrCode())) {
                            allocatedSuccessNum.getAndIncrement();
                            ongoingTakeoverContactIds.add(customer.getExternalUserId());
                            contactSuccessCount.addAndGet(NumberUtils.INTEGER_ONE);
                            continue;
                        }
                        contactFailCount.addAndGet(NumberUtils.INTEGER_ONE);
                    }
                }
            }
            catch (Exception e) {
                contactFailCount.addAndGet(partitionContactIds.size());
                log.error("\u79bb\u804c\u5206\u914d\u53d1\u751f\u5f02\u5e38, transferCustomerParams:{}, \u5f02\u5e38\u4fe1\u606f:", (Object)transferCustomerParams, (Object)e);
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)ongoingTakeoverContactIds)) {
            Lists.partition((List)ongoingTakeoverContactIds, (int)500).forEach(partitionContactIds -> this.dimissionWeworkUserCustomerMapper.updateByWeworkUserIdAndContactIds(corpId, reqDto.getWeworkUserId(), reqDto.getTakeoverUserId(), (Collection)ongoingTakeoverContactIds, Integer.valueOf(TakeoverStatus.WAIT_TAKEOVER.getValue()), currentUserInfo.getId()));
        }
        if (allocatedSuccessNum.get() > 0) {
            this.dimissionWeworkUserMapper.updateCustomerCountByWeworkUserId(Integer.valueOf(allocatedSuccessNum.get()), corpId, reqDto.getWeworkUserId());
        }
        if (CollectionUtils.isNotEmpty((Collection)dimissionAllocateRecords)) {
            Lists.partition((List)dimissionAllocateRecords, (int)500).forEach(partitionRecords -> this.dimissionAllocateRecordMapper.batchInsert(partitionRecords));
        }
        allocateResultRespDto.setContactFailCount(contactFailCount.get());
        allocateResultRespDto.setContactSuccessCount(contactSuccessCount.get());
        return allocateResultRespDto;
    }

    @Override
    public AllocateResultRespDto allocateRoom(AllocateRoomReqDto reqDto) {
        Set roomIds;
        CurrentUserInfo currentUserInfo = this.validateCurrentOperateUser();
        String corpId = currentUserInfo.getCorpId();
        Long bizId = currentUserInfo.getBizId();
        String weworkUserId = reqDto.getWeworkUserId();
        String takeoverUserId = reqDto.getTakeoverUserId();
        log.info("allocateRoom,params:{}, operatorId:{},bizId:{},corpId:{}", new Object[]{reqDto, currentUserInfo.getId(), bizId, corpId});
        reqDto.validateParams();
        WeworkUser takeoverUser = this.validateAllocateParams(takeoverUserId, corpId);
        Date beginOfToday = new Date(DateUtil.getTheDateBegin((Date)new Date()));
        int count = this.dimissionWeworkUserRoomMapper.getTodayAllocatedCount(corpId, weworkUserId, takeoverUserId, beginOfToday);
        log.info("\u4eca\u65e5\u5df2\u5206\u914d\u7684\u5ba2\u6237\u7fa4\u6570,weworkUserId:{}, count:{}", (Object)weworkUserId, (Object)count);
        AllocateResultRespDto allocateResultRespDto = new AllocateResultRespDto();
        AtomicInteger roomSuccessCount = new AtomicInteger(0);
        AtomicInteger roomFailCount = new AtomicInteger(0);
        if (reqDto.isSelectAll()) {
            RoomQueryParams roomQueryParams = reqDto.convert2RoomQueryParams(corpId);
            roomQueryParams.setStatus(NumberUtils.INTEGER_ZERO);
            roomIds = this.dimissionWeworkUserRoomMapper.getRoomIdsByParams(roomQueryParams);
            if (CollectionUtils.isEmpty((Collection)roomIds)) {
                log.warn("\u6839\u636eparams:{}\u672a\u83b7\u53d6\u5230\u5f85\u5206\u914d\u7684\u7fa4", (Object)roomQueryParams);
                allocateResultRespDto.setRoomFailCount(roomSuccessCount.get());
                allocateResultRespDto.setRoomSuccessCount(roomFailCount.get());
                return allocateResultRespDto;
            }
        } else {
            Set<String> frontendRoomIds = reqDto.getRoomIds();
            roomIds = this.dimissionWeworkUserRoomMapper.getRoomIdsByCorpIdWeworkUserIdAndRoomIds(corpId, weworkUserId, frontendRoomIds);
            Preconditions.checkArgument((boolean)frontendRoomIds.equals(roomIds), (Object)"\u9009\u62e9\u7684\u5f85\u5206\u914d\u7fa4\u4e0d\u5408\u6cd5");
        }
        if (count + roomIds.size() > 300) {
            log.info("\u5df2\u5206\u914d\u6570{}\u52a0\u5f85\u5206\u914d\u6570{}\u8d85\u8fc7300", (Object)count, (Object)roomIds.size());
            Preconditions.checkArgument((count + roomIds.size() <= 300 ? 1 : 0) != 0, (Object)("\u5df2\u5206\u914d\u6570" + count + "\u52a0\u5f85\u5206\u914d\u6570" + roomIds.size() + "\u8d85\u8fc7" + 300));
        }
        ArrayList allocatedSuccessRoomIds = Lists.newArrayList();
        ArrayList dimissionAllocateRecords = Lists.newArrayList();
        Lists.partition((List)Lists.newArrayList((Iterable)roomIds), (int)50).forEach(partitionRoomIds -> {
            try {
                TransferGroupChatResp transferGroupChatResp = this.transferClient.transferGroupChat(corpId, (Set)Sets.newHashSet((Iterable)partitionRoomIds), takeoverUser.getWeworkUserId());
                log.info("transferGroupChatResp:{}", (Object)transferGroupChatResp);
                List transferGroupChatFailMsgs = transferGroupChatResp.getFailedChatList();
                Map roomId2TransferObjMap = null;
                if (CollectionUtils.isEmpty((Collection)transferGroupChatFailMsgs)) {
                    roomId2TransferObjMap = transferGroupChatFailMsgs.stream().collect(Collectors.toMap(TransferGroupChatFailMsg::getChatId, Functions.identity()));
                }
                for (String roomId : partitionRoomIds) {
                    int status;
                    String errorCode = "";
                    String errorMsg = "";
                    if (MapUtils.isNotEmpty(roomId2TransferObjMap) && roomId2TransferObjMap.containsKey(roomId)) {
                        roomFailCount.addAndGet(NumberUtils.INTEGER_ONE);
                        errorCode = String.valueOf(((TransferGroupChatFailMsg)roomId2TransferObjMap.get(roomId)).getErrCode());
                        errorMsg = ((TransferGroupChatFailMsg)roomId2TransferObjMap.get(roomId)).getErrMsg();
                        status = TakeoverStatus.FAIL.getValue();
                    } else {
                        roomSuccessCount.addAndGet(NumberUtils.INTEGER_ONE);
                        allocatedSuccessRoomIds.add(roomId);
                        status = TakeoverStatus.FINISH.getValue();
                    }
                    DimissionAllocateRecord dimissionAllocateRecord = this.buildAllocateRecord(bizId, corpId, reqDto.getWeworkUserId(), NumberUtils.INTEGER_TWO, roomId, reqDto.getTakeoverUserId(), errorCode, currentUserInfo.getId());
                    dimissionAllocateRecord.setErrorMsg(errorMsg);
                    dimissionAllocateRecord.setStatus(Integer.valueOf(status));
                    dimissionAllocateRecords.add(dimissionAllocateRecord);
                }
            }
            catch (Exception ex) {
                roomFailCount.addAndGet(partitionRoomIds.size());
                log.error("\u5206\u914d\u79bb\u804c\u6210\u5458:{}\u7684\u5ba2\u6237\u7fa4\u53d1\u751f\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f", (Object)weworkUserId, (Object)ex);
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)allocatedSuccessRoomIds)) {
            this.dimissionWeworkUserRoomMapper.updateByWeworkUserIdAndRoomIds(corpId, weworkUserId, (Collection)roomIds, takeoverUserId, Integer.valueOf(TakeoverStatus.FINISH.getValue()), currentUserInfo.getId());
        }
        if (roomSuccessCount.get() > 0) {
            this.dimissionWeworkUserMapper.updateRoomCountByWeworkUserId(corpId, weworkUserId, Integer.valueOf(roomSuccessCount.get()));
        }
        if (CollectionUtils.isNotEmpty((Collection)dimissionAllocateRecords)) {
            this.dimissionAllocateRecordMapper.batchInsert((List)dimissionAllocateRecords);
        }
        allocateResultRespDto.setRoomSuccessCount(roomSuccessCount.get());
        allocateResultRespDto.setRoomFailCount(roomFailCount.get());
        return allocateResultRespDto;
    }

    @Override
    public AllocateResultRespDto allocateCustomerAndRoom(AllocateReqDto reqDto) {
        List weworkUserRooms;
        String weworkUserId;
        String weworkUserNum;
        CurrentUserInfo currentUserInfo = this.validateCurrentOperateUser();
        String corpId = currentUserInfo.getCorpId();
        Long bizId = currentUserInfo.getBizId();
        log.info("allocateCustomerAndRoom,params:{}, operatorId:{},bizId:{},corpId:{}", new Object[]{reqDto, currentUserInfo.getId(), bizId, corpId});
        reqDto.validateParams();
        String takeoverUserNum = reqDto.getTakeoverUserId();
        String takeoverUserId = this.weworkUserMapper.queryWeworkUserIdByNum(takeoverUserNum);
        if (StringUtils.isEmpty((CharSequence)takeoverUserId)) {
            log.info("\u6839\u636etakeoverUserNum:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)takeoverUserNum);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u63a5\u66ff\u8005\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        AllocateResultRespDto allocateResultRespDto = new AllocateResultRespDto();
        AtomicInteger contactSuccessCount = new AtomicInteger(0);
        AtomicInteger contactFailCount = new AtomicInteger(0);
        AtomicInteger roomSuccessCount = new AtomicInteger(0);
        AtomicInteger roomFailCount = new AtomicInteger(0);
        this.validateAllocateParams(takeoverUserNum, corpId);
        Collection<Object> weworkUserNums = null;
        if (reqDto.getIsSelectAll().booleanValue()) {
            DimissionWeworkUserQueryParams queryParams = new DimissionWeworkUserQueryParams();
            queryParams.setCorpId(corpId);
            if (Objects.nonNull(reqDto.getSelectParams())) {
                Collection weworkUserIds = Sets.newHashSet();
                SelectParams selectParams = reqDto.getSelectParams();
                if (StringUtils.isNotBlank((CharSequence)selectParams.getWeworkUserId())) {
                    weworkUserIds.add(this.weworkUserMapper.queryWeworkUserIdByNum(selectParams.getWeworkUserId()));
                }
                if (Objects.nonNull(selectParams.getWeworkDepartmentId())) {
                    Set departmentIds = this.departmentService.getChildDepartment(corpId, selectParams.getWeworkDepartmentId(), true);
                    Set departmentWeworkUserIds = this.weworkDepartmentUserMapper.selectByCorpIdAndDepartmentIds(currentUserInfo.getCorpId(), (Collection)departmentIds, Boolean.valueOf(false));
                    if (CollectionUtils.isEmpty((Collection)departmentWeworkUserIds)) {
                        log.info("\u6839\u636e\u4f01\u5fae\u90e8\u95e8ids:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)departmentIds);
                        allocateResultRespDto.setContactSuccessCount(contactSuccessCount.get());
                        allocateResultRespDto.setContactFailCount(contactFailCount.get());
                        allocateResultRespDto.setRoomSuccessCount(roomSuccessCount.get());
                        allocateResultRespDto.setRoomFailCount(roomFailCount.get());
                        return allocateResultRespDto;
                    }
                    if (CollectionUtils.isEmpty((Collection)weworkUserIds)) {
                        weworkUserIds.addAll(departmentWeworkUserIds);
                    } else if (CollectionUtils.isEmpty((Collection)(weworkUserIds = CollectionUtils.retainAll((Collection)weworkUserIds, (Collection)departmentWeworkUserIds)))) {
                        allocateResultRespDto.setContactSuccessCount(contactSuccessCount.get());
                        allocateResultRespDto.setContactFailCount(contactFailCount.get());
                        allocateResultRespDto.setRoomSuccessCount(roomSuccessCount.get());
                        allocateResultRespDto.setRoomFailCount(roomFailCount.get());
                        return allocateResultRespDto;
                    }
                }
                if (CollectionUtils.isNotEmpty((Collection)weworkUserIds)) {
                    weworkUserNums = this.weworkUserMapper.selectWeworkUserIdAndNumByWeworkUserIds(corpId, weworkUserIds).values();
                }
                queryParams.setWeworkUserNums((Collection)weworkUserNums);
                queryParams.setStartTime(selectParams.getStartTime());
                queryParams.setEndTime(selectParams.getEndTime());
            }
            weworkUserNums = this.dimissionWeworkUserMapper.selectWeworkUserIdsByParams(queryParams);
        } else {
            weworkUserNums = reqDto.getWeworkUserIds();
        }
        if (CollectionUtils.isEmpty(weworkUserNums)) {
            allocateResultRespDto.setContactSuccessCount(contactSuccessCount.get());
            allocateResultRespDto.setContactFailCount(contactFailCount.get());
            allocateResultRespDto.setRoomSuccessCount(roomSuccessCount.get());
            allocateResultRespDto.setRoomFailCount(roomFailCount.get());
            return allocateResultRespDto;
        }
        List userCustomers = this.dimissionWeworkUserCustomerMapper.selectWaitAllocateContactByCorpIdAndWeworkUserNums(corpId, weworkUserNums);
        if (CollectionUtils.isNotEmpty((Collection)userCustomers)) {
            Map<String, List<DimissionWeworkUserCustomer>> weworkUserId2CustomersMap = userCustomers.stream().collect(Collectors.groupingBy(DimissionWeworkUserCustomer::getWeworkUserNum));
            TransferCustomerParams transferCustomerParams = new TransferCustomerParams();
            transferCustomerParams.setTakeoverUserId(takeoverUserId);
            for (Map.Entry<String, List<DimissionWeworkUserCustomer>> entry : weworkUserId2CustomersMap.entrySet()) {
                weworkUserNum = entry.getKey();
                weworkUserId = this.weworkUserMapper.queryWeworkUserIdByNum(weworkUserNum);
                transferCustomerParams.setHandoverUserId(weworkUserId);
                ArrayList dimissionAllocateRecords = Lists.newArrayList();
                List<DimissionWeworkUserCustomer> weworkUserCustomers = entry.getValue();
                List contactIds = weworkUserCustomers.stream().map(DimissionWeworkUserCustomer::getWeworkContactId).collect(Collectors.toList());
                ArrayList ongoingTakeoverContactIds = Lists.newArrayList();
                AtomicInteger allocatedSuccessNum = new AtomicInteger(NumberUtils.INTEGER_ZERO);
                Lists.partition(contactIds, (int)50).forEach(partitionContactIds -> {
                    transferCustomerParams.setExternalUserIdList(partitionContactIds);
                    try {
                        TransferCustomerResp transferCustomerResp = this.transferClient.dimissionTransferCustomer(corpId, transferCustomerParams);
                        log.info("dimissionTransferCustomer,transferCustomerResp:{}", (Object)transferCustomerResp);
                        if (Objects.isNull(transferCustomerResp) || !NumberUtils.INTEGER_ZERO.equals(transferCustomerResp.getErrCode())) {
                            contactFailCount.addAndGet(partitionContactIds.size());
                        } else {
                            List customers = transferCustomerResp.getCustomer();
                            for (TransferCustomerResp.Customer customer : customers) {
                                DimissionAllocateRecord dimissionAllocateRecord = this.buildAllocateRecord(bizId, corpId, weworkUserNum, NumberUtils.INTEGER_ONE, customer.getExternalUserId(), takeoverUserNum, customer.getErrCode(), currentUserInfo.getId());
                                dimissionAllocateRecords.add(dimissionAllocateRecord);
                                if (String.valueOf(NumberUtils.INTEGER_ZERO).equals(customer.getErrCode())) {
                                    allocatedSuccessNum.getAndIncrement();
                                    ongoingTakeoverContactIds.add(customer.getExternalUserId());
                                    contactSuccessCount.addAndGet(NumberUtils.INTEGER_ONE);
                                    continue;
                                }
                                contactFailCount.addAndGet(NumberUtils.INTEGER_ONE);
                            }
                        }
                    }
                    catch (Exception e) {
                        contactFailCount.addAndGet(partitionContactIds.size());
                        log.error("\u79bb\u804c\u5206\u914d\u53d1\u751f\u5f02\u5e38, transferCustomerParams:{}, \u5f02\u5e38\u4fe1\u606f:", (Object)transferCustomerParams, (Object)e);
                    }
                });
                if (CollectionUtils.isNotEmpty((Collection)ongoingTakeoverContactIds)) {
                    Lists.partition((List)ongoingTakeoverContactIds, (int)500).forEach(partitionContactIds -> this.dimissionWeworkUserCustomerMapper.updateByWeworkUserIdAndContactIds(corpId, weworkUserNum, takeoverUserNum, (Collection)ongoingTakeoverContactIds, Integer.valueOf(TakeoverStatus.WAIT_TAKEOVER.getValue()), currentUserInfo.getId()));
                }
                if (allocatedSuccessNum.get() > 0) {
                    this.dimissionWeworkUserMapper.updateCustomerCountByWeworkUserId(Integer.valueOf(allocatedSuccessNum.get()), corpId, weworkUserNum);
                }
                if (!CollectionUtils.isNotEmpty((Collection)dimissionAllocateRecords)) continue;
                Lists.partition((List)dimissionAllocateRecords, (int)500).forEach(partitionRecords -> this.dimissionAllocateRecordMapper.batchInsert(partitionRecords));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(weworkUserRooms = this.dimissionWeworkUserRoomMapper.selectByCorpIdAndWeworkUserNums(corpId, (Collection)weworkUserNums)))) {
            Map<String, List<DimissionWeworkUserRoom>> weworkUserNum2RoomsMap = weworkUserRooms.stream().collect(Collectors.groupingBy(DimissionWeworkUserRoom::getWeworkUserNum));
            for (Map.Entry<String, List<DimissionWeworkUserCustomer>> entry : weworkUserNum2RoomsMap.entrySet()) {
                weworkUserNum = entry.getKey();
                weworkUserId = this.weworkUserMapper.queryWeworkUserIdByNum(weworkUserNum);
                List<DimissionWeworkUserCustomer> userRooms = entry.getValue();
                List roomIds = userRooms.stream().map(DimissionWeworkUserRoom::getWeworkRoomId).collect(Collectors.toList());
                ArrayList allocatedSuccessRoomIds = Lists.newArrayList();
                ArrayList dimissionAllocateRecords = Lists.newArrayList();
                Lists.partition((List)Lists.newArrayList(roomIds), (int)50).forEach(partitionRoomIds -> {
                    try {
                        TransferGroupChatResp transferGroupChatResp = this.transferClient.transferGroupChat(corpId, (Set)Sets.newHashSet((Iterable)partitionRoomIds), takeoverUserId);
                        log.info("transferGroupChatResp:{}", (Object)transferGroupChatResp);
                        List transferGroupChatFailMsgs = transferGroupChatResp.getFailedChatList();
                        Map roomId2TransferObjMap = null;
                        if (CollectionUtils.isEmpty((Collection)transferGroupChatFailMsgs)) {
                            roomId2TransferObjMap = transferGroupChatFailMsgs.stream().collect(Collectors.toMap(TransferGroupChatFailMsg::getChatId, Functions.identity()));
                        }
                        for (String roomId : partitionRoomIds) {
                            int status;
                            String errorCode = "";
                            String errorMsg = "";
                            if (MapUtils.isNotEmpty(roomId2TransferObjMap) && roomId2TransferObjMap.containsKey(roomId)) {
                                roomFailCount.addAndGet(NumberUtils.INTEGER_ONE);
                                errorCode = String.valueOf(((TransferGroupChatFailMsg)roomId2TransferObjMap.get(roomId)).getErrCode());
                                errorMsg = ((TransferGroupChatFailMsg)roomId2TransferObjMap.get(roomId)).getErrMsg();
                                status = TakeoverStatus.FAIL.getValue();
                            } else {
                                roomSuccessCount.addAndGet(NumberUtils.INTEGER_ONE);
                                allocatedSuccessRoomIds.add(roomId);
                                status = TakeoverStatus.FINISH.getValue();
                            }
                            DimissionAllocateRecord dimissionAllocateRecord = this.buildAllocateRecord(bizId, corpId, weworkUserNum, NumberUtils.INTEGER_TWO, roomId, takeoverUserNum, errorCode, currentUserInfo.getId());
                            dimissionAllocateRecord.setErrorMsg(errorMsg);
                            dimissionAllocateRecord.setStatus(Integer.valueOf(status));
                            dimissionAllocateRecords.add(dimissionAllocateRecord);
                        }
                    }
                    catch (Exception ex) {
                        roomFailCount.addAndGet(partitionRoomIds.size());
                        log.error("\u5206\u914d\u79bb\u804c\u6210\u5458:{}\u7684\u5ba2\u6237\u7fa4\u53d1\u751f\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f", (Object)weworkUserId, (Object)ex);
                    }
                });
                if (CollectionUtils.isNotEmpty((Collection)allocatedSuccessRoomIds)) {
                    this.dimissionWeworkUserRoomMapper.updateByWeworkUserIdAndRoomIds(corpId, weworkUserNum, roomIds, takeoverUserNum, Integer.valueOf(TakeoverStatus.FINISH.getValue()), currentUserInfo.getId());
                }
                if (roomSuccessCount.get() > 0) {
                    this.dimissionWeworkUserMapper.updateRoomCountByWeworkUserId(corpId, weworkUserNum, Integer.valueOf(roomSuccessCount.get()));
                }
                if (!CollectionUtils.isNotEmpty((Collection)dimissionAllocateRecords)) continue;
                this.dimissionAllocateRecordMapper.batchInsert((List)dimissionAllocateRecords);
            }
        }
        allocateResultRespDto.setContactSuccessCount(contactSuccessCount.get());
        allocateResultRespDto.setContactFailCount(contactFailCount.get());
        allocateResultRespDto.setRoomSuccessCount(roomSuccessCount.get());
        allocateResultRespDto.setRoomFailCount(roomFailCount.get());
        return allocateResultRespDto;
    }

    private CurrentUserInfo validateCurrentOperateUser() {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo), (Object)"\u5f53\u524d\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo.getBizId()), (Object)"\u5f53\u524d\u7528\u6237\u5546\u6237id\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)currentUserInfo.getCorpId()), (Object)"\u5f53\u524d\u7528\u6237\u6240\u5c5e\u4f01\u4e1aid\u4e3a\u7a7a");
        return currentUserInfo;
    }

    private DimissionWeworkUserQueryParams buildQueryParamsObj(Collection<String> weworkUserIds, DimissionWeworkUserListReqDto reqDto, String corpId) {
        DimissionWeworkUserQueryParams queryParams = new DimissionWeworkUserQueryParams();
        if (CollectionUtils.isNotEmpty(weworkUserIds)) {
            Map weworkUserId2NumMap = this.weworkUserMapper.selectWeworkUserIdAndNumByWeworkUserIds(corpId, weworkUserIds);
            queryParams.setWeworkUserNums(weworkUserId2NumMap.values());
        }
        queryParams.setStartTime(reqDto.getStartTime());
        queryParams.setEndTime(reqDto.getEndTime());
        queryParams.setCorpId(corpId);
        queryParams.setOffset(Integer.valueOf((reqDto.getPageDto().getPageNum() - 1) * reqDto.getPageDto().getPageSize()));
        queryParams.setPageSize(reqDto.getPageDto().getPageSize());
        return queryParams;
    }

    private List<DimissionWeworkUserRespDto> buildWeworkUserList(List<DimissionWeworkUser> dimissionWeworkUsers, Map<String, WeworkUser> weworkUserNum2WeworkUserMap, Map<String, List<Integer>> weworkUserId2DepartmentIdsMap, Map<Integer, WeworkDepartment> weworkDepartmentId2ObjMap) {
        Set weworkUserNums = dimissionWeworkUsers.stream().map(DimissionWeworkUser::getWeworkUserNum).collect(Collectors.toSet());
        Map weworkUserNum2IdMap = this.weworkUserMapper.selectWeworkUserNumAndIdByNums(weworkUserNums);
        ArrayList dimissionWeworkUserRespDtos = Lists.newArrayList();
        for (DimissionWeworkUser dimissionWeworkUser : dimissionWeworkUsers) {
            DimissionWeworkUserRespDto dimissionWeworkUserRespDto = new DimissionWeworkUserRespDto();
            dimissionWeworkUserRespDtos.add(dimissionWeworkUserRespDto);
            String weworkUserNum = dimissionWeworkUser.getWeworkUserNum();
            String weworkUserId = (String)weworkUserNum2IdMap.get(weworkUserNum);
            dimissionWeworkUserRespDto.setWeworkUserId(weworkUserNum);
            dimissionWeworkUserRespDto.setWaitAllocateCustomerCount(dimissionWeworkUser.getWaitAllocateCustomerCount());
            dimissionWeworkUserRespDto.setWaitAllocateRoomCount(dimissionWeworkUser.getWaitAllocateRoomCount());
            dimissionWeworkUserRespDto.setAllocatedCustomerCount(dimissionWeworkUser.getAllocatedCustomerCount());
            dimissionWeworkUserRespDto.setAllocatedRoomCount(dimissionWeworkUser.getAllocatedRoomCount());
            dimissionWeworkUserRespDto.setDimissionTime(dimissionWeworkUser.getDimissionTime());
            if (MapUtils.isNotEmpty(weworkUserNum2WeworkUserMap) && weworkUserNum2WeworkUserMap.containsKey(weworkUserNum)) {
                dimissionWeworkUserRespDto.setWeworkUserName(weworkUserNum2WeworkUserMap.get(weworkUserNum).getName());
                dimissionWeworkUserRespDto.setAvatar(weworkUserNum2WeworkUserMap.get(weworkUserNum).getAvatar());
            }
            if (!MapUtils.isNotEmpty(weworkUserId2DepartmentIdsMap) || !weworkUserId2DepartmentIdsMap.containsKey(weworkUserId)) continue;
            ArrayList nodes = Lists.newArrayList();
            dimissionWeworkUserRespDto.setNodes(nodes);
            List<Integer> departmentIds = weworkUserId2DepartmentIdsMap.get(weworkUserId);
            for (Integer departmentId : departmentIds) {
                ArrayList idAndNameDtos = Lists.newArrayList();
                this.getAllNode(idAndNameDtos, weworkDepartmentId2ObjMap, departmentId);
                Collections.reverse(idAndNameDtos);
                nodes.add(idAndNameDtos);
            }
        }
        return dimissionWeworkUserRespDtos;
    }

    private List<CustomerRespDto> buildWaitAllocateCustomerList(Set<String> contactIds, Map<String, WeworkContact> contactId2ObjMap, Map<String, WeworkContactRelation> contactId2RelationMap, Map<String, List<String>> contactId2MobilesMap, Map<String, List<String>> contactId2TagNamesMap, Map<String, Long> contactId2ChannelIdMap, Map<Long, String> channelId2NameMap, CustomerReqDto reqDto, Map<String, String> contactCustomerMap) {
        ArrayList customerRespDtos = Lists.newArrayList();
        boolean encryptMobile = this.isNeedEncryptMobile();
        for (String contactId : contactIds) {
            CustomerRespDto customerRespDto = new CustomerRespDto();
            customerRespDtos.add(customerRespDto);
            customerRespDto.setWeworkContactId(contactId);
            customerRespDto.setWeworkUserId(reqDto.getWeworkUserId());
            customerRespDto.setWeworkUserName(reqDto.getWeworkUserName());
            if (MapUtils.isNotEmpty(contactCustomerMap) && contactCustomerMap.containsKey(contactId)) {
                String customerNum = contactCustomerMap.get(contactId);
                customerRespDto.setCustomerNum(customerNum);
            }
            if (MapUtils.isNotEmpty(contactId2ObjMap) && contactId2ObjMap.containsKey(contactId)) {
                WeworkContact weworkContact = contactId2ObjMap.get(contactId);
                customerRespDto.setAvatar(weworkContact.getAvatar());
                customerRespDto.setName(weworkContact.getName());
                customerRespDto.setCorpName(weworkContact.getCorpName());
            }
            if (MapUtils.isNotEmpty(contactId2RelationMap) && contactId2RelationMap.containsKey(contactId)) {
                customerRespDto.setRemark(contactId2RelationMap.get(contactId).getRemark());
                customerRespDto.setAddTime(contactId2RelationMap.get(contactId).getAddTime());
            }
            if (MapUtils.isNotEmpty(contactId2MobilesMap) && contactId2MobilesMap.containsKey(contactId)) {
                List<String> remarkMobiles = contactId2MobilesMap.get(contactId);
                if (encryptMobile && CollectionUtils.isNotEmpty(remarkMobiles)) {
                    MobileUtils.encryptMobile(remarkMobiles);
                }
                customerRespDto.setRemarkMobiles(remarkMobiles);
            }
            if (MapUtils.isNotEmpty(contactId2TagNamesMap) && contactId2TagNamesMap.containsKey(contactId)) {
                customerRespDto.setWeworkTagNames(contactId2TagNamesMap.get(contactId));
            }
            if (!MapUtils.isNotEmpty(contactId2ChannelIdMap) || !contactId2ChannelIdMap.containsKey(contactId)) continue;
            Long channelId = contactId2ChannelIdMap.get(contactId);
            if (!MapUtils.isNotEmpty(channelId2NameMap) || !channelId2NameMap.containsKey(channelId)) continue;
            customerRespDto.setChannelName(channelId2NameMap.get(channelId));
        }
        return customerRespDtos;
    }

    private List<CustomerRespDto> buildAllocatedCustomerList(List<DimissionWeworkUserCustomer> dimissionWeworkUserCustomers, Map<String, WeworkContact> contactId2ObjMap, Map<String, WeworkContactRelation> contactId2RelationMap, Map<String, String> weworkUserNum2NameMap, Map<String, List<String>> contactId2MobilesMap, Map<String, List<String>> contactId2TagNamesMap, Map<String, List<Integer>> weworkUserId2DepartmentIdsMap, Map<Integer, WeworkDepartment> weworkDepartmentId2ObjMap, Map<String, String> weworkUserNum2IdMap, Map<String, String> contactCustomerMap) {
        ArrayList customerRespDtos = Lists.newArrayList();
        boolean encryptMobile = this.isNeedEncryptMobile();
        for (DimissionWeworkUserCustomer weworkUserCustomer : dimissionWeworkUserCustomers) {
            String contactId = weworkUserCustomer.getWeworkContactId();
            String takeoverUserNum = weworkUserCustomer.getTakeoverUserNum();
            String takeoverUserId = weworkUserNum2IdMap.get(takeoverUserNum);
            String unqKey = takeoverUserId + ":" + contactId;
            CustomerRespDto customerRespDto = new CustomerRespDto();
            customerRespDtos.add(customerRespDto);
            customerRespDto.setWeworkContactId(contactId);
            customerRespDto.setStatus(TakeoverStatus.FINISH.getValue());
            customerRespDto.setStatusDesc(TakeoverStatus.FINISH.getDesc());
            customerRespDto.setAllocateTime(weworkUserCustomer.getAllocateTime());
            if (MapUtils.isNotEmpty(contactCustomerMap) && contactCustomerMap.containsKey(contactId)) {
                String customerNum = contactCustomerMap.get(contactId);
                customerRespDto.setCustomerNum(customerNum);
            }
            if (MapUtils.isNotEmpty(contactId2ObjMap) && contactId2ObjMap.containsKey(contactId)) {
                WeworkContact weworkContact = contactId2ObjMap.get(contactId);
                customerRespDto.setAvatar(weworkContact.getAvatar());
                customerRespDto.setNickname(weworkContact.getName());
                customerRespDto.setCorpName(weworkContact.getCorpName());
            }
            if (MapUtils.isNotEmpty(contactId2RelationMap) && contactId2RelationMap.containsKey(unqKey)) {
                customerRespDto.setRemark(contactId2RelationMap.get(unqKey).getRemark());
            }
            if (MapUtils.isNotEmpty(contactId2MobilesMap) && contactId2MobilesMap.containsKey(unqKey)) {
                List<String> remarkMobiles = contactId2MobilesMap.get(unqKey);
                if (encryptMobile && CollectionUtils.isNotEmpty(remarkMobiles)) {
                    MobileUtils.encryptMobile(remarkMobiles);
                }
                customerRespDto.setRemarkMobiles(remarkMobiles);
            }
            if (MapUtils.isNotEmpty(contactId2TagNamesMap) && contactId2TagNamesMap.containsKey(unqKey)) {
                customerRespDto.setWeworkTagNames(contactId2TagNamesMap.get(unqKey));
            }
            customerRespDto.setTakeoverUserId(takeoverUserNum);
            customerRespDto.setWeworkUserId(weworkUserCustomer.getWeworkUserNum());
            if (MapUtils.isNotEmpty(weworkUserNum2NameMap) && weworkUserNum2NameMap.containsKey(takeoverUserNum)) {
                customerRespDto.setTakeoverUserName(weworkUserNum2NameMap.get(takeoverUserNum));
            }
            if (MapUtils.isNotEmpty(weworkUserNum2NameMap) && weworkUserNum2NameMap.containsKey(weworkUserCustomer.getWeworkUserNum())) {
                customerRespDto.setWeworkUserName(weworkUserNum2NameMap.get(weworkUserCustomer.getWeworkUserNum()));
            }
            if (!MapUtils.isNotEmpty(weworkUserId2DepartmentIdsMap) || !weworkUserId2DepartmentIdsMap.containsKey(takeoverUserId)) continue;
            ArrayList nodes = Lists.newArrayList();
            customerRespDto.setNodes(nodes);
            List<Integer> departmentIds = weworkUserId2DepartmentIdsMap.get(takeoverUserId);
            for (Integer departmentId : departmentIds) {
                ArrayList idAndNameDtos = Lists.newArrayList();
                this.getAllNode(idAndNameDtos, weworkDepartmentId2ObjMap, departmentId);
                Collections.reverse(idAndNameDtos);
                nodes.add(idAndNameDtos);
            }
        }
        return customerRespDtos;
    }

    private List<CustomerRespDto> buildAllocateCustomerRecordList(List<DimissionAllocateRecord> allocateRecords, Map<String, WeworkContact> contactId2ObjMap, Map<String, WeworkContactRelation> contactId2RelationMap, Map<String, List<String>> contactId2MobilesMap, Map<String, List<String>> contactId2TagNamesMap, Map<String, List<Integer>> takeoverUserId2DepartmentIdsMap, Map<Integer, WeworkDepartment> weworkDepartmentId2ObjMap, Map<String, WeworkUser> weworkUserNum2WeworkUserMap, Map<String, String> contactCustomerMap) {
        ArrayList customerRespDtos = Lists.newArrayList();
        boolean encryptMobile = this.isNeedEncryptMobile();
        for (DimissionAllocateRecord dimissionAllocateRecord : allocateRecords) {
            String weworkUserNum = dimissionAllocateRecord.getWeworkUserNum();
            String contactId = dimissionAllocateRecord.getTargetId();
            String takeoverUserNum = dimissionAllocateRecord.getTakeoverUserNum();
            String weworkUserId = weworkUserNum2WeworkUserMap.get(weworkUserNum).getWeworkUserId();
            String takeoverUserId = weworkUserNum2WeworkUserMap.get(takeoverUserNum).getWeworkUserId();
            String weworkUserAndContactId = weworkUserId + ":" + contactId;
            CustomerRespDto customerRespDto = new CustomerRespDto();
            customerRespDtos.add(customerRespDto);
            customerRespDto.setAllocateTime(dimissionAllocateRecord.getAllocateTime());
            customerRespDto.setWeworkContactId(contactId);
            if (MapUtils.isNotEmpty(contactCustomerMap) && contactCustomerMap.containsKey(contactId)) {
                String customerNum = contactCustomerMap.get(contactId);
                customerRespDto.setCustomerNum(customerNum);
            }
            if (MapUtils.isNotEmpty(contactId2ObjMap) && contactId2ObjMap.containsKey(contactId)) {
                customerRespDto.setAvatar(contactId2ObjMap.get(contactId).getAvatar());
                customerRespDto.setNickname(contactId2ObjMap.get(contactId).getName());
                customerRespDto.setCorpName(contactId2ObjMap.get(contactId).getCorpName());
            }
            if (MapUtils.isNotEmpty(contactId2RelationMap) && contactId2RelationMap.containsKey(weworkUserAndContactId)) {
                customerRespDto.setRemark(contactId2RelationMap.get(weworkUserAndContactId).getRemark());
            }
            if (MapUtils.isNotEmpty(contactId2MobilesMap) && contactId2MobilesMap.containsKey(weworkUserAndContactId)) {
                List<String> remarkMobiles = contactId2MobilesMap.get(weworkUserAndContactId);
                if (encryptMobile && CollectionUtils.isNotEmpty(remarkMobiles)) {
                    MobileUtils.encryptMobile(remarkMobiles);
                }
                customerRespDto.setRemarkMobiles(remarkMobiles);
                customerRespDto.setRemarkMobiles(contactId2MobilesMap.get(weworkUserAndContactId));
            }
            if (MapUtils.isNotEmpty(contactId2TagNamesMap) && contactId2TagNamesMap.containsKey(weworkUserAndContactId)) {
                customerRespDto.setWeworkTagNames(contactId2TagNamesMap.get(weworkUserAndContactId));
            }
            customerRespDto.setTakeoverUserId(takeoverUserNum);
            customerRespDto.setWeworkUserId(weworkUserNum);
            customerRespDto.setWeworkUserName(weworkUserNum2WeworkUserMap.get(weworkUserNum).getName());
            customerRespDto.setTakeoverUserName(weworkUserNum2WeworkUserMap.get(takeoverUserNum).getName());
            customerRespDto.setStatus(dimissionAllocateRecord.getStatus());
            TakeoverStatus takeoverStatus = TakeoverStatus.get((int)dimissionAllocateRecord.getStatus());
            if (Objects.nonNull(takeoverStatus)) {
                customerRespDto.setStatusDesc(takeoverStatus.getDesc());
            }
            if (!MapUtils.isNotEmpty(takeoverUserId2DepartmentIdsMap) || !takeoverUserId2DepartmentIdsMap.containsKey(takeoverUserId)) continue;
            ArrayList nodes = Lists.newArrayList();
            customerRespDto.setNodes(nodes);
            List<Integer> departmentIds = takeoverUserId2DepartmentIdsMap.get(takeoverUserId);
            for (Integer departmentId : departmentIds) {
                ArrayList idAndNameDtos = Lists.newArrayList();
                this.getAllNode(idAndNameDtos, weworkDepartmentId2ObjMap, departmentId);
                Collections.reverse(idAndNameDtos);
                nodes.add(idAndNameDtos);
            }
        }
        return customerRespDtos;
    }

    private List<RoomRespDto> buildWaitAllocateRoomList(List<DimissionWeworkUserRoom> chatRooms, Map<String, Integer> roomId2MemberCountMap, Map<String, Integer> roomId2JoinCountMap, Map<String, Integer> roomId2QuitCountMap, Map<String, String> weworkUserNum2NameMap) {
        ArrayList roomRespDtos = Lists.newArrayList();
        for (DimissionWeworkUserRoom room : chatRooms) {
            RoomRespDto roomRespDto = new RoomRespDto();
            roomRespDtos.add(roomRespDto);
            roomRespDto.setRoomId(room.getWeworkRoomId());
            roomRespDto.setName(room.getName());
            roomRespDto.setOwner(room.getWeworkUserNum());
            if (MapUtils.isNotEmpty(weworkUserNum2NameMap)) {
                roomRespDto.setOwnerName(weworkUserNum2NameMap.get(room.getWeworkUserNum()));
            }
            if (MapUtils.isNotEmpty(roomId2MemberCountMap)) {
                roomRespDto.setMemberCount(roomId2MemberCountMap.get(room.getWeworkRoomId()));
            } else {
                roomRespDto.setMemberCount(NumberUtils.INTEGER_ZERO);
            }
            if (MapUtils.isNotEmpty(roomId2JoinCountMap)) {
                roomRespDto.setJoinRoomCount(roomId2JoinCountMap.get(room.getWeworkRoomId()));
            } else {
                roomRespDto.setJoinRoomCount(NumberUtils.INTEGER_ZERO);
            }
            if (MapUtils.isNotEmpty(roomId2QuitCountMap)) {
                roomRespDto.setQuitRoomCount(roomId2QuitCountMap.get(room.getWeworkRoomId()));
            } else {
                roomRespDto.setQuitRoomCount(NumberUtils.INTEGER_ZERO);
            }
            roomRespDto.setBuildRoomTime(room.getBuildRoomTime());
            roomRespDto.setStatus(room.getRoomStatus());
            if (!Objects.nonNull(RoomStatus.get((int)room.getRoomStatus()))) continue;
            roomRespDto.setStatusStr(RoomStatus.get((int)room.getRoomStatus()).getDesc());
        }
        return roomRespDtos;
    }

    private List<RoomRespDto> buildAllocatedRoomList(List<DimissionWeworkUserRoom> chatRooms, Map<String, Integer> roomId2MemberCountMap, Map<String, String> takeoverUserNum2NameMap, Map<String, List<Integer>> weworkUserId2DepartmentIdsMap, Map<Integer, WeworkDepartment> departmentId2ObjMap, Map<String, String> takeoverUserNum2IdMap) {
        ArrayList roomRespDtos = Lists.newArrayList();
        for (DimissionWeworkUserRoom room : chatRooms) {
            RoomRespDto roomRespDto = new RoomRespDto();
            roomRespDtos.add(roomRespDto);
            roomRespDto.setRoomId(room.getWeworkRoomId());
            roomRespDto.setName(room.getName());
            roomRespDto.setTakeoverUserId(room.getTakeoverUserNum());
            if (MapUtils.isNotEmpty(takeoverUserNum2NameMap)) {
                roomRespDto.setTakeoverUserName(takeoverUserNum2NameMap.get(room.getTakeoverUserNum()));
            }
            if (MapUtils.isNotEmpty(roomId2MemberCountMap)) {
                roomRespDto.setMemberCount(roomId2MemberCountMap.get(room.getWeworkRoomId()));
            }
            roomRespDto.setAllocateTime(room.getAllocateTime());
            String takeoverUserId = takeoverUserNum2IdMap.get(room.getTakeoverUserNum());
            if (!MapUtils.isNotEmpty(weworkUserId2DepartmentIdsMap) || !weworkUserId2DepartmentIdsMap.containsKey(takeoverUserId)) continue;
            ArrayList nodes = Lists.newArrayList();
            roomRespDto.setNodes(nodes);
            List<Integer> departmentIds = weworkUserId2DepartmentIdsMap.get(takeoverUserId);
            for (Integer departmentId : departmentIds) {
                ArrayList idAndNameDtos = Lists.newArrayList();
                this.getAllNode(idAndNameDtos, departmentId2ObjMap, departmentId);
                Collections.reverse(idAndNameDtos);
                nodes.add(idAndNameDtos);
            }
        }
        return roomRespDtos;
    }

    private List<RoomRespDto> buildAllocatedRoomRecords(List<DimissionAllocateRecord> allocatedRoomRecords, Map<String, Integer> roomId2MemberCountMap, Map<String, List<Integer>> takeoverUserId2DepartmentIdsMap, Map<Integer, WeworkDepartment> departmentId2ObjMap, Map<String, String> weworkUserId2NameMap, Map<String, String> takeoverUserNum2IdMap) {
        ArrayList roomRespDtos = Lists.newArrayList();
        for (DimissionAllocateRecord allocateRecord : allocatedRoomRecords) {
            RoomRespDto roomRespDto = new RoomRespDto();
            roomRespDtos.add(roomRespDto);
            roomRespDto.setRoomId(allocateRecord.getTargetId());
            roomRespDto.setName(allocateRecord.getRoomName());
            roomRespDto.setOwner(allocateRecord.getWeworkUserNum());
            roomRespDto.setTakeoverUserId(allocateRecord.getTakeoverUserNum());
            if (MapUtils.isNotEmpty(weworkUserId2NameMap)) {
                roomRespDto.setOwnerName(weworkUserId2NameMap.get(allocateRecord.getWeworkUserNum()));
                roomRespDto.setTakeoverUserName(weworkUserId2NameMap.get(allocateRecord.getTakeoverUserNum()));
            }
            if (MapUtils.isNotEmpty(roomId2MemberCountMap)) {
                roomRespDto.setMemberCount(roomId2MemberCountMap.get(allocateRecord.getTargetId()));
            }
            roomRespDto.setAllocateTime(allocateRecord.getAllocateTime());
            String takeoverUserId = takeoverUserNum2IdMap.get(allocateRecord.getTakeoverUserNum());
            if (!MapUtils.isNotEmpty(takeoverUserId2DepartmentIdsMap) || !takeoverUserId2DepartmentIdsMap.containsKey(takeoverUserId)) continue;
            ArrayList nodes = Lists.newArrayList();
            roomRespDto.setNodes(nodes);
            List<Integer> departmentIds = takeoverUserId2DepartmentIdsMap.get(takeoverUserId);
            for (Integer departmentId : departmentIds) {
                ArrayList idAndNameDtos = Lists.newArrayList();
                this.getAllNode(idAndNameDtos, departmentId2ObjMap, departmentId);
                Collections.reverse(idAndNameDtos);
                nodes.add(idAndNameDtos);
            }
        }
        return roomRespDtos;
    }

    private void getAllNode(List<IdAndNameDto> nodes, Map<Integer, WeworkDepartment> weworkDepartmentId2ObjMap, Integer departmentId) {
        if (MapUtils.isNotEmpty(weworkDepartmentId2ObjMap) && weworkDepartmentId2ObjMap.containsKey(departmentId)) {
            IdAndNameDto idAndNameDto = new IdAndNameDto();
            nodes.add(idAndNameDto);
            WeworkDepartment weworkDepartment = weworkDepartmentId2ObjMap.get(departmentId);
            idAndNameDto.setId(Long.valueOf(weworkDepartment.getDepartmentId().intValue()));
            idAndNameDto.setName(weworkDepartment.getName());
            this.getAllNode(nodes, weworkDepartmentId2ObjMap, weworkDepartment.getParentId());
        }
    }

    private boolean isMobile(String query) {
        if (StringUtils.isBlank((CharSequence)query)) {
            return false;
        }
        return NUM_PATTERN.matcher(query).matches();
    }

    private Map<String, List<Integer>> getWeworkUserId2DepartmentIdsMap(String corpId, Collection<String> weworkUserIds) {
        List weworkDepartmentUsers = this.weworkDepartmentUserMapper.selectByCorpIdAndWwUserIds(corpId, weworkUserIds);
        Map weworkUserId2DepartmentIdsMap = null;
        if (CollectionUtils.isNotEmpty((Collection)weworkDepartmentUsers)) {
            weworkUserId2DepartmentIdsMap = weworkDepartmentUsers.stream().collect(Collectors.groupingBy(WeworkDepartmentUser::getWeworkUserId, Collectors.mapping(WeworkDepartmentUser::getDepartmentId, Collectors.toList())));
        }
        return weworkUserId2DepartmentIdsMap;
    }

    private Map<Integer, WeworkDepartment> getWeworkDepartmentMap(String corpId) {
        List weworkDepartments = this.weworkDepartmentMapper.selectByCorpId(corpId);
        Map departmentId2ObjMap = null;
        if (CollectionUtils.isNotEmpty((Collection)weworkDepartments)) {
            departmentId2ObjMap = weworkDepartments.stream().collect(Collectors.toMap(WeworkDepartment::getDepartmentId, Functions.identity()));
        }
        return departmentId2ObjMap;
    }

    private WeworkUser validateAllocateParams(String takeoverUserNum, String corpId) {
        log.info("validateAllocateParams,corpId:{}, takeoverUserNum:{}", (Object)corpId, (Object)takeoverUserNum);
        String takeoverUserId = this.weworkUserMapper.queryWeworkUserIdByNum(takeoverUserNum);
        WeworkUser weworkUser = this.weworkUserMapper.selectByWeworkUserIdAndCorpId(takeoverUserId, corpId);
        if (Objects.isNull(weworkUser)) {
            log.error("\u6839\u636e\u63a5\u66ff\u6210\u5458userId:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)takeoverUserId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u63a5\u66ff\u6210\u5458userId\u4e0d\u5408\u6cd5");
        }
        if (NumberUtils.INTEGER_ZERO.equals(weworkUser.getIsAgentAuth()) && NumberUtils.INTEGER_ZERO.equals(weworkUser.getIsSuiteAuth())) {
            log.error("takeoverUserId:{}, isAgentAuth:{}, isSuiteAuth:{}", new Object[]{takeoverUserId, weworkUser.getIsAgentAuth(), weworkUser.getIsSuiteAuth()});
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.SIGN_INVALIDATE, "\u63a5\u66ff\u6210\u5458\u5fc5\u987b\u5728\u7b2c\u4e09\u65b9\u5e94\u7528\u6216\u81ea\u5efa\u5e94\u7528\u7684\u53ef\u89c1\u8303\u56f4\u5185");
        }
        if (!NumberUtils.INTEGER_ONE.equals(weworkUser.getStatus())) {
            log.error("takeoverUserId:{},status:{}", (Object)takeoverUserId, (Object)weworkUser.getStatus());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.SIGN_INVALIDATE, "\u63a5\u66ff\u6210\u5458\u9700\u8981\u5728\u4f01\u4e1a\u5fae\u4fe1\u6fc0\u6d3b");
        }
        return weworkUser;
    }

    private boolean getWeworkContactIds(ContactQueryParams contactQueryParams, Date startTime, Date endTime, Set<String> tagIds, String channelNum, String query, Set<String> contactIds) {
        if (Objects.nonNull(startTime) || Objects.nonNull(endTime)) {
            contactQueryParams.setStartTime(startTime);
            contactQueryParams.setEndTime(endTime);
            Set addTimeContactIds = this.weworkContactRelationMapper.selectContactIdByCustomerQueryParams(contactQueryParams);
            if (CollectionUtils.isEmpty((Collection)addTimeContactIds)) {
                log.info("\u6839\u636e\u67e5\u8be2\u6761\u4ef6:{}\u67e5\u8be2weworkContactRelation\u8868\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)contactQueryParams);
                return true;
            }
            contactIds.addAll(addTimeContactIds);
        }
        if (CollectionUtils.isNotEmpty(tagIds)) {
            contactQueryParams.setTagIds(tagIds);
            Set tagContactIds = this.weworkContactTagMapper.selectContactIdsByQueryParams(contactQueryParams);
            if (CollectionUtils.isEmpty((Collection)tagContactIds)) {
                log.info("\u6839\u636e\u67e5\u8be2\u6761\u4ef6:{}\u67e5\u8be2weworkContactTag\u8868\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)contactQueryParams);
                return true;
            }
            if (CollectionUtils.isNotEmpty(contactIds)) {
                contactIds.retainAll(tagContactIds);
                if (CollectionUtils.isEmpty(contactIds)) {
                    return true;
                }
            } else {
                contactIds.addAll(tagContactIds);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)channelNum)) {
            Channel channel = this.channelMapper.selectByNum(channelNum, LoginUtils.getCurrentUser().getBizId(), LoginUtils.getCurrentUser().getCorpId());
            Preconditions.checkArgument((boolean)Objects.nonNull(channel), (Object)"\u6e20\u9053id\u4e0d\u5408\u6cd5");
            contactQueryParams.setChannelId(channel.getId());
            Set channelContactIds = this.weworkContactLogMapper.selectContactIdsByQueryParams(contactQueryParams);
            if (CollectionUtils.isEmpty((Collection)channelContactIds)) {
                log.info("\u6839\u636e\u67e5\u8be2\u6761\u4ef6:{}\u67e5\u8be2weworkContactLog\u8868\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)contactQueryParams);
                return true;
            }
            if (CollectionUtils.isNotEmpty(contactIds)) {
                contactIds.retainAll(channelContactIds);
                if (CollectionUtils.isEmpty(contactIds)) {
                    return true;
                }
            } else {
                contactIds.addAll(channelContactIds);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)query)) {
            contactQueryParams.setQuery(query);
            HashSet queryContactIds = Sets.newHashSet();
            if (this.isMobile(query)) {
                Set mobileContactIds = this.weworkContactMobileMapper.selectContactIdsByQueryParams(contactQueryParams);
                if (CollectionUtils.isEmpty((Collection)mobileContactIds)) {
                    log.info("\u6839\u636e\u67e5\u8be2\u6761\u4ef6:{}\u67e5\u8be2weworkContactMobile\u8868\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)contactQueryParams);
                    return true;
                }
                queryContactIds.addAll(mobileContactIds);
            } else {
                Set nicknameContactIds = this.weworkContactMapper.selectContactIdsByQueryParams(contactQueryParams);
                if (CollectionUtils.isEmpty((Collection)nicknameContactIds)) {
                    log.info("\u6839\u636e\u67e5\u8be2\u6761\u4ef6:{}\u67e5\u8be2weworkContact\u3001weworkContactRelation\u8868\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)contactQueryParams);
                    return true;
                }
                queryContactIds.addAll(nicknameContactIds);
            }
            if (CollectionUtils.isNotEmpty(contactIds)) {
                contactIds.retainAll(queryContactIds);
                return CollectionUtils.isEmpty(contactIds);
            }
            contactIds.addAll(queryContactIds);
        }
        return false;
    }

    private DimissionAllocateRecord buildAllocateRecord(Long bizId, String corpId, String weworkUserNum, Integer targetType, String targetId, String takeoverUserNum, String errorCode, Long operatorId) {
        DimissionAllocateRecord dimissionAllocateRecord = new DimissionAllocateRecord();
        dimissionAllocateRecord.setBizId(bizId);
        dimissionAllocateRecord.setCorpId(corpId);
        dimissionAllocateRecord.setWeworkUserNum(weworkUserNum);
        dimissionAllocateRecord.setTargetType(targetType);
        dimissionAllocateRecord.setTargetId(targetId);
        dimissionAllocateRecord.setTakeoverUserNum(takeoverUserNum);
        if (String.valueOf(NumberUtils.INTEGER_ZERO).equals(errorCode)) {
            dimissionAllocateRecord.setStatus(Integer.valueOf(TakeoverStatus.WAIT_TAKEOVER.getValue()));
        } else {
            dimissionAllocateRecord.setStatus(NumberUtils.INTEGER_MINUS_ONE);
        }
        dimissionAllocateRecord.setErrorCode(errorCode);
        dimissionAllocateRecord.setCreateBy(operatorId);
        dimissionAllocateRecord.setCreateTime(new Date());
        dimissionAllocateRecord.setAllocateTime(new Date());
        return dimissionAllocateRecord;
    }

    private boolean isNeedEncryptMobile() {
        return this.settingService.getMobileEncrypt(LoginUtils.getCurrentUserBizId());
    }
}

