/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.tranfer.dto.request;

import com.google.common.base.Preconditions;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.dal.transfer.dto.InJobAllocateQueryParams;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;

public class InJobAllocateRecordReqDto {
    private String query;
    private String weworkUserId;
    private String takeoverUserId;
    private Date startTime;
    private Date endTime;
    private Integer status;
    private PageDto pageDto;

    public void validateParams() {
        Preconditions.checkArgument((boolean)Objects.nonNull(this.pageDto), (Object)"\u5206\u9875\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public InJobAllocateQueryParams convert2QueryParams(String corpId, Collection<String> weworkUserNums) {
        InJobAllocateQueryParams inJobAllocateQueryParams = new InJobAllocateQueryParams();
        inJobAllocateQueryParams.setCorpId(corpId);
        inJobAllocateQueryParams.setWeworkUserNums(weworkUserNums);
        inJobAllocateQueryParams.setTakeoverUserNum(this.takeoverUserId);
        inJobAllocateQueryParams.setStartTime(this.startTime);
        inJobAllocateQueryParams.setEndTime(this.endTime);
        inJobAllocateQueryParams.setStatus(this.status);
        inJobAllocateQueryParams.setOffset(Integer.valueOf((this.pageDto.getPageNum() - 1) * this.pageDto.getPageSize()));
        inJobAllocateQueryParams.setPageSize(this.pageDto.getPageSize());
        return inJobAllocateQueryParams;
    }

    public String getQuery() {
        return this.query;
    }

    public String getWeworkUserId() {
        return this.weworkUserId;
    }

    public String getTakeoverUserId() {
        return this.takeoverUserId;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Integer getStatus() {
        return this.status;
    }

    public PageDto getPageDto() {
        return this.pageDto;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setWeworkUserId(String weworkUserId) {
        this.weworkUserId = weworkUserId;
    }

    public void setTakeoverUserId(String takeoverUserId) {
        this.takeoverUserId = takeoverUserId;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setPageDto(PageDto pageDto) {
        this.pageDto = pageDto;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InJobAllocateRecordReqDto)) {
            return false;
        }
        InJobAllocateRecordReqDto other = (InJobAllocateRecordReqDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        String this$weworkUserId = this.getWeworkUserId();
        String other$weworkUserId = other.getWeworkUserId();
        if (this$weworkUserId == null ? other$weworkUserId != null : !this$weworkUserId.equals(other$weworkUserId)) {
            return false;
        }
        String this$takeoverUserId = this.getTakeoverUserId();
        String other$takeoverUserId = other.getTakeoverUserId();
        if (this$takeoverUserId == null ? other$takeoverUserId != null : !this$takeoverUserId.equals(other$takeoverUserId)) {
            return false;
        }
        Date this$startTime = this.getStartTime();
        Date other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Date this$endTime = this.getEndTime();
        Date other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        PageDto this$pageDto = this.getPageDto();
        PageDto other$pageDto = other.getPageDto();
        return !(this$pageDto == null ? other$pageDto != null : !this$pageDto.equals(other$pageDto));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InJobAllocateRecordReqDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        String $weworkUserId = this.getWeworkUserId();
        result = result * 59 + ($weworkUserId == null ? 43 : $weworkUserId.hashCode());
        String $takeoverUserId = this.getTakeoverUserId();
        result = result * 59 + ($takeoverUserId == null ? 43 : $takeoverUserId.hashCode());
        Date $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Date $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        PageDto $pageDto = this.getPageDto();
        result = result * 59 + ($pageDto == null ? 43 : $pageDto.hashCode());
        return result;
    }

    public String toString() {
        return "InJobAllocateRecordReqDto(query=" + this.getQuery() + ", weworkUserId=" + this.getWeworkUserId() + ", takeoverUserId=" + this.getTakeoverUserId() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", status=" + this.getStatus() + ", pageDto=" + this.getPageDto() + ")";
    }
}

