/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.teladdfriend.service.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.component.AliyunOss;
import com.kuaike.scrm.common.component.PojoExportExcel;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.addfriend.TelAndRemarkDto;
import com.kuaike.scrm.common.enums.TelAddFriendStatus;
import com.kuaike.scrm.common.utils.ExcelUtil;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.MobileUtils;
import com.kuaike.scrm.dal.teladdfriend.dto.TelAddFriendDetailDto;
import com.kuaike.scrm.dal.teladdfriend.entity.TelAddFriendTask;
import com.kuaike.scrm.dal.teladdfriend.mapper.TelAddFriendTaskMapper;
import com.kuaike.scrm.dal.teladdfriend.mapper.TelTaskDetailRoomMapper;
import com.kuaike.scrm.teladdfriend.dto.DownloadTelReqDto;
import com.kuaike.scrm.teladdfriend.dto.ImportResultDto;
import com.kuaike.scrm.teladdfriend.dto.TaskWeworkUserAddFriendDto;
import com.kuaike.scrm.teladdfriend.dto.TaskWeworkUserAddFriendReq;
import com.kuaike.scrm.teladdfriend.dto.TelAddFriendDetailReqDto;
import com.kuaike.scrm.teladdfriend.service.ImportFileService;
import com.kuaike.scrm.teladdfriend.service.TelAddFriendService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ImportFileServiceImpl
implements ImportFileService {
    private static final Logger log = LoggerFactory.getLogger(ImportFileServiceImpl.class);
    @Autowired
    private AliyunOss aliyunOss;
    @Autowired
    private TelAddFriendService telAddFriendService;
    @Autowired
    private TelAddFriendTaskMapper telAddFriendTaskMapper;
    @Autowired
    private TelTaskDetailRoomMapper telTaskDetailRoomMapper;
    private static final int HEADER_ROWS = 5;
    private static final int MAX_ROWS = 5000;
    private static final String HEADER_FIRST_CELL_STR = "\u624b\u673a\u53f7\uff08\u5fc5\u586b\uff09";
    private static final String HEADER_SECOND_CELL_STR = "\u5907\u6ce8\u540d";
    private static final String[] HEADERS = new String[]{"\u7535\u8bdd\u53f7\u7801", "\u4efb\u52a1\u5907\u6ce8\u540d", "\u4efb\u52a1\u5ba2\u6237\u6807\u7b7e", "\u5206\u914d\u6210\u5458", "\u6dfb\u52a0\u72b6\u6001", "\u6dfb\u52a0\u65f6\u95f4", "\u5bfc\u5165\u65f6\u95f4", "\u662f\u5426\u5165\u7fa4", "\u7fa4\u540d\u79f0"};
    private static final String IMPORT_FILE_DIR = "./importDir/telAddFriend";

    @Override
    public void downLoadExcel(DownloadTelReqDto reqDto, HttpServletResponse response) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        log.info("downLoadExcel,params:{}, operatorId:{}, corpId:{}", new Object[]{reqDto, currentUser.getId(), currentUser.getCorpId()});
        reqDto.validateParams();
        TelAddFriendTask task = this.telAddFriendTaskMapper.selectByNum(reqDto.getTaskNum());
        if (Objects.isNull(task)) {
            log.warn("\u6839\u636etaskNum:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)reqDto.getTaskNum());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4efb\u52a1\u552f\u4e00\u6807\u8bc6\u4e0d\u5408\u6cd5");
        }
        TelAddFriendDetailReqDto telAddFriendDetailReqDto = new TelAddFriendDetailReqDto();
        telAddFriendDetailReqDto.setTaskNum(reqDto.getTaskNum());
        telAddFriendDetailReqDto.setQuery(reqDto.getQuery());
        telAddFriendDetailReqDto.setStatus(reqDto.getStatus());
        telAddFriendDetailReqDto.setBeginCreateTime(reqDto.getBeginCreateTime());
        telAddFriendDetailReqDto.setEndCreateTime(reqDto.getEndCreateTime());
        telAddFriendDetailReqDto.setIsJoinRoom(reqDto.getIsJoinRoom());
        List<TelAddFriendDetailDto> detailList = this.telAddFriendService.detailList(telAddFriendDetailReqDto);
        HSSFWorkbook workbook = new HSSFWorkbook();
        String taskName = task.getTaskName();
        String sheetName = ExcelUtil.replaceSpecialChar((String)taskName, (String)"-");
        HSSFSheet sheet = workbook.createSheet(sheetName);
        String fileName = task.getTaskName() + "_\u52a0\u597d\u53cb\u8be6\u60c5.xls";
        HSSFRow row = sheet.createRow(0);
        row.setZeroHeight(false);
        row.setHeight((short)360);
        HSSFCellStyle headerCellStyle = workbook.createCellStyle();
        headerCellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        headerCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        HSSFFont headerFont = workbook.createFont();
        headerFont.setBold(true);
        headerFont.setFontHeightInPoints((short)12);
        headerCellStyle.setFont((Font)headerFont);
        for (int i = 0; i < HEADERS.length; ++i) {
            sheet.setColumnWidth(i, 6400);
            HSSFCell cell = row.createCell(i);
            cell.setCellStyle(headerCellStyle);
            HSSFRichTextString text = new HSSFRichTextString(HEADERS[i]);
            cell.setCellValue((RichTextString)text);
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
        int rowNum = 1;
        for (TelAddFriendDetailDto detail : detailList) {
            HSSFRow row1 = sheet.createRow(rowNum);
            row1.createCell(0).setCellValue(detail.getTel());
            row1.createCell(1).setCellValue(detail.getRemark());
            List tagNames = detail.getTagNames();
            if (CollectionUtils.isNotEmpty((Collection)tagNames)) {
                row1.createCell(2).setCellValue(String.join((CharSequence)"/", tagNames));
            }
            row1.createCell(3).setCellValue(detail.getWeworkUserName());
            TelAddFriendStatus telAddFriendStatus = TelAddFriendStatus.getTelAddFriendStatus((Integer)detail.getStatus());
            row1.createCell(4).setCellValue(Objects.nonNull(telAddFriendStatus) ? telAddFriendStatus.getDesc() : "");
            if (Objects.nonNull(detail.getAddTime())) {
                row1.createCell(5).setCellValue(simpleDateFormat.format(detail.getAddTime()));
            }
            row1.createCell(6).setCellValue(simpleDateFormat.format(detail.getCreateTime()));
            if (detail.getIsJoinRoom() == null || detail.getIsJoinRoom() == 0) {
                row1.createCell(7).setCellValue("\u5426");
            } else {
                row1.createCell(7).setCellValue("\u662f");
            }
            List roomNames = this.telTaskDetailRoomMapper.queryJoinRoomNames(currentUser.getCorpId(), detail.getContactId(), detail.getTaskDetailId());
            if (CollectionUtils.isNotEmpty((Collection)roomNames)) {
                row1.createCell(8).setCellValue(Joiner.on((String)", ").join((Iterable)roomNames));
            }
            ++rowNum;
        }
        try {
            response.setCharacterEncoding("UTF-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            response.setHeader("content-Type", "application/vnd.ms-excel");
            response.flushBuffer();
            workbook.write((OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            log.error("\u5199\u5165excel\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public void exportTaskWeworkUserList(TaskWeworkUserAddFriendReq params, HttpServletResponse response) {
        List<TaskWeworkUserAddFriendDto> dataList = this.telAddFriendService.weworkUserAddList(params);
        String fileName = "\u6210\u5458\u6dfb\u52a0\u8be6\u60c5.xlsx";
        try {
            PojoExportExcel.doPrint(dataList, TaskWeworkUserAddFriendDto.class, (String)"\u6210\u5458\u6dfb\u52a0\u8be6\u60c5", (HttpServletResponse)response, (String)fileName);
        }
        catch (Exception e) {
            log.error("exportTaskWeworkUserList error: ", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5bfc\u51fa\u6587\u4ef6\u51fa\u9519");
        }
    }

    @Override
    public ImportResultDto importExcelFile(InputStream inp) {
        ImportResultDto importResultDto;
        FileOutputStream outputStream = null;
        try {
            Workbook workbook = ImportFileServiceImpl.create(inp);
            importResultDto = this.parseExcel(workbook);
            File dir = new File(IMPORT_FILE_DIR);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS", Locale.getDefault());
            String fileName = IMPORT_FILE_DIR + File.separator + simpleDateFormat.format(new Date()) + "_\u624b\u673a\u53f7\u5bfc\u5165\u7ed3\u679c.xlsx";
            File file = new File(fileName);
            outputStream = new FileOutputStream(file);
            workbook.write((OutputStream)outputStream);
            ((OutputStream)outputStream).close();
            String fileUrl = this.aliyunOss.uploadFile(LoginUtils.getCurrentUser().getCorpId(), file, file.getName());
            importResultDto.setFileUrl(fileUrl);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            if (e instanceof BusinessException) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, e.getMessage());
            }
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5bfc\u5165\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        return importResultDto;
    }

    private ImportResultDto parseExcel(Workbook workbook) {
        int numberOfSheets = workbook.getNumberOfSheets();
        if (numberOfSheets != 1) {
            if (log.isWarnEnabled()) {
                log.warn("excel\u6587\u4ef6sheet\u9875\u6570\u4e3a:{}", (Object)numberOfSheets);
            }
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "excel\u6587\u4ef6\u4e2dsheet\u9875\u6570\u4e0d\u4e3a1");
        }
        Sheet sheet = workbook.getSheetAt(0);
        int physicalNumberOfRows = sheet.getPhysicalNumberOfRows();
        if (physicalNumberOfRows - 5 > 5000) {
            if (log.isWarnEnabled()) {
                log.warn("excel\u6587\u4ef6\u4e2d\u6570\u636e\u603b\u884c\u6570\u4e3a:{}", (Object)(physicalNumberOfRows - 5));
            }
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5355\u6b21\u6700\u591a\u5bfc\u51655000\u6761");
        }
        Row headerRow = sheet.getRow(4);
        Cell firstCell = headerRow.getCell(NumberUtils.INTEGER_ZERO.intValue());
        String firstCellStr = firstCell.getStringCellValue();
        if (!HEADER_FIRST_CELL_STR.equals(firstCellStr)) {
            if (log.isWarnEnabled()) {
                log.warn("\u6807\u9898\u884c\u7b2c\u4e00\u5217\u6807\u9898\u4e3a:{}", (Object)firstCellStr);
            }
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8868\u5934\u7b2c\u4e00\u5217\u4e0d\u4e3a\u3010\u624b\u673a\u53f7\uff08\u5fc5\u586b\uff09\u3011");
        }
        Cell secondCell = headerRow.getCell(NumberUtils.INTEGER_ONE.intValue());
        String secondCellStr = secondCell.getStringCellValue();
        if (!HEADER_SECOND_CELL_STR.equals(secondCellStr)) {
            if (log.isWarnEnabled()) {
                log.warn("\u6807\u9898\u884c\u7b2c\u4e8c\u5217\u6807\u9898\u4e3a:{}", (Object)secondCellStr);
            }
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8868\u5934\u7b2c\u4e8c\u5217\u4e0d\u4e3a\u3010\u5907\u6ce8\u540d\u3011");
        }
        headerRow.createCell(2).setCellValue("\u9519\u8bef\u4fe1\u606f");
        ImportResultDto importResultDto = new ImportResultDto();
        HashSet mobiles = Sets.newHashSet();
        ArrayList telAndRemarkDtos = Lists.newArrayList();
        int duplicateCount = 0;
        int invalidateCount = 0;
        int totalCount = physicalNumberOfRows - 5;
        int notExistDateRow = 0;
        int i = 0;
        int dataStartRow = 4;
        while (i < totalCount) {
            Row row;
            if (Objects.isNull(row = sheet.getRow(++dataStartRow))) {
                ++i;
                continue;
            }
            if (!this.existDate(row)) {
                ++notExistDateRow;
                ++i;
                continue;
            }
            Cell cell = row.getCell(NumberUtils.INTEGER_ZERO.intValue());
            if (Objects.isNull(cell)) {
                row.createCell(2).setCellValue("\u624b\u673a\u53f7\u672a\u586b\u5199");
                ++invalidateCount;
                ++i;
                continue;
            }
            cell.setCellType(CellType.STRING);
            String mobile = cell.getStringCellValue();
            if (StringUtils.isBlank((CharSequence)mobile)) {
                row.createCell(2).setCellValue("\u624b\u673a\u53f7\u672a\u586b\u5199");
                ++invalidateCount;
                ++i;
                continue;
            }
            if (!MobileUtils.isPhone((String)mobile)) {
                row.createCell(2).setCellValue("\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e");
                ++invalidateCount;
            } else if (mobiles.contains(mobile)) {
                ++duplicateCount;
                row.createCell(2).setCellValue("\u624b\u673a\u53f7\u91cd\u590d");
            } else {
                mobiles.add(mobile);
                TelAndRemarkDto telAndRemarkDto = new TelAndRemarkDto();
                telAndRemarkDto.setTel(mobile);
                cell = row.getCell(NumberUtils.INTEGER_ONE.intValue());
                if (Objects.nonNull(cell)) {
                    cell.setCellType(CellType.STRING);
                    String remark = cell.getStringCellValue();
                    telAndRemarkDto.setRemark(remark);
                }
                telAndRemarkDtos.add(telAndRemarkDto);
            }
            ++i;
        }
        importResultDto.setInvalidCount(invalidateCount);
        importResultDto.setDuplicateCount(duplicateCount);
        importResultDto.setTotalCount(totalCount - notExistDateRow);
        importResultDto.setTelAndRemarkDtos(telAndRemarkDtos);
        return importResultDto;
    }

    public boolean existDate(Row row) {
        if (Objects.isNull(row)) {
            return false;
        }
        Cell cell = row.getCell(NumberUtils.INTEGER_ZERO.intValue());
        Cell cell2 = row.getCell(NumberUtils.INTEGER_ONE.intValue());
        String cellValue = null;
        if (Objects.nonNull(cell)) {
            cell.setCellType(CellType.STRING);
            cellValue = cell.getStringCellValue();
        }
        String cell2Value = null;
        if (Objects.nonNull(cell2)) {
            cell2.setCellType(CellType.STRING);
            cell2Value = cell2.getStringCellValue();
        }
        if (StringUtils.isBlank(cell2Value) && StringUtils.isBlank((CharSequence)cellValue)) {
            log.info("\u5bfc\u5165\u6570\u636e\u90fd\u4e3a\u7a7a\uff1a val1:{};val2:{}", (Object)cellValue, (Object)cell2Value);
            return false;
        }
        return true;
    }

    private static Workbook create(InputStream inp) throws IOException {
        if (!inp.markSupported()) {
            inp = new PushbackInputStream(inp, 8);
        }
        return WorkbookFactory.create((InputStream)inp);
    }
}

