/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.teladdfriend.service.impl;

import cn.kinyun.wework.sdk.entity.msg.Article;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.common.utils.lang.BeanUtil;
import com.kuaike.scrm.common.dto.ChannelDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.addfriend.TelAddFriendWelcomeDto;
import com.kuaike.scrm.common.dto.addfriend.TelAndRemarkDto;
import com.kuaike.scrm.common.enums.TelAddFriendStatus;
import com.kuaike.scrm.common.enums.addfriend.AddFriendsTaskType;
import com.kuaike.scrm.common.enums.addfriend.TelAddType;
import com.kuaike.scrm.common.enums.sop.SopTaskType;
import com.kuaike.scrm.common.enums.sop.TaskRunStatusEnum;
import com.kuaike.scrm.common.perm.service.UserRoleCommonService;
import com.kuaike.scrm.common.service.ScrmContactService;
import com.kuaike.scrm.common.service.SopTaskStatusService;
import com.kuaike.scrm.common.service.dto.req.ModMobileSyncReq;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.channel.mapper.ChannelMapper;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.teladdfriend.dto.ApplyDetailDto;
import com.kuaike.scrm.dal.teladdfriend.dto.DetailListReqDto;
import com.kuaike.scrm.dal.teladdfriend.dto.ListReqDto;
import com.kuaike.scrm.dal.teladdfriend.dto.TaskMobileDto;
import com.kuaike.scrm.dal.teladdfriend.dto.TelAddFriendDetailDto;
import com.kuaike.scrm.dal.teladdfriend.dto.TelAddFriendId2StatusCount;
import com.kuaike.scrm.dal.teladdfriend.dto.WeworkUserNameDto;
import com.kuaike.scrm.dal.teladdfriend.dto.WeworkUserStatusDto;
import com.kuaike.scrm.dal.teladdfriend.entity.TelAddFriendTask;
import com.kuaike.scrm.dal.teladdfriend.entity.TelAddFriendTaskDetail;
import com.kuaike.scrm.dal.teladdfriend.mapper.TelAddFriendTaskDetailMapper;
import com.kuaike.scrm.dal.teladdfriend.mapper.TelAddFriendTaskMapper;
import com.kuaike.scrm.dal.teladdfriend.mapper.TelTaskDetailRoomMapper;
import com.kuaike.scrm.dal.wework.dto.TelContactRelation;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkChatRoomRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.dal.weworktag.WeworkTagDto;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkTagMapper;
import com.kuaike.scrm.remind.service.RemindService;
import com.kuaike.scrm.teladdfriend.dto.MobileDto;
import com.kuaike.scrm.teladdfriend.dto.RemindToAddFriendReqDto;
import com.kuaike.scrm.teladdfriend.dto.TaskBaseDto;
import com.kuaike.scrm.teladdfriend.dto.TaskDetailDto;
import com.kuaike.scrm.teladdfriend.dto.TaskMobileReqDto;
import com.kuaike.scrm.teladdfriend.dto.TaskMobileRespDto;
import com.kuaike.scrm.teladdfriend.dto.TaskSimpleInfoReqDto;
import com.kuaike.scrm.teladdfriend.dto.TaskSimpleInfoRespDto;
import com.kuaike.scrm.teladdfriend.dto.TaskStatisticDto;
import com.kuaike.scrm.teladdfriend.dto.TaskWeworkUserAddFriendDto;
import com.kuaike.scrm.teladdfriend.dto.TaskWeworkUserAddFriendReq;
import com.kuaike.scrm.teladdfriend.dto.TelAddFriendAddReqDto;
import com.kuaike.scrm.teladdfriend.dto.TelAddFriendApplyDto;
import com.kuaike.scrm.teladdfriend.dto.TelAddFriendDetailReqDto;
import com.kuaike.scrm.teladdfriend.dto.TelAddFriendListReqDto;
import com.kuaike.scrm.teladdfriend.dto.TelAddFriendListRespDto;
import com.kuaike.scrm.teladdfriend.service.TelAddFriendService;
import com.kuaike.scrm.wework.contact.dto.ModifyRemarkDto;
import com.kuaike.scrm.wework.contact.dto.ModifyTagDto;
import com.kuaike.scrm.wework.contact.service.ContactOpService;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TelAddFriendServiceImpl
implements TelAddFriendService {
    private static final Logger log = LoggerFactory.getLogger(TelAddFriendServiceImpl.class);
    @Autowired
    private TelAddFriendTaskMapper telAddFriendTaskMapper;
    @Autowired
    private TelAddFriendTaskDetailMapper telAddFriendTaskDetailMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private IdGen idGen;
    @Autowired
    private WeworkTagMapper weworkTagMapper;
    @Autowired
    private UserRoleCommonService userRoleCommonService;
    @Autowired
    private ContactOpService contactOpService;
    @Autowired
    private RemindService remindService;
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private ChannelMapper channelMapper;
    @Autowired
    private WeworkChatRoomRelationMapper weworkChatRoomRelationMapper;
    @Autowired
    private TelTaskDetailRoomMapper telTaskDetailRoomMapper;
    @Resource
    private ScrmContactService scrmContactService;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}${frontend.remind.url}")
    private String remindUrl;
    private static final String REMIND_CONTENT = "\u7ba1\u7406\u5458{0}\u4e3a\u60a8\u5206\u914d\u4e86{1}\u4e2a\u5ba2\u6237\uff0c>>\u5feb\u53bb\u6dfb\u52a0";
    private static final String PIC_URL = "http://cdn.kinyun.cn/tool/add-friend-bg.png";
    @Autowired
    private SopTaskStatusService sopTaskStatusService;

    @Override
    public List<TaskMobileRespDto> taskMobileList(TaskMobileReqDto reqDto) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        log.info("taskMobileList, params:{}, operatorId:{}, corpId:{}", new Object[]{reqDto, currentUser.getId(), currentUser.getCorpId()});
        reqDto.validateParams();
        TaskMobileDto taskMobileDto = reqDto.convert2TaskMobileDto();
        taskMobileDto.setBizId(currentUser.getBizId());
        List details = this.telAddFriendTaskDetailMapper.selectByParams(taskMobileDto);
        if (CollectionUtils.isEmpty((Collection)details)) {
            log.info("\u6839\u636e\u67e5\u8be2\u6761\u4ef6:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)taskMobileDto);
            return Collections.emptyList();
        }
        int count = this.telAddFriendTaskDetailMapper.getWeworkUserMobileCount(reqDto.getTaskNum(), reqDto.getWeworkUserNum(), reqDto.getStatus());
        reqDto.getPageDto().setCount(Integer.valueOf(count));
        ArrayList taskMobileRespDtos = Lists.newArrayListWithCapacity((int)details.size());
        for (TelAddFriendTaskDetail detail : details) {
            TaskMobileRespDto taskMobileRespDto = new TaskMobileRespDto();
            taskMobileRespDtos.add(taskMobileRespDto);
            taskMobileRespDto.setDetailNum(detail.getNum());
            taskMobileRespDto.setTel(detail.getTel());
            taskMobileRespDto.setStatus(detail.getStatus());
            TelAddFriendStatus telAddFriendStatus = TelAddFriendStatus.getTelAddFriendStatus((Integer)detail.getStatus());
            taskMobileRespDto.setStatusDesc(telAddFriendStatus.getDesc());
        }
        return taskMobileRespDtos;
    }

    @Override
    public List<TelAddFriendDetailDto> detailList(TelAddFriendDetailReqDto reqDto) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        log.info("tel add friend detailList:{}, operatorId:{}, corpId:{}", new Object[]{reqDto, currentUser.getId(), currentUser.getCorpId()});
        Long bizId = currentUser.getBizId();
        DetailListReqDto req = (DetailListReqDto)BeanUtil.convert((Object)reqDto, DetailListReqDto.class, (String[])new String[0]);
        req.setCorpId(currentUser.getCorpId());
        req.setManageUserIds(this.userRoleCommonService.getManageUserIds());
        List detailList = this.telAddFriendTaskDetailMapper.detailList(req);
        if (CollectionUtils.isEmpty((Collection)detailList)) {
            log.info("\u6839\u636e\u6761\u4ef6:{}\u672a\u67e5\u5904\u5230\u8bb0\u5f55", (Object)req);
            return Collections.emptyList();
        }
        if (Objects.nonNull(req.getPageDto())) {
            Integer count = this.telAddFriendTaskDetailMapper.detailListCount(req);
            req.getPageDto().setCount(count);
        }
        HashSet tagIds = Sets.newHashSet();
        for (TelAddFriendDetailDto detailDto : detailList) {
            if (!StringUtils.isNotEmpty((CharSequence)detailDto.getTagIds())) continue;
            List tags = Splitter.on((String)",").omitEmptyStrings().splitToList((CharSequence)detailDto.getTagIds());
            tagIds.addAll(tags);
            detailDto.setTagIdList(tags);
        }
        Map tagMap = null;
        if (CollectionUtils.isNotEmpty((Collection)tagIds)) {
            tagMap = this.weworkTagMapper.selectTagIdAndNameByCorpIdAndTagIds(currentUser.getCorpId(), (Collection)tagIds);
        }
        Set taskNums = detailList.stream().map(TelAddFriendDetailDto::getTaskNum).collect(Collectors.toSet());
        Map taskChannelMap = this.telAddFriendTaskMapper.selectChannelsByNums(taskNums);
        HashSet channelNums = new HashSet();
        for (String channelNumStr : taskChannelMap.values()) {
            if (!StringUtils.isNotEmpty((CharSequence)channelNumStr)) continue;
            channelNums.addAll(Lists.newArrayList((Object[])channelNumStr.split(",")));
        }
        Map channelMap = this.channelMapper.selectNameByNums(bizId, channelNums);
        for (TelAddFriendDetailDto detailDto : detailList) {
            String channelStr;
            TelAddType telAddType;
            TelAddFriendStatus telAddFriendStatus = TelAddFriendStatus.getTelAddFriendStatus((Integer)detailDto.getStatus());
            if (Objects.nonNull(telAddFriendStatus)) {
                detailDto.setStatusDesc(telAddFriendStatus.getDesc());
            }
            if (Objects.nonNull(telAddType = TelAddType.get((int)detailDto.getAddType()))) {
                detailDto.setAddTypeDesc(telAddType.getDesc());
            }
            if (CollectionUtils.isNotEmpty((Collection)detailDto.getTagIdList())) {
                ArrayList tagNames = Lists.newArrayList();
                for (String tagId : detailDto.getTagIdList()) {
                    if (!MapUtils.isNotEmpty((Map)tagMap) || !tagMap.containsKey(tagId)) continue;
                    tagNames.add(tagMap.get(tagId));
                }
                detailDto.setTagNames((List)tagNames);
            }
            if (detailDto.getIsJoinRoom() == null) {
                detailDto.setIsJoinRoom(Integer.valueOf(0));
            }
            if (StringUtils.isNotEmpty((CharSequence)(channelStr = (String)taskChannelMap.get(detailDto.getTaskNum())))) {
                ArrayList channels = Lists.newArrayList((Object[])channelStr.split(","));
                ArrayList channelList = Lists.newArrayList();
                for (String channel : channels) {
                    channelList.add(channelMap.get(channel));
                }
                detailDto.setChannelList((List)channelList);
            }
            List roomNames = this.telTaskDetailRoomMapper.queryJoinRoomNames(currentUser.getCorpId(), detailDto.getContactId(), detailDto.getTaskDetailId());
            detailDto.setJoinRoomNames(roomNames);
        }
        return detailList;
    }

    @Override
    public List<TelAddFriendListRespDto> taskList(TelAddFriendListReqDto reqDto) {
        log.info("tel add friend taskList:{}", (Object)reqDto);
        reqDto.validate();
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Long bizId = currentUser.getBizId();
        ListReqDto req = (ListReqDto)BeanUtil.convert((Object)reqDto, ListReqDto.class, (String[])new String[0]);
        req.setTaskType(Integer.valueOf(AddFriendsTaskType.NORMAL_ADD.getValue()));
        req.setCorpId(currentUser.getCorpId());
        req.setManageUserIds(this.userRoleCommonService.getManageUserIds());
        List taskList = this.telAddFriendTaskMapper.list(req);
        if (CollectionUtils.isEmpty((Collection)taskList)) {
            log.info("\u6839\u636ereq:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)req);
            return Collections.emptyList();
        }
        Integer count = this.telAddFriendTaskMapper.listCount(req);
        req.getPageDto().setCount(count);
        Set userIds = taskList.stream().map(TelAddFriendTask::getCreateBy).collect(Collectors.toSet());
        Map nameMap = this.userMapper.selectUserIdAndNameByIds(currentUser.getBizId(), currentUser.getCorpId(), userIds);
        List taskNums = taskList.stream().map(TelAddFriendTask::getNum).collect(Collectors.toList());
        Map statusCountMap = this.telAddFriendTaskDetailMapper.queryStatusByTaskNums(taskNums).stream().collect(Collectors.toMap(TelAddFriendId2StatusCount::getTaskNum, Function.identity()));
        Map weworkUserNameMap = this.telAddFriendTaskDetailMapper.queryWeworkUserNameByTaskNums(taskNums, currentUser.getCorpId()).stream().collect(Collectors.groupingBy(WeworkUserNameDto::getTaskNum, Collectors.mapping(WeworkUserNameDto::getWeworkUserName, Collectors.toList())));
        ArrayList result = Lists.newArrayListWithExpectedSize((int)taskList.size());
        for (TelAddFriendTask task : taskList) {
            TelAddFriendListRespDto dto = new TelAddFriendListRespDto();
            dto.setCreateTime(task.getCreateTime());
            dto.setTaskNum(task.getNum());
            dto.setImportTelCount(task.getImportCount());
            dto.setTagList(this.buildTagList(task.getTagIds(), currentUser.getCorpId()));
            dto.setChannelList(this.buildChannelList(bizId, task.getChannelNums()));
            dto.setCreateName((String)nameMap.get(task.getCreateBy()));
            dto.setTaskName(task.getTaskName());
            dto.setDeadline(task.getDeadline());
            dto.setFileUrl(task.getFileUrl());
            dto.setWeworkUserNameList(weworkUserNameMap.get(task.getNum()));
            TelAddFriendId2StatusCount id2StatusCount = (TelAddFriendId2StatusCount)statusCountMap.get(task.getNum());
            if (Objects.nonNull(id2StatusCount)) {
                dto.setApplyCount(id2StatusCount.getApplyCount());
                dto.setSuccessCount(id2StatusCount.getSuccessCount());
            }
            dto.setAddType(task.getAddType());
            result.add(dto);
        }
        return result;
    }

    private List<String> buildTagList(String tagIds, String corpId) {
        if (StringUtils.isNotBlank((CharSequence)tagIds)) {
            List tags = Splitter.on((String)",").omitEmptyStrings().splitToList((CharSequence)tagIds);
            Map tagMap = this.weworkTagMapper.selectTagIdAndNameByCorpIdAndTagIds(corpId, (Collection)tags);
            ArrayList tagNameList = Lists.newArrayListWithCapacity((int)tags.size());
            for (String tagId : tags) {
                String name = (String)tagMap.get(tagId);
                if (!StringUtils.isNotBlank((CharSequence)name)) continue;
                tagNameList.add(name);
            }
            return tagNameList;
        }
        return Lists.newArrayList();
    }

    private List<String> buildChannelList(Long bizId, String channelNums) {
        ArrayList channelList = Lists.newArrayList();
        if (StringUtils.isNotEmpty((CharSequence)channelNums)) {
            ArrayList channelNumList = Lists.newArrayList((Object[])channelNums.split(","));
            Map channelMap = this.channelMapper.selectNameByNums(bizId, (Collection)channelNumList);
            for (Map.Entry entry : channelMap.entrySet()) {
                channelList.add(entry.getValue());
            }
        }
        return channelList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long add(TelAddFriendAddReqDto reqDto) {
        Map<String, List<Pair<String, String>>> weworkMap;
        TelAddFriendTask task;
        CurrentUserInfo currentUser;
        if (reqDto.getIsMarketingSop().booleanValue()) {
            currentUser = new CurrentUserInfo();
            currentUser.setId(reqDto.getUserId());
            currentUser.setCorpId(reqDto.getCorpId());
            currentUser.setBizId(reqDto.getBizId());
        } else {
            currentUser = LoginUtils.getCurrentUser();
        }
        log.info("add,params:{}, operatorId:{}, corpId:{}", new Object[]{JSON.toJSONString((Object)reqDto), currentUser.getId(), currentUser.getCorpId()});
        reqDto.validate();
        Set<TelAndRemarkDto> telAndRemarkDtos = reqDto.getTelAndRemarkDtos();
        Map<String, String> tel2RemarkMap = telAndRemarkDtos.stream().collect(Collectors.toMap(TelAndRemarkDto::getUniqKey, TelAndRemarkDto::getRemark));
        if (NumberUtils.INTEGER_ONE.equals(reqDto.getIsDistinct())) {
            List tels = telAndRemarkDtos.stream().map(TelAndRemarkDto::getTel).collect(Collectors.toList());
            ArrayList filteredTels = Lists.newArrayList();
            Lists.partition(tels, (int)200).forEach(partitionTels -> {
                Set filterMobiles = this.weworkContactMapper.selectMobilesByCorpIdAndMobiles(currentUser.getCorpId(), (Collection)partitionTels);
                if (CollectionUtils.isNotEmpty((Collection)filterMobiles)) {
                    filteredTels.addAll(filterMobiles);
                }
            });
            log.info("corpId:{},\u8fc7\u6ee4\u6389\u7684\u624b\u673a\u53f7:{}", (Object)currentUser.getCorpId(), (Object)filteredTels);
            for (Object tel : filteredTels) {
                tel2RemarkMap.remove(tel);
            }
            if (MapUtils.isEmpty(tel2RemarkMap)) {
                log.info("tel2RemarkMap\u4e3a\u7a7a");
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u53bb\u91cd\u8fc7\u6ee4\u4e4b\u540e\u624b\u673a\u53f7\u6570\u91cf\u4e3a0");
            }
        }
        if (!reqDto.getIsMarketingSop().booleanValue() && tel2RemarkMap.size() > 5000) {
            log.info("\u624b\u673a\u53f7\u4e2a\u6570\u4e3a:{}", (Object)tel2RemarkMap.size());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u624b\u673a\u53f7\u4e2a\u6570\u8d85\u8fc75000");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getTaskNum())) {
            TelAddFriendTask telAddFriendTask = new TelAddFriendTask();
            telAddFriendTask.setNum(reqDto.getTaskNum());
            task = (TelAddFriendTask)this.telAddFriendTaskMapper.selectOne((Object)telAddFriendTask);
        } else {
            task = this.buildTask(reqDto, currentUser, tel2RemarkMap.size());
        }
        if (reqDto.getIsMarketingSop().booleanValue()) {
            ArrayList result = Lists.newArrayListWithExpectedSize((int)tel2RemarkMap.size());
            for (TelAndRemarkDto telAndRemarkDto : reqDto.getTelAndRemarkDtos()) {
                result.add(new ImmutablePair((Object)telAndRemarkDto.getWeworkUserNum(), (Object)telAndRemarkDto.getTel()));
            }
            weworkMap = result.stream().collect(Collectors.groupingBy(Pair::getLeft));
        } else {
            weworkMap = this.partition(Lists.newArrayList(tel2RemarkMap.keySet()), Lists.newArrayList(reqDto.getWeworkUserNums())).stream().collect(Collectors.groupingBy(Pair::getLeft));
        }
        Map<String, WeworkUser> weworkUserMap = this.weworkUserMapper.queryWeworkUsersByNums(currentUser.getCorpId(), weworkMap.keySet()).stream().collect(Collectors.toMap(WeworkUser::getNum, Function.identity()));
        ArrayList subTaskList = Lists.newArrayListWithExpectedSize((int)reqDto.getTelAndRemarkDtos().size());
        weworkMap.forEach((weworkUserNum, list) -> {
            WeworkUser weworkUser = (WeworkUser)weworkUserMap.get(weworkUserNum);
            if (Objects.isNull(weworkUser)) {
                return;
            }
            if (CollectionUtils.isEmpty((Collection)list)) {
                return;
            }
            List tels = list.stream().map(Pair::getRight).collect(Collectors.toList());
            for (String tel : tels) {
                StringBuilder uniqKey = new StringBuilder(tel);
                if (reqDto.getIsMarketingSop().booleanValue()) {
                    uniqKey.append(':').append((String)weworkUserNum);
                }
                TelAddFriendTaskDetail detail = this.buildTaskDetail((String)weworkUserNum, currentUser, tel, task.getNum(), (String)tel2RemarkMap.get(uniqKey.toString()), reqDto.getTaskType());
                subTaskList.add(detail);
            }
        });
        if (StringUtils.isBlank((CharSequence)reqDto.getTaskNum())) {
            this.telAddFriendTaskMapper.insertSelective((Object)task);
        } else {
            task.setImportCount(Integer.valueOf(task.getImportCount() + subTaskList.size()));
            task.setUpdateTime(new Date());
            this.telAddFriendTaskMapper.updateByPrimaryKey((Object)task);
        }
        try {
            Lists.partition((List)subTaskList, (int)200).forEach(partitionSubTasks -> this.telAddFriendTaskDetailMapper.batchInsert(partitionSubTasks));
        }
        catch (Exception ex) {
            log.error("\u4fdd\u5b58\u5b50\u4efb\u52a1\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f:", (Throwable)ex);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u521b\u5efa\u624b\u673a\u53f7\u52a0\u597d\u53cb\u4efb\u52a1\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        try {
            this.sendRemindMsg(weworkMap, weworkUserMap, task);
        }
        catch (Exception ex) {
            log.error("\u53d1\u9001\u767e\u5bb6\u4e91\u63d0\u9192\u53d1\u9001\u5f02\u5e38", (Throwable)ex);
        }
        return task.getId();
    }

    private void sendRemindMsg(Map<String, List<Pair<String, String>>> weworkMap, Map<String, WeworkUser> weworkUserMap, TelAddFriendTask task) {
        String userName = this.userMapper.getUserNameByUserId(task.getCreateBy());
        new Thread(() -> {
            for (Map.Entry entry : weworkMap.entrySet()) {
                String weworkUserNum = (String)entry.getKey();
                if (!weworkUserMap.containsKey(weworkUserNum)) {
                    log.warn("weworkUserMap\u4e2d\u4e0d\u5305\u542b:{}", (Object)weworkUserNum);
                    continue;
                }
                String weworkUserId = ((WeworkUser)weworkUserMap.get(weworkUserNum)).getWeworkUserId();
                String url = MessageFormat.format(this.remindUrl, task.getCorpId(), task.getNum(), weworkUserNum);
                String description = MessageFormat.format(REMIND_CONTENT, userName, ((List)entry.getValue()).size());
                ArrayList articles = Lists.newArrayList();
                Article article = this.remindService.setArticleNews(task.getTaskName(), description, url, PIC_URL);
                articles.add(article);
                try {
                    this.remindService.sendNewMsg(task.getCorpId(), weworkUserId, (List)articles);
                }
                catch (Exception ex) {
                    log.error("taskNum:{}, \u7ed9\u6210\u5458:{}\u53d1\u9001\u767e\u5bb6\u4e91\u63d0\u9192\u53d1\u9001\u5f02\u5e38:", new Object[]{task.getNum(), weworkUserId, ex});
                }
            }
        }).start();
    }

    @Override
    public void apply(TelAddFriendApplyDto applyDto) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        log.info("apply,params:{}, operatorId:{}, corpId:{}", new Object[]{applyDto, currentUser.getId(), currentUser.getCorpId()});
        applyDto.validateParams();
        TelAddFriendTaskDetail detail = this.telAddFriendTaskDetailMapper.selectByDetailNum(applyDto.getDetailNum());
        if (Objects.isNull(detail)) {
            log.warn("\u6839\u636edetailNum:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)applyDto.getDetailNum());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5");
        }
        TelAddFriendTaskDetail updateBean = new TelAddFriendTaskDetail();
        updateBean.setId(detail.getId());
        updateBean.setStatus(Integer.valueOf(TelAddFriendStatus.APPLY_ING.getStatus()));
        updateBean.setApplyTime(new Date());
        updateBean.setUpdateTime(new Date());
        updateBean.setUpdateBy(currentUser.getId());
        this.telAddFriendTaskDetailMapper.updateByPrimaryKeySelective((Object)updateBean);
        TelAddFriendTask task = this.telAddFriendTaskMapper.selectByNum(detail.getTaskNum());
        if (task != null) {
            this.sopTaskStatusService.sendSopTaskStatusMsg(task.getId(), detail.getId(), SopTaskType.TEL_ADD_FRIEND, detail.getTel(), Integer.valueOf(TaskRunStatusEnum.EXECUTED.getStatus()), null, new Date());
        }
    }

    @Override
    public void addFriendFailTask() {
        log.info("tel add friend  addFreindFailTask begin");
        List failDetailList = this.telAddFriendTaskDetailMapper.selectExpireTask(DateUtils.addDays((Date)new Date(), (int)-7));
        if (CollectionUtils.isEmpty((Collection)failDetailList)) {
            return;
        }
        for (ApplyDetailDto detailDto : failDetailList) {
            TelAddFriendTaskDetail detail = new TelAddFriendTaskDetail();
            detail.setId(detailDto.getId());
            detail.setStatus(Integer.valueOf(TelAddFriendStatus.EXPIRE.getStatus()));
            detail.setUpdateTime(new Date());
            this.telAddFriendTaskDetailMapper.updateByPrimaryKeySelective((Object)detail);
            TelAddFriendTask task = this.telAddFriendTaskMapper.selectByNum(detail.getTaskNum());
            if (task == null) continue;
            this.sopTaskStatusService.sendSopTaskStatusMsg(task.getId(), detail.getId(), SopTaskType.TEL_ADD_FRIEND, detail.getTel(), Integer.valueOf(TaskRunStatusEnum.FAIL.getStatus()), TelAddFriendStatus.EXPIRE.getDesc(), null);
        }
    }

    @Override
    public void addFriendSuccessTask() {
        log.info("tel add friend addFriendSuccessTask begin");
        List inApplyDetailList = this.telAddFriendTaskDetailMapper.selectInApplyDetail(DateUtils.addDays((Date)new Date(), (int)-7));
        if (CollectionUtils.isEmpty((Collection)inApplyDetailList)) {
            log.info("\u6ca1\u6709\u5f85\u5904\u7406\u7684\u6dfb\u52a0\u597d\u53cb\u5b50\u4efb\u52a1");
            return;
        }
        Lists.partition((List)inApplyDetailList, (int)100).forEach(partitionDetails -> {
            for (ApplyDetailDto detailDto : partitionDetails) {
                String mobile;
                String weworkUserId;
                Long bizId = detailDto.getBizId();
                String corpId = detailDto.getCorpId();
                TelContactRelation telContactRelation = this.weworkContactMapper.selectByCorpIdWeworkUserIdAndMobile(corpId, weworkUserId = detailDto.getWeworkUserId(), mobile = detailDto.getTel());
                if (!Objects.nonNull(telContactRelation)) continue;
                this.telAddFriendTaskDetailMapper.updateStatusById(Integer.valueOf(TelAddFriendStatus.SUCCESS.getStatus()), telContactRelation.getContactId(), detailDto.getId(), new Date());
                if (StringUtils.isBlank((CharSequence)telContactRelation.getRemark()) && StringUtils.isNotBlank((CharSequence)detailDto.getRemark())) {
                    this.remark(bizId, corpId, weworkUserId, telContactRelation.getContactId(), detailDto.getRemark());
                }
                if (StringUtils.isNotBlank((CharSequence)detailDto.getTagIds())) {
                    this.addTags(bizId, corpId, weworkUserId, telContactRelation.getContactId(), detailDto.getTagIds());
                }
                ModMobileSyncReq syncReq = new ModMobileSyncReq();
                syncReq.setCorpId(corpId);
                syncReq.setContactId(telContactRelation.getContactId());
                syncReq.setMobiles((List)Lists.newArrayList((Object[])new String[]{mobile}));
                this.scrmContactService.modMobileByAllWeworkUserIds(syncReq);
            }
        });
        log.info("tel add friend addFriendSuccessTask end");
    }

    private List<Pair<String, String>> partition(List<String> tels, List<String> weworkUserNums) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)tels.size());
        int size = weworkUserNums.size();
        int j = 0;
        for (String tel : tels) {
            result.add(new ImmutablePair((Object)weworkUserNums.get(j), (Object)tel));
            if (++j != size) continue;
            j = 0;
        }
        return result;
    }

    private TelAddFriendTaskDetail buildTaskDetail(String weworkUserNum, CurrentUserInfo currentUserInfo, String tel, String taskNum, String remark, Integer taskType) {
        TelAddFriendTaskDetail detail = new TelAddFriendTaskDetail();
        detail.setBizId(currentUserInfo.getBizId());
        detail.setCorpId(currentUserInfo.getCorpId());
        detail.setCreateBy(currentUserInfo.getId());
        detail.setCreateTime(new Date());
        detail.setNum(this.idGen.getNum());
        detail.setWeworkUserNum(weworkUserNum);
        detail.setTel(tel);
        detail.setUpdateTime(new Date());
        detail.setUpdateBy(currentUserInfo.getId());
        detail.setTaskNum(taskNum);
        detail.setFriendRemark(remark);
        detail.setStatus(Integer.valueOf(TelAddFriendStatus.TOBE_APPLY.getStatus()));
        detail.setIsSync(NumberUtils.INTEGER_ZERO);
        if (Objects.nonNull(taskType)) {
            detail.setTaskType(taskType);
        }
        return detail;
    }

    private TelAddFriendTask buildTask(TelAddFriendAddReqDto reqDto, CurrentUserInfo currentUserInfo, Integer totalCount) {
        TelAddFriendTask task = new TelAddFriendTask();
        task.setNum(this.idGen.getNum());
        task.setBizId(currentUserInfo.getBizId());
        task.setCorpId(currentUserInfo.getCorpId());
        task.setTaskName(reqDto.getTaskName());
        task.setAddType(reqDto.getAddType());
        if (CollectionUtils.isNotEmpty(reqDto.getTagIds())) {
            task.setTagIds(Joiner.on((String)",").join(reqDto.getTagIds()));
        }
        task.setIsDistinct(reqDto.getIsDistinct());
        task.setImportCount(totalCount);
        task.setDeadline(reqDto.getDeadline());
        task.setCreateBy(currentUserInfo.getId());
        task.setCreateTime(new Date());
        task.setUpdateTime(new Date());
        task.setUpdateBy(currentUserInfo.getId());
        task.setFileUrl(reqDto.getFileUrl());
        task.setTaskType(reqDto.getTaskType());
        if (CollectionUtils.isNotEmpty(reqDto.getChannelIds())) {
            task.setChannelNums(Joiner.on((String)",").join(reqDto.getChannelIds()));
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getFriendRemark())) {
            task.setFriendRemark(reqDto.getFriendRemark());
        }
        if (reqDto.getFriendWelcome() != null) {
            String welcomeStr = JacksonUtil.obj2Str((Object)reqDto.getFriendWelcome());
            task.setWelcomeJson(welcomeStr);
        }
        task.setIsVisible(NumberUtils.INTEGER_ONE);
        if (reqDto.getIsMarketingSop().booleanValue()) {
            task.setIsVisible(NumberUtils.INTEGER_ZERO);
        }
        return task;
    }

    @Override
    public MobileDto getFilterMobiles(MobileDto mobileDto) {
        log.info("getFilterMobiles, params:{}", (Object)mobileDto);
        mobileDto.validateParams();
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        HashSet mobiles = Sets.newHashSet();
        Lists.partition((List)Lists.newArrayList(mobileDto.getMobiles()), (int)200).forEach(partitionMobiles -> {
            Set filterMobiles = this.weworkContactMapper.selectMobilesByCorpIdAndMobiles(currentUserInfo.getCorpId(), (Collection)partitionMobiles);
            if (CollectionUtils.isNotEmpty((Collection)filterMobiles)) {
                mobiles.addAll(filterMobiles);
            }
        });
        MobileDto result = new MobileDto();
        result.setFilterCount(mobiles.size());
        if (!mobiles.isEmpty()) {
            result.setMobiles(mobiles);
        }
        return result;
    }

    @Override
    public void remindToAddFriend(RemindToAddFriendReqDto reqDto) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        log.info("remindToAddFriend,params:{}, operatorId:{}, corpId:{}", new Object[]{reqDto, currentUserInfo.getId(), currentUserInfo.getCorpId()});
        reqDto.validateParams();
        TelAddFriendTask telAddFriendTask = this.telAddFriendTaskMapper.selectByNum(reqDto.getTaskNum());
        if (Objects.isNull(telAddFriendTask)) {
            log.warn("\u6839\u636etaskNum:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)reqDto.getTaskNum());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4efb\u52a1\u552f\u4e00\u6807\u8bc6\u4e0d\u5408\u6cd5");
        }
        if (!currentUserInfo.getCorpId().equals(telAddFriendTask.getCorpId())) {
            log.warn("\u6839\u636etaskNum:{}\u83b7\u53d6\u5230\u7684\u8bb0\u5f55\u4e0d\u662f\u5f53\u524d\u7528\u6237\u5546\u6237\u4e0b\u7684,\u4efb\u52a1\u5bf9\u5e94\u7684corpId:{}, \u5f53\u524d\u7528\u6237corpId:{}", new Object[]{reqDto.getTaskNum(), telAddFriendTask.getCorpId(), currentUserInfo.getCorpId()});
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4efb\u52a1\u552f\u4e00\u6807\u8bc6\u4e0d\u5408\u6cd5");
        }
        Set weworkUserNums = this.telAddFriendTaskDetailMapper.selectWeworkUserNumsByTaskNumAndStatus(reqDto.getTaskNum(), Integer.valueOf(TelAddFriendStatus.TOBE_APPLY.getStatus()));
        if (CollectionUtils.isEmpty((Collection)weworkUserNums)) {
            log.info("\u52a0\u597d\u53cb\u4efb\u52a1:{}\u4e0b\u6ca1\u6709\u5f85\u6dfb\u52a0\u7684\u5b50\u4efb\u52a1", (Object)reqDto.getTaskNum());
            return;
        }
        Map weworkUserNum2IdMap = this.weworkUserMapper.selectWeworkUserNumAndIdByNums((Collection)weworkUserNums);
        String userName = this.userMapper.getUserNameByUserId(telAddFriendTask.getCreateBy());
        Map weworkUserNum2CountMap = this.telAddFriendTaskDetailMapper.selectWeworkUserNumAndAllocateCount(reqDto.getTaskNum(), (Collection)weworkUserNums);
        for (Map.Entry entry : weworkUserNum2CountMap.entrySet()) {
            String url = MessageFormat.format(this.remindUrl, telAddFriendTask.getCorpId(), reqDto.getTaskNum(), entry.getKey());
            String description = MessageFormat.format(REMIND_CONTENT, userName, entry.getValue());
            String weworkUserId = (String)weworkUserNum2IdMap.get(entry.getKey());
            ArrayList articles = Lists.newArrayList();
            Article article = this.remindService.setArticleNews(reqDto.getTaskName(), description, url, reqDto.getPicUrl());
            articles.add(article);
            try {
                this.remindService.sendNewMsg(currentUserInfo.getCorpId(), weworkUserId, (List)articles);
            }
            catch (Exception ex) {
                log.error("\u7ed9\u6210\u5458:{}\u53d1\u9001\u767e\u5bb6\u4e91\u63d0\u9192\u53d1\u9001\u5f02\u5e38:", entry.getKey(), (Object)ex);
            }
        }
    }

    @Override
    public TaskSimpleInfoRespDto taskSimpleInfo(TaskSimpleInfoReqDto reqDto) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        log.info("taskSimpleInfo,params:{}, operatorId:{}, corpId:{}", new Object[]{reqDto, currentUser.getId(), currentUser.getCorpId()});
        reqDto.validateParams();
        TelAddFriendTask telAddFriendTask = this.telAddFriendTaskMapper.selectByNum(reqDto.getTaskNum());
        if (Objects.isNull(telAddFriendTask)) {
            log.warn("\u6839\u636etaskNum:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)reqDto.getTaskNum());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4efb\u52a1\u552f\u4e00\u6807\u8bc6\u4e0d\u5408\u6cd5");
        }
        int count = this.telAddFriendTaskDetailMapper.getWeworkUserMobileCount(reqDto.getTaskNum(), reqDto.getWeworkUserNum(), null);
        TaskSimpleInfoRespDto taskSimpleInfoRespDto = new TaskSimpleInfoRespDto();
        taskSimpleInfoRespDto.setTaskName(telAddFriendTask.getTaskName());
        taskSimpleInfoRespDto.setCreateTime(telAddFriendTask.getCreateTime());
        taskSimpleInfoRespDto.setDeadline(telAddFriendTask.getDeadline());
        taskSimpleInfoRespDto.setTotalCount(count);
        return taskSimpleInfoRespDto;
    }

    @Override
    public TaskDetailDto detail(TaskBaseDto params) {
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String taskNum = params.getTaskNum();
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)taskNum), (Object)"\u4efb\u52a1taskNum\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        TelAddFriendTask task = new TelAddFriendTask();
        task.setCorpId(corpId);
        task.setNum(taskNum);
        task = (TelAddFriendTask)this.telAddFriendTaskMapper.selectOne((Object)task);
        if (task == null) {
            return null;
        }
        TaskDetailDto taskDetailDto = new TaskDetailDto();
        taskDetailDto.setTaskNum(task.getNum());
        taskDetailDto.setTaskName(task.getTaskName());
        String channelNums = task.getChannelNums();
        if (StringUtils.isNotEmpty((CharSequence)channelNums)) {
            ArrayList channelNumList = Lists.newArrayList((Object[])channelNums.split(","));
            Map channelMap = this.channelMapper.selectNameByNums(bizId, (Collection)channelNumList);
            ArrayList channelDtos = Lists.newArrayList();
            for (Map.Entry entry : channelMap.entrySet()) {
                ChannelDto channelDto = new ChannelDto();
                channelDto.setId((String)entry.getKey());
                channelDto.setName((String)entry.getValue());
                channelDtos.add(channelDto);
            }
            taskDetailDto.setChannelList(channelDtos);
        }
        List weworkUserNums = this.telAddFriendTaskDetailMapper.queryWeworkUserNumByTaskNum(corpId, taskNum);
        taskDetailDto.setWeworkUserList(this.weworkUserMapper.getWeworkUserByNums(corpId, (Collection)weworkUserNums));
        taskDetailDto.setAddType(task.getAddType());
        if (StringUtils.isNotEmpty((CharSequence)task.getTagIds())) {
            ArrayList tagIdList = Lists.newArrayList((Object[])task.getTagIds().split(","));
            Map weworkTagMap = this.weworkTagMapper.queryTagIdAndName(corpId, (Collection)tagIdList);
            ArrayList tagDtos = Lists.newArrayList();
            for (Map.Entry entry : weworkTagMap.entrySet()) {
                WeworkTagDto weworkTagDto = new WeworkTagDto();
                weworkTagDto.setId((String)entry.getKey());
                weworkTagDto.setName((String)entry.getValue());
                tagDtos.add(weworkTagDto);
            }
            taskDetailDto.setTagList(tagDtos);
        }
        taskDetailDto.setDeadline(task.getDeadline());
        taskDetailDto.setIsDistinct(task.getIsDistinct());
        taskDetailDto.setFriendRemark(task.getFriendRemark());
        if (StringUtils.isNotEmpty((CharSequence)task.getWelcomeJson())) {
            try {
                TelAddFriendWelcomeDto friendWelcomeDto = (TelAddFriendWelcomeDto)JacksonUtil.str2Obj((String)task.getWelcomeJson(), TelAddFriendWelcomeDto.class);
                taskDetailDto.setFriendWelcome(friendWelcomeDto);
            }
            catch (IOException e) {
                log.error("parse json error: ", (Throwable)e);
            }
        }
        return taskDetailDto;
    }

    @Override
    public void edit(TelAddFriendAddReqDto reqDto) {
        Preconditions.checkArgument((reqDto != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String taskNum = reqDto.getTaskNum();
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)taskNum), (Object)"taskNum\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        TelAddFriendTask task = new TelAddFriendTask();
        task.setCorpId(corpId);
        task.setNum(taskNum);
        task = (TelAddFriendTask)this.telAddFriendTaskMapper.selectOne((Object)task);
        if (task == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "taskNum\u53c2\u6570\u9519\u8bef\uff0c\u627e\u4e0d\u5230\u4efb\u52a1");
        }
        task.setFriendRemark(reqDto.getFriendRemark());
        if (CollectionUtils.isNotEmpty(reqDto.getTagIds())) {
            task.setTagIds(Joiner.on((String)",").join(reqDto.getTagIds()));
        } else {
            task.setTagIds("");
        }
        if (reqDto.getFriendWelcome() != null) {
            String friendWelcome = JacksonUtil.obj2Str((Object)reqDto.getFriendWelcome());
            task.setWelcomeJson(friendWelcome);
        } else {
            task.setWelcomeJson(null);
        }
        task.setUpdateBy(userInfo.getId());
        task.setUpdateTime(new Date());
        this.telAddFriendTaskMapper.updateByPrimaryKey((Object)task);
    }

    @Override
    public TaskStatisticDto taskStatistic(TaskBaseDto params) {
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String taskNum = params.getTaskNum();
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)taskNum), (Object)"taskNum\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        TelAddFriendTask task = this.telAddFriendTaskMapper.selectByNum(taskNum);
        if (task == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "taskNum\u53c2\u6570\u9519\u8bef\uff0c\u627e\u4e0d\u5230\u4efb\u52a1");
        }
        TaskStatisticDto taskStatisticDto = new TaskStatisticDto();
        Integer totalTel = task.getImportCount();
        taskStatisticDto.setTotalTel(totalTel);
        int remainAdd = this.telAddFriendTaskDetailMapper.selectTaskStatusCount(taskNum, Integer.valueOf(TelAddFriendStatus.TOBE_APPLY.getStatus()));
        taskStatisticDto.setRemainAdd(remainAdd);
        int remainPass = this.telAddFriendTaskDetailMapper.selectTaskStatusCount(taskNum, Integer.valueOf(TelAddFriendStatus.APPLY_ING.getStatus()));
        taskStatisticDto.setRemainPass(remainPass);
        int successPass = this.telAddFriendTaskDetailMapper.selectTaskStatusCount(taskNum, Integer.valueOf(TelAddFriendStatus.SUCCESS.getStatus()));
        taskStatisticDto.setSuccessPass(successPass);
        String passPercent = "0.00%";
        NumberFormat numberFormat = NumberFormat.getPercentInstance();
        numberFormat.setMaximumFractionDigits(2);
        if (remainPass + successPass > 0) {
            passPercent = numberFormat.format((double)successPass * 1.0 / (double)(remainPass + successPass));
        }
        taskStatisticDto.setPassPercent(passPercent);
        String addPassPercent = "0.00%";
        if (totalTel > 0) {
            addPassPercent = numberFormat.format((double)successPass * 1.0 / (double)totalTel.intValue());
        }
        taskStatisticDto.setAddPassPercent(addPassPercent);
        return taskStatisticDto;
    }

    @Override
    public List<TaskWeworkUserAddFriendDto> weworkUserAddList(TaskWeworkUserAddFriendReq params) {
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String taskNum = params.getTaskNum();
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)taskNum), (Object)"taskNum\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        PageDto pageDto = params.getPageDto();
        if (pageDto != null) {
            int total = this.telAddFriendTaskDetailMapper.queryWeworkUserCount(taskNum, params.getWeworkUserId());
            pageDto.setCount(Integer.valueOf(total));
        }
        List weworkUserStatusList = this.telAddFriendTaskDetailMapper.selectWeworkUserTaskStatusList(taskNum, params.getWeworkUserId(), pageDto);
        List weworkUserNums = weworkUserStatusList.stream().map(WeworkUserStatusDto::getWeworkUserNum).collect(Collectors.toList());
        List weworkUserList = this.weworkUserMapper.queryInfoListByNums(weworkUserNums);
        ArrayList result = Lists.newArrayListWithCapacity((int)weworkUserStatusList.size());
        for (WeworkUserStatusDto userStatusDto : weworkUserStatusList) {
            TaskWeworkUserAddFriendDto taskWeworkUserDto = new TaskWeworkUserAddFriendDto();
            String weworkUserNum = userStatusDto.getWeworkUserNum();
            taskWeworkUserDto.setWeworkUserId(userStatusDto.getWeworkUserNum());
            for (WeworkUser weworkUser : weworkUserList) {
                if (!weworkUser.getNum().equals(weworkUserNum)) continue;
                taskWeworkUserDto.setName(weworkUser.getName());
                taskWeworkUserDto.setAvatar(weworkUser.getAvatar());
            }
            taskWeworkUserDto.setAllocateTotal(userStatusDto.getAllocateTotal());
            taskWeworkUserDto.setRemainAddCount(userStatusDto.getRemainAddCount());
            taskWeworkUserDto.setRemainPassCount(userStatusDto.getRemainPassCount());
            taskWeworkUserDto.setSuccessPassCount(userStatusDto.getSuccessPassCount());
            String passPercent = "0.00%";
            NumberFormat numberFormat = NumberFormat.getPercentInstance();
            numberFormat.setMaximumFractionDigits(2);
            if (userStatusDto.getRemainPassCount() + userStatusDto.getSuccessPassCount() > 0) {
                passPercent = numberFormat.format((double)userStatusDto.getSuccessPassCount().intValue() * 1.0 / (double)(userStatusDto.getRemainPassCount() + userStatusDto.getSuccessPassCount()));
            }
            taskWeworkUserDto.setPassPercent(passPercent);
            String addPassPercent = "0.00%";
            if (userStatusDto.getAllocateTotal() > 0) {
                addPassPercent = numberFormat.format((double)userStatusDto.getSuccessPassCount().intValue() * 1.0 / (double)userStatusDto.getAllocateTotal().intValue());
            }
            taskWeworkUserDto.setAddPassPercent(addPassPercent);
            int joinRoomCount = this.getWeworkUserFriendJoinRoom(corpId, taskNum, weworkUserNum);
            taskWeworkUserDto.setJoinRoomCount(joinRoomCount);
            String joinPercent = "0.00%";
            if (userStatusDto.getSuccessPassCount() > 0) {
                joinPercent = numberFormat.format((double)joinRoomCount * 1.0 / (double)userStatusDto.getSuccessPassCount().intValue());
            }
            taskWeworkUserDto.setJoinRoomPercent(joinPercent);
            result.add(taskWeworkUserDto);
        }
        return result;
    }

    private int getWeworkUserFriendJoinRoom(String corpId, String taskNum, String weworkUserNum) {
        Map detailContactIdMap = this.telAddFriendTaskDetailMapper.selectByWeworkUserNum(taskNum, weworkUserNum);
        int result = 0;
        for (Map.Entry entry : detailContactIdMap.entrySet()) {
            Long taskDetailId;
            List roomIds;
            String contactId = (String)entry.getValue();
            if (!this.isJoinRoom(corpId, contactId, roomIds = this.telTaskDetailRoomMapper.queryTaskRoomIds(taskDetailId = (Long)entry.getKey()))) continue;
            ++result;
        }
        return result;
    }

    private boolean isJoinRoom(String corpId, String contactId, List<String> roomIds) {
        if (CollectionUtils.isEmpty(roomIds)) {
            return false;
        }
        int count = this.weworkChatRoomRelationMapper.queryContactJoinRoom(corpId, contactId, roomIds);
        return count > 0;
    }

    private void remark(Long bizId, String corpId, String weworkUserId, String contactId, String remark) {
        ModifyRemarkDto modifyRemarkDto = new ModifyRemarkDto();
        modifyRemarkDto.setBizId(bizId);
        modifyRemarkDto.setCorpId(corpId);
        modifyRemarkDto.setWeworkUserId(weworkUserId);
        modifyRemarkDto.setContactId(contactId);
        modifyRemarkDto.setRemark(remark);
        try {
            this.contactOpService.modifyRemark(modifyRemarkDto);
        }
        catch (Exception e) {
            log.error("\u5907\u6ce8\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
        }
    }

    private void addTags(Long bizId, String corpId, String weworkUserId, String contactId, String tagIds) {
        if (StringUtils.isEmpty((CharSequence)tagIds)) {
            log.info("\u6dfb\u52a0\u597d\u53cb\u4efb\u52a1:{}\u672a\u8bbe\u7f6e\u5ba2\u6237\u6807\u7b7e", (Object)tagIds);
            return;
        }
        ModifyTagDto modifyTagDto = new ModifyTagDto();
        modifyTagDto.setWeworkUserId(weworkUserId);
        modifyTagDto.setContactId(contactId);
        modifyTagDto.setAddTagIds((List)Lists.newArrayList((Object[])tagIds.split(",")));
        modifyTagDto.setBizId(bizId);
        modifyTagDto.setCorpId(corpId);
        log.info("addTags: \u6253\u6807\u7b7e:{}", (Object)modifyTagDto);
        try {
            this.contactOpService.modifyTag(modifyTagDto);
        }
        catch (Exception ex) {
            log.error("weworkUserId:{},contactId:{},tagIds:{}\u589e\u52a0\u6807\u7b7e\u5931\u8d25:", new Object[]{weworkUserId, contactId, ex});
        }
    }
}

