/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.teladdfriend.dto;

import com.google.common.base.Preconditions;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.dal.teladdfriend.dto.TaskMobileDto;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class TaskMobileReqDto {
    private String taskNum;
    private String weworkUserNum;
    private Integer status;
    private PageDto pageDto;

    public void validateParams() {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.taskNum), (Object)"\u4efb\u52a1\u552f\u4e00\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.weworkUserNum), (Object)"\u6210\u5458\u552f\u4e00\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.pageDto), (Object)"\u5206\u9875\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public TaskMobileDto convert2TaskMobileDto() {
        TaskMobileDto taskMobileDto = new TaskMobileDto();
        taskMobileDto.setTaskNum(this.taskNum);
        taskMobileDto.setWeworkUserNum(this.weworkUserNum);
        taskMobileDto.setStatus(this.status);
        taskMobileDto.setPageSize(this.pageDto.getPageSize());
        taskMobileDto.setOffset(Integer.valueOf((this.pageDto.getPageNum() - 1) * this.pageDto.getPageSize()));
        return taskMobileDto;
    }

    public String getTaskNum() {
        return this.taskNum;
    }

    public String getWeworkUserNum() {
        return this.weworkUserNum;
    }

    public Integer getStatus() {
        return this.status;
    }

    public PageDto getPageDto() {
        return this.pageDto;
    }

    public void setTaskNum(String taskNum) {
        this.taskNum = taskNum;
    }

    public void setWeworkUserNum(String weworkUserNum) {
        this.weworkUserNum = weworkUserNum;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setPageDto(PageDto pageDto) {
        this.pageDto = pageDto;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskMobileReqDto)) {
            return false;
        }
        TaskMobileReqDto other = (TaskMobileReqDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        String this$taskNum = this.getTaskNum();
        String other$taskNum = other.getTaskNum();
        if (this$taskNum == null ? other$taskNum != null : !this$taskNum.equals(other$taskNum)) {
            return false;
        }
        String this$weworkUserNum = this.getWeworkUserNum();
        String other$weworkUserNum = other.getWeworkUserNum();
        if (this$weworkUserNum == null ? other$weworkUserNum != null : !this$weworkUserNum.equals(other$weworkUserNum)) {
            return false;
        }
        PageDto this$pageDto = this.getPageDto();
        PageDto other$pageDto = other.getPageDto();
        return !(this$pageDto == null ? other$pageDto != null : !this$pageDto.equals(other$pageDto));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskMobileReqDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        String $taskNum = this.getTaskNum();
        result = result * 59 + ($taskNum == null ? 43 : $taskNum.hashCode());
        String $weworkUserNum = this.getWeworkUserNum();
        result = result * 59 + ($weworkUserNum == null ? 43 : $weworkUserNum.hashCode());
        PageDto $pageDto = this.getPageDto();
        result = result * 59 + ($pageDto == null ? 43 : $pageDto.hashCode());
        return result;
    }

    public String toString() {
        return "TaskMobileReqDto(taskNum=" + this.getTaskNum() + ", weworkUserNum=" + this.getWeworkUserNum() + ", status=" + this.getStatus() + ", pageDto=" + this.getPageDto() + ")";
    }
}

