/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.system.service.impl;

import com.kuaike.common.dto.resp.IdAndNameDto;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.permission.mapper.MenuMapper;
import com.kuaike.scrm.dal.permission.mapper.RoleMapper;
import com.kuaike.scrm.dal.permission.mapper.RoleMenuMapper;
import com.kuaike.scrm.dal.system.entity.Version;
import com.kuaike.scrm.dal.system.mapper.VersionMapper;
import com.kuaike.scrm.dal.system.mapper.VersionMenuMapper;
import com.kuaike.scrm.system.dto.request.VersionMenuReqDto;
import com.kuaike.scrm.system.dto.request.VersionReqDto;
import com.kuaike.scrm.system.dto.response.VersionMenuRespDto;
import com.kuaike.scrm.system.service.VersionService;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VersionServiceImpl
implements VersionService {
    private static final Logger log = LoggerFactory.getLogger(VersionServiceImpl.class);
    @Autowired
    private VersionMapper versionMapper;
    @Autowired
    private VersionMenuMapper versionMenuMapper;
    @Autowired
    private MenuMapper menuMapper;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;
    @Autowired
    private RoleMapper roleMapper;
    @Autowired
    private RoleMenuMapper roleMenuMapper;

    @Override
    public List<IdAndNameDto> list() {
        List idAndNameDtos = this.versionMapper.getAllVersion();
        if (CollectionUtils.isEmpty((Collection)idAndNameDtos)) {
            log.warn("\u7cfb\u7edf\u8fd8\u672a\u521d\u59cb\u5316\u6240\u6709\u7248\u672c");
            return Collections.emptyList();
        }
        return idAndNameDtos;
    }

    @Override
    public VersionMenuRespDto versionMenuDetail(VersionReqDto reqDto) {
        log.info("versionMenuDetail,reqDto:{}", (Object)reqDto);
        reqDto.validateParams();
        Set menuCodes = this.versionMenuMapper.selectMenuCodesByVersionId(reqDto.getVersionId());
        VersionMenuRespDto versionMenuRespDto = new VersionMenuRespDto();
        versionMenuRespDto.setVersionId(reqDto.getVersionId());
        versionMenuRespDto.setMenuCodes(menuCodes);
        return versionMenuRespDto;
    }

    @Override
    public void setVersionMenu(VersionMenuReqDto reqDto) {
        Collection<String> needAddMenuCodes;
        log.info("setVersionMenu,reqDto:{}", (Object)reqDto);
        reqDto.validateParams();
        Version version = (Version)this.versionMapper.selectByPrimaryKey((Object)reqDto.getVersionId());
        if (Objects.isNull(version)) {
            log.warn("\u6839\u636e\u7248\u672cid:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)reqDto.getVersionId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u7248\u672cid\u4e0d\u5408\u6cd5");
        }
        Set<String> menuCodes = reqDto.getMenuCodes();
        List menus = this.menuMapper.selectByCodes(menuCodes);
        if (CollectionUtils.isEmpty((Collection)menus) || menus.size() != menuCodes.size()) {
            log.warn("\u4f20\u5165\u7684menuCodes:{}\u4e0d\u5408\u6cd5", menuCodes);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u83dc\u5355\u7f16\u7801\u4e0d\u5408\u6cd5");
        }
        Collection needDelMenuCodes = null;
        Set versionMenuCodes = this.versionMenuMapper.selectMenuCodesByVersionId(reqDto.getVersionId());
        if (CollectionUtils.isEmpty((Collection)versionMenuCodes)) {
            needAddMenuCodes = menuCodes;
        } else {
            needAddMenuCodes = CollectionUtils.removeAll(menuCodes, (Collection)versionMenuCodes);
            needDelMenuCodes = CollectionUtils.removeAll((Collection)versionMenuCodes, menuCodes);
        }
        if (CollectionUtils.isNotEmpty(needAddMenuCodes)) {
            this.versionMenuMapper.batchInsert(reqDto.getVersionId(), needAddMenuCodes, NumberUtils.LONG_MINUS_ONE);
        }
        if (CollectionUtils.isNotEmpty(needDelMenuCodes)) {
            this.versionMenuMapper.delByVersionAndMenuCodes(reqDto.getVersionId(), needDelMenuCodes);
        }
    }
}

