/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.system.service.impl;

import com.google.common.collect.Sets;
import com.kuaike.scrm.common.service.ScrmBizService;
import com.kuaike.scrm.common.service.ScrmSchoolService;
import com.kuaike.scrm.system.dto.response.SchoolListRespDto;
import com.kuaike.scrm.system.service.ScrmNetSchoolService;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ScrmSchoolServiceImpl
implements ScrmSchoolService {
    private static final Logger log = LoggerFactory.getLogger(ScrmSchoolServiceImpl.class);
    @Resource
    private ScrmNetSchoolService scrmNetSchoolService;
    @Resource
    private ScrmBizService bizService;

    public String getOrgCodeBySchoolId(Long schoolId) {
        if (schoolId == null) {
            log.info("getOrgCodeBySchoolId,schoolId is null");
            return null;
        }
        SchoolListRespDto schoolListRespDto = this.scrmNetSchoolService.schoolSimpleInfo(this.bizService.getMainBizId(), Sets.newHashSet((Object[])new Long[]{schoolId}));
        if (schoolListRespDto != null && schoolListRespDto.getData() != null && CollectionUtils.isNotEmpty(schoolListRespDto.getData())) {
            return schoolListRespDto.getData().get(0).getOrgCode();
        }
        return "";
    }
}

