/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.sms.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.bjy.sdk.service.BjyPartnerService;
import com.kuaike.scrm.common.service.AppInstallService;
import com.kuaike.scrm.dal.app.entity.AppBindings;
import com.kuaike.scrm.dal.app.mapper.AppBindingsMapper;
import com.kuaike.scrm.dal.sms.entity.PartnerInfo;
import com.kuaike.scrm.sms.dto.SmsConfig;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SmsConfigServiceImpl
implements AppInstallService {
    private static final Logger log = LoggerFactory.getLogger(SmsConfigServiceImpl.class);
    @Value(value="${app.sms.appCode}")
    private String appCode;
    @Value(value="${app.sms.price.max}")
    private Integer priceMax;
    @Value(value="${app.sms.price.min}")
    private Integer priceMin;
    @Value(value="${app.sms.price.default}")
    private Integer priceDefault;
    @Value(value="${app.sms.signature.count}")
    private Integer signatureCount;
    @Value(value="${app.sms.openUrl}")
    private String openUrl;
    @Resource
    private AppBindingsMapper bindingsMapper;
    @Autowired
    private BjyPartnerService bjyPartnerService;

    public String getAppCode() {
        return this.appCode;
    }

    public void install(AppBindings binding) {
        SmsConfig smsConfig;
        log.info("install sms binding:{}", (Object)binding);
        Integer price = this.priceDefault;
        if (0 == binding.getIsOpen()) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)binding.getConfigJson())) {
            smsConfig = new SmsConfig();
            smsConfig.setUnitPrice(this.priceDefault);
            binding.setConfigJson(JacksonUtil.obj2Str((Object)smsConfig));
        } else {
            try {
                log.info("addOrModBjySetting SMS getConfigJson: {}", (Object)binding.getConfigJson());
                smsConfig = (SmsConfig)JacksonUtil.str2Obj((String)binding.getConfigJson(), SmsConfig.class);
                price = smsConfig.getUnitPrice();
                Preconditions.checkArgument((price != null ? 1 : 0) != 0, (Object)"\u77ed\u4fe1\u4ef7\u683c\u4e3a\u7a7a");
                Preconditions.checkArgument((price >= this.priceMin && price <= this.priceMax ? 1 : 0) != 0, (Object)"\u77ed\u4fe1\u4ef7\u683c\u4e0d\u5728\u533a\u95f4");
            }
            catch (IOException e) {
                log.error("configJson str2Obj error", (Throwable)e);
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u77ed\u4fe1\u4ef7\u683c\u53c2\u6570\u914d\u7f6e\u5f02\u5e38");
            }
        }
        log.info("install sms");
        Long bizId = binding.getBizId();
        PartnerInfo partnerInfo = this.bjyPartnerService.validPartner(bizId);
        this.open(price, partnerInfo.getPartnerId());
        this.bindingsMapper.updateByPrimaryKeySelective((Object)binding);
    }

    private void open(int price, String partnerId) {
        Map<String, String> params = this.getOpenParams(price, partnerId);
        try {
            JSONObject jsonObject = this.bjyPartnerService.bjyPost(this.openUrl, params, (Map)Maps.newHashMap());
            Boolean data = jsonObject.getBoolean("data");
            log.info("open sms result:{}", (Object)data);
        }
        catch (Exception e) {
            log.error("open sms error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u77ed\u4fe1\u5f00\u901a\u5f02\u5e38");
        }
    }

    private Map<String, String> getOpenParams(int unitPrice, String partnerId) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put("unit_price", String.valueOf(unitPrice));
        result.put("partner_id", partnerId);
        result.put("timestamp", String.valueOf(System.currentTimeMillis()));
        return result;
    }

    public void update(AppBindings bindings) {
        Integer price;
        log.info("update,bindings:{}", (Object)bindings);
        Long bizId = bindings.getBizId();
        try {
            if (StringUtils.isBlank((CharSequence)bindings.getConfigJson())) {
                return;
            }
            if (0 == bindings.getIsOpen()) {
                return;
            }
            SmsConfig smsConfig = (SmsConfig)JacksonUtil.str2Obj((String)bindings.getConfigJson(), SmsConfig.class);
            price = smsConfig.getUnitPrice();
            bindings.setConfigJson(JacksonUtil.obj2Str((Object)smsConfig));
            this.bindingsMapper.updateByPrimaryKeySelective((Object)bindings);
        }
        catch (IOException e) {
            log.error("configJson str2Obj error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u77ed\u4fe1\u4ef7\u683c\u53c2\u6570\u914d\u7f6e\u5f02\u5e38");
        }
        Preconditions.checkArgument((price != null ? 1 : 0) != 0, (Object)"\u77ed\u4fe1\u4ef7\u683c\u4e3a\u7a7a");
        Preconditions.checkArgument((price >= this.priceMin && price <= this.priceMax ? 1 : 0) != 0, (Object)"\u77ed\u4fe1\u4ef7\u683c\u4e0d\u5728\u533a\u95f4\u5185");
        PartnerInfo partnerInfo = this.bjyPartnerService.validPartner(bizId);
        this.open(price, partnerInfo.getPartnerId());
    }

    public void uninstall(AppBindings bindings) {
    }
}

