/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.shop.service.datasync;

import cn.hutool.core.date.DateUtil;
import cn.kinyun.scrm.weixin.sdk.api.shop.WxShopAfterSaleAPI;
import cn.kinyun.scrm.weixin.sdk.api.shop.WxShopOrderAPI;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.AfterSaleDetail;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.AfterSaleOrderListItem;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.DeliveryInfoDto;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.ExtInfo;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.OrderDetailDto;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.OrderItem;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.PayInfoDto;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.PriceInfoDto;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.aftersale.AfterSaleOrder;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.aftersale.AfterSaleProductInfo;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.aftersale.DetailDto;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.aftersale.MerchantUploadInfo;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.aftersale.RefundInfo;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.AfterSaleBatchGetReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.OrderGetListReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.AfterSaleBatchGetResp;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.OrderGetListResp;
import com.alibaba.fastjson.JSON;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.applet.dto.PullResult;
import com.kuaike.scrm.applet.service.AppletAccessTokenService;
import com.kuaike.scrm.applet.service.shopdatasync.AbstractPullService;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.dal.shop.entity.AppletInfo;
import com.kuaike.scrm.dal.shop.entity.ShopOrder;
import com.kuaike.scrm.dal.shop.entity.ShopOrderAftersale;
import com.kuaike.scrm.dal.shop.mapper.AppletInfoMapper;
import com.kuaike.scrm.dal.shop.mapper.ShopOrderAftersaleMapper;
import com.kuaike.scrm.dal.shop.mapper.ShopOrderMapper;
import com.kuaike.scrm.shop.dto.OrderEsModel;
import com.kuaike.scrm.shop.enums.WxShopAfterSaleReason;
import com.kuaike.scrm.shop.enums.WxShopAfterSaleStatus;
import com.kuaike.scrm.shop.enums.WxShopAfterSaleType;
import com.kuaike.scrm.shop.service.OrderEsService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class OrderUpdatePullService
extends AbstractPullService {
    private static final Logger log = LoggerFactory.getLogger(OrderUpdatePullService.class);
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private AppletAccessTokenService appletAccessTokenService;
    @Resource
    private WxShopOrderAPI wxShopOrderAPI;
    @Resource
    private AppletInfoMapper appletInfoMapper;
    @Resource
    private ShopOrderMapper shopOrderMapper;
    @Resource
    private IdGen idGen;
    private static final String ORDER_LAST_UPDATE_TIME_KEY = "orderLastUpdateTime";
    @Resource
    private OrderEsService orderEsService;
    @Resource
    private WxShopAfterSaleAPI wxShopAfterSaleAPI;
    @Resource
    private ShopOrderAftersaleMapper shopOrderAftersaleMapper;

    public String getKey() {
        String key = "orderUpdate";
        Integer status = (Integer)this.paramMap.get("status");
        if (Objects.nonNull(status)) {
            key = key + ":" + status;
        }
        return key;
    }

    public String getStartTime(String appId) {
        String value = (String)this.stringRedisTemplate.opsForHash().get((Object)appId, (Object)this.getHashKey());
        return StringUtils.isNotBlank((CharSequence)value) ? value : "1970-01-02 00:00:00";
    }

    public int getTotalNum(String appId) {
        return 0;
    }

    public void saveTotalNum(String appId, int newTotalNum) {
    }

    public void saveUpdateTime(String appId, String updateTime) {
        this.stringRedisTemplate.opsForHash().put((Object)appId, (Object)this.getHashKey(), (Object)updateTime);
    }

    private String getHashKey() {
        Integer status;
        String hashKey = ORDER_LAST_UPDATE_TIME_KEY;
        if (MapUtils.isNotEmpty((Map)this.paramMap) && Objects.nonNull(status = (Integer)this.paramMap.get("status"))) {
            hashKey = hashKey + ":" + status;
        }
        return hashKey;
    }

    public int getPageSize() {
        return 30;
    }

    public PullResult doPull(String appId, String startTime, String endTime, int page, int pageSize) {
        String accessToken = this.appletAccessTokenService.getAccessToken(appId);
        OrderGetListReq req = this.buildReq(page, pageSize, startTime, endTime);
        OrderGetListResp orderList = this.getOrderList(accessToken, req);
        log.info("\u6839\u636eupdateTime\u540c\u6b65\u5c0f\u5546\u5e97\u8ba2\u5355\uff0creq:{}\uff0cresp:{}", (Object)req, (Object)orderList.toString());
        PullResult pullResult = new PullResult();
        pullResult.setResultList(orderList.getOrders());
        pullResult.setTotalNum(Integer.valueOf(orderList.getTotalNum().intValue()));
        return pullResult;
    }

    private OrderGetListReq buildReq(int page, int pageSize, String startTime, String endTime) {
        Integer status;
        OrderGetListReq req = new OrderGetListReq();
        req.setPage(Integer.valueOf(page));
        req.setPageSize(Integer.valueOf(pageSize));
        if (MapUtils.isNotEmpty((Map)this.paramMap) && Objects.nonNull(status = (Integer)this.paramMap.get("status"))) {
            req.setStatus(status);
        }
        req.setStartUpdateTime(startTime);
        req.setEndUpdateTime(endTime);
        return req;
    }

    private OrderGetListResp getOrderList(String token, OrderGetListReq req) {
        int retry = 3;
        while (retry != 0) {
            try {
                return this.wxShopOrderAPI.orderGetList(token, req);
            }
            catch (Exception e) {
                log.error("\u540c\u6b65\u8ba2\u5355\u6570\u636e\uff0c\u8bf7\u6c42\u5fae\u4fe1\u5f02\u5e38\uff0c\u5269\u4f59\u91cd\u8bd5\u6b21\u6570:{}", (Object)(--retry), (Object)e);
            }
        }
        log.error("\u540c\u6b65\u8ba2\u5355\u6570\u636e\uff0c\u8bf7\u6c42\u5fae\u4fe1\u5f02\u5e38");
        throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR);
    }

    protected void save(String appId, PullResult result) {
        super.save(appId, result);
        ArrayList<OrderItem> orderList = new ArrayList<OrderItem>();
        ArrayList<Long> orderIds = new ArrayList<Long>();
        ArrayList<Long> afterSaleOrderIds = new ArrayList<Long>();
        for (Object item : result.getResultList()) {
            List afterSaleOrderList;
            OrderItem orderItem = (OrderItem)item;
            orderList.add(orderItem);
            orderIds.add(orderItem.getOrderId());
            AfterSaleDetail afterSaleDetail = orderItem.getAfterSaleDetail();
            if (afterSaleDetail == null || !CollectionUtils.isNotEmpty((Collection)(afterSaleOrderList = afterSaleDetail.getAfterSaleOrderList()))) continue;
            List collect = afterSaleOrderList.stream().map(AfterSaleOrderListItem::getAfterSaleOrderId).collect(Collectors.toList());
            afterSaleOrderIds.addAll(collect);
        }
        this.checkExistInDbAndUpdate(orderList, orderIds, appId);
        this.checkExistInEsAndUpdate(orderList, appId);
        if (CollectionUtils.isNotEmpty(afterSaleOrderIds)) {
            this.handleAfterSale(afterSaleOrderIds, appId);
        }
    }

    private void handleAfterSale(List<Long> afterSaleOrderIds, String appId) {
        AfterSaleBatchGetReq req = new AfterSaleBatchGetReq();
        req.setAfterSaleOrderIdList(afterSaleOrderIds);
        AfterSaleBatchGetResp afterSaleBatchGetResp = null;
        int retry = 3;
        while (retry != 0) {
            try {
                afterSaleBatchGetResp = this.wxShopAfterSaleAPI.batchGetAfterSaleOrder(this.appletAccessTokenService.getAccessToken(appId), req);
                break;
            }
            catch (Exception e) {
                log.error("\u540c\u6b65\u8ba2\u5355\u552e\u540e\u6570\u636e\uff0c\u8bf7\u6c42\u5fae\u4fe1\u5f02\u5e38\uff0c\u5269\u4f59\u91cd\u8bd5\u6b21\u6570:{}", (Object)(--retry), (Object)e);
            }
        }
        if (afterSaleBatchGetResp == null) {
            log.error("\u540c\u6b65\u8ba2\u5355\u552e\u540e\u6570\u636e\uff0c\u8bf7\u6c42\u5fae\u4fe1\u5f02\u5e38");
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR);
        }
        this.handleAfterSaleResp(afterSaleBatchGetResp.getAfterSaleOrderList(), appId);
    }

    private void handleAfterSaleResp(List<AfterSaleOrder> afterSaleOrderList, String appId) {
        AppletInfo appletInfo = this.appletInfoMapper.getByAppId(appId);
        if (appletInfo == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5c0f\u5546\u5e97\u4e0d\u5b58\u5728");
        }
        HashMap<String, AfterSaleOrder> afterSaleOrderMap = new HashMap<String, AfterSaleOrder>();
        ArrayList<String> allAfterSaleOrderIds = new ArrayList<String>();
        for (AfterSaleOrder afterSaleOrder : afterSaleOrderList) {
            allAfterSaleOrderIds.add(String.valueOf(afterSaleOrder.getOrderId()));
            afterSaleOrderMap.put(String.valueOf(afterSaleOrder.getOrderId()), afterSaleOrder);
        }
        List existsAfterSales = this.shopOrderAftersaleMapper.selectListByAfterSaleOrderIds(allAfterSaleOrderIds, appId);
        if (CollectionUtils.isEmpty((Collection)existsAfterSales)) {
            List<ShopOrderAftersale> list = this.build(afterSaleOrderList, appId, appletInfo.getCorpId(), appletInfo.getBizId());
            this.shopOrderAftersaleMapper.batchInsert(list);
        } else {
            List existAfterSaleOrderIds = existsAfterSales.stream().map(ShopOrderAftersale::getAftersaleOrderId).collect(Collectors.toList());
            List<AfterSaleOrder> insertList = afterSaleOrderList.stream().filter(a -> !existAfterSaleOrderIds.contains(a.getOrderId())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(insertList)) {
                List<ShopOrderAftersale> list = this.build(insertList, appId, appletInfo.getCorpId(), appletInfo.getBizId());
                this.shopOrderAftersaleMapper.batchInsert(list);
            }
            this.updateAfterSale(existsAfterSales, afterSaleOrderMap);
        }
    }

    private void updateAfterSale(List<ShopOrderAftersale> existsAfterSale, Map<String, AfterSaleOrder> afterSaleOrderMap) {
        ArrayList<ShopOrderAftersale> updateList = new ArrayList<ShopOrderAftersale>();
        for (ShopOrderAftersale shopOrderAftersale : existsAfterSale) {
            AfterSaleOrder afterSaleOrder = afterSaleOrderMap.get(shopOrderAftersale.getAftersaleOrderId());
            if (afterSaleOrder == null || shopOrderAftersale.getUpdateTime().getTime() == afterSaleOrder.getUpdateTime() * 1000L) continue;
            ShopOrderAftersale update = this.afterSaleOrderToShopOrderAfterSale(afterSaleOrder);
            update.setId(shopOrderAftersale.getId());
            updateList.add(update);
        }
        if (CollectionUtils.isNotEmpty(updateList)) {
            this.shopOrderAftersaleMapper.batchUpdateById(updateList);
        }
    }

    private ShopOrderAftersale afterSaleOrderToShopOrderAfterSale(AfterSaleOrder afterSaleOrder) {
        ShopOrderAftersale shopOrderAftersale = new ShopOrderAftersale();
        WxShopAfterSaleStatus statusByEnDesc = WxShopAfterSaleStatus.getByEnDesc(afterSaleOrder.getStatus());
        shopOrderAftersale.setStatus(Integer.valueOf(statusByEnDesc != null ? statusByEnDesc.getStatus() : -1));
        AfterSaleProductInfo productInfo = afterSaleOrder.getProductInfo();
        shopOrderAftersale.setProductId(String.valueOf(productInfo.getProductId()));
        shopOrderAftersale.setSkuId(String.valueOf(productInfo.getSkuId()));
        shopOrderAftersale.setSkuCount(Integer.valueOf(productInfo.getCount().intValue()));
        DetailDto details = afterSaleOrder.getDetails();
        shopOrderAftersale.setProductNum(Integer.valueOf(details.getNum().intValue()));
        shopOrderAftersale.setDesc(details.getDesc());
        if (details.getCancelTime() != 0L) {
            shopOrderAftersale.setCancelTime(new Date(details.getCancelTime() * 1000L));
        }
        shopOrderAftersale.setProveImgs(JSON.toJSONString((Object)details.getProveImgs()));
        shopOrderAftersale.setTelNumber(details.getTelNumber());
        RefundInfo refundInfo = afterSaleOrder.getRefundInfo();
        shopOrderAftersale.setRefundAmount(refundInfo.getAmount());
        MerchantUploadInfo merchantUploadInfo = afterSaleOrder.getMerchantUploadInfo();
        shopOrderAftersale.setRejectReason(merchantUploadInfo.getRejectReason());
        shopOrderAftersale.setRefundCertificates(JSON.toJSONString((Object)merchantUploadInfo.getRefundCertifycates()));
        WxShopAfterSaleReason wxShopAfterSaleReason = WxShopAfterSaleReason.getByEnReason(afterSaleOrder.getReason());
        shopOrderAftersale.setReason(Integer.valueOf(wxShopAfterSaleReason != null ? wxShopAfterSaleReason.getType() : -1));
        WxShopAfterSaleType wxShopAfterSaleType = WxShopAfterSaleType.getByEnDesc(afterSaleOrder.getType());
        shopOrderAftersale.setType(Integer.valueOf(wxShopAfterSaleType != null ? wxShopAfterSaleType.getType() : -1));
        shopOrderAftersale.setCreateTime(new Date(afterSaleOrder.getCreateTime() * 1000L));
        shopOrderAftersale.setUpdateTime(new Date(afterSaleOrder.getUpdateTime() * 1000L));
        shopOrderAftersale.setCreateBy(Long.valueOf(-1L));
        shopOrderAftersale.setUpdateBy(Long.valueOf(-1L));
        return shopOrderAftersale;
    }

    private List<ShopOrderAftersale> build(List<AfterSaleOrder> afterSaleOrderList, String appId, String corpId, Long bizId) {
        ArrayList<ShopOrderAftersale> list = new ArrayList<ShopOrderAftersale>();
        for (AfterSaleOrder afterSaleOrder : afterSaleOrderList) {
            ShopOrderAftersale shopOrderAftersale = this.afterSaleOrderToShopOrderAfterSale(afterSaleOrder);
            shopOrderAftersale.setNum(this.idGen.getNum());
            shopOrderAftersale.setBizId(bizId);
            shopOrderAftersale.setCorpId(corpId);
            shopOrderAftersale.setAppId(appId);
            shopOrderAftersale.setOriginalOrderId(String.valueOf(afterSaleOrder.getOriginalOrderId()));
            shopOrderAftersale.setAftersaleOrderId(String.valueOf(afterSaleOrder.getOrderId()));
            shopOrderAftersale.setIsDeleted(Integer.valueOf(0));
            list.add(shopOrderAftersale);
        }
        return list;
    }

    private void checkExistInEsAndUpdate(List<OrderItem> orderList, String appId) {
        Set<OrderEsModel> orderEsModels = this.orderEsService.existsOrderIds(orderList);
        Set existOrderIds = orderEsModels.stream().map(OrderEsModel::getOrderId).collect(Collectors.toSet());
        List<OrderItem> insertOrderItemList = orderList.stream().filter(o -> existOrderIds.contains(o.getOrderId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(insertOrderItemList)) {
            return;
        }
        this.orderEsService.batchUpdateByOrderId(insertOrderItemList, appId);
    }

    private void checkExistInDbAndUpdate(List<OrderItem> orderList, List<Long> orderIds, String appId) {
        AppletInfo appletInfo = this.appletInfoMapper.getByAppId(appId);
        if (appletInfo == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5c0f\u5546\u5e97\u4e0d\u5b58\u5728");
        }
        Set existOrderIds = this.shopOrderMapper.existsOrderIds(appletInfo.getBizId(), orderIds);
        List<OrderItem> updateOrderItemList = orderList.stream().filter(o -> existOrderIds.contains(o.getOrderId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(updateOrderItemList)) {
            return;
        }
        this.handleSyncOrder(updateOrderItemList);
    }

    private void handleSyncOrder(List<OrderItem> insertOrderItemList) {
        ArrayList<ShopOrder> shopOrderList = new ArrayList<ShopOrder>();
        for (OrderItem orderItem : insertOrderItemList) {
            ShopOrder shopOrder = new ShopOrder();
            shopOrder.setOrderId(String.valueOf(orderItem.getOrderId()));
            shopOrder.setStatus(orderItem.getStatus());
            OrderDetailDto orderDetail = orderItem.getOrderDetail();
            PayInfoDto payInfo = orderDetail.getPayInfo();
            shopOrder.setPayMethod(payInfo.getPayMethod());
            shopOrder.setPrepayId(payInfo.getPrepayId());
            if (payInfo.getPrepayTime() != null) {
                shopOrder.setPrepayTime((Date)DateUtil.parse((CharSequence)payInfo.getPrepayTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            shopOrder.setTransactionId(payInfo.getTransactionId());
            if (payInfo.getPayTime() != null) {
                shopOrder.setPayTime((Date)DateUtil.parse((CharSequence)payInfo.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            PriceInfoDto priceInfo = orderDetail.getPriceInfo();
            shopOrder.setProductPrice(priceInfo.getProductPrice());
            shopOrder.setOrderPrice(priceInfo.getOrderPrice());
            shopOrder.setFreight(priceInfo.getFreight());
            shopOrder.setIsDiscounted(priceInfo.getIsDiscounted());
            shopOrder.setDiscountedPrice(priceInfo.getDiscountedPrice());
            shopOrder.setChangeDownPrice(priceInfo.getChangeDownPrice());
            shopOrder.setOpenId(orderItem.getOpenId());
            ExtInfo extInfo = orderItem.getExtInfo();
            if (extInfo != null) {
                shopOrder.setCustomerNotes(extInfo.getCustomerNotes());
                shopOrder.setMerchantNotes(extInfo.getMerchantNotes());
            }
            DeliveryInfoDto deliveryInfoDto = orderDetail.getDeliveryInfoDto();
            shopOrder.setAddressinfo(JSON.toJSONString((Object)deliveryInfoDto.getAddressInfo()));
            shopOrder.setDeliveryInfo(JSON.toJSONString((Object)deliveryInfoDto));
            shopOrder.setCouponCodeInfo(JSON.toJSONString((Object)orderDetail.getCouponCodeInfo()));
            shopOrder.setCreateTime((Date)DateUtil.parse((CharSequence)orderItem.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            shopOrder.setUpdateTime((Date)DateUtil.parse((CharSequence)orderItem.getUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            shopOrder.setUpdateBy(Long.valueOf(-1L));
            shopOrder.setIsDeleted(Integer.valueOf(0));
            shopOrderList.add(shopOrder);
        }
        this.shopOrderMapper.batchUpdate(shopOrderList);
    }
}

