/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.shop.service.datasync;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.kinyun.scrm.weixin.sdk.api.shop.WxShopOrderAPI;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.CouponInfoDto;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.DeliveryInfoDto;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.ExtInfo;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.OrderDetailDto;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.OrderItem;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.PayInfoDto;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.PriceInfoDto;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.OrderGetListReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.OrderGetListResp;
import com.alibaba.fastjson.JSON;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.applet.dto.PullResult;
import com.kuaike.scrm.applet.service.AppletAccessTokenService;
import com.kuaike.scrm.applet.service.shopdatasync.AbstractPullService;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.dal.shop.entity.AppletInfo;
import com.kuaike.scrm.dal.shop.entity.ShopOrder;
import com.kuaike.scrm.dal.shop.mapper.AppletInfoMapper;
import com.kuaike.scrm.dal.shop.mapper.ShopOrderMapper;
import com.kuaike.scrm.shop.dto.OrderEsModel;
import com.kuaike.scrm.shop.service.OrderEsService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class OrderCreatePullService
extends AbstractPullService {
    private static final Logger log = LoggerFactory.getLogger(OrderCreatePullService.class);
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private AppletAccessTokenService appletAccessTokenService;
    @Resource
    private WxShopOrderAPI wxShopOrderAPI;
    @Resource
    private AppletInfoMapper appletInfoMapper;
    @Resource
    private ShopOrderMapper shopOrderMapper;
    @Resource
    private IdGen idGen;
    private static final String ORDER_CREATE_LAST_CREATE_TIME_KEY = "orderCreateLastCreateTime";
    @Resource
    private OrderEsService orderEsService;

    public String getKey() {
        String key = "orderCreate";
        Integer status = (Integer)this.paramMap.get("status");
        if (Objects.nonNull(status)) {
            key = key + ":" + status;
        }
        return key;
    }

    public String getStartTime(String appId) {
        String value = (String)this.stringRedisTemplate.opsForHash().get((Object)appId, (Object)this.getHashKey());
        return StringUtils.isNotBlank((CharSequence)value) ? value : "1970-01-02 00:00:00";
    }

    public int getTotalNum(String appId) {
        return 0;
    }

    public void saveTotalNum(String appId, int newTotalNum) {
    }

    private String getHashKey() {
        Integer status;
        String hashKey = ORDER_CREATE_LAST_CREATE_TIME_KEY;
        if (MapUtils.isNotEmpty((Map)this.paramMap) && Objects.nonNull(status = (Integer)this.paramMap.get("status"))) {
            hashKey = hashKey + ":" + status;
        }
        return hashKey;
    }

    public int getPageSize() {
        return 30;
    }

    public PullResult doPull(String appId, String startTime, String endTime, int page, int pageSize) {
        String accessToken = this.appletAccessTokenService.getAccessToken(appId);
        OrderGetListReq req = this.buildReq(page, pageSize, startTime, endTime);
        OrderGetListResp orderList = this.getOrderList(accessToken, req);
        log.info("\u6839\u636ecreateTime\u540c\u6b65\u5c0f\u5546\u5e97\u8ba2\u5355\uff0cstartTime:{}\uff0cendTime:{}\uff0creq:{}\uff0cresp:{}", new Object[]{startTime, endTime, req, orderList.toString()});
        PullResult pullResult = new PullResult();
        pullResult.setResultList(orderList.getOrders());
        pullResult.setTotalNum(Integer.valueOf(orderList.getTotalNum().intValue()));
        return pullResult;
    }

    private OrderGetListReq buildReq(int page, int pageSize, String startTime, String endTime) {
        Integer status;
        OrderGetListReq req = new OrderGetListReq();
        req.setPage(Integer.valueOf(page));
        req.setPageSize(Integer.valueOf(pageSize));
        if (MapUtils.isNotEmpty((Map)this.paramMap) && Objects.nonNull(status = (Integer)this.paramMap.get("status"))) {
            req.setStatus(status);
        }
        req.setStartCreateTime(startTime);
        req.setEndCreateTime(endTime);
        return req;
    }

    private OrderGetListResp getOrderList(String token, OrderGetListReq req) {
        int retry = 3;
        while (retry != 0) {
            try {
                return this.wxShopOrderAPI.orderGetList(token, req);
            }
            catch (Exception e) {
                log.error("\u540c\u6b65\u8ba2\u5355\u6570\u636e\uff0c\u8bf7\u6c42\u5fae\u4fe1\u5f02\u5e38\uff0c\u5269\u4f59\u91cd\u8bd5\u6b21\u6570:{}", (Object)(--retry), (Object)e);
            }
        }
        log.error("\u540c\u6b65\u8ba2\u5355\u6570\u636e\uff0c\u8bf7\u6c42\u5fae\u4fe1\u5f02\u5e38");
        throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR);
    }

    protected void save(String appId, PullResult result) {
        super.save(appId, result);
        ArrayList<OrderItem> orderList = new ArrayList<OrderItem>();
        ArrayList<Long> orderIds = new ArrayList<Long>();
        DateTime lastCreateTime = null;
        for (Object item : result.getResultList()) {
            OrderItem orderItem = (OrderItem)item;
            orderList.add(orderItem);
            orderIds.add(orderItem.getOrderId());
            DateTime createTime = DateUtil.parse((CharSequence)orderItem.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss");
            if (lastCreateTime != null && createTime.getTime() <= lastCreateTime.getTime()) continue;
            lastCreateTime = createTime;
        }
        lastCreateTime = DateUtil.offsetSecond(lastCreateTime, (int)-1);
        this.stringRedisTemplate.opsForHash().put((Object)appId, (Object)this.getHashKey(), (Object)DateUtil.format((Date)lastCreateTime, (String)"yyyy-MM-dd HH:mm:ss"));
        this.checkExistInDbAndInsert(orderList, orderIds, appId);
        this.checkExistInEsAndInsert(orderList, appId);
    }

    private void checkExistInEsAndInsert(List<OrderItem> orderList, String appId) {
        List<Object> insertOrderItemList;
        Set<OrderEsModel> orderEsModels = this.orderEsService.existsOrderIds(orderList);
        if (CollectionUtils.isNotEmpty(orderEsModels)) {
            Set existOrderIds = orderEsModels.stream().map(OrderEsModel::getOrderId).collect(Collectors.toSet());
            insertOrderItemList = orderList.stream().filter(o -> !existOrderIds.contains(o.getOrderId())).collect(Collectors.toList());
        } else {
            insertOrderItemList = orderList;
        }
        this.orderEsService.batchInsertOrders(insertOrderItemList, appId);
    }

    private void checkExistInDbAndInsert(List<OrderItem> orderList, List<Long> orderIds, String appId) {
        AppletInfo appletInfo = this.appletInfoMapper.getByAppId(appId);
        if (appletInfo == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5c0f\u5546\u5e97\u4e0d\u5b58\u5728");
        }
        Set existOrderIds = this.shopOrderMapper.existsOrderIds(appletInfo.getBizId(), orderIds);
        List<OrderItem> insertOrderItemList = orderList.stream().filter(o -> !existOrderIds.contains(o.getOrderId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(insertOrderItemList)) {
            return;
        }
        this.handleSyncOrder(insertOrderItemList, appletInfo.getBizId(), appletInfo.getCorpId(), appId);
    }

    private void handleSyncOrder(List<OrderItem> insertOrderItemList, Long bizId, String corpId, String appId) {
        ArrayList<ShopOrder> shopOrderList = new ArrayList<ShopOrder>();
        for (OrderItem orderItem : insertOrderItemList) {
            ShopOrder shopOrder = new ShopOrder();
            shopOrder.setNum(this.idGen.getNum());
            shopOrder.setBizId(bizId);
            shopOrder.setCorpId(corpId);
            shopOrder.setAppId(appId);
            shopOrder.setOrderId(String.valueOf(orderItem.getOrderId()));
            shopOrder.setOutOrderId("0");
            shopOrder.setStatus(orderItem.getStatus());
            OrderDetailDto orderDetail = orderItem.getOrderDetail();
            PayInfoDto payInfo = orderDetail.getPayInfo();
            shopOrder.setPayMethod(payInfo.getPayMethod());
            shopOrder.setPrepayId(payInfo.getPrepayId());
            shopOrder.setTransactionId(payInfo.getTransactionId());
            if (payInfo.getPayTime() != null) {
                shopOrder.setPayTime((Date)DateUtil.parse((CharSequence)payInfo.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            shopOrder.setPrepayTime((Date)DateUtil.parse((CharSequence)payInfo.getPrepayTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            PriceInfoDto priceInfo = orderDetail.getPriceInfo();
            shopOrder.setProductPrice(priceInfo.getProductPrice());
            shopOrder.setOrderPrice(priceInfo.getOrderPrice());
            shopOrder.setFreight(priceInfo.getFreight());
            shopOrder.setIsDiscounted(priceInfo.getIsDiscounted());
            shopOrder.setDiscountedPrice(priceInfo.getDiscountedPrice());
            shopOrder.setChangeDownPrice(priceInfo.getChangeDownPrice());
            shopOrder.setOpenId(orderItem.getOpenId());
            ExtInfo extInfo = orderItem.getExtInfo();
            if (extInfo != null) {
                shopOrder.setCustomerNotes(extInfo.getCustomerNotes());
                shopOrder.setMerchantNotes(extInfo.getMerchantNotes());
            }
            DeliveryInfoDto deliveryInfoDto = orderDetail.getDeliveryInfoDto();
            shopOrder.setAddressinfo(JSON.toJSONString((Object)deliveryInfoDto.getAddressInfo()));
            shopOrder.setDeliveryInfo(JSON.toJSONString((Object)deliveryInfoDto));
            shopOrder.setCouponCodeInfo(JSON.toJSONString((Object)orderDetail.getCouponCodeInfo()));
            shopOrder.setCreateBy(Long.valueOf(-1L));
            shopOrder.setUpdateBy(Long.valueOf(-1L));
            shopOrder.setCreateTime((Date)DateUtil.parse((CharSequence)orderItem.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            shopOrder.setUpdateTime((Date)DateUtil.parse((CharSequence)orderItem.getUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            shopOrder.setIsDeleted(Integer.valueOf(0));
            shopOrderList.add(shopOrder);
            CouponInfoDto couponInfo = orderDetail.getCouponInfo();
            for (String couponId : couponInfo.getCouponId()) {
                this.stringRedisTemplate.opsForHash().put((Object)("shop:waitSyncCouponIds:" + appId), (Object)String.valueOf(couponId), (Object)String.valueOf(couponId));
            }
        }
        this.shopOrderMapper.batchInsert(shopOrderList);
    }
}

