/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.shop.enums;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public enum WxShopSpuStatus {
    INIT(0, "\u521d\u59cb\u503c"),
    LISTING(5, "\u4e0a\u67b6"),
    RECYCLE_BIN(6, "\u56de\u6536\u7ad9"),
    LOGIC_DELETED(9, "\u903b\u8f91\u5220\u9664"),
    SELF_DELISTING(11, "\u81ea\u4e3b\u4e0b\u67b6"),
    SOLD_OUT_DELISTING(12, "\u552e\u7f44\u4e0b\u67b6"),
    VIOLATION_DELISTING(13, "\u8fdd\u89c4\u4e0b\u67b6/\u98ce\u63a7\u7cfb\u7edf\u4e0b\u67b6");

    private int status;
    private String desc;
    private static final Map<Integer, WxShopSpuStatus> MAP;

    public int getStatus() {
        return this.status;
    }

    public String getDesc() {
        return this.desc;
    }

    private WxShopSpuStatus(int status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public static WxShopSpuStatus getByStatus(int status) {
        return MAP.get(status);
    }

    public static Set<Integer> getAllStatus() {
        return Sets.newHashSet(MAP.keySet());
    }

    static {
        MAP = Arrays.stream(WxShopSpuStatus.values()).collect(Collectors.toMap(WxShopSpuStatus::getStatus, a -> a));
    }
}

