/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.shop.enums;

import com.google.common.collect.Maps;
import java.util.Map;

public enum WxShopAfterSaleType {
    REFUND(1, "\u9000\u6b3e", "REFUND"),
    RETURN(2, "\u9000\u8d27\u9000\u6b3e", "RETURN");

    private Integer type;
    private String desc;
    private String enDesc;
    private static Map<Integer, WxShopAfterSaleType> map;
    private static Map<String, WxShopAfterSaleType> enDescMap;

    private WxShopAfterSaleType(Integer type, String desc, String enDesc) {
        this.type = type;
        this.desc = desc;
        this.enDesc = enDesc;
    }

    public static boolean isExistByType(int type) {
        return map.containsKey(type);
    }

    public static String getDescByType(int type) {
        return map.containsKey(type) ? map.get(type).getDesc() : null;
    }

    public static WxShopAfterSaleType getByEnDesc(String enDesc) {
        return enDescMap.getOrDefault(enDesc, null);
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getEnDesc() {
        return this.enDesc;
    }

    static {
        map = Maps.newHashMap();
        enDescMap = Maps.newHashMap();
        for (WxShopAfterSaleType type : WxShopAfterSaleType.values()) {
            map.put(type.type, type);
            enDescMap.put(type.getEnDesc(), type);
        }
    }
}

