/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.shop.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.kinyun.customer.center.dto.req.order.OrderRecordReq;
import cn.kinyun.customer.center.dto.req.order.SetOrderPayStatusReq;
import cn.kinyun.customer.center.enums.ModuleType;
import cn.kinyun.customer.center.enums.OrderSource;
import cn.kinyun.customer.center.enums.PayChannelType;
import cn.kinyun.customer.center.enums.PayStatusEnum;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import cn.kinyun.customer.center.service.CcCustomerOrderService;
import cn.kinyun.pay.business.dto.vo.PayMessageDto;
import cn.kinyun.pay.business.enums.PayMessageType;
import cn.kinyun.scrm.weixin.sdk.api.shop.WxShopOrderAPI;
import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;
import cn.kinyun.scrm.weixin.sdk.entity.message.event.ProductOrderStatusEvent;
import cn.kinyun.scrm.weixin.sdk.entity.message.event.ProductOrderStatusUpdateInfo;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.AttrItem;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.CouponCodeInfo;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.CouponInfoDto;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.DeliveryInfoDto;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.ExtInfo;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.OrderDetailDto;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.OrderItem;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.PayInfoDto;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.PriceInfoDto;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.ProductInfo;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.SkuItem;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.address.AddressInfo;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.OrderChangeNoteReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.OrderDetailReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.OrderDetailResp;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.common.enums.order.PayStatus;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.applet.service.AppletAccessTokenService;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.GoodsOrderSource;
import com.kuaike.scrm.common.service.CustomerDetailSupportService;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.meeting.entity.MeetingCustomerInfo;
import com.kuaike.scrm.dal.meeting.mapper.MeetingCustomerInfoMapper;
import com.kuaike.scrm.dal.shop.entity.AppletInfo;
import com.kuaike.scrm.dal.shop.entity.ShopOrder;
import com.kuaike.scrm.dal.shop.entity.ShopOrderAftersale;
import com.kuaike.scrm.dal.shop.entity.ShopSku;
import com.kuaike.scrm.dal.shop.mapper.AppletInfoMapper;
import com.kuaike.scrm.dal.shop.mapper.ShopOrderAftersaleMapper;
import com.kuaike.scrm.dal.shop.mapper.ShopOrderMapper;
import com.kuaike.scrm.dal.shop.mapper.ShopSkuMapper;
import com.kuaike.scrm.enums.AppletUseBusinessType;
import com.kuaike.scrm.shop.dto.OrderEsModel;
import com.kuaike.scrm.shop.dto.order.ChangeMerchantNotesReqDto;
import com.kuaike.scrm.shop.dto.order.CustomerInfoDto;
import com.kuaike.scrm.shop.dto.order.DynamicOrderExportDataDto;
import com.kuaike.scrm.shop.dto.order.OrderAfterSaleInfoDto;
import com.kuaike.scrm.shop.dto.order.OrderBaseInfoDto;
import com.kuaike.scrm.shop.dto.order.OrderDetailReqDto;
import com.kuaike.scrm.shop.dto.order.OrderDetailRespDto;
import com.kuaike.scrm.shop.dto.order.OrderLisQueryParam;
import com.kuaike.scrm.shop.dto.order.OrderListRespDto;
import com.kuaike.scrm.shop.dto.order.OrderProductInfoDto;
import com.kuaike.scrm.shop.dto.order.StatisticsCountByStatusRespDto;
import com.kuaike.scrm.shop.enums.WxShopOrderStatus;
import com.kuaike.scrm.shop.service.OrderEsService;
import com.kuaike.scrm.shop.service.ShopOrderService;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ShopOrderServiceImpl
implements ShopOrderService {
    private static final Logger log = LoggerFactory.getLogger(ShopOrderServiceImpl.class);
    @Resource
    private ShopOrderMapper shopOrderMapper;
    @Resource
    private ShopOrderAftersaleMapper shopOrderAftersaleMapper;
    @Resource
    private AppletInfoMapper appletInfoMapper;
    @Resource
    private OrderEsService orderEsService;
    @Resource
    private WxShopOrderAPI wxShopOrderAPI;
    @Resource
    private AppletAccessTokenService appletAccessTokenService;
    @Resource
    private ShopSkuMapper shopSkuMapper;
    @Resource
    private IdGen idGen;
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    private CcCustomerOrderService ccCustomerOrderService;
    @Resource
    private CcCustomerNumService ccCustomerNumService;
    @Resource
    private MeetingCustomerInfoMapper meetingCustomerInfoMapper;
    @Autowired
    private CustomerDetailSupportService customerDetailSupportService;

    @Override
    public StatisticsCountByStatusRespDto statisticsCountByStatus() {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((userInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        String appId = this.getAppId(userInfo);
        Long waitPayCount = this.orderEsService.getOrderCountByStatus(WxShopOrderStatus.WAIT_PAY.getStatus(), appId);
        Long waitDeliveryCount = this.orderEsService.getOrderCountByStatus(WxShopOrderStatus.WAIT_DELIVERY.getStatus(), appId);
        Long waitOrderCount = this.orderEsService.getOrderCountByStatus(WxShopOrderStatus.WAIT_GROUP.getStatus(), appId);
        StatisticsCountByStatusRespDto respDto = new StatisticsCountByStatusRespDto();
        respDto.setWaitPayCount(waitPayCount);
        respDto.setWaitDeliveryCount(waitDeliveryCount);
        respDto.setWaitOrderCount(waitOrderCount);
        return respDto;
    }

    private String getAppId(CurrentUserInfo userInfo) {
        AppletInfo shopExist = new AppletInfo();
        shopExist.setBizId(userInfo.getBizId());
        shopExist.setAuthStatus(Integer.valueOf(1));
        shopExist.setBusinessType(AppletUseBusinessType.WX_SHOP.getType());
        AppletInfo appletInfo = (AppletInfo)this.appletInfoMapper.selectOne((Object)shopExist);
        Preconditions.checkArgument((appletInfo != null ? 1 : 0) != 0, (Object)"\u5c0f\u5546\u5e97\u4e0d\u5b58\u5728\u6216\u5df2\u53d6\u6d88\u6388\u6743");
        return appletInfo.getAppId();
    }

    @Override
    public List<OrderListRespDto> list(OrderLisQueryParam dto) {
        log.info("list,dto:{}", (Object)dto);
        dto.validate();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((userInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        String appId = this.getAppId(userInfo);
        Pair<List<OrderEsModel>, Long> pair = this.orderEsService.queryOrderList(dto, false, false, appId);
        if (Objects.nonNull(dto.getPageDto())) {
            dto.getPageDto().setCount(Integer.valueOf(((Long)pair.getRight()).intValue()));
            dto.getPageDto().setCurPageCount(Integer.valueOf(((List)pair.getLeft()).size()));
        }
        List left = (List)pair.getLeft();
        dto.getPageDto().setCount(Integer.valueOf(((Long)pair.getRight()).intValue()));
        return this.buildListResp(left);
    }

    private List<OrderListRespDto> buildListResp(List<OrderEsModel> orderEsModels) {
        ArrayList<OrderListRespDto> list = new ArrayList<OrderListRespDto>();
        for (OrderEsModel esModel : orderEsModels) {
            OrderListRespDto respDto = new OrderListRespDto();
            respDto.setOrderId(String.valueOf(esModel.getOrderId()));
            respDto.setOrderStatus(esModel.getStatus());
            OrderDetailDto orderDetail = esModel.getOrderDetail();
            PayInfoDto payInfo = orderDetail.getPayInfo();
            respDto.setPayTime(payInfo.getPayTime());
            respDto.setPrepayTime(payInfo.getPrepayTime());
            ArrayList<OrderProductInfoDto> productInfoDtos = new ArrayList<OrderProductInfoDto>();
            for (ProductInfo productInfo : orderDetail.getProductInfos()) {
                OrderProductInfoDto dto = new OrderProductInfoDto();
                dto.setProductName(productInfo.getTitle());
                dto.setProductAttrs(productInfo.getSkuAttrs());
                dto.setProductPrice(productInfo.getSalePrice());
                dto.setProductCount(productInfo.getSkuCnt() != null ? productInfo.getSkuCnt().intValue() : 0);
                dto.setProductFirstImg(productInfo.getThumbImg());
                ShopOrderAftersale select = new ShopOrderAftersale();
                select.setOriginalOrderId(esModel.getOrderId());
                select.setSkuId(String.valueOf(productInfo.getSkuId()));
                List orderAftersales = this.shopOrderAftersaleMapper.select((Object)select);
                if (CollectionUtils.isNotEmpty((Collection)orderAftersales)) {
                    dto.setAfterSaleStatus(((ShopOrderAftersale)orderAftersales.get(0)).getStatus());
                }
                productInfoDtos.add(dto);
            }
            respDto.setProductInfo(productInfoDtos);
            PriceInfoDto priceInfo = orderDetail.getPriceInfo();
            respDto.setOrderPrice(priceInfo.getOrderPrice());
            respDto.setDiscountedPrice(priceInfo.getDiscountedPrice());
            respDto.setChangeDownPrice(priceInfo.getChangeDownPrice());
            respDto.setOpenId(esModel.getOpenId());
            ExtInfo extInfo = esModel.getExtInfo();
            if (extInfo != null) {
                respDto.setMerchantNotes(extInfo.getMerchantNotes());
            }
            DeliveryInfoDto deliveryInfoDto = orderDetail.getDeliveryInfoDto();
            CouponCodeInfo couponCodeInfo = orderDetail.getCouponCodeInfo();
            if (couponCodeInfo != null) {
                respDto.setAddressTelNumber(couponCodeInfo.getPhoneNumber());
                respDto.setAddressUserName(couponCodeInfo.getVerifierNickname());
            }
            if (deliveryInfoDto != null) {
                AddressInfo addressInfo = deliveryInfoDto.getAddressInfo();
                if (StringUtils.isBlank((CharSequence)respDto.getAddressUserName())) {
                    respDto.setAddressUserName(addressInfo.getUserName());
                }
                if (StringUtils.isBlank((CharSequence)respDto.getAddressTelNumber())) {
                    respDto.setAddressTelNumber(addressInfo.getTelNumber());
                }
            }
            respDto.setPhone(respDto.getAddressTelNumber());
            list.add(respDto);
        }
        List mobiles = list.stream().map(OrderListRespDto::getAddressTelNumber).collect(Collectors.toList());
        this.customerDetailSupportService.setCustomerDetailParams(LoginUtils.getCurrentUserBizId(), mobiles, list);
        return list;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changeMerchantNotes(ChangeMerchantNotesReqDto dto) {
        ErrorCode errorCode;
        log.info("changeMerchantNotes,dto:{}", (Object)dto);
        dto.validate();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((userInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        ShopOrder exist = new ShopOrder();
        exist.setOrderId(dto.getOrderId());
        ShopOrder existOrder = (ShopOrder)this.shopOrderMapper.selectOne((Object)exist);
        Preconditions.checkArgument((existOrder != null ? 1 : 0) != 0, (Object)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        OrderChangeNoteReq req = new OrderChangeNoteReq();
        req.setMerchantNotes(dto.getMerchantNotes());
        req.setOrderId(Long.valueOf(existOrder.getOrderId()));
        try {
            errorCode = this.wxShopOrderAPI.modOrderNote(this.appletAccessTokenService.getAccessToken(existOrder.getAppId()), req);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u5fae\u4fe1\u4fee\u6539\u8ba2\u5355\u5907\u6ce8\u63a5\u53e3\u5f02\u5e38,req={}", (Object)req, (Object)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR);
        }
        if (!errorCode.getErrCode().equals(0)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, errorCode.getErrMsg());
        }
        ShopOrder update = new ShopOrder();
        update.setId(existOrder.getId());
        update.setMerchantNotes(dto.getMerchantNotes());
        log.info("changeMerchantNotes,before:{}", (Object)existOrder.getMerchantNotes());
        this.shopOrderMapper.updateByPrimaryKeySelective((Object)update);
        this.orderEsService.updateMerchantNoteByOrderId(existOrder.getOrderId(), dto.getMerchantNotes());
    }

    @Override
    public OrderDetailRespDto detail(OrderDetailReqDto dto) {
        DeliveryInfoDto deliveryInfoDto;
        log.info("OrderDetailReqDto,dto:{}", (Object)dto);
        dto.validate();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((userInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        ShopOrder exist = new ShopOrder();
        exist.setOrderId(dto.getOrderId());
        ShopOrder existOrder = (ShopOrder)this.shopOrderMapper.selectOne((Object)exist);
        Preconditions.checkArgument((existOrder != null ? 1 : 0) != 0, (Object)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        OrderEsModel orderEsModel = this.orderEsService.queryOrderByOrderId(existOrder.getOrderId());
        OrderDetailRespDto respDto = new OrderDetailRespDto();
        OrderBaseInfoDto baseInfoDto = new OrderBaseInfoDto();
        baseInfoDto.setOrderStatus(existOrder.getStatus());
        baseInfoDto.setOrderId(existOrder.getOrderId().toString());
        baseInfoDto.setPayTime(existOrder.getPayTime() != null ? com.kuaike.scrm.common.utils.DateUtil.dateToDateString((Date)existOrder.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss") : "");
        baseInfoDto.setPayMethod(existOrder.getPayMethod());
        baseInfoDto.setTransactionId(existOrder.getTransactionId());
        baseInfoDto.setPrepayTime(existOrder.getPrepayTime() != null ? com.kuaike.scrm.common.utils.DateUtil.dateToDateString((Date)existOrder.getPrepayTime(), (String)"yyyy-MM-dd HH:mm:ss") : "");
        respDto.setBaseInfo(baseInfoDto);
        OrderDetailDto orderDetail = orderEsModel.getOrderDetail();
        List productInfos = orderDetail.getProductInfos();
        ArrayList<OrderProductInfoDto> productInfoDto = new ArrayList<OrderProductInfoDto>();
        HashMap<Long, ProductInfo> skuIdAndProductMap = new HashMap<Long, ProductInfo>();
        for (ProductInfo productInfo : productInfos) {
            OrderProductInfoDto infoDto = new OrderProductInfoDto();
            infoDto.setProductName(productInfo.getTitle());
            infoDto.setProductAttrs(productInfo.getSkuAttrs());
            infoDto.setProductPrice(productInfo.getSalePrice());
            if (GoodsOrderSource.WX_SHOP.getSource() == existOrder.getSource().intValue()) {
                infoDto.setProductPrice(productInfo.getSalePrice() * 100L);
            }
            infoDto.setProductCount(productInfo.getSkuCnt() != null ? productInfo.getSkuCnt().intValue() : 0);
            infoDto.setProductFirstImg(productInfo.getThumbImg());
            productInfoDto.add(infoDto);
            skuIdAndProductMap.put(productInfo.getSkuId(), productInfo);
        }
        respDto.setProductInfo(productInfoDto);
        CustomerInfoDto customerInfoDto = new CustomerInfoDto();
        AddressInfo addressInfo = (AddressInfo)JSON.parseObject((String)existOrder.getAddressinfo(), AddressInfo.class);
        CouponCodeInfo couponCodeInfo = orderDetail.getCouponCodeInfo();
        if (couponCodeInfo != null) {
            customerInfoDto.setAddressTelNumber(couponCodeInfo.getPhoneNumber());
            customerInfoDto.setAddressUserName(couponCodeInfo.getVerifierNickname());
        }
        if ((deliveryInfoDto = orderDetail.getDeliveryInfoDto()) != null) {
            if (StringUtils.isBlank((CharSequence)customerInfoDto.getAddressUserName())) {
                customerInfoDto.setAddressUserName(addressInfo.getUserName());
            }
            if (StringUtils.isBlank((CharSequence)customerInfoDto.getAddressTelNumber())) {
                customerInfoDto.setAddressTelNumber(addressInfo.getTelNumber());
            }
        }
        customerInfoDto.setAddressProvinceName(addressInfo.getProvinceName());
        customerInfoDto.setAddressCityName(addressInfo.getCityName());
        respDto.setCustomerInfo(customerInfoDto);
        PriceInfoDto priceInfo = orderDetail.getPriceInfo();
        PriceInfoDto priceInfoDto = new PriceInfoDto();
        priceInfoDto.setOrderPrice(priceInfo.getOrderPrice());
        priceInfoDto.setDiscountedPrice(priceInfo.getDiscountedPrice());
        priceInfoDto.setChangeDownPrice(priceInfo.getChangeDownPrice());
        priceInfoDto.setFreight(priceInfo.getFreight());
        priceInfoDto.setIsDiscounted(priceInfo.getIsDiscounted());
        priceInfoDto.setProductPrice(priceInfo.getProductPrice());
        if (GoodsOrderSource.WX_SHOP.getSource() == existOrder.getSource().intValue()) {
            priceInfoDto.setOrderPrice(Long.valueOf(priceInfo.getOrderPrice() * 100L));
            priceInfoDto.setDiscountedPrice(priceInfo.getDiscountedPrice() == null ? null : Long.valueOf(priceInfo.getDiscountedPrice() * 100L));
            priceInfoDto.setChangeDownPrice(priceInfo.getChangeDownPrice() == null ? null : Long.valueOf(priceInfo.getChangeDownPrice() * 100L));
            priceInfoDto.setFreight(priceInfo.getFreight() == null ? null : Long.valueOf(priceInfo.getFreight() * 100L));
            priceInfoDto.setProductPrice(priceInfo.getProductPrice() == null ? null : Long.valueOf(priceInfo.getProductPrice() * 100L));
        }
        respDto.setPriceInfo(priceInfoDto);
        ArrayList<OrderAfterSaleInfoDto> afterSaleInfo = new ArrayList<OrderAfterSaleInfoDto>();
        ShopOrderAftersale afterSale = new ShopOrderAftersale();
        afterSale.setOriginalOrderId(existOrder.getOrderId());
        List orderAfterSales = this.shopOrderAftersaleMapper.select((Object)afterSale);
        for (ShopOrderAftersale shopOrderAfterSale : orderAfterSales) {
            OrderAfterSaleInfoDto orderAfterSaleInfoDto = new OrderAfterSaleInfoDto();
            orderAfterSaleInfoDto.setAfterSaleOrderId(shopOrderAfterSale.getAftersaleOrderId());
            orderAfterSaleInfoDto.setProductCount(shopOrderAfterSale.getSkuCount());
            orderAfterSaleInfoDto.setAfterSaleStatus(shopOrderAfterSale.getStatus());
            orderAfterSaleInfoDto.setAfterSaleReason(shopOrderAfterSale.getReason());
            orderAfterSaleInfoDto.setCreateTime(com.kuaike.scrm.common.utils.DateUtil.dateToDateString((Date)shopOrderAfterSale.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            ProductInfo productInfo = (ProductInfo)skuIdAndProductMap.get(shopOrderAfterSale.getSkuId());
            orderAfterSaleInfoDto.setProductName(productInfo.getTitle());
            orderAfterSaleInfoDto.setProductAttrs(productInfo.getSkuAttrs());
            orderAfterSaleInfoDto.setProductPrice(shopOrderAfterSale.getRefundAmount() * 100L);
            orderAfterSaleInfoDto.setProductFirstImg(productInfo.getThumbImg());
            afterSaleInfo.add(orderAfterSaleInfoDto);
        }
        respDto.setAfterSaleInfo(afterSaleInfo);
        return respDto;
    }

    @Override
    public void export(HttpServletResponse response, OrderLisQueryParam dto) {
        log.info("export,dto:{}", (Object)dto);
        dto.validate();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((userInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        ArrayList<OrderEsModel> allData = new ArrayList<OrderEsModel>();
        int curPage = 1;
        int pageSize = 100;
        PageDto pageDto = new PageDto();
        dto.setPageDto(pageDto);
        dto.getPageDto().setPageSize(Integer.valueOf(pageSize));
        dto.getPageDto().setPageNum(Integer.valueOf(curPage));
        String appId = this.getAppId(userInfo);
        boolean doWhile = true;
        do {
            log.info("\u5206\u9875\u67e5\u8be2ES \u5bfc\u51fa\u8ba2\u5355\u6570\u636e \u5f53\u524d\u9875:{}", (Object)curPage);
            Pair<List<OrderEsModel>, Long> pair = this.orderEsService.queryOrderList(dto, false, true, appId);
            List data = (List)pair.getLeft();
            if (CollectionUtils.isEmpty((Collection)data)) break;
            long totalPage = (Long)pair.getRight() / (long)pageSize + (long)((Long)pair.getRight() % (long)pageSize != 0L ? 1 : 0);
            log.info("\u5206\u9875\u67e5\u8be2ES \u5bfc\u51fa\u8ba2\u5355\u6570\u636e \u603b\u9875\u6570:{}", (Object)totalPage);
            if (totalPage > (long)curPage) {
                dto.getPageDto().setPageNum(Integer.valueOf(++curPage));
            } else {
                doWhile = false;
            }
            allData.addAll(data);
        } while (doWhile);
        DynamicOrderExportDataDto res = this.dynamicOrderExportData(allData);
        try {
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("utf-8");
            String fileName = URLEncoder.encode("\u8ba2\u5355\u6570\u636e_" + System.currentTimeMillis() + ".xlsx", "UTF-8");
            response.setHeader("Content-disposition", "attachment;filename=" + fileName);
            List<List<String>> head = this.dynamicOrderExportHead(res.getMaxProductCount());
            List<List<Object>> data = res.getData();
            ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream()).head(head)).sheet("\u8ba2\u5355\u6570\u636e").doWrite(data);
        }
        catch (Exception e) {
            log.error("\u8ba2\u5355\u5bfc\u51fa\u5f02\u5e38", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5bfc\u51fa\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }

    private DynamicOrderExportDataDto dynamicOrderExportData(List<OrderEsModel> esModelList) {
        DynamicOrderExportDataDto res = new DynamicOrderExportDataDto();
        ArrayList<List<Object>> dataList = new ArrayList<List<Object>>();
        int maxProductCount = 0;
        for (OrderEsModel esModel : esModelList) {
            ArrayList<Object> data = new ArrayList<Object>();
            data.add(String.valueOf(esModel.getOrderId()));
            OrderDetailDto orderDetail = esModel.getOrderDetail();
            PayInfoDto payInfo = orderDetail.getPayInfo();
            data.add(payInfo.getPayTime());
            WxShopOrderStatus wxShopOrderStatus = WxShopOrderStatus.getByStatus(esModel.getStatus());
            data.add(wxShopOrderStatus != null ? wxShopOrderStatus.getDesc() : "-");
            data.add(esModel.getOpenId());
            DeliveryInfoDto deliveryInfoDto = orderDetail.getDeliveryInfoDto();
            if (deliveryInfoDto != null) {
                AddressInfo addressInfo = deliveryInfoDto.getAddressInfo();
                data.add(addressInfo.getUserName());
                String address = (addressInfo.getProvinceName() != null ? addressInfo.getProvinceName() : "") + (addressInfo.getCityName() != null ? addressInfo.getCityName() : "") + (addressInfo.getCountyName() != null ? addressInfo.getCountyName() : "") + (addressInfo.getDetailInfo() != null ? addressInfo.getDetailInfo() : "");
                data.add(address);
                data.add(addressInfo.getTelNumber());
            } else {
                data.add("");
                data.add("");
                data.add("");
            }
            ExtInfo extInfo = esModel.getExtInfo();
            if (extInfo != null) {
                data.add(extInfo.getCustomerNotes());
                data.add(extInfo.getMerchantNotes());
            } else {
                data.add("");
                data.add("");
            }
            PriceInfoDto priceInfo = orderDetail.getPriceInfo();
            data.add(priceInfo.getOrderPrice());
            data.add(payInfo.getPayMethod());
            data.add(payInfo.getPayTime());
            data.add(payInfo.getTransactionId());
            List productInfos = orderDetail.getProductInfos();
            List productIds = productInfos.stream().map(p -> String.valueOf(p.getProductId())).collect(Collectors.toList());
            List shopSkus = this.shopSkuMapper.queryByProductIds(esModel.getAppId(), productIds);
            HashMap<String, String> productIdAndSkuCodeMap = new HashMap<String, String>();
            for (ShopSku shopSku : shopSkus) {
                SkuItem skuItem = null;
                try {
                    skuItem = (SkuItem)JSON.parseObject((String)shopSku.getSkuBody(), SkuItem.class);
                }
                catch (Exception e) {
                    log.error("\u8ba2\u5355\u5bfc\u51fa\uff0cshopSkuBody \u8f6c\u6362\u6210SkuItem\u5f02\u5e38", (Throwable)e);
                    continue;
                }
                productIdAndSkuCodeMap.put(shopSku.getProductId(), skuItem.getSkuCode());
            }
            maxProductCount = Math.max(maxProductCount, productInfos.size());
            for (ProductInfo productInfo : productInfos) {
                data.add(productInfo.getProductId());
                data.add(productIdAndSkuCodeMap.getOrDefault(String.valueOf(productInfo.getProductId()), ""));
                data.add(productInfo.getTitle());
                List skuAttrs = productInfo.getSkuAttrs();
                StringBuilder stringBuilder = new StringBuilder();
                for (AttrItem attrItem : skuAttrs) {
                    stringBuilder.append(attrItem.getAttrKey()).append(':').append(attrItem.getAttrValue()).append(';');
                }
                if (StringUtils.isNotBlank((CharSequence)stringBuilder)) {
                    data.add(stringBuilder.substring(0, stringBuilder.length() - 1));
                } else {
                    data.add("");
                }
                data.add(productInfo.getSalePrice().doubleValue() / 100.0);
                data.add(productInfo.getSkuCnt());
                ShopOrderAftersale select = new ShopOrderAftersale();
                select.setOriginalOrderId(esModel.getOrderId());
                select.setSkuId(String.valueOf(productInfo.getSkuId()));
                List orderAftersales = this.shopOrderAftersaleMapper.select((Object)select);
                if (CollectionUtils.isNotEmpty((Collection)orderAftersales)) {
                    data.add(((ShopOrderAftersale)orderAftersales.get(0)).getStatus());
                    data.add(((ShopOrderAftersale)orderAftersales.get(0)).getRefundAmount().doubleValue() / 100.0);
                    continue;
                }
                data.add("");
                data.add("");
            }
            dataList.add(data);
        }
        res.setData(dataList);
        res.setMaxProductCount(maxProductCount);
        return res;
    }

    private List<List<String>> dynamicOrderExportHead(int productCount) {
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        list.add(Collections.singletonList("\u8ba2\u5355\u53f7"));
        list.add(Collections.singletonList("\u4e0b\u5355\u65f6\u95f4"));
        list.add(Collections.singletonList("\u8ba2\u5355\u72b6\u6001"));
        list.add(Collections.singletonList("\u7528\u6237openid"));
        list.add(Collections.singletonList("\u6536\u4ef6\u4eba\u59d3\u540d"));
        list.add(Collections.singletonList("\u6536\u4ef6\u4eba\u5730\u5740"));
        list.add(Collections.singletonList("\u6536\u4ef6\u4eba\u624b\u673a"));
        list.add(Collections.singletonList("\u4e70\u5bb6\u5907\u6ce8"));
        list.add(Collections.singletonList("\u5546\u5bb6\u5907\u6ce8"));
        list.add(Collections.singletonList("\u8ba2\u5355\u5b9e\u9645\u652f\u4ed8\u91d1\u989d"));
        list.add(Collections.singletonList("\u652f\u4ed8\u65b9\u5f0f"));
        list.add(Collections.singletonList("\u652f\u4ed8\u65f6\u95f4"));
        list.add(Collections.singletonList("\u4ea4\u6613\u5355\u53f7"));
        for (int i = 1; i <= productCount; ++i) {
            list.add(Collections.singletonList("\u5546\u54c1spu-" + i));
            list.add(Collections.singletonList("\u5546\u54c1\u7f16\u7801-" + i));
            list.add(Collections.singletonList("\u5546\u54c1\u540d\u79f0-" + i));
            list.add(Collections.singletonList("\u5546\u54c1\u5c5e\u6027-" + i));
            list.add(Collections.singletonList("\u5546\u54c1\u4ef7\u683c-" + i));
            list.add(Collections.singletonList("\u5546\u54c1\u6570\u91cf-" + i));
            list.add(Collections.singletonList("\u5546\u54c1\u552e\u540e-" + i));
            list.add(Collections.singletonList("\u5546\u54c1\u5df2\u9000\u6b3e\u91d1\u989d-" + i));
        }
        return list;
    }

    @Override
    public void handleOrderStatusUpdateEvent(ProductOrderStatusEvent event) {
        log.info("handleOrderStatusUpdateEvent event:{}", (Object)event);
        ProductOrderStatusUpdateInfo productOrderStatusUpdate = event.getProductOrderStatusUpdate();
        AppletInfo select = new AppletInfo();
        select.setUserName(event.getToUserName());
        AppletInfo appletInfo = (AppletInfo)this.appletInfoMapper.selectOne((Object)select);
        if (appletInfo == null) {
            log.warn("handleOrderStatusUpdateEvent \u901a\u8fc7ToUserName\u67e5\u8be2\u4e0d\u5230\u5c0f\u5546\u5e97 ToUserName:{}", (Object)event.getToUserName());
            return;
        }
        OrderDetailReq req = new OrderDetailReq();
        req.setOrderId(productOrderStatusUpdate.getOrderId());
        OrderDetailResp orderDetail = this.getOrderDetail(3, appletInfo.getAccessToken(), req);
        if (orderDetail == null) {
            log.error("handleOrderStatusUpdateEvent \u83b7\u53d6\u8ba2\u5355\u8be6\u60c5\u5931\u8d25 orderId:{}", (Object)productOrderStatusUpdate.getOrderId());
            return;
        }
        ArrayList<OrderItem> exist = new ArrayList<OrderItem>();
        OrderItem orderItem = new OrderItem();
        orderItem.setOrderId(productOrderStatusUpdate.getOrderId());
        Set<OrderEsModel> orderEsModels = this.orderEsService.existsOrderIds(exist);
        ArrayList<OrderItem> list = new ArrayList<OrderItem>();
        list.add(orderDetail.getOrder());
        if (CollectionUtils.isNotEmpty(orderEsModels)) {
            this.orderEsService.batchUpdateByOrderId(list, appletInfo.getAppId());
        } else {
            this.orderEsService.batchInsertOrders(list, appletInfo.getAppId());
        }
        ShopOrder orderExist = new ShopOrder();
        orderExist.setBizId(appletInfo.getBizId());
        orderExist.setOrderId(String.valueOf(productOrderStatusUpdate.getOrderId()));
        int count = this.shopOrderMapper.selectCount((Object)orderExist);
        if (count != 1) {
            this.handleSyncOrder(orderDetail.getOrder(), appletInfo.getBizId(), appletInfo.getCorpId(), appletInfo.getAppId());
        }
    }

    @Override
    public void updateOrderStatus(PayMessageDto payMessageDto) {
        log.info("updateOrderStatus payMessageDto:{}", (Object)payMessageDto);
        String orderNum = payMessageDto.getOrderNum();
        ShopOrder exist = new ShopOrder();
        exist.setOutOrderId(orderNum);
        ShopOrder shopOrder = (ShopOrder)this.shopOrderMapper.selectOne((Object)exist);
        if (Objects.isNull(shopOrder)) {
            log.warn("order not found, orderNum:{}", (Object)orderNum);
            return;
        }
        OrderEsModel orderEsModel = this.orderEsService.getOneById(shopOrder.getOrderId());
        if (Objects.isNull(orderEsModel)) {
            log.warn("order es not found, id:{}", (Object)shopOrder.getId());
            return;
        }
        PayMessageType payMessageType = PayMessageType.getType((Integer)payMessageDto.getMsgType());
        if (payMessageType.getValue() == PayMessageType.ORDER.getValue()) {
            shopOrder.setStatus(Integer.valueOf(PayStatus.PAY.getStatus()));
            shopOrder.setPayTime(new Date());
            this.shopOrderMapper.updateByPrimaryKeySelective((Object)shopOrder);
            OrderItem orderItem = this.orderEsModelToOrderItem(orderEsModel);
            orderItem.setStatus(shopOrder.getStatus());
            String payTime = com.kuaike.scrm.common.utils.DateUtil.dateToDateString((Date)shopOrder.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss");
            orderItem.getOrderDetail().getPayInfo().setPayTime(payTime);
            this.orderEsService.batchUpdateByOrderId(Lists.newArrayList((Object[])new OrderItem[]{orderItem}), orderEsModel.getAppId());
            try {
                this.syncToCustomerOrder(shopOrder, PayStatusEnum.PAID.getValue());
            }
            catch (Exception e) {
                log.error("\u5ba2\u6237\u8ba2\u5355\u652f\u4ed8\u6210\u529f\u56de\u8c03\uff0c\u540c\u6b65\u5230\u5ba2\u6237\u4e2d\u5fc3\u5f02\u5e38\uff0corderNum:{}", (Object)shopOrder.getOutOrderId(), (Object)e);
            }
            try {
                this.syncToCustomerEvent(orderItem, shopOrder.getBizId());
            }
            catch (Exception e) {
                log.error("\u5ba2\u6237\u8ba2\u5355\u652f\u4ed8\u6210\u529f\u56de\u8c03\uff0c\u66f4\u65b0\u5ba2\u6237\u4e2d\u5fc3visitPage\u4e8b\u4ef6\u5f02\u5e38\uff0corderNum:{}", (Object)shopOrder.getOutOrderId(), (Object)e);
            }
        }
    }

    public OrderItem orderEsModelToOrderItem(OrderEsModel orderEsModel) {
        OrderItem orderItem = new OrderItem();
        orderItem.setOrderId(orderItem.getOrderId());
        orderItem.setStatus(orderItem.getStatus());
        String createTime = com.kuaike.scrm.common.utils.DateUtil.getCurTimeString((long)orderEsModel.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss");
        orderItem.setCreateTime(createTime);
        String updateTime = com.kuaike.scrm.common.utils.DateUtil.getCurTimeString((long)orderEsModel.getUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss");
        orderItem.setUpdateTime(updateTime);
        orderItem.setOpenId(orderItem.getOpenId());
        orderItem.setOrderDetail(orderItem.getOrderDetail());
        orderItem.setAfterSaleDetail(orderItem.getAfterSaleDetail());
        orderItem.setExtInfo(orderItem.getExtInfo());
        log.info("orderEsModelToOrderItem orderItem:{}", (Object)orderEsModel);
        return orderItem;
    }

    private void syncToCustomerOrder(ShopOrder shopOrder, Integer payStatus) {
        log.info("syncToCustomerOrder shopOrder:{}", (Object)shopOrder);
        SetOrderPayStatusReq req = new SetOrderPayStatusReq();
        req.setBizId(shopOrder.getBizId());
        req.setOrderNo(shopOrder.getOutOrderId());
        req.setProductLineId("");
        req.setSource(OrderSource.MEETING_ORDER.name());
        req.setPaidAmount(shopOrder.getOrderPrice());
        req.setPayStatus(payStatus);
        this.ccCustomerOrderService.setOrderPayStatus(req);
        OrderRecordReq recordReq = new OrderRecordReq();
        recordReq.setBizId(shopOrder.getBizId());
        recordReq.setSource(OrderSource.MEETING_ORDER.name());
        recordReq.setProductLineId("");
        recordReq.setPayAmount(shopOrder.getOrderPrice());
        recordReq.setPayTime(shopOrder.getPayTime());
        recordReq.setOrderNo(shopOrder.getOutOrderId());
        recordReq.setPayNo(shopOrder.getOutOrderId());
        recordReq.setChannelType(PayChannelType.WEIXIN_JSAPI.getValue());
        log.info("syncToCustomerOrder|recordReq:{}", (Object)recordReq);
        this.ccCustomerOrderService.addOrderPayRecord(recordReq);
    }

    private void syncToCustomerEvent(OrderItem orderItem, Long bizId) {
        log.info("syncToCustomerEvent orderItem:{}", (Object)orderItem);
        String meetingCustomerNum = "";
        MeetingCustomerInfo exist = new MeetingCustomerInfo();
        exist.setBizId(bizId);
        exist.setNum(meetingCustomerNum);
        MeetingCustomerInfo meetingCustomerInfo = (MeetingCustomerInfo)this.meetingCustomerInfoMapper.selectOne((Object)exist);
        if (meetingCustomerInfo == null) {
            log.warn("meetingCustomerInfo not found, num:{}", (Object)meetingCustomerNum);
            return;
        }
        String appId = meetingCustomerInfo.getAppId();
        String openId = meetingCustomerInfo.getOpenId();
        String customerNum = this.ccCustomerNumService.getCustomerNumByOfficialFans(bizId, appId, openId, null);
        this.orderEsService.syncToCustomerEvent(orderItem, customerNum, bizId, ModuleType.LIVE);
    }

    private void handleSyncOrder(OrderItem orderItem, Long bizId, String corpId, String appId) {
        ShopOrder shopOrder = new ShopOrder();
        shopOrder.setNum(this.idGen.getNum());
        shopOrder.setBizId(bizId);
        shopOrder.setCorpId(corpId);
        shopOrder.setAppId(appId);
        shopOrder.setOrderId(String.valueOf(orderItem.getOrderId()));
        shopOrder.setOutOrderId("0");
        shopOrder.setStatus(orderItem.getStatus());
        OrderDetailDto orderDetail = orderItem.getOrderDetail();
        PayInfoDto payInfo = orderDetail.getPayInfo();
        shopOrder.setPayMethod(payInfo.getPayMethod());
        shopOrder.setPrepayId(payInfo.getPrepayId());
        shopOrder.setTransactionId(payInfo.getTransactionId());
        if (payInfo.getPayTime() != null) {
            shopOrder.setPayTime((Date)DateUtil.parse((CharSequence)payInfo.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        shopOrder.setPrepayTime((Date)DateUtil.parse((CharSequence)payInfo.getPrepayTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        PriceInfoDto priceInfo = orderDetail.getPriceInfo();
        shopOrder.setProductPrice(priceInfo.getProductPrice());
        shopOrder.setOrderPrice(priceInfo.getOrderPrice());
        shopOrder.setFreight(priceInfo.getFreight());
        shopOrder.setIsDiscounted(priceInfo.getIsDiscounted());
        shopOrder.setDiscountedPrice(priceInfo.getDiscountedPrice());
        shopOrder.setChangeDownPrice(priceInfo.getChangeDownPrice());
        shopOrder.setOpenId(orderItem.getOpenId());
        ExtInfo extInfo = orderItem.getExtInfo();
        if (extInfo != null) {
            shopOrder.setCustomerNotes(extInfo.getCustomerNotes());
            shopOrder.setMerchantNotes(extInfo.getMerchantNotes());
        }
        DeliveryInfoDto deliveryInfoDto = orderDetail.getDeliveryInfoDto();
        shopOrder.setAddressinfo(JSON.toJSONString((Object)deliveryInfoDto.getAddressInfo()));
        shopOrder.setDeliveryInfo(JSON.toJSONString((Object)deliveryInfoDto));
        shopOrder.setCouponCodeInfo(JSON.toJSONString((Object)orderDetail.getCouponCodeInfo()));
        shopOrder.setCreateBy(Long.valueOf(-1L));
        shopOrder.setUpdateBy(Long.valueOf(-1L));
        shopOrder.setCreateTime((Date)DateUtil.parse((CharSequence)orderItem.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        shopOrder.setUpdateTime((Date)DateUtil.parse((CharSequence)orderItem.getUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        shopOrder.setIsDeleted(Integer.valueOf(0));
        CouponInfoDto couponInfo = orderDetail.getCouponInfo();
        for (String couponId : couponInfo.getCouponId()) {
            this.stringRedisTemplate.opsForHash().put((Object)("shop:waitSyncCouponIds:" + appId), (Object)couponId, (Object)couponId);
        }
        this.shopOrderMapper.insert((Object)shopOrder);
    }

    private OrderDetailResp getOrderDetail(Integer retryCount, String accessToken, OrderDetailReq req) {
        OrderDetailResp orderDetailResp;
        log.info("getOrderDetail req:{}", (Object)req);
        try {
            if (retryCount < 1) {
                log.error("getOrderDetail \u91cd\u8bd5\u83b7\u53d6\u5931\u8d25");
                return null;
            }
            orderDetailResp = this.wxShopOrderAPI.orderGetDetail(accessToken, req);
        }
        catch (Exception e) {
            log.error("getOrderDetail\u5f02\u5e38 \u5269\u4f59\u91cd\u8bd5\u6b21\u6570:{}", (Object)retryCount, (Object)e);
            Integer n = retryCount;
            Integer n2 = retryCount = Integer.valueOf(retryCount - 1);
            return this.getOrderDetail(retryCount, accessToken, req);
        }
        return orderDetailResp;
    }
}

