/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.shop.service.impl;

import com.kuaike.scrm.applet.service.AppletCommonService;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.dal.shop.mapper.AppletInfoMapper;
import com.kuaike.scrm.dal.shop.mapper.ShopOrderAftersaleMapper;
import com.kuaike.scrm.dal.shop.mapper.ShopOrderFlowMapper;
import com.kuaike.scrm.dal.shop.mapper.ShopOrderMapper;
import com.kuaike.scrm.dal.shop.mapper.ShopSpuMapper;
import com.kuaike.scrm.shop.dto.shopinfo.dto.ShopPayInfo;
import com.kuaike.scrm.shop.dto.shopinfo.dto.ShopProductInfo;
import com.kuaike.scrm.shop.dto.shopinfo.dto.ShopUnDeal;
import com.kuaike.scrm.shop.dto.shopinfo.resp.ShopStatisticResp;
import com.kuaike.scrm.shop.enums.WxShopAfterSaleStatus;
import com.kuaike.scrm.shop.enums.WxShopOrderStatus;
import com.kuaike.scrm.shop.enums.WxShopSpuStatus;
import com.kuaike.scrm.shop.service.ShopInfoService;
import com.kuaike.scrm.shop.service.datasync.FundFlowPullService;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShopInfoServiceImpl
implements ShopInfoService {
    private static final Logger log = LoggerFactory.getLogger(ShopInfoServiceImpl.class);
    @Autowired
    private AppletInfoMapper appletInfoMapper;
    @Autowired
    private AppletCommonService appletCommonService;
    @Autowired
    private ShopOrderMapper shopOrderMapper;
    @Autowired
    private ShopOrderAftersaleMapper orderAftersaleMapper;
    @Autowired
    private ShopOrderFlowMapper shopOrderFlowMapper;
    @Autowired
    private ShopSpuMapper spuMapper;
    @Autowired
    private FundFlowPullService fundFlowPullService;

    @Override
    public ShopStatisticResp shopStatistic() {
        String appId = this.appletCommonService.getCurrentAppId();
        log.info("query shopStatistic, appId={}", (Object)appId);
        ShopStatisticResp resp = new ShopStatisticResp();
        Integer waitPayCount = this.shopOrderMapper.queryCountByStatus(appId, WxShopOrderStatus.WAIT_PAY.getStatus());
        Integer waitDeliveryCount = this.shopOrderMapper.queryCountByStatus(appId, WxShopOrderStatus.WAIT_DELIVERY.getStatus());
        Integer afterSaleCount = this.orderAftersaleMapper.queryCountByStatus(appId, WxShopAfterSaleStatus.MERCHANT_PROCESSING.getStatus());
        resp.setUnDeal(new ShopUnDeal(waitPayCount, waitDeliveryCount, afterSaleCount));
        Date todayStart = DateUtil.getTodayStartTime();
        Date todayEnd = DateUtil.getTodayEndTime();
        Date yesterdayStart = DateUtil.getDateAddDay((Date)todayStart, (int)-1);
        Date yesterdayEnd = DateUtil.getDateAddDay((Date)todayEnd, (int)-1);
        Long todayPayAmount = this.shopOrderFlowMapper.queryPriceByDate(appId, todayStart, todayEnd);
        Long yesterdayPayAmount = this.shopOrderFlowMapper.queryPriceByDate(appId, yesterdayStart, yesterdayEnd);
        Integer todayOrderCount = this.shopOrderFlowMapper.queryCountByDate(appId, todayStart, todayEnd);
        Integer yesterdayOrderCount = this.shopOrderFlowMapper.queryCountByDate(appId, yesterdayStart, yesterdayEnd);
        Long updateTimeStamp = this.fundFlowPullService.getLastPullTime(appId);
        Date updateTime = null;
        if (Objects.nonNull(updateTimeStamp)) {
            updateTime = new Date(updateTimeStamp);
        }
        resp.setPayInfo(new ShopPayInfo(todayPayAmount, yesterdayPayAmount, todayOrderCount, yesterdayOrderCount, updateTime));
        Integer onSaleCount = this.spuMapper.queryCountByStatus(appId, Integer.valueOf(WxShopSpuStatus.LISTING.getStatus()));
        Integer waitOnListCount = this.spuMapper.queryCountByStatus(appId, Integer.valueOf(WxShopSpuStatus.INIT.getStatus()));
        resp.setProductInfo(new ShopProductInfo(onSaleCount, waitOnListCount));
        return resp;
    }
}

