/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.shop.service.datasync;

import cn.kinyun.scrm.weixin.sdk.api.shop.WxShopSkuAPI;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.SkuItem;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.SkuGetListReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.SkuGetListResp;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.scrm.applet.service.AppletAccessTokenService;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.dal.shop.entity.ShopSku;
import com.kuaike.scrm.dal.shop.mapper.ShopSkuMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SkuCreatePullServcie {
    private static final Logger log = LoggerFactory.getLogger(SkuCreatePullServcie.class);
    @Autowired
    WxShopSkuAPI wxShopSkuAPI;
    @Autowired
    AppletAccessTokenService appletAccessTokenService;
    @Autowired
    private ShopSkuMapper skuMapper;
    @Autowired
    private IdGen idGen;

    public void syncSku(String appId, String productId, boolean draft) {
        List<ShopSku> skus;
        String accessToken = this.appletAccessTokenService.getAccessToken(appId);
        SkuGetListReq req = new SkuGetListReq();
        req.setProductId(Long.valueOf(productId));
        if (draft) {
            req.setNeedEditSku(Integer.valueOf(1));
            req.setNeedRealStock(Integer.valueOf(0));
        } else {
            req.setNeedEditSku(Integer.valueOf(0));
            req.setNeedRealStock(Integer.valueOf(1));
        }
        SkuGetListResp skuGetBatchResp = this.wxShopSkuAPI.skuGetBatch(accessToken, req);
        List skuIds = skuGetBatchResp.getSkus().stream().map(a -> a.getSkuId().toString()).collect(Collectors.toList());
        List existSkus = this.skuMapper.queryByProductId(appId, productId);
        Set existSkuIds = existSkus.stream().map(a -> a.getSkuId()).collect(Collectors.toSet());
        ArrayList updateList = Lists.newArrayList();
        ArrayList insertList = Lists.newArrayList();
        HashSet needInsertSkuIds = Sets.newHashSet((Iterable)CollectionUtils.subtract(skuIds, existSkuIds));
        HashSet needDeleteSkuIds = Sets.newHashSet((Iterable)CollectionUtils.subtract(existSkuIds, skuIds));
        HashSet needUpdateSkuIds = Sets.newHashSet((Iterable)CollectionUtils.intersection(skuIds, existSkuIds));
        if (CollectionUtils.isNotEmpty((Collection)skuGetBatchResp.getSkus())) {
            for (SkuItem skuItem : skuGetBatchResp.getSkus()) {
                if (needInsertSkuIds.contains(skuItem.getSkuId())) {
                    insertList.add(skuItem);
                    continue;
                }
                if (!needUpdateSkuIds.contains(skuItem.getSkuId())) continue;
                updateList.add(skuItem);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)insertList)) {
            skus = this.buildShopSku(appId, insertList);
            this.skuMapper.batchInsert(skus);
        }
        if (CollectionUtils.isNotEmpty((Collection)updateList)) {
            skus = this.buildShopSku(appId, updateList);
            this.skuMapper.batchUpdate(skus);
        }
        if (CollectionUtils.isNotEmpty((Collection)needDeleteSkuIds) && CollectionUtils.isNotEmpty((Collection)existSkus)) {
            for (ShopSku sku : existSkus) {
                if (!needDeleteSkuIds.contains(sku.getSkuId())) continue;
                this.skuMapper.deleteByPrimaryKey((Object)sku.getId());
            }
        }
    }

    private List<ShopSku> buildShopSku(String appId, List<SkuItem> insertList) {
        ArrayList skus = Lists.newArrayList();
        for (SkuItem skuItem : insertList) {
            ShopSku sku = new ShopSku();
            sku.setCreateBy(Long.valueOf(-1L));
            sku.setCreateTime(new Date());
            sku.setSkuId(String.valueOf(skuItem.getSkuId()));
            sku.setOutSkuId(skuItem.getOutSkuId());
            sku.setSkuBody(JSON.toJSONString((Object)skuItem));
            sku.setAppId(appId);
            sku.setMarketPrice(skuItem.getMarketPrice());
            sku.setNum(this.idGen.getNum());
            sku.setStatus(skuItem.getStatus());
            sku.setStockNum(skuItem.getStockNum());
            sku.setOutProductId(skuItem.getOutProductId());
            sku.setProductId(String.valueOf(skuItem.getProductId()));
            sku.setSalePrice(skuItem.getSalePrice());
            sku.setBizId(Long.valueOf(-1L));
            sku.setSource(Integer.valueOf(1));
            skus.add(sku);
        }
        return skus;
    }
}

