/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.shop.service.datasync;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.scrm.applet.service.shopdatasync.AbstractPullService;
import com.kuaike.scrm.applet.service.shopdatasync.PullDispatchService;
import com.kuaike.scrm.common.utils.ThreadPoolMonitorUtils;
import com.kuaike.scrm.common.utils.ThreadTools;
import com.kuaike.scrm.dal.shop.mapper.AppletInfoMapper;
import com.kuaike.scrm.shop.enums.WxShopCouponStatus;
import com.kuaike.scrm.shop.enums.WxShopOrderStatus;
import com.kuaike.scrm.shop.enums.WxShopSpuStatus;
import com.kuaike.scrm.shop.service.datasync.CouponCreatePullService;
import com.kuaike.scrm.shop.service.datasync.FundFlowPullService;
import com.kuaike.scrm.shop.service.datasync.OrderCreatePullService;
import com.kuaike.scrm.shop.service.datasync.OrderUpdatePullService;
import com.kuaike.scrm.shop.service.datasync.ProductCreatePullService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class PullDispatchServiceImpl
extends PullDispatchService
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(PullDispatchServiceImpl.class);
    @Autowired
    private AppletInfoMapper appletInfoMapper;
    private List<AbstractPullService> allPullServiceList = Lists.newArrayList();
    private static ApplicationContext context;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        context = applicationContext;
    }

    @PostConstruct
    public void init() {
        HashMap paramMap;
        ThreadPoolMonitorUtils.addToMonitor((ExecutorService)ThreadTools.getMixTaskThreadPool());
        ArrayList productStatusList = Lists.newArrayList(WxShopSpuStatus.getAllStatus());
        for (WxShopCouponStatus[] status : productStatusList) {
            ProductCreatePullService productCreatePullService = (ProductCreatePullService)((Object)context.getBean(ProductCreatePullService.class));
            paramMap = Maps.newHashMap();
            paramMap.put("status", status);
            paramMap.put("needEditSpu", 0);
            productCreatePullService.setExtParamMap(paramMap);
            this.allPullServiceList.add(productCreatePullService);
        }
        HashSet<Integer> syncStatus = new HashSet<Integer>();
        syncStatus.add(WxShopOrderStatus.WAIT_PAY.getStatus());
        syncStatus.add(WxShopOrderStatus.PAID_WAIT_WRITE_OFF.getStatus());
        syncStatus.add(WxShopOrderStatus.WAIT_DELIVERY.getStatus());
        syncStatus.add(WxShopOrderStatus.FINISHED.getStatus());
        syncStatus.add(WxShopOrderStatus.AFTER_SALE_CANCEL.getStatus());
        syncStatus.add(WxShopOrderStatus.USER_CANCEL_OR_PAY_TIMEOUT.getStatus());
        for (Integer status : syncStatus) {
            paramMap = Maps.newHashMap();
            paramMap.put("status", status);
            OrderCreatePullService orderCreatePullService = (OrderCreatePullService)((Object)context.getBean(OrderCreatePullService.class));
            orderCreatePullService.setExtParamMap(paramMap);
            this.allPullServiceList.add(orderCreatePullService);
            OrderUpdatePullService orderUpdatePullService = (OrderUpdatePullService)((Object)context.getBean(OrderUpdatePullService.class));
            orderUpdatePullService.setExtParamMap(paramMap);
            this.allPullServiceList.add(orderUpdatePullService);
        }
        for (WxShopCouponStatus status : WxShopCouponStatus.values()) {
            if (WxShopCouponStatus.DELETED.equals((Object)status)) continue;
            HashMap paramMap2 = Maps.newHashMap();
            paramMap2.put("status", status.getStatus());
            CouponCreatePullService couponCreatePullService = (CouponCreatePullService)((Object)context.getBean(CouponCreatePullService.class));
            couponCreatePullService.setExtParamMap(paramMap2);
            this.allPullServiceList.add(couponCreatePullService);
        }
        FundFlowPullService fundFlowPullService = (FundFlowPullService)((Object)context.getBean(FundFlowPullService.class));
        this.allPullServiceList.add(fundFlowPullService);
    }

    public void sync() {
        log.info("shop pull sync start");
        List appIds = this.appletInfoMapper.queryAllAuthShopAppId();
        if (CollectionUtils.isNotEmpty((Collection)appIds)) {
            for (String appId : appIds) {
                this.runAppSync(appId);
            }
        }
        log.info("shop pull sync end");
    }

    public void runAppSync(String appId) {
        for (AbstractPullService abstractPullService : this.allPullServiceList) {
            ThreadTools.getMixTaskThreadPool().submit(() -> abstractPullService.running(appId));
        }
    }
}

