/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.shop.service.datasync;

import cn.kinyun.scrm.weixin.sdk.api.shop.WxShopSpuAPI;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.SpuItemDto;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.SpuListReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.SpuListResp;
import com.google.common.collect.Lists;
import com.kuaike.scrm.applet.dto.PullResult;
import com.kuaike.scrm.applet.service.AppletAccessTokenService;
import com.kuaike.scrm.applet.service.shopdatasync.AbstractPullService;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.shop.service.ShopProductService;
import com.kuaike.scrm.shop.service.datasync.SkuCreatePullServcie;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ProductCreatePullService
extends AbstractPullService {
    private static final Logger log = LoggerFactory.getLogger(ProductCreatePullService.class);
    private static final String PRODUCT_CREATE_TOTAL_NUM = "productCreateTotalNum";
    @Autowired
    WxShopSpuAPI wxShopSpuAPI;
    @Autowired
    AppletAccessTokenService appletAccessTokenService;
    @Resource
    StringRedisTemplate stringRedisTemplate;
    @Autowired
    private ShopProductService shopProductService;
    @Autowired
    private SkuCreatePullServcie skuCreatePullServcie;
    @Autowired
    IdGen idGen;

    public String getKey() {
        return "productCreate" + this.getHashKey();
    }

    public String getStartTime(String appId) {
        return null;
    }

    public int getTotalNum(String appId) {
        String value = (String)this.stringRedisTemplate.opsForHash().get((Object)appId, (Object)this.getHashKey());
        return StringUtils.isNotBlank((CharSequence)value) ? Integer.valueOf(value) : 0;
    }

    public void saveTotalNum(String appId, int newTotalNum) {
        String hashKey = this.getHashKey();
        this.stringRedisTemplate.opsForHash().put((Object)appId, (Object)hashKey, (Object)String.valueOf(newTotalNum));
    }

    private String getHashKey() {
        String hashKey = PRODUCT_CREATE_TOTAL_NUM;
        if (MapUtils.isNotEmpty((Map)this.paramMap)) {
            Integer needEditSpu;
            Integer source;
            Integer status = (Integer)this.paramMap.get("status");
            if (Objects.nonNull(status)) {
                hashKey = hashKey + ":" + status;
            }
            if (Objects.nonNull(source = (Integer)this.paramMap.get("source"))) {
                hashKey = hashKey + ":" + source;
            }
            if (Objects.nonNull(needEditSpu = (Integer)this.paramMap.get("needEditSpu"))) {
                hashKey = hashKey + ":" + needEditSpu;
            }
        }
        return hashKey;
    }

    public int getPageSize() {
        return 20;
    }

    public PullResult doPull(String appId, String startTime, String endTime, int page, int pageSize) {
        String accessToken = this.appletAccessTokenService.getAccessToken(appId);
        SpuListReq req = this.buildReq(page, pageSize);
        SpuListResp spuListResp = this.wxShopSpuAPI.spuList(accessToken, req);
        PullResult pullResult = new PullResult();
        pullResult.setResultList(spuListResp.getSpus());
        pullResult.setTotalNum(spuListResp.getTotalNum());
        return pullResult;
    }

    private SpuListReq buildReq(int page, int pageSize) {
        SpuListReq req = new SpuListReq();
        req.setPage(Integer.valueOf(page));
        req.setPageSize(Integer.valueOf(pageSize));
        if (MapUtils.isNotEmpty((Map)this.paramMap)) {
            Integer needEditSpu;
            Integer source;
            Integer status = (Integer)this.paramMap.get("status");
            if (Objects.nonNull(status)) {
                req.setStatus(status);
            }
            if (Objects.nonNull(source = (Integer)this.paramMap.get("source"))) {
                req.setSource(source);
            }
            if (Objects.nonNull(needEditSpu = (Integer)this.paramMap.get("needEditSpu"))) {
                req.setNeedEditSpu(needEditSpu);
            }
        }
        return req;
    }

    protected void save(String appId, PullResult result) {
        super.save(appId, result);
        ArrayList productIds = Lists.newArrayList();
        ArrayList spuItemDtos = Lists.newArrayList();
        for (Object item : result.getResultList()) {
            SpuItemDto dto = (SpuItemDto)item;
            productIds.add(dto.getProductId().toString());
            spuItemDtos.add(dto);
            boolean draft = !dto.getEditStatus().equals(4);
            this.skuCreatePullServcie.syncSku(appId, dto.getProductId().toString(), draft);
        }
        if (CollectionUtils.isNotEmpty((Collection)productIds)) {
            this.shopProductService.checkExistInDbAndInsert(appId, productIds, spuItemDtos);
        }
        if (CollectionUtils.isNotEmpty((Collection)spuItemDtos)) {
            this.shopProductService.checkExistInEsAndInsert(spuItemDtos, appId);
        }
    }
}

