/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.shop.service;

import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.CategoryLevelDto;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.SkuItem;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.SpuItemDto;
import cn.kinyun.wework.sdk.utils.JacksonUtils;
import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.utils.NamedThreadFactory;
import com.kuaike.scrm.common.utils.ThreadPoolMonitorUtils;
import com.kuaike.scrm.dal.shop.entity.ShopSpu;
import com.kuaike.scrm.shop.dto.ProductEsModel;
import com.kuaike.scrm.shop.dto.spu.req.SpuListQueryParam;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.Header;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetRequestBuilder;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ProductEsService {
    private static final Logger log = LoggerFactory.getLogger(ProductEsService.class);
    @Value(value="${scrm.elasticsearch.shopProductIndex}")
    private String shopProductIndex;
    @Autowired
    private RestHighLevelClient restHighLevelClient;
    @Autowired
    private Client client;
    private static final String TYPE = "doc";
    private final ExecutorService productSaveExecutorService = new ThreadPoolExecutor(2, 4, 10L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(1000), (ThreadFactory)new NamedThreadFactory("productSaveExecutorService"), new ThreadPoolExecutor.CallerRunsPolicy());

    @PostConstruct
    public void init() {
        ThreadPoolMonitorUtils.addToMonitor((ExecutorService)this.productSaveExecutorService);
    }

    public void batchInsertProduct(List<SpuItemDto> spuItemDtos, String appId) {
        if (CollectionUtils.isNotEmpty(spuItemDtos)) {
            List<ProductEsModel> models = spuItemDtos.stream().map(a -> new ProductEsModel((SpuItemDto)a, appId)).collect(Collectors.toList());
            this.batchWriteProductAsync(models);
        } else {
            log.info("batchInsert product empty");
        }
    }

    public void batchWriteProductAsync(List<ProductEsModel> productList) {
        if (CollectionUtils.isEmpty(productList)) {
            return;
        }
        List partition = Lists.partition(productList, (int)100);
        ArrayList resultFutureList = Lists.newArrayListWithExpectedSize((int)partition.size());
        for (List list : partition) {
            CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> {
                try {
                    this.batchWriteProduct(list);
                }
                catch (IOException e) {
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR);
                }
            }, this.productSaveExecutorService);
            resultFutureList.add(completableFuture);
        }
        ((CompletableFuture)CompletableFuture.allOf(resultFutureList.toArray(new CompletableFuture[0])).whenComplete((r, t) -> {
            if (t != null) {
                log.error("store product error", t);
            }
        })).join();
    }

    private void batchWriteProduct(List<ProductEsModel> productList) throws IOException {
        BulkRequest bulkRequest = new BulkRequest();
        for (ProductEsModel model : productList) {
            IndexRequest indexRequest = new IndexRequest(this.shopProductIndex, TYPE, String.valueOf(model.getProductId()));
            try {
                indexRequest.source(JacksonUtils.writeValueAsString((Object)model), XContentType.JSON);
            }
            catch (JsonProcessingException e) {
                log.error("josn error:{}", (Object)JSON.toJSONString((Object)model));
                continue;
            }
            bulkRequest.add(indexRequest);
        }
        BulkResponse bulkResponse = this.restHighLevelClient.bulk(bulkRequest, new Header[0]);
        log.info("bulk response:{}", (Object)bulkResponse.status());
        for (BulkItemResponse response : bulkResponse) {
            log.info("write product id:{}, error:{}", (Object)response.getId(), (Object)response.getFailureMessage());
        }
    }

    public int writeProduct(ProductEsModel model) throws IOException {
        IndexRequest indexRequest = new IndexRequest(this.shopProductIndex, TYPE, String.valueOf(model.getProductId()));
        try {
            indexRequest.source(JacksonUtils.writeValueAsString((Object)model), XContentType.JSON);
        }
        catch (JsonProcessingException e) {
            log.error("josn error:{}", (Object)JSON.toJSONString((Object)model));
        }
        IndexResponse indexResponse = this.restHighLevelClient.index(indexRequest, new Header[0]);
        return indexResponse.status().getStatus();
    }

    public Set<ProductEsModel> existsProducts(List<SpuItemDto> list) {
        HashSet result = Sets.newHashSet();
        if (CollectionUtils.isEmpty(list)) {
            return result;
        }
        MultiGetRequestBuilder multiGetRequestBuilder = this.client.prepareMultiGet();
        for (SpuItemDto item : list) {
            multiGetRequestBuilder.add(new MultiGetRequest.Item(this.shopProductIndex, TYPE, String.valueOf(item.getProductId())));
        }
        try {
            MultiGetResponse multiGetResponse = (MultiGetResponse)multiGetRequestBuilder.get();
            for (MultiGetItemResponse response : multiGetResponse) {
                GetResponse itemResponse = response.getResponse();
                if (!Objects.nonNull(itemResponse) || !itemResponse.isExists()) continue;
                result.add(JSON.parseObject((String)itemResponse.getSourceAsString(), ProductEsModel.class));
            }
        }
        catch (Exception e) {
            log.error("existsChatMsg with error", (Throwable)e);
        }
        return result;
    }

    public Pair<List<ProductEsModel>, Long> queryProductList(SpuListQueryParam queryParam, boolean direction) {
        log.info("queryProductList params: param:{}, direction:{}", (Object)queryParam, (Object)direction);
        queryParam.validate();
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"appId", (String)queryParam.getAppId())).must((QueryBuilder)QueryBuilders.termsQuery((String)"status", queryParam.getRealStatus())).must((QueryBuilder)QueryBuilders.termQuery((String)"isDeleted", (int)0));
        if (StringUtils.isNotBlank((CharSequence)queryParam.getProductCodeQuery())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"productId", (Object)queryParam.getProductCodeQuery()));
        }
        if (StringUtils.isNotBlank((CharSequence)queryParam.getProductNameQuery())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"title", (Object)queryParam.getProductNameQuery()));
        }
        if (Objects.nonNull(queryParam.getMinPrice()) || Objects.nonNull(queryParam.getMaxPrice())) {
            RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"price");
            if (Objects.nonNull(queryParam.getMinPrice())) {
                rangeQueryBuilder.gte((Object)queryParam.getMinPrice());
            }
            if (Objects.nonNull(queryParam.getMaxPrice())) {
                rangeQueryBuilder.lte((Object)queryParam.getMaxPrice());
            }
            queryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (CollectionUtils.isNotEmpty(queryParam.getCatIds())) {
            int level = 0;
            for (Integer catId : queryParam.getCatIds()) {
                if (++level == 1) {
                    queryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"categoryIdL1", (Object)catId));
                    continue;
                }
                if (level == 2) {
                    queryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"categoryIdL2", (Object)catId));
                    continue;
                }
                if (level != 3) continue;
                queryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"categoryIdL3", (Object)catId));
            }
        }
        ValuesSourceAggregationBuilder aggregationBuilder = AggregationBuilders.count((String)"count").field("productId.keyword");
        SearchRequest searchRequest = new SearchRequest(new String[]{this.shopProductIndex});
        searchRequest.types(new String[]{TYPE});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        if (direction) {
            searchSourceBuilder.sort("updateTime", SortOrder.ASC);
        } else {
            searchSourceBuilder.sort("updateTime", SortOrder.DESC);
        }
        if (Objects.isNull(queryParam.getPageDto())) {
            searchSourceBuilder.size(20);
            searchSourceBuilder.from(0);
        } else {
            searchSourceBuilder.size(queryParam.getPageDto().getPageSize().intValue());
            searchSourceBuilder.from(queryParam.getPageDto().getOffset());
        }
        searchSourceBuilder.aggregation((AggregationBuilder)aggregationBuilder);
        return this.executeQueryAndDealResult(searchRequest, searchSourceBuilder);
    }

    private Pair<List<ProductEsModel>, Long> executeQueryAndDealResult(SearchRequest searchRequest, SearchSourceBuilder searchSourceBuilder) {
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = null;
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (IOException e) {
            log.error("Search es failed, searchRequest={}", (Object)searchRequest, (Object)e);
        }
        ArrayList productList = Lists.newArrayList();
        if (Objects.isNull(searchResponse)) {
            return new ImmutablePair((Object)productList, (Object)0L);
        }
        SearchHits hits = searchResponse.getHits();
        SearchHit[] searchHits = hits.getHits();
        long totalHits = hits.getTotalHits();
        Stream.of(searchHits).forEach(searchHit -> {
            String sourceAsString = searchHit.getSourceAsString();
            ProductEsModel chatMsg = (ProductEsModel)JSON.parseObject((String)sourceAsString, ProductEsModel.class);
            productList.add(chatMsg);
        });
        return new ImmutablePair((Object)productList, (Object)totalHits);
    }

    public void updateSpuEs(SpuItemDto spuItemDto, String appId) throws IOException {
        ProductEsModel model = new ProductEsModel();
        model.setAppId(appId);
        model.setProductId(String.valueOf(spuItemDto.getProductId()));
        model.setOutProductId(spuItemDto.getOutProductId());
        model.setTitle(spuItemDto.getTitle());
        model.setSubTitle(spuItemDto.getSubTitle());
        model.setStatus(spuItemDto.getStatus());
        model.setEditStatus(spuItemDto.getEditStatus());
        model.setUpdateTime(new Date());
        model.setPrice(spuItemDto.getMinPrice());
        if (Objects.isNull(model.getPrice()) && CollectionUtils.isNotEmpty((Collection)spuItemDto.getSkus())) {
            Long price = ((SkuItem)spuItemDto.getSkus().get(0)).getSalePrice();
            model.setPrice(price);
        }
        if (CollectionUtils.isNotEmpty((Collection)spuItemDto.getCats())) {
            for (CategoryLevelDto cat : spuItemDto.getCats()) {
                if (cat.getLevel().equals(1)) {
                    model.setCategoryIdL1(cat.getCatId());
                }
                if (cat.getLevel().equals(2)) {
                    model.setCategoryIdL2(cat.getCatId());
                }
                if (!cat.getLevel().equals(3)) continue;
                model.setCategoryIdL3(cat.getCatId());
            }
        }
        this.updateProduct(model);
    }

    public void updateSpu(ShopSpu shopSpu) {
        ProductEsModel model = new ProductEsModel();
        model.setAppId(shopSpu.getAppId());
        model.setProductId(String.valueOf(shopSpu.getProductId()));
        model.setOutProductId(shopSpu.getOutProductId());
        SpuItemDto spuItemDto = (SpuItemDto)JSON.parseObject((String)shopSpu.getSpuBody(), SpuItemDto.class);
        model.setTitle(spuItemDto.getTitle());
        model.setSubTitle(spuItemDto.getSubTitle());
        model.setStatus(spuItemDto.getStatus());
        model.setEditStatus(spuItemDto.getEditStatus());
        model.setUpdateTime(new Date());
        model.setPrice(spuItemDto.getMinPrice());
        if (Objects.isNull(model.getPrice()) && CollectionUtils.isNotEmpty((Collection)spuItemDto.getSkus())) {
            Long price = ((SkuItem)spuItemDto.getSkus().get(0)).getSalePrice();
            model.setPrice(price);
        }
        if (CollectionUtils.isNotEmpty((Collection)spuItemDto.getCats())) {
            for (CategoryLevelDto cat : spuItemDto.getCats()) {
                if (cat.getLevel().equals(1)) {
                    model.setCategoryIdL1(cat.getCatId());
                }
                if (cat.getLevel().equals(2)) {
                    model.setCategoryIdL2(cat.getCatId());
                }
                if (!cat.getLevel().equals(3)) continue;
                model.setCategoryIdL3(cat.getCatId());
            }
        }
        this.updateProduct(model);
    }

    public void batchUpdateProduct(List<ShopSpu> shopSpus) {
        for (ShopSpu dto : shopSpus) {
            try {
                this.updateSpu(dto);
            }
            catch (Exception e) {
                log.error("updateSpuEs with error", (Throwable)e);
            }
        }
    }

    public void batchUpdateProduct(List<SpuItemDto> updateSpuList, String appId) {
        for (SpuItemDto dto : updateSpuList) {
            try {
                this.updateSpuEs(dto, appId);
            }
            catch (Exception e) {
                log.error("updateSpuEs with error", (Throwable)e);
            }
        }
    }

    public Boolean updateProduct(ProductEsModel productEsModel) {
        log.info("updateProduct with:{}", (Object)productEsModel);
        boolean flag = false;
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.put("appId", productEsModel.getAppId());
        jsonMap.put("status", productEsModel.getStatus());
        jsonMap.put("title", productEsModel.getTitle());
        jsonMap.put("subTitle", productEsModel.getSubTitle());
        jsonMap.put("categoryIdL1", productEsModel.getCategoryIdL1());
        jsonMap.put("categoryIdL2", productEsModel.getCategoryIdL2());
        jsonMap.put("categoryIdL3", productEsModel.getCategoryIdL3());
        jsonMap.put("editStatus", productEsModel.getEditStatus());
        jsonMap.put("price", productEsModel.getPrice());
        jsonMap.put("updateTime", productEsModel.getUpdateTime().getTime());
        jsonMap.put("isDeleted", 0);
        UpdateRequest updateRequest = new UpdateRequest(this.shopProductIndex, TYPE, productEsModel.getProductId()).doc(jsonMap);
        updateRequest.retryOnConflict(3);
        try {
            UpdateResponse updateResponse = this.restHighLevelClient.update(updateRequest, new Header[0]);
            if (updateResponse.getResult() == DocWriteResponse.Result.UPDATED) {
                flag = true;
                log.info("updateProduct success productId:{}", (Object)productEsModel.getProductId());
            }
        }
        catch (IOException e) {
            log.error("updateProduct failed, productId={}", (Object)productEsModel.getProductId(), (Object)e);
        }
        return flag;
    }

    public Boolean deleteProduct(String productId) {
        log.info("deleteProduct with productId={}", (Object)productId);
        boolean flag = false;
        HashMap<String, Number> jsonMap = new HashMap<String, Number>();
        jsonMap.put("updateTime", System.currentTimeMillis());
        jsonMap.put("isDeleted", 1);
        UpdateRequest updateRequest = new UpdateRequest(this.shopProductIndex, TYPE, productId).doc(jsonMap);
        updateRequest.retryOnConflict(3);
        updateRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        try {
            UpdateResponse updateResponse = this.restHighLevelClient.update(updateRequest, new Header[0]);
            if (updateResponse.getResult() == DocWriteResponse.Result.UPDATED) {
                flag = true;
                log.info("deleteProduct success productId:{}", (Object)productId);
            }
        }
        catch (IOException e) {
            log.error("deleteProduct failed, productId={}", (Object)productId, (Object)e);
        }
        return flag;
    }
}

