/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.shop.enums;

import com.google.common.collect.Maps;
import java.util.Map;

public enum IdCardType {
    CHINESE_ID_CARD(1, "\u4e2d\u56fd\u5927\u9646\u5c45\u6c11\u8eab\u4efd\u8bc1"),
    PASSPORT(2, "\u5176\u4ed6\u56fd\u5bb6\u6216\u5730\u533a\u5c45\u6c11-\u62a4\u7167"),
    HONG_KONG_PERMIT(3, "\u4e2d\u56fd\u9999\u6e2f\u5c45\u6c11-\u6765\u5f80\u5185\u5730\u901a\u884c\u8bc1"),
    MACAU_PERMIT(4, "\u4e2d\u56fd\u6fb3\u95e8\u5c45\u6c11-\u6765\u5f80\u5185\u5730\u901a\u884c\u8bc1"),
    TAIWAN_PERMIT(5, "\u4e2d\u56fd\u53f0\u6e7e\u5c45\u6c11-\u6765\u5f80\u5185\u5730\u901a\u884c\u8bc1");

    private Integer type;
    private String desc;
    private static Map<Integer, IdCardType> map;

    private IdCardType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static boolean isExistByType(int type) {
        return map.containsKey(type);
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        map = Maps.newHashMap();
        for (IdCardType type : IdCardType.values()) {
            map.put(type.type, type);
        }
    }
}

