/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.shop.dto.register;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.shop.dto.register.BusiLicenseDto;
import com.kuaike.scrm.shop.dto.register.IdCardInfoDto;
import com.kuaike.scrm.shop.dto.register.NameInfoDto;
import com.kuaike.scrm.shop.dto.register.ReturnInfoDto;
import com.kuaike.scrm.shop.dto.register.SuperAdministratorInfoDto;
import com.kuaike.scrm.shop.enums.IdCardType;
import com.kuaike.scrm.shop.enums.LicenseType;
import com.kuaike.scrm.shop.enums.RegisterStep;
import com.kuaike.scrm.shop.enums.SubmitInfoOptType;
import com.kuaike.scrm.shop.enums.WxSubjectType;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class SubmitInfoDto {
    private Integer type;
    private Integer step;
    private String num;
    private Integer subjectType;
    private BusiLicenseDto busiLicense;
    private String merchantShortname;
    private IdCardInfoDto idCardInfo;
    private SuperAdministratorInfoDto superAdministratorInfo;
    private NameInfoDto nameInfo;
    private ReturnInfoDto returnInfo;
    private ReturnInfoDto companyAddress;
    private List<String> specialQualification;
    private List<String> supplementaryMaterial;
    private String supplementaryDesc;

    public void validate() {
        Preconditions.checkArgument((this.step != null && RegisterStep.isExistByType(this.step) ? 1 : 0) != 0, (Object)"step\u4e3a\u7a7a\u6216\u4e0d\u5b58\u5728");
        Preconditions.checkArgument((this.type != null && SubmitInfoOptType.isExistByType(this.type) ? 1 : 0) != 0, (Object)"type\u4e3a\u7a7a\u6216\u4e0d\u5b58\u5728");
        if (RegisterStep.ONE_REGISTER_SHOP_AND_AUTHORIZE.getType().equals(this.step)) {
            Preconditions.checkArgument((this.superAdministratorInfo != null ? 1 : 0) != 0, (Object)"superAdministratorInfo\u4e0d\u80fd\u4e3anull");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.superAdministratorInfo.getName()), (Object)"\u8d85\u7ba1\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.superAdministratorInfo.getIdCardNumber()), (Object)"\u8bc1\u4ef6\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.superAdministratorInfo.getPhone()), (Object)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.superAdministratorInfo.getMail()), (Object)"\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.superAdministratorInfo.getWxName()), (Object)"\u5fae\u4fe1\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        } else if (RegisterStep.TWO_SUBMIT_PAYMENT_QUALIFICATION_VERIFY_ACCOUNT.getType().equals(this.step)) {
            Preconditions.checkArgument((this.subjectType != null && WxSubjectType.isExistByType(this.subjectType) ? 1 : 0) != 0, (Object)"\u4e3b\u4f53\u7c7b\u578b\u4e3a\u7a7a\u6216\u4e0d\u5b58\u5728");
            Preconditions.checkArgument((this.busiLicense != null ? 1 : 0) != 0, (Object)"busiLicense\u4e0d\u80fd\u4e3anull");
            Preconditions.checkArgument((this.busiLicense.getLicenseType() != null && LicenseType.isExistByType(this.busiLicense.getLicenseType()) ? 1 : 0) != 0, (Object)"\u8425\u4e1a\u6267\u7167\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.busiLicense.getPicFile()), (Object)"\u8425\u4e1a\u6267\u7167\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.busiLicense.getRegistrationNum()), (Object)"\u8425\u4e1a\u6267\u7167\u6ce8\u518c\u53f7/\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.busiLicense.getMerchantName()), (Object)"\u8425\u4e1a\u6267\u7167\u5546\u5bb6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.busiLicense.getLegalRepresentative()), (Object)"\u8425\u4e1a\u6267\u7167\u7ecf\u8425\u8005/\u6cd5\u5b9a\u4ee3\u8868\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.busiLicense.getStartDate()), (Object)"\u8425\u4e1a\u6267\u7167\u6ce8\u518c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.merchantShortname), (Object)"\u5546\u6237\u7b80\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((this.idCardInfo != null ? 1 : 0) != 0, (Object)"idCardInfo\u4e0d\u80fd\u4e3anull");
            Preconditions.checkArgument((this.idCardInfo.getType() != null && IdCardType.isExistByType(this.idCardInfo.getType()) ? 1 : 0) != 0, (Object)"\u8bc1\u4ef6\u7c7b\u578b\u4e3a\u7a7a\u6216\u4e0d\u5b58\u5728");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.idCardInfo.getPortraitPicFile()), (Object)"\u4eba\u50cf\u9762\u7167\u7247\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.idCardInfo.getNationPicFile()), (Object)"\u56fd\u5fbd\u9762\u7167\u7247\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.idCardInfo.getIdCardName()), (Object)"\u8bc1\u4ef6\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.idCardInfo.getIdCardNumber()), (Object)"\u8bc1\u4ef6\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.idCardInfo.getStartDate()), (Object)"\u8bc1\u4ef6\u6ce8\u518c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        } else if (RegisterStep.THREE_SHOP_BASIC_INFO_PAYMENT_SIGNING.getType().equals(this.step)) {
            Preconditions.checkArgument((this.nameInfo != null ? 1 : 0) != 0, (Object)"nameInfo\u4e0d\u80fd\u4e3anull");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.nameInfo.getNickname()), (Object)"\u5e97\u94fa\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.nameInfo.getAbbr()), (Object)"\u5e97\u94fa\u7b80\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.nameInfo.getIntroduction()), (Object)"\u4ecb\u7ecd\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((this.returnInfo != null ? 1 : 0) != 0, (Object)"returnInfo\u4e0d\u80fd\u4e3anull");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.returnInfo.getProvinceName()), (Object)"\u7701\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.returnInfo.getTelNumber()), (Object)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.returnInfo.getMail()), (Object)"\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((this.companyAddress != null ? 1 : 0) != 0, (Object)"companyAddress\u4e0d\u80fd\u4e3anull");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.companyAddress.getProvinceName()), (Object)"\u7701\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.companyAddress.getTelNumber()), (Object)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.companyAddress.getMail()), (Object)"\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public Integer getType() {
        return this.type;
    }

    public Integer getStep() {
        return this.step;
    }

    public String getNum() {
        return this.num;
    }

    public Integer getSubjectType() {
        return this.subjectType;
    }

    public BusiLicenseDto getBusiLicense() {
        return this.busiLicense;
    }

    public String getMerchantShortname() {
        return this.merchantShortname;
    }

    public IdCardInfoDto getIdCardInfo() {
        return this.idCardInfo;
    }

    public SuperAdministratorInfoDto getSuperAdministratorInfo() {
        return this.superAdministratorInfo;
    }

    public NameInfoDto getNameInfo() {
        return this.nameInfo;
    }

    public ReturnInfoDto getReturnInfo() {
        return this.returnInfo;
    }

    public ReturnInfoDto getCompanyAddress() {
        return this.companyAddress;
    }

    public List<String> getSpecialQualification() {
        return this.specialQualification;
    }

    public List<String> getSupplementaryMaterial() {
        return this.supplementaryMaterial;
    }

    public String getSupplementaryDesc() {
        return this.supplementaryDesc;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public void setStep(Integer step) {
        this.step = step;
    }

    public void setNum(String num) {
        this.num = num;
    }

    public void setSubjectType(Integer subjectType) {
        this.subjectType = subjectType;
    }

    public void setBusiLicense(BusiLicenseDto busiLicense) {
        this.busiLicense = busiLicense;
    }

    public void setMerchantShortname(String merchantShortname) {
        this.merchantShortname = merchantShortname;
    }

    public void setIdCardInfo(IdCardInfoDto idCardInfo) {
        this.idCardInfo = idCardInfo;
    }

    public void setSuperAdministratorInfo(SuperAdministratorInfoDto superAdministratorInfo) {
        this.superAdministratorInfo = superAdministratorInfo;
    }

    public void setNameInfo(NameInfoDto nameInfo) {
        this.nameInfo = nameInfo;
    }

    public void setReturnInfo(ReturnInfoDto returnInfo) {
        this.returnInfo = returnInfo;
    }

    public void setCompanyAddress(ReturnInfoDto companyAddress) {
        this.companyAddress = companyAddress;
    }

    public void setSpecialQualification(List<String> specialQualification) {
        this.specialQualification = specialQualification;
    }

    public void setSupplementaryMaterial(List<String> supplementaryMaterial) {
        this.supplementaryMaterial = supplementaryMaterial;
    }

    public void setSupplementaryDesc(String supplementaryDesc) {
        this.supplementaryDesc = supplementaryDesc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubmitInfoDto)) {
            return false;
        }
        SubmitInfoDto other = (SubmitInfoDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$type = this.getType();
        Integer other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        Integer this$step = this.getStep();
        Integer other$step = other.getStep();
        if (this$step == null ? other$step != null : !((Object)this$step).equals(other$step)) {
            return false;
        }
        Integer this$subjectType = this.getSubjectType();
        Integer other$subjectType = other.getSubjectType();
        if (this$subjectType == null ? other$subjectType != null : !((Object)this$subjectType).equals(other$subjectType)) {
            return false;
        }
        String this$num = this.getNum();
        String other$num = other.getNum();
        if (this$num == null ? other$num != null : !this$num.equals(other$num)) {
            return false;
        }
        BusiLicenseDto this$busiLicense = this.getBusiLicense();
        BusiLicenseDto other$busiLicense = other.getBusiLicense();
        if (this$busiLicense == null ? other$busiLicense != null : !((Object)this$busiLicense).equals(other$busiLicense)) {
            return false;
        }
        String this$merchantShortname = this.getMerchantShortname();
        String other$merchantShortname = other.getMerchantShortname();
        if (this$merchantShortname == null ? other$merchantShortname != null : !this$merchantShortname.equals(other$merchantShortname)) {
            return false;
        }
        IdCardInfoDto this$idCardInfo = this.getIdCardInfo();
        IdCardInfoDto other$idCardInfo = other.getIdCardInfo();
        if (this$idCardInfo == null ? other$idCardInfo != null : !((Object)this$idCardInfo).equals(other$idCardInfo)) {
            return false;
        }
        SuperAdministratorInfoDto this$superAdministratorInfo = this.getSuperAdministratorInfo();
        SuperAdministratorInfoDto other$superAdministratorInfo = other.getSuperAdministratorInfo();
        if (this$superAdministratorInfo == null ? other$superAdministratorInfo != null : !((Object)this$superAdministratorInfo).equals(other$superAdministratorInfo)) {
            return false;
        }
        NameInfoDto this$nameInfo = this.getNameInfo();
        NameInfoDto other$nameInfo = other.getNameInfo();
        if (this$nameInfo == null ? other$nameInfo != null : !((Object)this$nameInfo).equals(other$nameInfo)) {
            return false;
        }
        ReturnInfoDto this$returnInfo = this.getReturnInfo();
        ReturnInfoDto other$returnInfo = other.getReturnInfo();
        if (this$returnInfo == null ? other$returnInfo != null : !((Object)this$returnInfo).equals(other$returnInfo)) {
            return false;
        }
        ReturnInfoDto this$companyAddress = this.getCompanyAddress();
        ReturnInfoDto other$companyAddress = other.getCompanyAddress();
        if (this$companyAddress == null ? other$companyAddress != null : !((Object)this$companyAddress).equals(other$companyAddress)) {
            return false;
        }
        List<String> this$specialQualification = this.getSpecialQualification();
        List<String> other$specialQualification = other.getSpecialQualification();
        if (this$specialQualification == null ? other$specialQualification != null : !((Object)this$specialQualification).equals(other$specialQualification)) {
            return false;
        }
        List<String> this$supplementaryMaterial = this.getSupplementaryMaterial();
        List<String> other$supplementaryMaterial = other.getSupplementaryMaterial();
        if (this$supplementaryMaterial == null ? other$supplementaryMaterial != null : !((Object)this$supplementaryMaterial).equals(other$supplementaryMaterial)) {
            return false;
        }
        String this$supplementaryDesc = this.getSupplementaryDesc();
        String other$supplementaryDesc = other.getSupplementaryDesc();
        return !(this$supplementaryDesc == null ? other$supplementaryDesc != null : !this$supplementaryDesc.equals(other$supplementaryDesc));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SubmitInfoDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        Integer $step = this.getStep();
        result = result * 59 + ($step == null ? 43 : ((Object)$step).hashCode());
        Integer $subjectType = this.getSubjectType();
        result = result * 59 + ($subjectType == null ? 43 : ((Object)$subjectType).hashCode());
        String $num = this.getNum();
        result = result * 59 + ($num == null ? 43 : $num.hashCode());
        BusiLicenseDto $busiLicense = this.getBusiLicense();
        result = result * 59 + ($busiLicense == null ? 43 : ((Object)$busiLicense).hashCode());
        String $merchantShortname = this.getMerchantShortname();
        result = result * 59 + ($merchantShortname == null ? 43 : $merchantShortname.hashCode());
        IdCardInfoDto $idCardInfo = this.getIdCardInfo();
        result = result * 59 + ($idCardInfo == null ? 43 : ((Object)$idCardInfo).hashCode());
        SuperAdministratorInfoDto $superAdministratorInfo = this.getSuperAdministratorInfo();
        result = result * 59 + ($superAdministratorInfo == null ? 43 : ((Object)$superAdministratorInfo).hashCode());
        NameInfoDto $nameInfo = this.getNameInfo();
        result = result * 59 + ($nameInfo == null ? 43 : ((Object)$nameInfo).hashCode());
        ReturnInfoDto $returnInfo = this.getReturnInfo();
        result = result * 59 + ($returnInfo == null ? 43 : ((Object)$returnInfo).hashCode());
        ReturnInfoDto $companyAddress = this.getCompanyAddress();
        result = result * 59 + ($companyAddress == null ? 43 : ((Object)$companyAddress).hashCode());
        List<String> $specialQualification = this.getSpecialQualification();
        result = result * 59 + ($specialQualification == null ? 43 : ((Object)$specialQualification).hashCode());
        List<String> $supplementaryMaterial = this.getSupplementaryMaterial();
        result = result * 59 + ($supplementaryMaterial == null ? 43 : ((Object)$supplementaryMaterial).hashCode());
        String $supplementaryDesc = this.getSupplementaryDesc();
        result = result * 59 + ($supplementaryDesc == null ? 43 : $supplementaryDesc.hashCode());
        return result;
    }

    public String toString() {
        return "SubmitInfoDto(type=" + this.getType() + ", step=" + this.getStep() + ", num=" + this.getNum() + ", subjectType=" + this.getSubjectType() + ", busiLicense=" + this.getBusiLicense() + ", merchantShortname=" + this.getMerchantShortname() + ", idCardInfo=" + this.getIdCardInfo() + ", superAdministratorInfo=" + this.getSuperAdministratorInfo() + ", nameInfo=" + this.getNameInfo() + ", returnInfo=" + this.getReturnInfo() + ", companyAddress=" + this.getCompanyAddress() + ", specialQualification=" + this.getSpecialQualification() + ", supplementaryMaterial=" + this.getSupplementaryMaterial() + ", supplementaryDesc=" + this.getSupplementaryDesc() + ")";
    }
}

