/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.shop.dto.order;

import cn.hutool.core.date.DateUtil;
import com.google.common.base.Preconditions;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.shop.enums.WxShopOrderStatus;
import org.apache.commons.lang3.StringUtils;

public class OrderLisQueryParam {
    private Integer status;
    private String productName;
    private String orderId;
    private String mobile;
    private String orderStartTime;
    private String orderEndTime;
    private PageDto pageDto;

    public void validate() {
        if (this.status != null) {
            Preconditions.checkArgument((this.status == 0 || WxShopOrderStatus.isExistByStatus(this.status) ? 1 : 0) != 0, (Object)"status\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isNotBlank((CharSequence)this.orderStartTime)) {
            try {
                DateUtil.parse((CharSequence)this.orderStartTime, (String)"yyyy-MM-dd HH:mm:ss");
            }
            catch (Exception e) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "orderStartTime\u683c\u5f0f\u9519\u8bef");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.orderEndTime)) {
            try {
                DateUtil.parse((CharSequence)this.orderEndTime, (String)"yyyy-MM-dd HH:mm:ss");
            }
            catch (Exception e) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "orderEndTime\u683c\u5f0f\u9519\u8bef");
            }
        }
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public String getMobile() {
        return this.mobile;
    }

    public String getOrderStartTime() {
        return this.orderStartTime;
    }

    public String getOrderEndTime() {
        return this.orderEndTime;
    }

    public PageDto getPageDto() {
        return this.pageDto;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public void setOrderStartTime(String orderStartTime) {
        this.orderStartTime = orderStartTime;
    }

    public void setOrderEndTime(String orderEndTime) {
        this.orderEndTime = orderEndTime;
    }

    public void setPageDto(PageDto pageDto) {
        this.pageDto = pageDto;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrderLisQueryParam)) {
            return false;
        }
        OrderLisQueryParam other = (OrderLisQueryParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        String this$productName = this.getProductName();
        String other$productName = other.getProductName();
        if (this$productName == null ? other$productName != null : !this$productName.equals(other$productName)) {
            return false;
        }
        String this$orderId = this.getOrderId();
        String other$orderId = other.getOrderId();
        if (this$orderId == null ? other$orderId != null : !this$orderId.equals(other$orderId)) {
            return false;
        }
        String this$mobile = this.getMobile();
        String other$mobile = other.getMobile();
        if (this$mobile == null ? other$mobile != null : !this$mobile.equals(other$mobile)) {
            return false;
        }
        String this$orderStartTime = this.getOrderStartTime();
        String other$orderStartTime = other.getOrderStartTime();
        if (this$orderStartTime == null ? other$orderStartTime != null : !this$orderStartTime.equals(other$orderStartTime)) {
            return false;
        }
        String this$orderEndTime = this.getOrderEndTime();
        String other$orderEndTime = other.getOrderEndTime();
        if (this$orderEndTime == null ? other$orderEndTime != null : !this$orderEndTime.equals(other$orderEndTime)) {
            return false;
        }
        PageDto this$pageDto = this.getPageDto();
        PageDto other$pageDto = other.getPageDto();
        return !(this$pageDto == null ? other$pageDto != null : !this$pageDto.equals(other$pageDto));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OrderLisQueryParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        String $productName = this.getProductName();
        result = result * 59 + ($productName == null ? 43 : $productName.hashCode());
        String $orderId = this.getOrderId();
        result = result * 59 + ($orderId == null ? 43 : $orderId.hashCode());
        String $mobile = this.getMobile();
        result = result * 59 + ($mobile == null ? 43 : $mobile.hashCode());
        String $orderStartTime = this.getOrderStartTime();
        result = result * 59 + ($orderStartTime == null ? 43 : $orderStartTime.hashCode());
        String $orderEndTime = this.getOrderEndTime();
        result = result * 59 + ($orderEndTime == null ? 43 : $orderEndTime.hashCode());
        PageDto $pageDto = this.getPageDto();
        result = result * 59 + ($pageDto == null ? 43 : $pageDto.hashCode());
        return result;
    }

    public String toString() {
        return "OrderLisQueryParam(status=" + this.getStatus() + ", productName=" + this.getProductName() + ", orderId=" + this.getOrderId() + ", mobile=" + this.getMobile() + ", orderStartTime=" + this.getOrderStartTime() + ", orderEndTime=" + this.getOrderEndTime() + ", pageDto=" + this.getPageDto() + ")";
    }
}

