/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.reply.service.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.perm.service.UserRoleCommonService;
import com.kuaike.scrm.common.service.OrgService;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.quickreply.entity.QuickReply;
import com.kuaike.scrm.dal.quickreply.entity.QuickReplyGroup;
import com.kuaike.scrm.dal.quickreply.entity.QuickReplyGroupOrg;
import com.kuaike.scrm.dal.quickreply.mapper.QuickReplyGroupMapper;
import com.kuaike.scrm.dal.quickreply.mapper.QuickReplyGroupOrgMapper;
import com.kuaike.scrm.dal.quickreply.mapper.QuickReplyMapper;
import com.kuaike.scrm.reply.dto.request.GroupAddReqDto;
import com.kuaike.scrm.reply.dto.request.GroupDeleteReqDto;
import com.kuaike.scrm.reply.dto.request.GroupListReqDto;
import com.kuaike.scrm.reply.dto.request.GroupModReqDto;
import com.kuaike.scrm.reply.dto.request.ReplyDelReqDto;
import com.kuaike.scrm.reply.dto.response.GroupListRespDto;
import com.kuaike.scrm.reply.service.QuickReplyService;
import com.kuaike.scrm.reply.service.ReplyGroupService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReplyGroupServiceImpl
implements ReplyGroupService {
    private static final Logger log = LoggerFactory.getLogger(ReplyGroupServiceImpl.class);
    @Autowired
    private IdGen idGen;
    @Autowired
    private QuickReplyGroupMapper groupMapper;
    @Autowired
    private QuickReplyGroupOrgMapper groupOrgMapper;
    @Autowired
    private QuickReplyService quickReplyService;
    @Autowired
    private QuickReplyMapper quickReplyMapper;
    @Autowired
    private UserRoleCommonService commonService;
    @Autowired
    private OrgService orgService;

    @Override
    public List<GroupListRespDto> groupList(GroupListReqDto reqDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("groupList reqDto: {}, operateId: {}, bizId: {}", new Object[]{reqDto, userInfo.getId(), userInfo.getBizId()});
        List groupList = null;
        groupList = Objects.isNull(reqDto) || Objects.isNull(reqDto.getGroupName()) ? this.groupMapper.allGroupList(userInfo.getBizId()) : this.groupMapper.groupListByGroupName(reqDto.getGroupName(), userInfo.getBizId());
        if (!CollectionUtils.isEmpty((Collection)groupList) && groupList.size() > 0) {
            GroupListRespDto defaultDto;
            int index;
            ArrayList groupRespDto = Lists.newArrayList();
            Set ids = this.commonService.getManageNodeIds();
            ids.add(userInfo.getUserNodeId());
            List parentNodeIds = this.orgService.getParentNodeIdsByBizIdAndNodeId(userInfo.getBizId(), userInfo.getUserNodeId());
            ids.addAll(parentNodeIds);
            log.info("groupList commonService ids: {}", (Object)ids);
            Set departMentIds = this.orgService.getDepartmentIds(ids);
            log.info("groupList orgService departMentIds: {}", (Object)departMentIds);
            block0: for (QuickReplyGroup group : groupList) {
                GroupListRespDto respDto = new GroupListRespDto();
                respDto.setId(group.getNum());
                respDto.setGroupName(group.getGroupName());
                respDto.setVisibleType(group.getVisibleType());
                respDto.setIsDefault(group.getIsDefault());
                ArrayList nodeIds = Lists.newArrayList();
                if (group.getVisibleType() == 2) {
                    List groupOrgList = this.groupOrgMapper.groupOrgList(group.getId(), userInfo.getBizId());
                    if (!CollectionUtils.isNotEmpty((Collection)groupOrgList)) continue;
                    for (QuickReplyGroupOrg groupOrg : groupOrgList) {
                        nodeIds.add(groupOrg.getNodeId());
                    }
                    for (Long nodeId : nodeIds) {
                        if (!departMentIds.contains(nodeId.intValue())) continue;
                        respDto.setNodeIds(nodeIds);
                        groupRespDto.add(respDto);
                        continue block0;
                    }
                    continue;
                }
                groupRespDto.add(respDto);
            }
            List defaultList = groupRespDto.stream().filter(n -> n.getIsDefault() == 1).collect(Collectors.toList());
            if (defaultList.size() > 0 && (index = groupRespDto.indexOf(defaultDto = (GroupListRespDto)defaultList.get(0))) > 0) {
                groupRespDto.add(0, groupRespDto.remove(index));
            }
            return groupRespDto;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(GroupAddReqDto reqDto) {
        List<Long> nodeIds;
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("add reqDto: {}, operateId: {}", (Object)reqDto, (Object)userInfo.getId());
        reqDto.validate();
        List groupList = this.groupMapper.allGroupList(userInfo.getBizId());
        if (CollectionUtils.isNotEmpty((Collection)groupList)) {
            Set groupNames = groupList.stream().map(QuickReplyGroup::getGroupName).collect(Collectors.toSet());
            Preconditions.checkArgument((!groupNames.contains(reqDto.getGroupName().trim()) ? 1 : 0) != 0, (Object)"\u5206\u7ec4\u540d\u4e0d\u80fd\u91cd\u590d");
        }
        QuickReplyGroup replyGroup = new QuickReplyGroup();
        replyGroup.setNum(this.idGen.getNum());
        replyGroup.setBizId(userInfo.getBizId());
        replyGroup.setCorpId(userInfo.getCorpId());
        replyGroup.setGroupName(reqDto.getGroupName().trim());
        replyGroup.setVisibleType(reqDto.getVisibleType());
        replyGroup.setCreateBy(userInfo.getId());
        replyGroup.setCreateTime(new Date());
        replyGroup.setUpdateTime(new Date());
        replyGroup.setIsDefault(Integer.valueOf(0));
        this.groupMapper.insertSelective((Object)replyGroup);
        if (reqDto.getVisibleType() == 2 && CollectionUtils.isNotEmpty(nodeIds = reqDto.getNodeIds())) {
            List<QuickReplyGroupOrg> groupOrgList = this.getReplyGroupOrgs(userInfo, replyGroup, nodeIds);
            this.groupOrgMapper.insertOrgList(groupOrgList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void mod(GroupModReqDto reqDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("mod reqDto: {}, operateId: {}, bizId: {}", new Object[]{reqDto, userInfo.getId(), userInfo.getBizId()});
        reqDto.validate();
        QuickReplyGroup replyGroup = this.groupMapper.groupListById(reqDto.getId(), userInfo.getBizId());
        if (replyGroup == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u627e\u4e0d\u5230\u56de\u590dgroup");
        }
        List groupList = this.groupMapper.allGroupList(userInfo.getBizId());
        if (CollectionUtils.isNotEmpty((Collection)groupList)) {
            groupList.remove(replyGroup);
            Set groupNames = groupList.stream().map(QuickReplyGroup::getGroupName).collect(Collectors.toSet());
            Preconditions.checkArgument((!groupNames.contains(reqDto.getGroupName().trim()) ? 1 : 0) != 0, (Object)"\u5206\u7ec4\u540d\u4e0d\u80fd\u91cd\u590d");
        }
        List groupOrgList = this.groupOrgMapper.groupOrgList(replyGroup.getId(), userInfo.getBizId());
        if (reqDto.getVisibleType() == 2) {
            List<Long> nodeIds = reqDto.getNodeIds();
            List<QuickReplyGroupOrg> newGroupOrgList = this.getReplyGroupOrgs(userInfo, replyGroup, nodeIds);
            if (CollectionUtils.isEmpty((Collection)groupOrgList)) {
                this.groupOrgMapper.insertOrgList(newGroupOrgList);
            } else {
                if (groupOrgList.size() > 0) {
                    this.deleteGroupOrgList(groupOrgList, userInfo.getId(), userInfo.getBizId());
                }
                if (newGroupOrgList.size() > 0) {
                    this.groupOrgMapper.insertOrgList(newGroupOrgList);
                }
            }
        } else if (!CollectionUtils.isEmpty((Collection)groupOrgList) && groupOrgList.size() > 0) {
            this.deleteGroupOrgList(groupOrgList, userInfo.getId(), userInfo.getBizId());
        }
        this.groupMapper.updateGroup(reqDto.getId(), reqDto.getGroupName().trim(), reqDto.getVisibleType(), userInfo.getBizId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(GroupDeleteReqDto reqDto) {
        List groupOrgList;
        QuickReplyGroup replyGroup;
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("delete reqDto: {}, operateId: {}, bizId: {}", new Object[]{reqDto, userInfo.getId(), userInfo.getBizId()});
        reqDto.validate();
        List replies = this.quickReplyMapper.getNumsByGroupId(reqDto.getId(), userInfo.getBizId());
        ArrayList nums = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)replies)) {
            for (QuickReply reply : replies) {
                nums.add(reply.getNum());
            }
        }
        log.info("delete nums: {}", (Object)nums);
        if (CollectionUtils.isNotEmpty((Collection)nums)) {
            ReplyDelReqDto delReqDto = new ReplyDelReqDto();
            delReqDto.setNums(nums);
            this.quickReplyService.del(delReqDto);
        }
        if ((replyGroup = this.groupMapper.groupListById(reqDto.getId(), userInfo.getBizId())).getVisibleType() == 2 && !CollectionUtils.isEmpty((Collection)(groupOrgList = this.groupOrgMapper.groupOrgList(replyGroup.getId(), userInfo.getBizId()))) && groupOrgList.size() > 0) {
            this.deleteGroupOrgList(groupOrgList, userInfo.getId(), userInfo.getBizId());
        }
        this.groupMapper.deleteGroup(reqDto.getId(), userInfo.getId(), userInfo.getBizId());
    }

    private List<QuickReplyGroupOrg> getReplyGroupOrgs(CurrentUserInfo userInfo, QuickReplyGroup replyGroup, List<Long> nodeIds) {
        ArrayList groupOrgList = Lists.newArrayList();
        for (Long nodeId : nodeIds) {
            QuickReplyGroupOrg replyGroupOrg = new QuickReplyGroupOrg();
            replyGroupOrg.setNodeId(nodeId);
            replyGroupOrg.setQuickReplyGroupId(replyGroup.getId());
            replyGroupOrg.setBizId(userInfo.getBizId());
            replyGroupOrg.setCorpId(userInfo.getCorpId());
            replyGroupOrg.setNum(replyGroup.getNum());
            replyGroupOrg.setCreateBy(userInfo.getId());
            replyGroupOrg.setCreateTime(replyGroup.getCreateTime());
            replyGroupOrg.setUpdateTime(replyGroup.getCreateTime());
            groupOrgList.add(replyGroupOrg);
        }
        return groupOrgList;
    }

    private void deleteGroupOrgList(List<QuickReplyGroupOrg> removeOrgList, Long userId, Long bizId) {
        ArrayList delOrgIds = Lists.newArrayList();
        for (QuickReplyGroupOrg removeOrg : removeOrgList) {
            delOrgIds.add(removeOrg.getId());
        }
        this.groupOrgMapper.deleteNodeByIds((List)delOrgIds, userId, bizId);
    }
}

