/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.remind.dto.req;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.MoneyConverterUtil;
import com.kuaike.scrm.common.utils.TemplateReplaceUtil;
import com.kuaike.scrm.remind.dto.OrderRemindBaseReq;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;

public class RefundSuccessRemindDto
extends OrderRemindBaseReq {
    private String template = "\u3010\u9000\u6b3e\u6210\u529f\u3011\u60a8\u53d1\u8d77\u7684\u9000\u6b3e\u5355\u5df2\u9000\u6b3e\u6210\u529f\uff01\n\u8ba2\u5355\u7f16\u53f7\uff1a${orderNo}\n\u9000\u6b3e\u5355\u7f16\u53f7\uff1a${refundOrderNum}\n\u9000\u6b3e\u91d1\u989d\uff1a\u00a5${refundAmount}\n\u5ba2\u6237\u540d\u79f0\uff1a${customerName}\n \u624b\u673a\u53f7\uff1a${mobile}\n\u9000\u6b3e\u65f6\u95f4\uff1a${refundTime}";
    private String content;
    private String orderNo;
    private String refundOrderNum;
    private Long refundAmount;
    private String customerName;
    private String mobile;
    private Date refundTime;

    public void buildContent() {
        ConcurrentMap paramsMap = Maps.newConcurrentMap();
        paramsMap.put("${orderNo}", this.orderNo);
        paramsMap.put("${refundOrderNum}", this.refundOrderNum);
        String refundAmountStr = MoneyConverterUtil.liToStr((Long)this.refundAmount);
        paramsMap.put("${refundAmount}", refundAmountStr);
        paramsMap.put("${customerName}", StringUtils.isNotBlank((CharSequence)this.customerName) ? this.customerName : "");
        paramsMap.put("${mobile}", StringUtils.isNotBlank((CharSequence)this.mobile) ? this.mobile : "");
        paramsMap.put("${refundTime}", DateUtil.dateToDateString((Date)this.refundTime));
        this.content = TemplateReplaceUtil.render((String)this.template, (Map)paramsMap);
    }

    @Override
    public void validate() {
        super.validate();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.orderNo), (Object)"\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.refundOrderNum), (Object)"\u9000\u6b3e\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.refundAmount != null ? 1 : 0) != 0, (Object)"\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3anull");
    }

    public String getTemplate() {
        return this.template;
    }

    public String getContent() {
        return this.content;
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    @Override
    public String getRefundOrderNum() {
        return this.refundOrderNum;
    }

    public Long getRefundAmount() {
        return this.refundAmount;
    }

    public String getCustomerName() {
        return this.customerName;
    }

    public String getMobile() {
        return this.mobile;
    }

    public Date getRefundTime() {
        return this.refundTime;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    @Override
    public void setRefundOrderNum(String refundOrderNum) {
        this.refundOrderNum = refundOrderNum;
    }

    public void setRefundAmount(Long refundAmount) {
        this.refundAmount = refundAmount;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public void setRefundTime(Date refundTime) {
        this.refundTime = refundTime;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RefundSuccessRemindDto)) {
            return false;
        }
        RefundSuccessRemindDto other = (RefundSuccessRemindDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$refundAmount = this.getRefundAmount();
        Long other$refundAmount = other.getRefundAmount();
        if (this$refundAmount == null ? other$refundAmount != null : !((Object)this$refundAmount).equals(other$refundAmount)) {
            return false;
        }
        String this$template = this.getTemplate();
        String other$template = other.getTemplate();
        if (this$template == null ? other$template != null : !this$template.equals(other$template)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$orderNo = this.getOrderNo();
        String other$orderNo = other.getOrderNo();
        if (this$orderNo == null ? other$orderNo != null : !this$orderNo.equals(other$orderNo)) {
            return false;
        }
        String this$refundOrderNum = this.getRefundOrderNum();
        String other$refundOrderNum = other.getRefundOrderNum();
        if (this$refundOrderNum == null ? other$refundOrderNum != null : !this$refundOrderNum.equals(other$refundOrderNum)) {
            return false;
        }
        String this$customerName = this.getCustomerName();
        String other$customerName = other.getCustomerName();
        if (this$customerName == null ? other$customerName != null : !this$customerName.equals(other$customerName)) {
            return false;
        }
        String this$mobile = this.getMobile();
        String other$mobile = other.getMobile();
        if (this$mobile == null ? other$mobile != null : !this$mobile.equals(other$mobile)) {
            return false;
        }
        Date this$refundTime = this.getRefundTime();
        Date other$refundTime = other.getRefundTime();
        return !(this$refundTime == null ? other$refundTime != null : !((Object)this$refundTime).equals(other$refundTime));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RefundSuccessRemindDto;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $refundAmount = this.getRefundAmount();
        result = result * 59 + ($refundAmount == null ? 43 : ((Object)$refundAmount).hashCode());
        String $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : $template.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $orderNo = this.getOrderNo();
        result = result * 59 + ($orderNo == null ? 43 : $orderNo.hashCode());
        String $refundOrderNum = this.getRefundOrderNum();
        result = result * 59 + ($refundOrderNum == null ? 43 : $refundOrderNum.hashCode());
        String $customerName = this.getCustomerName();
        result = result * 59 + ($customerName == null ? 43 : $customerName.hashCode());
        String $mobile = this.getMobile();
        result = result * 59 + ($mobile == null ? 43 : $mobile.hashCode());
        Date $refundTime = this.getRefundTime();
        result = result * 59 + ($refundTime == null ? 43 : ((Object)$refundTime).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "RefundSuccessRemindDto(template=" + this.getTemplate() + ", content=" + this.getContent() + ", orderNo=" + this.getOrderNo() + ", refundOrderNum=" + this.getRefundOrderNum() + ", refundAmount=" + this.getRefundAmount() + ", customerName=" + this.getCustomerName() + ", mobile=" + this.getMobile() + ", refundTime=" + this.getRefundTime() + ")";
    }
}

