/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.remind.dto.req;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.kuaike.scrm.common.utils.MoneyConverterUtil;
import com.kuaike.scrm.common.utils.TemplateReplaceUtil;
import com.kuaike.scrm.remind.dto.OrderRemindBaseReq;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;

public class ApprovalRemindDto
extends OrderRemindBaseReq {
    private String msgTemplate = "\u3010\u9000\u6b3e\u5ba1\u6279\u901a\u77e5\u3011\n[${userName}]\u53d1\u8d77\u4e86\u4e00\u4e2a\u9000\u6b3e\u7533\u8bf7\uff0c\u5ba2\u6237\u201c${customerName}\u201d\uff0c\u5546\u54c1\u540d\u79f0\u201c${skuNames}\u201d\uff0c\u9000\u6b3e\u91d1\u989d\u00a5${refundAmount}\u3002\n<a href=\"${approvalUrl}\">>>\u5ba1\u6279</a>";
    private String content;
    private String userName;
    private String customerName;
    private String skuNames;
    private Long refundAmount;
    private String approvalUrl;

    public void buildContent() {
        ConcurrentMap paramsMap = Maps.newConcurrentMap();
        paramsMap.put("${userName}", this.userName);
        paramsMap.put("${customerName}", StringUtils.isNotBlank((CharSequence)this.customerName) ? this.customerName : "");
        paramsMap.put("${skuNames}", StringUtils.isNotBlank((CharSequence)this.skuNames) ? this.skuNames : "");
        String refundAmountStr = MoneyConverterUtil.liToStr((Long)this.refundAmount);
        paramsMap.put("${refundAmount}", refundAmountStr);
        this.content = TemplateReplaceUtil.render((String)this.msgTemplate, (Map)paramsMap);
    }

    @Override
    public void validate() {
        super.validate();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.userName), (Object)"\u6210\u5458\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.refundAmount != null ? 1 : 0) != 0, (Object)"\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3anull");
    }

    public String getMsgTemplate() {
        return this.msgTemplate;
    }

    public String getContent() {
        return this.content;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getCustomerName() {
        return this.customerName;
    }

    public String getSkuNames() {
        return this.skuNames;
    }

    public Long getRefundAmount() {
        return this.refundAmount;
    }

    public String getApprovalUrl() {
        return this.approvalUrl;
    }

    public void setMsgTemplate(String msgTemplate) {
        this.msgTemplate = msgTemplate;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public void setSkuNames(String skuNames) {
        this.skuNames = skuNames;
    }

    public void setRefundAmount(Long refundAmount) {
        this.refundAmount = refundAmount;
    }

    public void setApprovalUrl(String approvalUrl) {
        this.approvalUrl = approvalUrl;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApprovalRemindDto)) {
            return false;
        }
        ApprovalRemindDto other = (ApprovalRemindDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$refundAmount = this.getRefundAmount();
        Long other$refundAmount = other.getRefundAmount();
        if (this$refundAmount == null ? other$refundAmount != null : !((Object)this$refundAmount).equals(other$refundAmount)) {
            return false;
        }
        String this$msgTemplate = this.getMsgTemplate();
        String other$msgTemplate = other.getMsgTemplate();
        if (this$msgTemplate == null ? other$msgTemplate != null : !this$msgTemplate.equals(other$msgTemplate)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$customerName = this.getCustomerName();
        String other$customerName = other.getCustomerName();
        if (this$customerName == null ? other$customerName != null : !this$customerName.equals(other$customerName)) {
            return false;
        }
        String this$skuNames = this.getSkuNames();
        String other$skuNames = other.getSkuNames();
        if (this$skuNames == null ? other$skuNames != null : !this$skuNames.equals(other$skuNames)) {
            return false;
        }
        String this$approvalUrl = this.getApprovalUrl();
        String other$approvalUrl = other.getApprovalUrl();
        return !(this$approvalUrl == null ? other$approvalUrl != null : !this$approvalUrl.equals(other$approvalUrl));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ApprovalRemindDto;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $refundAmount = this.getRefundAmount();
        result = result * 59 + ($refundAmount == null ? 43 : ((Object)$refundAmount).hashCode());
        String $msgTemplate = this.getMsgTemplate();
        result = result * 59 + ($msgTemplate == null ? 43 : $msgTemplate.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $customerName = this.getCustomerName();
        result = result * 59 + ($customerName == null ? 43 : $customerName.hashCode());
        String $skuNames = this.getSkuNames();
        result = result * 59 + ($skuNames == null ? 43 : $skuNames.hashCode());
        String $approvalUrl = this.getApprovalUrl();
        result = result * 59 + ($approvalUrl == null ? 43 : $approvalUrl.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ApprovalRemindDto(msgTemplate=" + this.getMsgTemplate() + ", content=" + this.getContent() + ", userName=" + this.getUserName() + ", customerName=" + this.getCustomerName() + ", skuNames=" + this.getSkuNames() + ", refundAmount=" + this.getRefundAmount() + ", approvalUrl=" + this.getApprovalUrl() + ")";
    }
}

