/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.remind.dto.req;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.enums.sop.SopRemindType;
import com.kuaike.scrm.dal.marketing.entity.SopRemind;
import java.util.Date;
import java.util.Optional;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;

public class AddSopRemindDto {
    private Long bizId;
    private Integer remindType;
    private String remindContent;
    private Date remindTime;
    private Long userId;
    private String customerId;
    private Integer customerType;
    private String mainNum;
    private Long sopId;
    private Long sopContentId;
    private Long sopTemplateId;

    public void validate() {
        Preconditions.checkArgument((this.bizId != null ? 1 : 0) != 0, (Object)"bizId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.remindType != null ? 1 : 0) != 0, (Object)"\u63d0\u9192\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        if (SopRemindType.NO_TEMPLATE.getValue() == this.remindType.intValue()) {
            this.remindContent = Optional.ofNullable(this.remindContent).orElse("");
        } else {
            SopRemindType type = SopRemindType.get((int)this.remindType);
            Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"\u63d0\u9192\u7c7b\u578b\u9519\u8bef");
            this.remindContent = type.getContent();
        }
        Preconditions.checkArgument((this.remindTime != null ? 1 : 0) != 0, (Object)"\u63d0\u9192\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.userId != null ? 1 : 0) != 0, (Object)"\u63d0\u9192\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.mainNum), (Object)"mainNum\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.customerId), (Object)"\u5ba2\u6237Id\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.customerType != null ? 1 : 0) != 0, (Object)"\u5ba2\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.sopId != null ? 1 : 0) != 0, (Object)"sopId\u4e0d\u80fd\u4e3a\u7a7a");
        this.sopContentId = Optional.ofNullable(this.sopContentId).orElse(0L);
        this.sopTemplateId = Optional.ofNullable(this.sopTemplateId).orElse(0L);
    }

    public SopRemind toSopRemind() {
        SopRemind sopRemind = new SopRemind();
        sopRemind.setBizId(this.bizId);
        sopRemind.setRemindType(this.remindType);
        sopRemind.setRemindContent(this.remindContent);
        sopRemind.setRemindTime(this.remindTime);
        sopRemind.setUserId(this.userId);
        sopRemind.setCustomerId(this.customerId);
        sopRemind.setCustomerType(this.customerType);
        sopRemind.setSopId(this.sopId);
        sopRemind.setSopContentId(this.sopContentId);
        sopRemind.setSopTemplateId(this.sopTemplateId);
        Date cTime = new Date();
        sopRemind.setCreateBy(Long.valueOf(-1L));
        sopRemind.setCreateTime(cTime);
        sopRemind.setUpdateBy(Long.valueOf(-1L));
        sopRemind.setUpdateTime(cTime);
        sopRemind.setIsDeleted(NumberUtils.INTEGER_ZERO);
        sopRemind.setSendStatus(NumberUtils.INTEGER_ZERO);
        sopRemind.setFailReason("");
        sopRemind.setMainNum(this.mainNum);
        return sopRemind;
    }

    public Long getBizId() {
        return this.bizId;
    }

    public Integer getRemindType() {
        return this.remindType;
    }

    public String getRemindContent() {
        return this.remindContent;
    }

    public Date getRemindTime() {
        return this.remindTime;
    }

    public Long getUserId() {
        return this.userId;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public Integer getCustomerType() {
        return this.customerType;
    }

    public String getMainNum() {
        return this.mainNum;
    }

    public Long getSopId() {
        return this.sopId;
    }

    public Long getSopContentId() {
        return this.sopContentId;
    }

    public Long getSopTemplateId() {
        return this.sopTemplateId;
    }

    public void setBizId(Long bizId) {
        this.bizId = bizId;
    }

    public void setRemindType(Integer remindType) {
        this.remindType = remindType;
    }

    public void setRemindContent(String remindContent) {
        this.remindContent = remindContent;
    }

    public void setRemindTime(Date remindTime) {
        this.remindTime = remindTime;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public void setCustomerType(Integer customerType) {
        this.customerType = customerType;
    }

    public void setMainNum(String mainNum) {
        this.mainNum = mainNum;
    }

    public void setSopId(Long sopId) {
        this.sopId = sopId;
    }

    public void setSopContentId(Long sopContentId) {
        this.sopContentId = sopContentId;
    }

    public void setSopTemplateId(Long sopTemplateId) {
        this.sopTemplateId = sopTemplateId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddSopRemindDto)) {
            return false;
        }
        AddSopRemindDto other = (AddSopRemindDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$bizId = this.getBizId();
        Long other$bizId = other.getBizId();
        if (this$bizId == null ? other$bizId != null : !((Object)this$bizId).equals(other$bizId)) {
            return false;
        }
        Integer this$remindType = this.getRemindType();
        Integer other$remindType = other.getRemindType();
        if (this$remindType == null ? other$remindType != null : !((Object)this$remindType).equals(other$remindType)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        Integer this$customerType = this.getCustomerType();
        Integer other$customerType = other.getCustomerType();
        if (this$customerType == null ? other$customerType != null : !((Object)this$customerType).equals(other$customerType)) {
            return false;
        }
        Long this$sopId = this.getSopId();
        Long other$sopId = other.getSopId();
        if (this$sopId == null ? other$sopId != null : !((Object)this$sopId).equals(other$sopId)) {
            return false;
        }
        Long this$sopContentId = this.getSopContentId();
        Long other$sopContentId = other.getSopContentId();
        if (this$sopContentId == null ? other$sopContentId != null : !((Object)this$sopContentId).equals(other$sopContentId)) {
            return false;
        }
        Long this$sopTemplateId = this.getSopTemplateId();
        Long other$sopTemplateId = other.getSopTemplateId();
        if (this$sopTemplateId == null ? other$sopTemplateId != null : !((Object)this$sopTemplateId).equals(other$sopTemplateId)) {
            return false;
        }
        String this$remindContent = this.getRemindContent();
        String other$remindContent = other.getRemindContent();
        if (this$remindContent == null ? other$remindContent != null : !this$remindContent.equals(other$remindContent)) {
            return false;
        }
        Date this$remindTime = this.getRemindTime();
        Date other$remindTime = other.getRemindTime();
        if (this$remindTime == null ? other$remindTime != null : !((Object)this$remindTime).equals(other$remindTime)) {
            return false;
        }
        String this$customerId = this.getCustomerId();
        String other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !this$customerId.equals(other$customerId)) {
            return false;
        }
        String this$mainNum = this.getMainNum();
        String other$mainNum = other.getMainNum();
        return !(this$mainNum == null ? other$mainNum != null : !this$mainNum.equals(other$mainNum));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddSopRemindDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $bizId = this.getBizId();
        result = result * 59 + ($bizId == null ? 43 : ((Object)$bizId).hashCode());
        Integer $remindType = this.getRemindType();
        result = result * 59 + ($remindType == null ? 43 : ((Object)$remindType).hashCode());
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        Integer $customerType = this.getCustomerType();
        result = result * 59 + ($customerType == null ? 43 : ((Object)$customerType).hashCode());
        Long $sopId = this.getSopId();
        result = result * 59 + ($sopId == null ? 43 : ((Object)$sopId).hashCode());
        Long $sopContentId = this.getSopContentId();
        result = result * 59 + ($sopContentId == null ? 43 : ((Object)$sopContentId).hashCode());
        Long $sopTemplateId = this.getSopTemplateId();
        result = result * 59 + ($sopTemplateId == null ? 43 : ((Object)$sopTemplateId).hashCode());
        String $remindContent = this.getRemindContent();
        result = result * 59 + ($remindContent == null ? 43 : $remindContent.hashCode());
        Date $remindTime = this.getRemindTime();
        result = result * 59 + ($remindTime == null ? 43 : ((Object)$remindTime).hashCode());
        String $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : $customerId.hashCode());
        String $mainNum = this.getMainNum();
        result = result * 59 + ($mainNum == null ? 43 : $mainNum.hashCode());
        return result;
    }

    public String toString() {
        return "AddSopRemindDto(bizId=" + this.getBizId() + ", remindType=" + this.getRemindType() + ", remindContent=" + this.getRemindContent() + ", remindTime=" + this.getRemindTime() + ", userId=" + this.getUserId() + ", customerId=" + this.getCustomerId() + ", customerType=" + this.getCustomerType() + ", mainNum=" + this.getMainNum() + ", sopId=" + this.getSopId() + ", sopContentId=" + this.getSopContentId() + ", sopTemplateId=" + this.getSopTemplateId() + ")";
    }
}

