/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.remind.dto;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.enums.WeworkNotifyTypeEnums;
import java.io.Serializable;

public class LeadsRemindDto
implements Serializable {
    private String bindTemplate = "${leadsCount}\u4e2a\u65b0\u5206\u914d\u7ebf\u7d22\uff0c>>\u67e5\u770b\u8be6\u60c5";
    private String unbindTemplate = "${leadsCount}\u4e2a\u7ebf\u7d22\u88ab\u56de\u6536\u91ca\u653e\uff0c>>\u67e5\u770b\u8be6\u60c5";
    private Integer notifyType;
    private int leadsCount;

    public void validate() {
        Preconditions.checkArgument((this.notifyType != null ? 1 : 0) != 0, (Object)"\u901a\u77e5\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.notifyType.intValue() == WeworkNotifyTypeEnums.LEADS_BIND_NOTIFY.getValue() || this.notifyType.intValue() == WeworkNotifyTypeEnums.LEADS_UNBIND_NOTIFY.getValue() ? 1 : 0) != 0, (Object)"\u901a\u77e5\u7c7b\u578b\u4e0d\u5bf9");
        Preconditions.checkArgument((this.leadsCount > 0 ? 1 : 0) != 0, (Object)"\u7ebf\u7d22\u6570\u91cf\u8981\u5927\u4e8e0");
    }

    public String buildRemindMsg() {
        this.validate();
        StringBuilder result = new StringBuilder();
        if (this.notifyType.intValue() == WeworkNotifyTypeEnums.LEADS_BIND_NOTIFY.getValue()) {
            result.append(this.bindTemplate.replace("${leadsCount}", String.valueOf(this.leadsCount)));
        } else if (this.notifyType.intValue() == WeworkNotifyTypeEnums.LEADS_UNBIND_NOTIFY.getValue()) {
            result.append(this.unbindTemplate.replace("${leadsCount}", String.valueOf(this.leadsCount)));
        }
        return result.toString();
    }

    public String getBindTemplate() {
        return this.bindTemplate;
    }

    public String getUnbindTemplate() {
        return this.unbindTemplate;
    }

    public Integer getNotifyType() {
        return this.notifyType;
    }

    public int getLeadsCount() {
        return this.leadsCount;
    }

    public void setBindTemplate(String bindTemplate) {
        this.bindTemplate = bindTemplate;
    }

    public void setUnbindTemplate(String unbindTemplate) {
        this.unbindTemplate = unbindTemplate;
    }

    public void setNotifyType(Integer notifyType) {
        this.notifyType = notifyType;
    }

    public void setLeadsCount(int leadsCount) {
        this.leadsCount = leadsCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LeadsRemindDto)) {
            return false;
        }
        LeadsRemindDto other = (LeadsRemindDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLeadsCount() != other.getLeadsCount()) {
            return false;
        }
        Integer this$notifyType = this.getNotifyType();
        Integer other$notifyType = other.getNotifyType();
        if (this$notifyType == null ? other$notifyType != null : !((Object)this$notifyType).equals(other$notifyType)) {
            return false;
        }
        String this$bindTemplate = this.getBindTemplate();
        String other$bindTemplate = other.getBindTemplate();
        if (this$bindTemplate == null ? other$bindTemplate != null : !this$bindTemplate.equals(other$bindTemplate)) {
            return false;
        }
        String this$unbindTemplate = this.getUnbindTemplate();
        String other$unbindTemplate = other.getUnbindTemplate();
        return !(this$unbindTemplate == null ? other$unbindTemplate != null : !this$unbindTemplate.equals(other$unbindTemplate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LeadsRemindDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLeadsCount();
        Integer $notifyType = this.getNotifyType();
        result = result * 59 + ($notifyType == null ? 43 : ((Object)$notifyType).hashCode());
        String $bindTemplate = this.getBindTemplate();
        result = result * 59 + ($bindTemplate == null ? 43 : $bindTemplate.hashCode());
        String $unbindTemplate = this.getUnbindTemplate();
        result = result * 59 + ($unbindTemplate == null ? 43 : $unbindTemplate.hashCode());
        return result;
    }

    public String toString() {
        return "LeadsRemindDto(bindTemplate=" + this.getBindTemplate() + ", unbindTemplate=" + this.getUnbindTemplate() + ", notifyType=" + this.getNotifyType() + ", leadsCount=" + this.getLeadsCount() + ")";
    }
}

