/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.permission.feign;

import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.common.utils.ErrorCodeUtil;
import java.io.Serializable;

public class RestResult<T>
implements Serializable {
    private static final long serialVersionUID = 4361875823065720972L;
    private long code;
    private String msg;
    private T data;
    private PageDto pageDto;

    public RestResult() {
        this.code = 0L;
        this.msg = "";
        this.data = null;
        this.pageDto = null;
    }

    public RestResult(long code, String msg) {
        this.code = code;
        this.msg = msg;
        this.data = null;
        this.pageDto = null;
    }

    public RestResult(long code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
        this.pageDto = null;
    }

    public RestResult(long code, String msg, T data, PageDto pageDto) {
        this.code = code;
        this.msg = msg;
        this.data = data;
        this.pageDto = pageDto;
    }

    public RestResult<T> okRequest() {
        this.code = 200L;
        return this;
    }

    public RestResult<T> data(T data) {
        this.data = data;
        return this;
    }

    public RestResult<T> msg(String msg) {
        this.msg = msg;
        return this;
    }

    public RestResult<T> code(long code) {
        this.code = code;
        return this;
    }

    public RestResult<T> pageDto(PageDto pageDto) {
        this.pageDto = pageDto;
        return this;
    }

    public static <T> RestResult<T> ok() {
        return new RestResult<T>(0L, "");
    }

    public static <T> RestResult<T> ok(T data) {
        return new RestResult<T>(0L, "", data);
    }

    public static <T> RestResult<T> ok(T data, PageDto pageDto) {
        return new RestResult<T>(0L, "", data, pageDto);
    }

    public static <T> RestResult<T> badRequest() {
        return new RestResult<T>(400L, null);
    }

    public static <T> RestResult<T> badRequest(int code) {
        return new RestResult<T>(code, null);
    }

    public static <T> RestResult<T> error(UniverseErrorCode errorCode) {
        return new RestResult<T>(ErrorCodeUtil.getUniverseErrorCode((UniverseErrorCode)errorCode), errorCode.getMessage());
    }

    public static <T> RestResult<T> error(UniverseErrorCode errorCode, String message) {
        return new RestResult<T>(ErrorCodeUtil.getUniverseErrorCode((UniverseErrorCode)errorCode), message);
    }

    public static <T> RestResult<T> error(UniverseErrorCode errorCode, String message, T result) {
        return new RestResult<T>(ErrorCodeUtil.getUniverseErrorCode((UniverseErrorCode)errorCode), message, result);
    }

    public long getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public PageDto getPageDto() {
        return this.pageDto;
    }

    public void setCode(long code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setPageDto(PageDto pageDto) {
        this.pageDto = pageDto;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RestResult)) {
            return false;
        }
        RestResult other = (RestResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        PageDto this$pageDto = this.getPageDto();
        PageDto other$pageDto = other.getPageDto();
        return !(this$pageDto == null ? other$pageDto != null : !this$pageDto.equals(other$pageDto));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RestResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $code = this.getCode();
        result = result * 59 + (int)($code >>> 32 ^ $code);
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        PageDto $pageDto = this.getPageDto();
        result = result * 59 + ($pageDto == null ? 43 : $pageDto.hashCode());
        return result;
    }

    public String toString() {
        return "RestResult(code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ", pageDto=" + this.getPageDto() + ")";
    }
}

