/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.permission.dto.response;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class NodeWithNum {
    private long id;
    private List<Long> ids;
    private Long pid;
    private int level;
    private String name;
    private List<String> names;
    private List<NodeWithNum> children;
    private int userNum;
    private int userNumIncludeChild;
    private String symbol;
    private Boolean disabled;

    public static List<NodeWithNum> buildNodeTrees(List<NodeWithNum> nodes) {
        ArrayList nodeTrees = Lists.newArrayList();
        if (CollectionUtils.isEmpty(nodes)) {
            return nodeTrees;
        }
        Map map = nodes.stream().collect(Collectors.toMap(a -> a.getId(), Function.identity()));
        for (NodeWithNum node : nodes) {
            if (!map.containsKey(node.getPid())) {
                nodeTrees.add(node);
                continue;
            }
            NodeWithNum parent = (NodeWithNum)map.get(node.getPid());
            if (parent.getChildren() == null) {
                parent.setChildren(Lists.newArrayList());
            }
            parent.getChildren().add(node);
        }
        for (NodeWithNum node : nodes) {
            if (map.containsKey(node.getPid())) continue;
            NodeWithNum.buildIdAndNames(node, null, null);
        }
        return nodeTrees;
    }

    private static void buildIdAndNames(NodeWithNum node, List<Long> parentIds, List<String> parentNames) {
        ArrayList ids = Lists.newArrayList();
        ArrayList names = Lists.newArrayList();
        node.setIds(ids);
        node.setNames(names);
        if (parentIds != null) {
            ids.addAll(parentIds);
            names.addAll(parentNames);
        }
        ids.add(node.getId());
        names.add(node.getName());
        if (CollectionUtils.isNotEmpty(node.getChildren())) {
            for (NodeWithNum child : node.getChildren()) {
                NodeWithNum.buildIdAndNames(child, ids, names);
            }
        }
    }

    public static List<NodeWithNum> buildPartOrgNodeTrees(List<NodeWithNum> nodes) {
        ArrayList nodeTrees = Lists.newArrayList();
        if (CollectionUtils.isEmpty(nodes)) {
            return nodeTrees;
        }
        Map<Long, NodeWithNum> map = nodes.stream().collect(Collectors.toMap(a -> a.getId(), Function.identity()));
        for (NodeWithNum node : nodes) {
            if (!"1".equals(node.getSymbol())) continue;
            if (!map.containsKey(node.getPid())) {
                nodeTrees.add(node);
                continue;
            }
            NodeWithNum parent = NodeWithNum.findInstitutionParent(node, map);
            if (parent == null) continue;
            if (parent.getChildren() == null) {
                parent.setChildren(Lists.newArrayList());
            }
            parent.getChildren().add(node);
        }
        for (NodeWithNum node : nodes) {
            if (map.containsKey(node.getPid())) continue;
            NodeWithNum.buildIdAndNames(node, null, null);
        }
        return nodeTrees;
    }

    public static NodeWithNum findInstitutionParent(NodeWithNum node, Map<Long, NodeWithNum> map) {
        if (map.containsKey(node.getPid())) {
            NodeWithNum parent = map.get(node.getPid());
            if ("1".equals(parent.getSymbol())) {
                return parent;
            }
            return NodeWithNum.findInstitutionParent(parent, map);
        }
        return null;
    }

    public long getId() {
        return this.id;
    }

    public List<Long> getIds() {
        return this.ids;
    }

    public Long getPid() {
        return this.pid;
    }

    public int getLevel() {
        return this.level;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getNames() {
        return this.names;
    }

    public List<NodeWithNum> getChildren() {
        return this.children;
    }

    public int getUserNum() {
        return this.userNum;
    }

    public int getUserNumIncludeChild() {
        return this.userNumIncludeChild;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public Boolean getDisabled() {
        return this.disabled;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setIds(List<Long> ids) {
        this.ids = ids;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNames(List<String> names) {
        this.names = names;
    }

    public void setChildren(List<NodeWithNum> children) {
        this.children = children;
    }

    public void setUserNum(int userNum) {
        this.userNum = userNum;
    }

    public void setUserNumIncludeChild(int userNumIncludeChild) {
        this.userNumIncludeChild = userNumIncludeChild;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NodeWithNum)) {
            return false;
        }
        NodeWithNum other = (NodeWithNum)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getLevel() != other.getLevel()) {
            return false;
        }
        if (this.getUserNum() != other.getUserNum()) {
            return false;
        }
        if (this.getUserNumIncludeChild() != other.getUserNumIncludeChild()) {
            return false;
        }
        Long this$pid = this.getPid();
        Long other$pid = other.getPid();
        if (this$pid == null ? other$pid != null : !((Object)this$pid).equals(other$pid)) {
            return false;
        }
        Boolean this$disabled = this.getDisabled();
        Boolean other$disabled = other.getDisabled();
        if (this$disabled == null ? other$disabled != null : !((Object)this$disabled).equals(other$disabled)) {
            return false;
        }
        List<Long> this$ids = this.getIds();
        List<Long> other$ids = other.getIds();
        if (this$ids == null ? other$ids != null : !((Object)this$ids).equals(other$ids)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<String> this$names = this.getNames();
        List<String> other$names = other.getNames();
        if (this$names == null ? other$names != null : !((Object)this$names).equals(other$names)) {
            return false;
        }
        List<NodeWithNum> this$children = this.getChildren();
        List<NodeWithNum> other$children = other.getChildren();
        if (this$children == null ? other$children != null : !((Object)this$children).equals(other$children)) {
            return false;
        }
        String this$symbol = this.getSymbol();
        String other$symbol = other.getSymbol();
        return !(this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NodeWithNum;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        result = result * 59 + this.getLevel();
        result = result * 59 + this.getUserNum();
        result = result * 59 + this.getUserNumIncludeChild();
        Long $pid = this.getPid();
        result = result * 59 + ($pid == null ? 43 : ((Object)$pid).hashCode());
        Boolean $disabled = this.getDisabled();
        result = result * 59 + ($disabled == null ? 43 : ((Object)$disabled).hashCode());
        List<Long> $ids = this.getIds();
        result = result * 59 + ($ids == null ? 43 : ((Object)$ids).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<String> $names = this.getNames();
        result = result * 59 + ($names == null ? 43 : ((Object)$names).hashCode());
        List<NodeWithNum> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        String $symbol = this.getSymbol();
        result = result * 59 + ($symbol == null ? 43 : $symbol.hashCode());
        return result;
    }

    public String toString() {
        return "NodeWithNum(id=" + this.getId() + ", ids=" + this.getIds() + ", pid=" + this.getPid() + ", level=" + this.getLevel() + ", name=" + this.getName() + ", names=" + this.getNames() + ", children=" + this.getChildren() + ", userNum=" + this.getUserNum() + ", userNumIncludeChild=" + this.getUserNumIncludeChild() + ", symbol=" + this.getSymbol() + ", disabled=" + this.getDisabled() + ")";
    }
}

