/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.payconfig.service.impl;

import cn.kinyun.customer.center.dto.req.QueryOrderListReq;
import cn.kinyun.customer.center.dto.resp.OrderListResp;
import cn.kinyun.customer.center.dto.resp.PageOrderListResp;
import cn.kinyun.customer.center.enums.RefundTypeEnum;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import cn.kinyun.customer.center.service.CcCustomerOrderService;
import cn.kinyun.pay.business.dto.request.audit.trans.ManualTransReq;
import cn.kinyun.pay.business.dto.request.audit.trans.TransBatchItemQueryResp;
import cn.kinyun.pay.business.dto.request.audit.trans.TransBatchListQueryResp;
import cn.kinyun.pay.business.dto.request.audit.trans.TransListCalReq;
import cn.kinyun.pay.business.dto.request.audit.trans.TransListQueryResp;
import cn.kinyun.pay.business.service.PayTransAuditService;
import cn.kinyun.scrm.payconfig.dto.req.trans.TransBatchItemDto;
import cn.kinyun.scrm.payconfig.dto.req.trans.TransBatchItemQuery;
import cn.kinyun.scrm.payconfig.dto.req.trans.TransBatchListQuery;
import cn.kinyun.scrm.payconfig.dto.req.trans.TransCalDto;
import cn.kinyun.scrm.payconfig.dto.req.trans.TransItemDto;
import cn.kinyun.scrm.payconfig.dto.req.trans.TransListQueryReq;
import cn.kinyun.scrm.payconfig.service.PayTransWrapService;
import com.google.common.collect.Lists;
import com.kuaike.scrm.common.service.ScrmBizService;
import com.kuaike.scrm.common.service.ScrmUserService;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.payorder.entity.PayRefundRecord;
import com.kuaike.scrm.dal.payorder.mapper.PayRefundRecordMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayTransWrapServiceImpl
implements PayTransWrapService {
    private static final Logger log = LoggerFactory.getLogger(PayTransWrapServiceImpl.class);
    @Autowired
    private PayTransAuditService payTransAuditService;
    @Autowired
    private CcCustomerOrderService customerService;
    @Autowired
    private PayRefundRecordMapper payRefundRecordMapper;
    @Autowired
    private ScrmUserService scrmUserService;
    @Autowired
    private CcCustomerNumService ccCustomerNumService;
    @Autowired
    private ScrmBizService scrmBizService;

    @Override
    public List<TransItemDto> queryList(TransListQueryReq req) {
        TransListQueryResp transListQueryResp;
        log.info("queryList with req={}", (Object)req);
        req.validate();
        String corpId = LoginUtils.getCurrentUserCorpId();
        Long bizId = LoginUtils.getCurrentUserBizId();
        ArrayList list = Lists.newArrayList();
        cn.kinyun.pay.business.dto.request.audit.trans.TransListQueryReq transListQueryReq = this.buildTransListQueryReq(req, corpId, bizId);
        if (Objects.isNull(transListQueryReq)) {
            return list;
        }
        boolean isMainBiz = this.scrmBizService.isMainBiz(bizId);
        if (isMainBiz) {
            transListQueryReq.setExcludeCorpIds(this.scrmBizService.excludeCorpIds());
        }
        if (Objects.isNull(transListQueryResp = this.payTransAuditService.queryList(transListQueryReq)) || CollectionUtils.isEmpty((Collection)transListQueryResp.getList())) {
            return list;
        }
        if (Objects.nonNull(req.getPageDto())) {
            req.setPageDto(transListQueryResp.getPageDto());
        }
        List bizTransNums = transListQueryResp.getList().stream().map(a -> a.getBizTransNum()).collect(Collectors.toList());
        List refundRecords = this.payRefundRecordMapper.queryRefundRecordByRefundNums(bizTransNums);
        Map<String, String> bizTransNum2OrderNum = refundRecords.stream().collect(Collectors.toMap(a -> a.getRefundNum(), a -> a.getOrderNum()));
        List createUserIds = refundRecords.stream().map(a -> a.getCreateBy()).collect(Collectors.toList());
        Map userId2Name = this.scrmUserService.getNameByIds(createUserIds);
        Map<String, PayRefundRecord> refundNum2PayRefundRecord = refundRecords.stream().collect(Collectors.toMap(a -> a.getRefundNum(), a -> a));
        QueryOrderListReq orderListReq = new QueryOrderListReq();
        orderListReq.setBizId(bizId);
        orderListReq.setOrderNos((List)Lists.newArrayList(bizTransNum2OrderNum.values()));
        if (isMainBiz) {
            orderListReq.setIsSystemAdmin(Boolean.valueOf(true));
            orderListReq.setExcludeBizIds(this.scrmBizService.excludeBizIds());
        }
        PageOrderListResp orderList = this.customerService.orderList(orderListReq);
        List mobiles = orderList.getList().stream().map(a -> a.getCustomerMobile()).distinct().collect(Collectors.toList());
        Map<String, OrderListResp> orderNum2OrderItem = orderList.getList().stream().collect(Collectors.toMap(a -> a.getOrderNo(), a -> a));
        for (cn.kinyun.pay.business.dto.request.audit.trans.TransItemDto dto : transListQueryResp.getList()) {
            TransItemDto item = this.buildTransItemDto(bizTransNum2OrderNum, userId2Name, refundNum2PayRefundRecord, orderNum2OrderItem, dto);
            list.add(item);
        }
        return list;
    }

    private TransItemDto buildTransItemDto(Map<String, String> bizTransNum2OrderNum, Map<Long, String> userId2Name, Map<String, PayRefundRecord> refundNum2PayRefundRecord, Map<String, OrderListResp> orderNum2OrderItem, cn.kinyun.pay.business.dto.request.audit.trans.TransItemDto dto) {
        TransItemDto item = new TransItemDto();
        item.setBatchNum(dto.getBatchNum());
        item.setBizTransNum(dto.getBizTransNum());
        item.setRemark(dto.getRemark());
        item.setStatus(dto.getStatus());
        item.setStatusDesc(dto.getStatusDesc());
        String orderNum = bizTransNum2OrderNum.getOrDefault(dto.getBizTransNum(), "");
        OrderListResp orderListResp = orderNum2OrderItem.get(orderNum);
        if (Objects.nonNull(orderListResp)) {
            item.setCustomerPhone(orderListResp.getCustomerMobile());
            item.setCustomerName(orderListResp.getCustomerName());
            item.setCustomerNum(orderListResp.getCustomerNum());
            item.setBizId(orderListResp.getBizId());
        }
        item.setAppId(dto.getAppId());
        item.setOrderNum(orderNum);
        item.setRefundMethod(RefundTypeEnum.TRANSFER.getDesc());
        item.setRequestId(dto.getRequestId());
        item.setReceiveAccount(dto.getReceiveAccount());
        item.setReceiveName(dto.getReceiveName());
        item.setReceivePhoneNum(dto.getReceivePhoneNum());
        PayRefundRecord refundRecord = refundNum2PayRefundRecord.get(dto.getBizTransNum());
        if (Objects.nonNull(refundRecord)) {
            item.setRefundOperateTime(refundRecord.getCreateTime());
            item.setRefundOperatorName(userId2Name.get(refundRecord.getCreateBy()));
        }
        item.setTransAmount(dto.getTransAmount().toString());
        item.setSuccessTime(dto.getSuccessTime());
        item.setThirdPartMsg(dto.getThirdPartMsg());
        item.setThirdPartStatus(dto.getThirdPartStatus());
        item.setTransType(dto.getTransType());
        item.setTransTypeDesc(dto.getTransTypeDesc());
        item.setTransSeq(dto.getOutTransNum());
        item.setTransNum(dto.getTransNum());
        return item;
    }

    private cn.kinyun.pay.business.dto.request.audit.trans.TransListQueryReq buildTransListQueryReq(TransListQueryReq req, String corpId, Long bizId) {
        cn.kinyun.pay.business.dto.request.audit.trans.TransListQueryReq transListQueryReq = new cn.kinyun.pay.business.dto.request.audit.trans.TransListQueryReq();
        List<Object> bizTransNums = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)req.getProductNameQuery()) || StringUtils.isNotBlank((CharSequence)req.getCustomerQuery()) || StringUtils.isNotBlank((CharSequence)req.getOrderNumQuery())) {
            PageOrderListResp orderListResp;
            List<Object> productBizOrderNums = Lists.newArrayList();
            QueryOrderListReq orderListReq = new QueryOrderListReq();
            orderListReq.setBizId(bizId);
            orderListReq.setSkuName(req.getProductNameQuery());
            orderListReq.setNameOrMobile(req.getCustomerQuery());
            orderListReq.setOrderNo(req.getOrderNumQuery());
            boolean isMainBiz = this.scrmBizService.isMainBiz(bizId);
            if (isMainBiz) {
                orderListReq.setIsSystemAdmin(Boolean.valueOf(true));
                orderListReq.setExcludeBizIds(this.scrmBizService.excludeBizIds());
            }
            if (Objects.nonNull(orderListResp = this.customerService.orderList(orderListReq))) {
                productBizOrderNums = orderListResp.getList().stream().map(a -> a.getOrderNo()).collect(Collectors.toList());
            }
            if (CollectionUtils.isNotEmpty((Collection)productBizOrderNums)) {
                List refundRecords = this.payRefundRecordMapper.queryRefundRecordsByBizOrderNums((Collection)productBizOrderNums, Integer.valueOf(RefundTypeEnum.TRANSFER.getValue()));
                bizTransNums = refundRecords.stream().map(a -> a.getRefundNum()).collect(Collectors.toList());
                if (CollectionUtils.isEmpty((Collection)bizTransNums)) {
                    return null;
                }
            } else {
                return null;
            }
        }
        transListQueryReq.setBizTransQuery(req.getBizTransQuery());
        transListQueryReq.setPageDto(req.getPageDto());
        transListQueryReq.setCorpId(corpId);
        transListQueryReq.setStartTime(req.getStartTime());
        transListQueryReq.setEndTime(req.getEndTime());
        transListQueryReq.setStatusList(req.getStatusList());
        transListQueryReq.setSelectedRequestId(req.getSelectedRequestId());
        transListQueryReq.setBizTransNums((List)bizTransNums);
        return transListQueryReq;
    }

    @Override
    public TransCalDto queryCal(cn.kinyun.scrm.payconfig.dto.req.trans.TransListCalReq req) {
        log.info("queryCal with req={}", (Object)req);
        req.validate();
        String corpId = LoginUtils.getCurrentUserCorpId();
        Long bizId = LoginUtils.getCurrentUserBizId();
        TransListCalReq transListCalReq = new TransListCalReq();
        transListCalReq.setQuery(this.buildTransListQueryReq(req.getQuery(), corpId, bizId));
        transListCalReq.setSelectMode(req.getSelectMode());
        if (Objects.isNull(transListCalReq.getQuery())) {
            return null;
        }
        boolean isMainBiz = this.scrmBizService.isMainBiz(bizId);
        if (isMainBiz) {
            transListCalReq.getQuery().setExcludeCorpIds(this.scrmBizService.excludeCorpIds());
        }
        cn.kinyun.pay.business.dto.request.audit.trans.TransCalDto transCalDto = this.payTransAuditService.queryCal(transListCalReq);
        TransCalDto result = new TransCalDto();
        result.setTotalAmount(transCalDto.getTotalAmount().toString());
        result.setCount(transCalDto.getCount());
        return result;
    }

    @Override
    public void submitTrans(cn.kinyun.scrm.payconfig.dto.req.trans.ManualTransReq req) {
        log.info("submitTrans with req={}", (Object)req);
        req.validate();
        String corpId = LoginUtils.getCurrentUserCorpId();
        Long bizId = LoginUtils.getCurrentUserBizId();
        Long userId = LoginUtils.getCurrentUserId();
        ManualTransReq manualTransReq = new ManualTransReq();
        manualTransReq.setQuery(this.buildTransListQueryReq(req.getQuery(), corpId, bizId));
        if (Objects.isNull(manualTransReq.getQuery())) {
            return;
        }
        boolean isMainBiz = this.scrmBizService.isMainBiz(bizId);
        if (isMainBiz) {
            manualTransReq.getQuery().setExcludeCorpIds(this.scrmBizService.excludeCorpIds());
        }
        manualTransReq.setSelectMode(req.getSelectMode());
        manualTransReq.setRemark(req.getRemark());
        manualTransReq.setSmsVerify(req.getSmsVerify());
        manualTransReq.setOperatorId(userId);
        this.payTransAuditService.submitTrans(manualTransReq);
    }

    @Override
    public void rejectTrans(cn.kinyun.scrm.payconfig.dto.req.trans.ManualTransReq req) {
        log.info("rejectTrans with req={}", (Object)req);
        req.rejectValidate();
        String corpId = LoginUtils.getCurrentUserCorpId();
        Long bizId = LoginUtils.getCurrentUserBizId();
        Long userId = LoginUtils.getCurrentUserId();
        ManualTransReq manualTransReq = new ManualTransReq();
        manualTransReq.setQuery(this.buildTransListQueryReq(req.getQuery(), corpId, bizId));
        if (Objects.isNull(manualTransReq.getQuery())) {
            return;
        }
        boolean isMainBiz = this.scrmBizService.isMainBiz(bizId);
        if (isMainBiz) {
            manualTransReq.getQuery().setExcludeCorpIds(this.scrmBizService.excludeCorpIds());
        }
        manualTransReq.setSelectMode(req.getSelectMode());
        manualTransReq.setRemark(req.getRemark());
        manualTransReq.setSmsVerify(req.getSmsVerify());
        manualTransReq.setOperatorId(userId);
        this.payTransAuditService.rejectTrans(manualTransReq);
    }

    @Override
    public void markTrans(cn.kinyun.scrm.payconfig.dto.req.trans.ManualTransReq req) {
        log.info("markTrans with req={}", (Object)req);
        req.rejectValidate();
        String corpId = LoginUtils.getCurrentUserCorpId();
        Long bizId = LoginUtils.getCurrentUserBizId();
        Long userId = LoginUtils.getCurrentUserId();
        ManualTransReq manualTransReq = new ManualTransReq();
        manualTransReq.setQuery(this.buildTransListQueryReq(req.getQuery(), corpId, bizId));
        if (Objects.isNull(manualTransReq.getQuery())) {
            return;
        }
        boolean isMainBiz = this.scrmBizService.isMainBiz(bizId);
        if (isMainBiz) {
            manualTransReq.getQuery().setExcludeCorpIds(this.scrmBizService.excludeCorpIds());
        }
        manualTransReq.setSelectMode(req.getSelectMode());
        manualTransReq.setRemark(req.getRemark());
        manualTransReq.setSmsVerify(req.getSmsVerify());
        manualTransReq.setOperatorId(userId);
        this.payTransAuditService.markTrans(manualTransReq);
    }

    @Override
    public List<TransBatchItemDto> queryTransBatchList(TransBatchListQuery req) {
        log.info("queryTransBatchList with req={}", (Object)req);
        req.validate();
        String corpId = LoginUtils.getCurrentUserCorpId();
        cn.kinyun.pay.business.dto.request.audit.trans.TransBatchListQuery transBatchListQuery = new cn.kinyun.pay.business.dto.request.audit.trans.TransBatchListQuery();
        transBatchListQuery.setBatchNumQuery(req.getBatchNumQuery());
        transBatchListQuery.setCorpId(corpId);
        transBatchListQuery.setTransNumQuery(req.getTransNumQuery());
        transBatchListQuery.setPageDto(req.getPageDto());
        transBatchListQuery.setStartTime(req.getStartTime());
        transBatchListQuery.setEndTime(req.getEndTime());
        boolean isMainBiz = this.scrmBizService.isMainBiz(LoginUtils.getCurrentUserBizId());
        if (isMainBiz) {
            transBatchListQuery.setExcludeCorpIds(this.scrmBizService.excludeCorpIds());
        }
        TransBatchListQueryResp transBatchListQueryResp = this.payTransAuditService.queryTransBatchList(transBatchListQuery);
        ArrayList list = Lists.newArrayList();
        if (Objects.nonNull(req.getPageDto())) {
            req.setPageDto(transBatchListQueryResp.getPageDto());
        }
        for (cn.kinyun.pay.business.dto.request.audit.trans.TransBatchItemDto dto : transBatchListQueryResp.getList()) {
            TransBatchItemDto item = new TransBatchItemDto();
            item.setTransAmount(dto.getTransAmount().toString());
            item.setCreateTime(dto.getCreateTime());
            item.setFailAmount(dto.getFailAmount().toString());
            item.setOperatorName(dto.getOperatorName());
            item.setFailCount(dto.getFailCount());
            item.setSuccessAmount(dto.getSuccessAmount().toString());
            item.setSuccessCount(dto.getSuccessCount());
            item.setTransCount(dto.getTransCount());
            item.setBatchNum(dto.getBatchNum());
            item.setRemark(dto.getRemark());
            item.setStatus(dto.getStatus());
            item.setStatusDesc(dto.getStatusDesc());
            list.add(item);
        }
        return list;
    }

    @Override
    public List<TransItemDto> queryTransBatchItems(TransBatchItemQuery req) {
        log.info("queryTransBatchItems with req={}", (Object)req);
        req.validate();
        String corpId = LoginUtils.getCurrentUserCorpId();
        Long bizId = LoginUtils.getCurrentUserBizId();
        ArrayList list = Lists.newArrayList();
        cn.kinyun.pay.business.dto.request.audit.trans.TransBatchItemQuery transBatchItemQuery = new cn.kinyun.pay.business.dto.request.audit.trans.TransBatchItemQuery();
        transBatchItemQuery.setCorpId(corpId);
        transBatchItemQuery.setTransBatchNum(req.getTransBatchNum());
        transBatchItemQuery.setPageDto(req.getPageDto());
        transBatchItemQuery.setTransStatusList(req.getTransStatusList());
        boolean isMainBiz = this.scrmBizService.isMainBiz(bizId);
        if (isMainBiz) {
            transBatchItemQuery.setExcludeCorpIds(this.scrmBizService.excludeCorpIds());
        }
        TransBatchItemQueryResp transBatchItemQueryResp = this.payTransAuditService.queryTransBatchItems(transBatchItemQuery);
        if (Objects.nonNull(req.getPageDto())) {
            req.setPageDto(transBatchItemQueryResp.getPageDto());
        }
        List bizTransNums = transBatchItemQueryResp.getList().stream().map(a -> a.getBizTransNum()).collect(Collectors.toList());
        List refundRecords = this.payRefundRecordMapper.queryRefundRecordByRefundNums(bizTransNums);
        Map<String, String> bizTransNum2OrderNum = refundRecords.stream().collect(Collectors.toMap(a -> a.getRefundNum(), a -> a.getOrderNum()));
        List createUserIds = refundRecords.stream().map(a -> a.getCreateBy()).collect(Collectors.toList());
        Map userId2Name = this.scrmUserService.getNameByIds(createUserIds);
        Map<String, PayRefundRecord> refundNum2PayRefundRecord = refundRecords.stream().collect(Collectors.toMap(a -> a.getRefundNum(), a -> a));
        QueryOrderListReq orderListReq = new QueryOrderListReq();
        orderListReq.setBizId(bizId);
        orderListReq.setOrderNos((List)Lists.newArrayList(bizTransNum2OrderNum.values()));
        if (isMainBiz) {
            orderListReq.setIsSystemAdmin(Boolean.valueOf(true));
            orderListReq.setExcludeBizIds(this.scrmBizService.excludeBizIds());
        }
        PageOrderListResp orderList = this.customerService.orderList(orderListReq);
        Map<String, OrderListResp> orderNum2OrderItem = orderList.getList().stream().collect(Collectors.toMap(a -> a.getOrderNo(), a -> a));
        for (cn.kinyun.pay.business.dto.request.audit.trans.TransItemDto dto : transBatchItemQueryResp.getList()) {
            TransItemDto item = this.buildTransItemDto(bizTransNum2OrderNum, userId2Name, refundNum2PayRefundRecord, orderNum2OrderItem, dto);
            list.add(item);
        }
        return list;
    }
}

