/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.payconfig.service.impl;

import cn.kinyun.pay.business.dto.request.PayConfigAddReq;
import cn.kinyun.pay.business.dto.request.PayConfigBaseReq;
import cn.kinyun.pay.business.dto.request.PayConfigGroupAddReq;
import cn.kinyun.pay.business.dto.request.PayConfigGroupQuery;
import cn.kinyun.pay.business.dto.request.PayConfigGroupReq;
import cn.kinyun.pay.business.dto.request.PayConfigListReq;
import cn.kinyun.pay.business.dto.request.PayConfigModReq;
import cn.kinyun.pay.business.dto.request.PayConfigSwitchReq;
import cn.kinyun.pay.business.dto.request.ScrmPayConfigDto;
import cn.kinyun.pay.business.dto.response.PayConfigChannelItem;
import cn.kinyun.pay.business.dto.response.PayConfigGroup;
import cn.kinyun.pay.business.dto.response.PayConfigGroupDto;
import cn.kinyun.pay.business.dto.response.PayConfigGroupDtoResp;
import cn.kinyun.pay.business.dto.response.PayConfigGroupItem;
import cn.kinyun.pay.business.dto.response.PayConfigGroupItemResp;
import cn.kinyun.pay.business.dto.response.PayConfigListResp;
import cn.kinyun.pay.business.dto.response.PayConfigPlainListResp;
import cn.kinyun.pay.business.enums.PayChannelCode;
import cn.kinyun.pay.business.service.ScrmPayConfigService;
import cn.kinyun.scrm.payconfig.dto.PayChannelDto;
import cn.kinyun.scrm.payconfig.dto.PayConfigDto;
import cn.kinyun.scrm.payconfig.service.PayConfigService;
import com.google.common.collect.Lists;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.common.utils.lang.BeanUtil;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountMapper;
import com.kuaike.scrm.dal.payconfig.entity.PayConfig;
import com.kuaike.scrm.dal.payconfig.mapper.PayConfigMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PayConfigServiceImpl
implements PayConfigService {
    private static final Logger log = LoggerFactory.getLogger(PayConfigServiceImpl.class);
    @Resource
    private PayConfigMapper payConfigMapper;
    @Resource
    private OfficialAccountMapper officialAccountMapper;
    @Autowired
    private ScrmPayConfigService scrmPayConfigService;

    @Override
    @Transactional
    public void setConfig(PayConfigDto params) {
        log.info("pay set config params: {}", (Object)params);
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        params.validate();
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        String corpName = userInfo.getBizName();
        Date curTime = new Date();
        PayConfig config = this.payConfigMapper.getConfigByBizId(userInfo.getBizId(), PayChannelCode.PAY_CHANNEL_CODE_WEIXIN.getValue());
        boolean needSync = false;
        if (config == null) {
            config = (PayConfig)BeanUtil.convert((Object)params, PayConfig.class, (String[])new String[0]);
            config.setAppId("");
            config.setBizId(userInfo.getBizId());
            config.setPayType(PayChannelCode.PAY_CHANNEL_CODE_WEIXIN.getValue());
            config.setAppConfig(JacksonUtil.obj2Str(params.getAppIds()));
            config.setCreateBy(userInfo.getId());
            config.setUpdateBy(userInfo.getId());
            config.setCreateTime(curTime);
            config.setUpdateTime(curTime);
            this.payConfigMapper.insertSelective((Object)config);
            needSync = true;
        } else {
            if (!Objects.equals(params.getOpen(), config.getOpen())) {
                needSync = true;
            }
            if (!params.getPayId().equals(config.getPayId())) {
                needSync = true;
            }
            if (!params.getPaySecret().equals(config.getPaySecret())) {
                needSync = true;
            }
            if (StringUtils.isEmpty((CharSequence)config.getPayCertUrl()) && StringUtils.isNotBlank((CharSequence)params.getPayCertUrl())) {
                needSync = true;
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{config.getPayCertUrl(), params.getPayCertUrl()}) && !Objects.equals(config.getPayCertUrl(), params.getPayCertUrl())) {
                needSync = true;
            }
            if (CollectionUtils.isNotEmpty(params.getAppIds())) {
                needSync = true;
            }
            config.setOpen(params.getOpen());
            config.setPayId(params.getPayId());
            config.setPaySecret(params.getPaySecret());
            config.setPayCertUrl(params.getPayCertUrl());
            config.setAppConfig(JacksonUtil.obj2Str(params.getAppIds()));
            config.setUpdateBy(userInfo.getId());
            config.setUpdateTime(curTime);
            this.payConfigMapper.updateByPrimaryKey((Object)config);
        }
        if (needSync && CollectionUtils.isNotEmpty(params.getAppIds())) {
            ScrmPayConfigDto configDto = new ScrmPayConfigDto();
            configDto.setBizId(bizId);
            configDto.setCorpId(corpId);
            configDto.setCorpName(corpName);
            configDto.setPayType(PayChannelCode.PAY_CHANNEL_CODE_WEIXIN.getValue());
            configDto.setPayId(params.getPayId());
            configDto.setPaySecret(params.getPaySecret());
            configDto.setPayCertUrl(params.getPayCertUrl());
            configDto.setAppId(params.getAppIds().get(0));
            if (params.getOpen() == 0) {
                configDto.setIsDeleted(Integer.valueOf(1));
            } else {
                configDto.setIsDeleted(Integer.valueOf(0));
            }
            String appId = this.scrmPayConfigService.setConfig(configDto);
            if (StringUtils.isNotBlank((CharSequence)appId) && !appId.equals(config.getAppId())) {
                config.setAppId(appId);
                this.payConfigMapper.updateByPrimaryKey((Object)config);
            }
        }
    }

    @Override
    public PayConfigDto getConfig(Long bizId) {
        PayConfig config = this.payConfigMapper.getConfigByBizId(bizId, PayChannelCode.PAY_CHANNEL_CODE_WEIXIN.getValue());
        PayConfigDto configDto = new PayConfigDto();
        if (config == null) {
            configDto.setOpen(0);
            return configDto;
        }
        configDto.setOpen(config.getOpen());
        if (configDto.getOpen() == 1) {
            configDto.setPayId(config.getPayId());
            configDto.setPaySecret(config.getPaySecret());
            configDto.setPayCertUrl(config.getPayCertUrl());
            if (StringUtils.isNotBlank((CharSequence)config.getAppConfig())) {
                try {
                    List appIds = JacksonUtil.str2List((String)config.getAppConfig(), String.class);
                    configDto.setAppIds(appIds);
                }
                catch (IOException e) {
                    log.error("appConfig json parse error: ", (Throwable)e);
                }
            }
        }
        return configDto;
    }

    @Override
    public List<String> getAppIds(Long bizId) {
        return this.officialAccountMapper.queryAppIdsByBizId(bizId);
    }

    @Override
    public List<PayConfigGroup> queryConfigList(cn.kinyun.scrm.payconfig.dto.PayConfigListReq req) {
        log.info("queryConfigList with req={}", (Object)req);
        PayConfigListReq req1 = new PayConfigListReq();
        req1.setCorpId(req.getCorpId());
        req1.setEnable(req.getEnable());
        req1.setMchAppId(req.getMchAppId());
        req1.setMchId(req.getMchId());
        req1.setPayChannelType(req.getPayChannelType());
        if (Objects.nonNull(req.getPageDto())) {
            req1.setStart(req.getPageDto().getPageNum());
            req1.setPageSize(req.getPageDto().getPageSize());
        }
        req1.validate();
        PayConfigListResp resp = this.scrmPayConfigService.queryConfigList(req1);
        if (Objects.nonNull(req.getPageDto())) {
            req.setPageDto(resp.getPageDto());
        }
        return resp.getList();
    }

    @Override
    public List<PayConfigChannelItem> queryPlainList(cn.kinyun.scrm.payconfig.dto.PayConfigListReq req) {
        log.info("queryConfigList with req={}", (Object)req);
        PayConfigListReq req1 = new PayConfigListReq();
        req1.setCorpId(req.getCorpId());
        req1.setEnable(req.getEnable());
        req1.setMchAppId(req.getMchAppId());
        req1.setMchId(req.getMchId());
        req1.setPayChannelType(req.getPayChannelType());
        req1.setGroupKey(req.getGroupKey());
        req1.setMchName(req.getMchName());
        if (Objects.nonNull(req.getPageDto())) {
            req1.setStart(req.getPageDto().getPageNum());
            req1.setPageSize(req.getPageDto().getPageSize());
        }
        req1.validate();
        PayConfigPlainListResp resp = this.scrmPayConfigService.queryConfigPlainList(req1);
        if (Objects.nonNull(req.getPageDto())) {
            req.setPageDto(resp.getPageDto());
        }
        return resp.getList();
    }

    @Override
    public List<PayChannelDto> queryPayChannelType() {
        log.info("queryPayChannelType");
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        PayConfigListReq req1 = new PayConfigListReq();
        PayConfigBaseReq payConfigBaseReq = new PayConfigBaseReq();
        payConfigBaseReq.setCorpId(currentUser.getCorpId());
        List payConfigGroupItems = this.scrmPayConfigService.queryDefaultConfigGroupItems(payConfigBaseReq);
        if (CollectionUtils.isEmpty((Collection)payConfigGroupItems)) {
            return Collections.emptyList();
        }
        ArrayList resultList = Lists.newArrayList();
        for (PayConfigGroupItem item : payConfigGroupItems) {
            PayChannelDto payChannelDto = new PayChannelDto();
            payChannelDto.setPayChannelCode(item.getPayChannelCode());
            payChannelDto.setPayChannelType(item.getPayChannelType());
            payChannelDto.setNum(item.getNum());
            resultList.add(payChannelDto);
        }
        return resultList;
    }

    @Override
    public void addConfig(PayConfigAddReq req) {
        log.info("addConfig with req={}", (Object)req);
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        req.setCorpId(currentUser.getCorpId());
        req.setBusinessName(currentUser.getBizName());
        req.setOperatorId(currentUser.getId());
        req.validate();
        this.scrmPayConfigService.addConfig(req);
    }

    @Override
    public void modConfig(PayConfigModReq req) {
        log.info("modConfig with req={}", (Object)req);
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        req.setCorpId(currentUser.getCorpId());
        req.setOperatorId(currentUser.getId());
        req.validate();
        this.scrmPayConfigService.modConfig(req);
    }

    @Override
    public void switchEnable(PayConfigSwitchReq req) {
        log.info("switchEnable with req={}", (Object)req);
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        req.setCorpId(currentUser.getCorpId());
        req.validate();
        this.scrmPayConfigService.switchEnable(req);
    }

    @Override
    public void editConfigGroup(PayConfigGroupAddReq req) {
        log.info("editConfigGroup with req={}", (Object)req);
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        req.setCorpId(currentUser.getCorpId());
        req.setOperatorId(currentUser.getId());
        this.scrmPayConfigService.editConfigGroup(req);
    }

    @Override
    public void deleteConfigGroup(PayConfigGroupReq req) {
        log.info("deleteConfigGroup with req={}", (Object)req);
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        req.setCorpId(currentUser.getCorpId());
        this.scrmPayConfigService.deleteConfigGroup(req);
    }

    @Override
    public List<PayConfigGroupDto> queryConfigGroup(PayConfigGroupQuery req) {
        log.info("queryConfigGroup with req={}", (Object)req);
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        req.setCorpId(currentUser.getCorpId());
        req.setIsIncludeDeleted(NumberUtils.INTEGER_ZERO);
        PayConfigGroupDtoResp resp = this.scrmPayConfigService.queryConfigGroup(req);
        if (Objects.isNull(resp)) {
            return Collections.emptyList();
        }
        if (Objects.nonNull(req.getPageDto())) {
            req.setPageDto(resp.getPageDto());
        }
        return resp.getList();
    }

    @Override
    public List<PayConfigGroupItem> queryConfigGroupItems(PayConfigGroupReq req) {
        log.info("queryConfigGroupItems with req={}", (Object)req);
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        req.setCorpId(currentUser.getCorpId());
        PayConfigGroupItemResp resp = this.scrmPayConfigService.queryConfigGroupItems(req);
        if (Objects.isNull(resp)) {
            return Collections.emptyList();
        }
        if (Objects.nonNull(req.getPageDto())) {
            req.setPageDto(resp.getPageDto());
        }
        return resp.getList();
    }
}

