/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.payconfig.service.impl;

import cn.kinyun.customer.center.enums.PayStatusEnum;
import cn.kinyun.scrm.payconfig.service.PayRecordService;
import com.kuaike.common.enums.order.PayStatus;
import com.kuaike.scrm.dal.payorder.entity.PayRecord;
import com.kuaike.scrm.dal.payorder.mapper.PayRecordMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayRecordServiceImpl
implements PayRecordService {
    private static final Logger log = LoggerFactory.getLogger(PayRecordServiceImpl.class);
    @Autowired
    private PayRecordMapper payRecordMapper;

    @Override
    public Integer getOrderStatus(String payTradeNum) {
        PayRecord payRecord = this.payRecordMapper.selectByPayTradeNum(payTradeNum);
        if (payRecord == null) {
            return null;
        }
        Integer status = null;
        switch (PayStatusEnum.get((int)payRecord.getStatus())) {
            case UNPAID: {
                status = PayStatus.UN_PAY.getStatus();
                break;
            }
            case PAID: {
                status = PayStatus.PAY.getStatus();
                break;
            }
            case TIMEOUT: {
                status = PayStatus.TIMEOUT.getStatus();
                break;
            }
        }
        return status;
    }
}

