/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.payconfig.service.impl;

import cn.kinyun.customer.center.dto.req.QueryOrderListReq;
import cn.kinyun.customer.center.dto.req.order.OrderRecordReq;
import cn.kinyun.customer.center.dto.req.order.SetOrderPayStatusReq;
import cn.kinyun.customer.center.dto.resp.OrderListResp;
import cn.kinyun.customer.center.dto.resp.PageOrderListResp;
import cn.kinyun.customer.center.enums.PayStatusEnum;
import cn.kinyun.customer.center.enums.electricity.PayOrderStatusEnum;
import cn.kinyun.customer.center.enums.electricity.PlatformEnum;
import cn.kinyun.customer.center.service.CcCustomerOrderService;
import cn.kinyun.scrm.payconfig.dto.OrderDelayDto;
import com.alibaba.fastjson.JSON;
import com.kuaike.scrm.dal.payorder.entity.PayOrder;
import com.kuaike.scrm.dal.payorder.entity.PayRecord;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.collections4.CollectionUtils;
import org.redisson.api.RBlockingQueue;
import org.redisson.api.RDelayedQueue;
import org.redisson.api.RQueue;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class UpdateCustomerOrderDelayManager {
    private static final Logger log = LoggerFactory.getLogger(UpdateCustomerOrderDelayManager.class);
    private final AtomicBoolean consumerThreadRun = new AtomicBoolean(true);
    private RDelayedQueue<OrderDelayDto> delayedQueue;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private CcCustomerOrderService ccCustomerOrderService;

    @PostConstruct
    public void init() {
        RBlockingQueue blockingFairQueue = this.redissonClient.getBlockingQueue(OrderDelayDto.class.getName());
        this.delayedQueue = this.redissonClient.getDelayedQueue((RQueue)blockingFairQueue);
        Thread consumerThread = new Thread(() -> {
            while (this.consumerThreadRun.get()) {
                try {
                    OrderDelayDto dto = (OrderDelayDto)blockingFairQueue.take();
                    log.info("take from delay queue: {}", (Object)JSON.toJSONString((Object)dto));
                    this.dealPayOrder(dto.getPayOrder(), dto.getPayRecord());
                }
                catch (InterruptedException e) {
                    log.error("take orderDelay dto failed", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
        });
        consumerThread.start();
        log.info("update customer order delay queue start");
    }

    @PreDestroy
    public void destroy() {
        this.consumerThreadRun.getAndSet(false);
        this.delayedQueue.destroy();
    }

    private void addQueue(OrderDelayDto dto, long delay, TimeUnit timeUnit) {
        this.delayedQueue.offer((Object)dto, delay, timeUnit);
    }

    private boolean updateCustomerCenterOrderStatus(PayOrder payOrder, PayRecord payRecord) {
        if (payOrder == null || payRecord == null) {
            log.warn("updateCustomerCenterOrderStatus payOrder or payRecord is null");
            return true;
        }
        try {
            SetOrderPayStatusReq req = new SetOrderPayStatusReq();
            req.setBizId(payOrder.getBizId());
            req.setOrderNo(payOrder.getOrderNum());
            req.setPaidAmount(Long.valueOf(payOrder.getPayAmount() * 100L));
            req.setPayStatus(payOrder.getPayStatus());
            if (PayStatusEnum.PAID.getValue() == req.getPayStatus().intValue()) {
                req.setOrderStatus(Integer.valueOf(PayOrderStatusEnum.HAD_PAY.getValue()));
            } else if (PayStatusEnum.PART_PAID.getValue() == req.getPayStatus().intValue()) {
                req.setOrderStatus(Integer.valueOf(PayOrderStatusEnum.PARTIAL_PAY.getValue()));
            }
            log.info("updateCustomerCenterOrderStatus set order pay status: {}", (Object)JSON.toJSONString((Object)req));
            this.ccCustomerOrderService.setOrderPayStatus(req);
            QueryOrderListReq queryOrderListReq = new QueryOrderListReq();
            queryOrderListReq.setBizId(payOrder.getBizId());
            queryOrderListReq.setOrderNo(req.getOrderNo());
            PageOrderListResp orderListResp = this.ccCustomerOrderService.orderList(queryOrderListReq);
            String source = "";
            if (Objects.isNull(orderListResp) || CollectionUtils.isEmpty((Collection)orderListResp.getList())) {
                log.info("\u8ba2\u5355\u4e2d\u5fc3\u4e0d\u5b58\u5728\u8be5\u8ba2\u5355, orderNo={}", (Object)req.getOrderNo());
                return false;
            }
            OrderListResp orderItem = (OrderListResp)orderListResp.getList().get(0);
            source = orderItem.getSource();
            OrderRecordReq recordReq = new OrderRecordReq();
            recordReq.setBizId(payOrder.getBizId());
            recordReq.setSource(source);
            recordReq.setOrderNo(payOrder.getOrderNum());
            recordReq.setEntry(Integer.valueOf(0));
            recordReq.setPayAmount(Long.valueOf(payRecord.getAmount() * 100L));
            recordReq.setPayNo(payRecord.getPayTradeNum());
            recordReq.setPayStatus(payRecord.getStatus());
            recordReq.setPayTime(payRecord.getUpdateTime());
            recordReq.setChannelType(payRecord.getPayChannelType());
            recordReq.setPlatformType(Integer.valueOf(PlatformEnum.SCRM.getValue()));
            log.info("updateCustomerCenterOrderStatus set order payRecord status: {}", (Object)JSON.toJSONString((Object)recordReq));
            this.ccCustomerOrderService.addOrderPayRecord(recordReq);
        }
        catch (Exception e) {
            log.error("update customer center order status error: {}", (Throwable)e);
            return false;
        }
        return true;
    }

    public void dealPayOrder(PayOrder payOrder, PayRecord payRecord) {
        log.info("dealPayOrder orderNo={}", (Object)payOrder.getOrderNum());
        if (!this.updateCustomerCenterOrderStatus(payOrder, payRecord)) {
            Long count = this.redisTemplate.opsForValue().increment((Object)payOrder.getOrderNum());
            this.redisTemplate.expire((Object)payOrder.getOrderNum(), 120L, TimeUnit.SECONDS);
            if (count != null && count > 4L) {
                log.info("\u91cd\u8bd54\u6b21\u540e\u672a\u627e\u5230\u9700\u8981\u66f4\u65b0\u7684customerOrder,orderNum={}, exit", (Object)payOrder.getOrderNum());
            } else {
                OrderDelayDto dto = new OrderDelayDto();
                dto.setPayOrder(payOrder);
                dto.setPayRecord(payRecord);
                this.addQueue(dto, 5L, TimeUnit.SECONDS);
                log.info("update customer order put into delayQueue, orderNum={},\u7b2c{}\u6b21", (Object)payOrder.getOrderNum(), (Object)count);
            }
        }
    }
}

