/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.payconfig.service.impl;

import cn.kinyun.customer.center.dto.req.order.SetOrderPayStatusReq;
import cn.kinyun.customer.center.dto.req.order.SetOrderRefundInfoReq;
import cn.kinyun.customer.center.enums.PayStatusEnum;
import cn.kinyun.customer.center.enums.RefundStatusEnum;
import cn.kinyun.customer.center.enums.electricity.PayOrderStatusEnum;
import cn.kinyun.customer.center.service.CcCustomerOrderService;
import cn.kinyun.customer.center.service.CcCustomerRefundOrderService;
import cn.kinyun.pay.business.dto.vo.ApproveResult;
import cn.kinyun.pay.business.event.PayEvent;
import cn.kinyun.scrm.payconfig.service.PayRefundRecordService;
import com.alibaba.fastjson.JSON;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.component.DistributedLock;
import com.kuaike.scrm.dal.payorder.entity.PayOrder;
import com.kuaike.scrm.dal.payorder.entity.PayRefundRecord;
import com.kuaike.scrm.dal.payorder.mapper.PayOrderMapper;
import com.kuaike.scrm.dal.payorder.mapper.PayRefundRecordMapper;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PayRefundRecordServiceImpl
implements PayRefundRecordService {
    private static final Logger log = LoggerFactory.getLogger(PayRefundRecordServiceImpl.class);
    @Autowired
    private PayRefundRecordMapper payRefundRecordMapper;
    @Autowired
    private PayOrderMapper payOrderMapper;
    @Autowired
    private DistributedLock lock;
    @Autowired
    private PayRefundRecordService self;
    @Autowired
    private CcCustomerRefundOrderService customerRefundOrderService;
    @Autowired
    private CcCustomerOrderService customerOrderService;

    @Override
    public void handleAuditPass(String refundNum) {
        log.info("handleAuditPass with refundNum={}", (Object)refundNum);
        PayRefundRecord refundRecord = this.getPayRefundRecord(refundNum);
        if (refundRecord == null) {
            return;
        }
        refundRecord.setRefundStatus(Integer.valueOf(RefundStatusEnum.REFUNDING.getValue()));
        refundRecord.setUpdateTime(new Date());
        this.payRefundRecordMapper.updateByPrimaryKey((Object)refundRecord);
        PayOrder payOrder = this.payOrderMapper.queryByOrderNo(refundRecord.getOrderNum());
        this.updateCustomerRefundOrder(payOrder, refundRecord, null);
    }

    @Override
    public void handleRefuseRefund(String refundNum, PayEvent payEvent) {
        log.info("handleRefuseRefund with refundNum={}, payEvent={}", (Object)refundNum, (Object)payEvent);
        ApproveResult approveResult = null;
        try {
            approveResult = (ApproveResult)JacksonUtil.str2Obj((String)payEvent.getBody(), ApproveResult.class);
        }
        catch (IOException e) {
            log.error("parse json with error", (Throwable)e);
        }
        String remark = approveResult.getRemark();
        PayRefundRecord refundRecord = this.getPayRefundRecord(refundNum);
        if (refundRecord == null) {
            return;
        }
        refundRecord.setRefundStatus(Integer.valueOf(RefundStatusEnum.REFUSE.getValue()));
        refundRecord.setUpdateTime(new Date());
        refundRecord.setFailReason(remark);
        this.payRefundRecordMapper.updateByPrimaryKey((Object)refundRecord);
        PayOrder payOrder = this.payOrderMapper.queryByOrderNo(refundRecord.getOrderNum());
        this.updateCustomerRefundOrder(payOrder, refundRecord, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRefundMarkDeal(String refundNum) {
        log.info("handleRefundMarkDeal with refundNum={}", (Object)refundNum);
        PayRefundRecord refundRecord = this.getPayRefundRecord(refundNum);
        if (refundRecord == null) {
            return;
        }
        String key = "order-center:" + refundRecord.getOrderNum();
        try {
            this.lock.lock(key, 10L, 15L, TimeUnit.SECONDS);
            this.self.offlineRefundTransactionWrap(refundNum);
        }
        catch (Exception e) {
            log.error("handleOfflineRefund with error", (Throwable)e);
        }
        finally {
            this.lock.unlock(key);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void offlineRefundTransactionWrap(String refundNum) {
        log.info("offlineRefundTransactionWrap with refundNum={}", (Object)refundNum);
        PayRefundRecord refundRecord = this.getPayRefundRecord(refundNum);
        if (refundRecord == null) {
            return;
        }
        String bizOrderNum = refundRecord.getOrderNum();
        PayOrder payOrder = this.payOrderMapper.queryByOrderNo(bizOrderNum);
        if (Objects.isNull(payOrder)) {
            log.warn("payOrder is not exist, orderNum={}", (Object)refundRecord.getOrderNum());
            return;
        }
        refundRecord.setRefundStatus(Integer.valueOf(RefundStatusEnum.REFUNDED.getValue()));
        refundRecord.setOfflineRefundAmount(refundRecord.getRefundAmount());
        refundRecord.setUpdateTime(new Date());
        this.payRefundRecordMapper.updateByPrimaryKey((Object)refundRecord);
        List list = this.payRefundRecordMapper.queryRefundRecordsByBizOrderNum(bizOrderNum);
        Long offlineRefundAmount = list.stream().filter(a -> Objects.equals(a.getRefundStatus(), RefundStatusEnum.REFUNDED.getValue()) && a.getOfflineRefundAmount() > 0L).mapToLong(a -> a.getOfflineRefundAmount()).sum();
        payOrder.setOfflineRefundAmount(offlineRefundAmount);
        if (payOrder.getPayRefundAmount() + payOrder.getOfflineRefundAmount() == payOrder.getPayAmount()) {
            payOrder.setRefundStatus(Integer.valueOf(RefundStatusEnum.REFUNDED.getValue()));
            payOrder.setPayStatus(Integer.valueOf(PayStatusEnum.REFUND.getValue()));
        } else {
            payOrder.setRefundStatus(Integer.valueOf(RefundStatusEnum.PART_REFUND.getValue()));
        }
        this.payOrderMapper.updateByPrimaryKey((Object)payOrder);
        this.updateCustomerOrderPayStatus(payOrder);
        this.updateCustomerOrderStatus(payOrder, refundRecord);
        this.updateCustomerRefundOrder(payOrder, refundRecord, null);
    }

    private PayRefundRecord getPayRefundRecord(String refundNum) {
        PayRefundRecord refundRecord = this.payRefundRecordMapper.queryRefundRecords(refundNum);
        if (Objects.isNull(refundRecord)) {
            log.warn("pay refund record is not exist, refundNum={}", (Object)refundNum);
            return null;
        }
        if (Objects.equals(refundRecord.getRefundStatus(), RefundStatusEnum.REFUNDED.getValue())) {
            log.warn("payRefundRecord have been refunded, refundNum={}", (Object)refundNum);
            return null;
        }
        if (Objects.equals(refundRecord.getRefundStatus(), RefundStatusEnum.REFUSE.getValue())) {
            log.warn("payRefundRecord have been refused, refundNum={}", (Object)refundNum);
            return null;
        }
        return refundRecord;
    }

    private void updateCustomerOrderStatus(PayOrder payOrder, PayRefundRecord payRefundRecord) {
        String orderNo = payOrder.getOrderNum();
        String refundNo = payRefundRecord.getRefundNum();
        SetOrderRefundInfoReq refundInfoReq = new SetOrderRefundInfoReq();
        refundInfoReq.setOrderNo(orderNo);
        refundInfoReq.setRefundNo(refundNo);
        refundInfoReq.setBizId(payOrder.getBizId());
        refundInfoReq.setRefundAmount(Long.valueOf(payOrder.getPayRefundAmount() * 100L));
        if (payOrder.getOfflineRefundAmount() != null) {
            refundInfoReq.setRefundAmount(Long.valueOf(refundInfoReq.getRefundAmount() + payOrder.getOfflineRefundAmount() * 100L));
        }
        refundInfoReq.setRefundStatus(payOrder.getRefundStatus());
        refundInfoReq.setRefundTime(new Date());
        try {
            log.info("setOrderRefundInfo with req={}", (Object)JSON.toJSONString((Object)refundInfoReq));
            this.customerOrderService.setOrderRefundInfo(refundInfoReq);
        }
        catch (Exception e) {
            log.error("setOrderRefundInfo with error, refundInfoReq={}", (Object)JSON.toJSONString((Object)refundInfoReq), (Object)e);
        }
    }

    private void updateCustomerOrderPayStatus(PayOrder payOrder) {
        SetOrderPayStatusReq req = new SetOrderPayStatusReq();
        req.setBizId(payOrder.getBizId());
        req.setOrderNo(payOrder.getOrderNum());
        req.setPaidAmount(Long.valueOf(payOrder.getPayAmount() * 100L));
        req.setPayStatus(payOrder.getPayStatus());
        if (payOrder.getRefundStatus().intValue() == RefundStatusEnum.REFUNDED.getValue()) {
            req.setPayStatus(Integer.valueOf(PayStatusEnum.REFUND.getValue()));
            req.setOrderStatus(Integer.valueOf(PayOrderStatusEnum.REFUNDED.getValue()));
        } else if (payOrder.getRefundStatus().intValue() == RefundStatusEnum.PART_REFUND.getValue()) {
            req.setOrderStatus(Integer.valueOf(PayOrderStatusEnum.PARTIAL_REFUND.getValue()));
        }
        try {
            log.info("setOrderPayStatus with req={}", (Object)JSON.toJSONString((Object)req));
            this.customerOrderService.setOrderPayStatus(req);
        }
        catch (Exception e) {
            log.error("setOrderPayStatus with error, req={}", (Object)JSON.toJSONString((Object)req), (Object)e);
        }
    }

    private void updateCustomerRefundOrder(PayOrder payOrder, PayRefundRecord payRefundRecord, String refundFailReason) {
        SetOrderRefundInfoReq setOrderRefundInfoReq = new SetOrderRefundInfoReq();
        try {
            setOrderRefundInfoReq.setRefundNo(payRefundRecord.getRefundNum());
            setOrderRefundInfoReq.setRefundTime(payRefundRecord.getUpdateTime());
            setOrderRefundInfoReq.setRefundStatus(payRefundRecord.getRefundStatus());
            setOrderRefundInfoReq.setRefundFailReason(refundFailReason);
            setOrderRefundInfoReq.setOrderNo(payOrder.getOrderNum());
            setOrderRefundInfoReq.setBizId(payOrder.getBizId());
            setOrderRefundInfoReq.setRefundAmount(Long.valueOf(payRefundRecord.getRefundAmount() * 100L));
            setOrderRefundInfoReq.setRefundType(Integer.valueOf(payRefundRecord.getRefundType().intValue()));
            log.info("refundOrder with req={}", (Object)JSON.toJSONString((Object)setOrderRefundInfoReq));
            this.customerOrderService.refundOrder(setOrderRefundInfoReq);
        }
        catch (Exception e) {
            log.error("add customer refund order with error, req={}", (Object)JSON.toJSONString((Object)setOrderRefundInfoReq), (Object)e);
        }
    }
}

